/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.diskimage;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.diskimage.DiskImageOrderPane;
import com.webcodepro.applecommander.ui.swt.wizard.diskimage.DiskImageWizard;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DiskImageNamePane
extends WizardPane {
    private TextBundle textBundle = UiBundle.getInstance();
    private DiskImageWizard wizard;
    private Composite control;
    private Composite parent;

    public DiskImageNamePane(Composite composite, DiskImageWizard diskImageWizard) {
        this.parent = composite;
        this.wizard = diskImageWizard;
    }

    public WizardPane getNextPane() {
        return new DiskImageOrderPane(this.parent, this.wizard);
    }

    public void open() {
        this.control = new Composite(this.parent, 0);
        this.wizard.enableNextButton(false);
        this.wizard.enableFinishButton(false);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.justify = true;
        rowLayout.marginBottom = 5;
        rowLayout.marginLeft = 5;
        rowLayout.marginRight = 5;
        rowLayout.marginTop = 5;
        rowLayout.spacing = 3;
        this.control.setLayout((Layout)rowLayout);
        Label label = new Label(this.control, 64);
        label.setText(this.textBundle.get("DiskImageNamePrompt"));
        final Text text = new Text(this.control, 2048);
        text.setFocus();
        RowData rowData = new RowData();
        rowData.width = this.parent.getClientArea().width - 50;
        text.setLayoutData((Object)rowData);
        text.setText(this.wizard.getFileName());
        this.setButtonStatus();
        text.addListener(25, new Listener(){

            public void handleEvent(Event event) {
                String string = DiskImageNamePane.this.edit(text.getText(), event);
                DiskImageNamePane.this.wizard.setFileName(string);
                DiskImageNamePane.this.setButtonStatus();
            }
        });
        if (this.wizard.isFormatProdos() || this.wizard.isFormatPascal()) {
            int n = this.wizard.isFormatProdos() ? 15 : 7;
            label = new Label(this.control, 64);
            Object[] objectArray = new Object[]{this.wizard.isFormatProdos() ? this.textBundle.get("Prodos") : this.textBundle.get("Pascal"), new Integer(n)};
            label.setText(this.textBundle.format("DiskImageNameLengthText", objectArray));
            final Text text2 = new Text(this.control, 2048);
            text2.setText(this.wizard.getVolumeName());
            text2.setTextLimit(n);
            text2.addListener(25, new Listener(){

                public void handleEvent(Event event) {
                    event.text = event.text.toUpperCase();
                    String string = DiskImageNamePane.this.edit(text2.getText(), event);
                    DiskImageNamePane.this.wizard.setVolumeName(string);
                    DiskImageNamePane.this.setButtonStatus();
                }
            });
        }
    }

    private String edit(String string, Event event) {
        if (event.character == '\b') {
            return string.substring(0, event.start) + string.substring(event.end);
        }
        return string.substring(0, event.start) + event.text + string.substring(event.end);
    }

    protected void setButtonStatus() {
        String string = this.wizard.getVolumeName();
        String string2 = this.wizard.getFileName();
        if (this.wizard.isFormatProdos() || this.wizard.isFormatPascal()) {
            this.wizard.enableNextButton(string2 != null && string2.length() > 0 && string != null && string.length() > 0 && string.charAt(0) >= 'A' && string.charAt(0) <= 'Z');
        } else {
            this.wizard.enableNextButton(string2 != null && string2.length() > 0);
        }
    }

    public void dispose() {
        this.control.dispose();
    }

    protected DiskImageWizard getWizard() {
        return this.wizard;
    }
}

