/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.dos33;

import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.filters.ApplesoftFileFilter;
import com.webcodepro.applecommander.storage.filters.AssemblySourceFileFilter;
import com.webcodepro.applecommander.storage.filters.BinaryFileFilter;
import com.webcodepro.applecommander.storage.filters.GraphicsFileFilter;
import com.webcodepro.applecommander.storage.filters.IntegerBasicFileFilter;
import com.webcodepro.applecommander.storage.filters.TextFileFilter;
import com.webcodepro.applecommander.storage.os.dos33.DosFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class DosFileEntry
implements FileEntry {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int FILE_DESCRIPTIVE_ENTRY_LENGTH = 35;
    private DosFormatDisk disk;
    private int track;
    private int sector;
    private int offset;
    private Integer address;

    public DosFileEntry(DosFormatDisk dosFormatDisk, int n, int n2, int n3) {
        this.disk = dosFormatDisk;
        this.track = n;
        this.sector = n2;
        this.offset = n3;
    }

    protected byte[] readFileEntry() {
        byte[] byArray = this.disk.readSector(this.track, this.sector);
        byte[] byArray2 = new byte[35];
        System.arraycopy(byArray, this.offset, byArray2, 0, byArray2.length);
        return byArray2;
    }

    protected void writeFileEntry(byte[] byArray) {
        if (byArray.length != 35) {
            throw new IllegalArgumentException(this.textBundle.format("DosFileEntry.DosFileEntryLengthError", 35));
        }
        byte[] byArray2 = this.disk.readSector(this.track, this.sector);
        System.arraycopy(byArray, 0, byArray2, this.offset, byArray.length);
        this.disk.writeSector(this.track, this.sector, byArray2);
    }

    public int getMaximumFilenameLength() {
        return 30;
    }

    public String getFilename() {
        return AppleUtil.getString(this.readFileEntry(), 3, 30).trim();
    }

    public void setFilename(String string) {
        byte[] byArray = this.readFileEntry();
        AppleUtil.setString(byArray, 3, string.toUpperCase(), 30);
        this.writeFileEntry(byArray);
    }

    public String getFiletype() {
        int n = AppleUtil.getUnsignedByte(this.readFileEntry()[2]) & 0x7F;
        if (n == 0) {
            return "T";
        }
        if ((n ^ 1) == 0) {
            return "I";
        }
        if ((n ^ 2) == 0) {
            return "A";
        }
        if ((n ^ 4) == 0) {
            return "B";
        }
        if ((n ^ 8) == 0) {
            return "S";
        }
        if ((n ^ 0x10) == 0) {
            return "R";
        }
        if ((n ^ 0x20) == 0) {
            return "a";
        }
        if ((n ^ 0x40) == 0) {
            return "b";
        }
        return "?";
    }

    public void setFiletype(String string) {
        byte[] byArray = this.readFileEntry();
        int n = 4;
        if ("T".equals(string)) {
            n = 0;
        }
        if ("I".equals(string)) {
            n = 1;
        }
        if ("A".equals(string)) {
            n = 2;
        }
        if ("B".equals(string)) {
            n = 4;
        }
        if ("S".equals(string)) {
            n = 8;
        }
        if ("R".equals(string)) {
            n = 16;
        }
        if ("a".equals(string)) {
            n = 32;
        }
        if ("b".equals(string)) {
            n = 64;
        }
        byArray[2] = (byte)(n |= byArray[2] & 0x80);
        this.writeFileEntry(byArray);
    }

    public boolean isLocked() {
        return (this.readFileEntry()[2] & 0x80) != 0;
    }

    public void setLocked(boolean bl) {
        byte[] byArray = this.readFileEntry();
        byArray[2] = bl ? (byte)(AppleUtil.getUnsignedByte(byArray[2]) | 0x80) : (byte)(AppleUtil.getUnsignedByte(byArray[2]) & 0x7F);
        this.writeFileEntry(byArray);
    }

    public int getSize() {
        int n;
        byte[] byArray = null;
        if (!this.isDeleted()) {
            byArray = this.disk.getFileData(this);
        }
        if ((n = (this.getSectorsUsed() - 1) * 256) < 1) {
            n = 0;
        }
        if (byArray != null) {
            if ("B".equals(this.getFiletype())) {
                return AppleUtil.getWordValue(byArray, 2);
            }
            if ("A".equals(this.getFiletype()) || "I".equals(this.getFiletype())) {
                return AppleUtil.getWordValue(byArray, 0);
            }
        }
        return n;
    }

    public int getSectorsUsed() {
        return AppleUtil.getWordValue(this.readFileEntry(), 33);
    }

    public void setSectorsUsed(int n) {
        byte[] byArray = this.readFileEntry();
        AppleUtil.setWordValue(byArray, 33, n);
        this.writeFileEntry(byArray);
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isDeleted() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[0]) == 255;
    }

    public void delete() {
        this.disk.freeSectors(this);
        byte[] byArray = this.readFileEntry();
        byArray[32] = byArray[0];
        byArray[0] = -1;
        this.writeFileEntry(byArray);
    }

    public List getFileColumnData(int n) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (n) {
            case 2: {
                arrayList.add(this.isLocked() ? "*" : " ");
                arrayList.add(this.getFiletype());
                numberFormat.setMinimumIntegerDigits(3);
                arrayList.add(numberFormat.format(this.getSectorsUsed()));
                arrayList.add(this.getFilename());
                break;
            }
            case 3: {
                arrayList.add(this.isLocked() ? "*" : " ");
                arrayList.add(this.getFiletype());
                arrayList.add(this.getFilename());
                arrayList.add(numberFormat.format(this.getSize()));
                numberFormat.setMinimumIntegerDigits(3);
                arrayList.add(numberFormat.format(this.getSectorsUsed()));
                arrayList.add(this.isDeleted() ? this.textBundle.get("Deleted") : "");
                arrayList.add("T" + this.getTrack() + " S" + this.getSector());
                break;
            }
            default: {
                arrayList.add(this.getFilename());
                arrayList.add(this.getFiletype());
                arrayList.add(numberFormat.format(this.getSize()));
                arrayList.add(this.isLocked() ? this.textBundle.get("Locked") : "");
            }
        }
        return arrayList;
    }

    public int getTrack() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[0]);
    }

    public void setTrack(int n) {
        byte[] byArray = this.readFileEntry();
        byArray[0] = (byte)n;
        this.writeFileEntry(byArray);
    }

    public int getSector() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[1]);
    }

    public void setSector(int n) {
        byte[] byArray = this.readFileEntry();
        byArray[1] = (byte)n;
        this.writeFileEntry(byArray);
    }

    public byte[] getFileData() {
        byte[] byArray;
        byte[] byArray2 = this.disk.getFileData(this);
        if (this.isBinaryFile()) {
            int n = AppleUtil.getWordValue(byArray2, 2);
            byArray = new byte[n];
            System.arraycopy(byArray2, 4, byArray, 0, n);
        } else if (this.isApplesoftBasicFile() || this.isIntegerBasicFile()) {
            byArray = new byte[this.getSize()];
            System.arraycopy(byArray2, 2, byArray, 0, byArray.length);
        } else {
            byArray = byArray2;
        }
        return byArray;
    }

    public void setFileData(byte[] byArray) throws DiskFullException {
        if (this.isBinaryFile()) {
            byte[] byArray2 = new byte[byArray.length + 4];
            if (this.address != null) {
                AppleUtil.setWordValue(byArray2, 0, this.address);
                this.address = null;
            } else {
                AppleUtil.setWordValue(byArray2, 0, 0);
            }
            AppleUtil.setWordValue(byArray2, 2, byArray.length);
            System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
            this.disk.setFileData(this, byArray2);
        } else if (this.isApplesoftBasicFile() || this.isIntegerBasicFile()) {
            byte[] byArray3 = new byte[byArray.length + 2];
            AppleUtil.setWordValue(byArray3, 0, byArray.length);
            System.arraycopy(byArray, 0, byArray3, 2, byArray.length);
            this.disk.setFileData(this, byArray3);
        } else if (this.isTextFile()) {
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)(byArray[i] | 0x80);
            }
            this.disk.setFileData(this, byArray);
        } else {
            this.disk.setFileData(this, byArray);
        }
    }

    public FileFilter getSuggestedFilter() {
        if (this.isApplesoftBasicFile()) {
            return new ApplesoftFileFilter();
        }
        if (this.isIntegerBasicFile()) {
            return new IntegerBasicFileFilter();
        }
        if (this.isAssemblySourceFile()) {
            return new AssemblySourceFileFilter();
        }
        if (this.isTextFile()) {
            return new TextFileFilter();
        }
        if (this.isBinaryFile()) {
            int n = this.getSize();
            GraphicsFileFilter graphicsFileFilter = new GraphicsFileFilter();
            if (n >= 8184 && n <= 8192) {
                graphicsFileFilter.setMode(2);
                return graphicsFileFilter;
            }
            if (n >= 16377 && n <= 16384) {
                graphicsFileFilter.setMode(4);
                return graphicsFileFilter;
            }
        }
        return new BinaryFileFilter();
    }

    public boolean isAssemblySourceFile() {
        boolean bl;
        boolean bl2 = bl = this.isTextFile() || this.isBinaryFile();
        if (bl && this.getFilename().endsWith(".S")) {
            return true;
        }
        return bl && this.getFilename().startsWith("T.");
    }

    public boolean isTextFile() {
        return "T".equals(this.getFiletype());
    }

    public boolean isApplesoftBasicFile() {
        return "A".equals(this.getFiletype());
    }

    public boolean isIntegerBasicFile() {
        return "I".equals(this.getFiletype());
    }

    public boolean isBinaryFile() {
        return "B".equals(this.getFiletype());
    }

    public FormattedDisk getFormattedDisk() {
        return this.disk;
    }

    public boolean needsAddress() {
        return this.disk.needsAddress(this.getFiletype());
    }

    public void setAddress(int n) {
        try {
            byte[] byArray = this.disk.getFileData(this);
            if (byArray == null || byArray.length == 0) {
                this.address = new Integer(n);
            } else {
                AppleUtil.setWordValue(byArray, 0, n);
                this.disk.setFileData(this, byArray);
            }
        }
        catch (DiskFullException diskFullException) {
            throw new IllegalStateException(this.textBundle.format("DosFileEntry.UnableToSetAddressError", this.getFilename()));
        }
    }

    public boolean canCompile() {
        return this.isApplesoftBasicFile();
    }
}

