/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class AppleWorksDataBaseFileFilter
implements FileFilter {
    private TextBundle textBundle = StorageBundle.getInstance();
    private static final int HEADER_LENGTH_WORD = 0;
    private static final int HEADER_CATEGORIES_BYTE = 35;
    private static final int HEADER_RECORDS_WORD = 36;
    private static final int HEADER_REPORTS_BYTE = 38;
    private static final int HEADER_DBMINVERS_BYTE = 218;
    private static final int HEADER_CATEGORY_STRING = 357;
    private static final int HEADER_CATEGORY_LENGTH = 22;
    private static final int REPORT_LENGTH = 600;
    private static final int DATA_CONTROL_SKIP = 128;
    private static final int DATA_CONTROL_END = 255;
    private static final int SPECIAL_CONTROL_DATE = 192;
    private static final int DATE_YEAR_OFFSET = 1;
    private static final int DATE_MONTH_OFFSET = 3;
    private static final String[] months = new String[]{StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.January"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.February"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.March"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.April"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.May"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.June"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.July"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.August"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.September"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.October"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.November"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.December")};
    private static final int DATE_DAY_OFFSET = 4;
    private static final int DATE_LENGTH = 6;
    private static final int SPECIAL_CONTROL_TIME = 212;
    private static final int TIME_HOUR_OFFSET = 1;
    private static final int TIME_MINUTE_OFFSET = 2;
    private static final int TIME_LENGTH = 4;

    public byte[] filter(FileEntry fileEntry) {
        int n;
        byte[] byArray = fileEntry.getFileData();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
        int n2 = AppleUtil.getWordValue(byArray, 0) + 2;
        int n3 = AppleUtil.getUnsignedByte(byArray[35]);
        int n4 = AppleUtil.getWordValue(byArray, 36);
        int n5 = AppleUtil.getUnsignedByte(byArray[38]);
        int n6 = AppleUtil.getUnsignedByte(byArray[218]);
        if (n6 > 0 && (n4 & 0x8000) != 0) {
            n4 &= Short.MAX_VALUE;
        }
        int n7 = 357;
        for (n = 0; n < n3; ++n) {
            String string = AppleUtil.getProdosString(byArray, n7);
            if (n > 0) {
                printWriter.print(",");
            }
            printWriter.print('\"');
            printWriter.print(string);
            printWriter.print('\"');
            n7 += 22;
        }
        printWriter.println();
        if (n7 != n2) {
            throw new IndexOutOfBoundsException(this.textBundle.get("AppleWorksDataBaseFileFilter.InvalidHeaderLengthError"));
        }
        n7 += n5 * 600;
        for (n = 0; n < n4 + 1; ++n) {
            int n8 = AppleUtil.getWordValue(byArray, n7) + 2;
            int n9 = n7 + 2;
            int n10 = 0;
            while (AppleUtil.getUnsignedByte(byArray[n9]) != 255) {
                int n11;
                if (n10 > 0) {
                    printWriter.print(',');
                }
                if ((n11 = AppleUtil.getUnsignedByte(byArray[n9])) < 128) {
                    String string = AppleUtil.getPascalString(byArray, n9);
                    int n12 = AppleUtil.getUnsignedByte(byArray[n9 + 1]);
                    n9 += string.length() + 1;
                    switch (n12) {
                        case 192: {
                            this.convertDate(printWriter, string);
                            break;
                        }
                        case 212: {
                            this.convertTime(printWriter, string);
                            break;
                        }
                        default: {
                            printWriter.print('\"');
                            printWriter.print(string);
                            printWriter.print('\"');
                            break;
                        }
                    }
                } else {
                    for (int i = n11 - 128; i > 0; --i) {
                        printWriter.print("\",\"");
                    }
                    ++n9;
                }
                ++n10;
            }
            n7 += n8;
            printWriter.println();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String getSuggestedFileName(FileEntry fileEntry) {
        return fileEntry.getFilename() + ".csv";
    }

    protected void convertDate(PrintWriter printWriter, String string) {
        if (string.length() != 6) {
            printWriter.print(this.textBundle.format("AppleWorksDataBaseFileFilter.InvalidDate", string));
        }
        printWriter.print((char)(48 + (string.charAt(1) - 48)));
        printWriter.print((char)(48 + (string.charAt(2) - 48)));
        printWriter.print('-');
        printWriter.print(months[string.charAt(3) - 65].substring(0, 3));
        printWriter.print('-');
        printWriter.print((char)(48 + (string.charAt(4) - 48)));
        printWriter.print((char)(48 + (string.charAt(5) - 48)));
    }

    protected void convertTime(PrintWriter printWriter, String string) {
        if (string.length() != 4) {
            printWriter.print(this.textBundle.format("AppleWorksDataBaseFileFilter.InvalidTime", string));
        }
        printWriter.print(string.charAt(1) - 65);
        printWriter.print(':');
        printWriter.print((char)(48 + string.charAt(2) - 48));
        printWriter.print((char)(48 + string.charAt(3) - 48));
    }
}

