/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.prodos;

import com.webcodepro.applecommander.storage.os.prodos.ProdosCommonEntry;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;

public class ProdosCommonDirectoryHeader
extends ProdosCommonEntry {
    public ProdosCommonDirectoryHeader(ProdosFormatDisk prodosFormatDisk, int n) {
        super(prodosFormatDisk, n, 4);
    }

    public int getEntryLength() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[31]);
    }

    public void setEntryLength() {
        byte[] byArray = this.readFileEntry();
        byArray[31] = 39;
        this.writeFileEntry(byArray);
    }

    public int getEntriesPerBlock() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[32]);
    }

    public void setEntriesPerBlock() {
        byte[] byArray = this.readFileEntry();
        byArray[32] = 13;
        this.writeFileEntry(byArray);
    }

    public int getFileCount() {
        return AppleUtil.getWordValue(this.readFileEntry(), 33);
    }

    public void setFileCount(int n) {
        byte[] byArray = this.readFileEntry();
        AppleUtil.setWordValue(byArray, 33, n);
        this.writeFileEntry(byArray);
    }

    public void incrementFileCount() {
        byte[] byArray = this.readFileEntry();
        byArray[33] = (byte)(byArray[33] + 1);
        this.writeFileEntry(byArray);
    }

    public void decrementFileCount() {
        byte[] byArray = this.readFileEntry();
        if (byArray[33] != 0) {
            byArray[33] = (byte)(byArray[33] - 1);
        }
        this.writeFileEntry(byArray);
    }

    public int getBitMapPointer() {
        return AppleUtil.getWordValue(this.readFileEntry(), 35);
    }

    public void setBitMapPointer(int n) {
        byte[] byArray = this.readFileEntry();
        AppleUtil.setWordValue(byArray, 35, n);
        this.writeFileEntry(byArray);
    }

    public int getTotalBlocks() {
        return AppleUtil.getWordValue(this.readFileEntry(), 37);
    }

    public void setTotalBlocks(int n) {
        byte[] byArray = this.readFileEntry();
        AppleUtil.setWordValue(byArray, 37, n);
        this.writeFileEntry(byArray);
    }
}

