/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.pascal;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.pascal.PascalFileEntry;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class PascalFormatDisk
extends FormattedDisk {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int ENTRY_SIZE = 26;
    private static final String TEXTFILE = "TEXT";
    private static final String CODEFILE = "CODE";
    private static final String DATAFILE = "DATA";
    private static final String[] filetypes = new String[]{"xdskfile", "CODE", "TEXT", "INFO", "DATA", "GRAF", "FOTO", "securedir"};

    public PascalFormatDisk(String string, ImageOrder imageOrder) {
        super(string, imageOrder);
    }

    public static PascalFormatDisk[] create(String string, String string2, ImageOrder imageOrder) {
        PascalFormatDisk pascalFormatDisk = new PascalFormatDisk(string, imageOrder);
        pascalFormatDisk.format();
        pascalFormatDisk.setDiskName(string2);
        return new PascalFormatDisk[]{pascalFormatDisk};
    }

    public String getFormat() {
        return this.textBundle.get("PascalFormatDisk.Pascal");
    }

    public List getFiles() {
        ArrayList<PascalFileEntry> arrayList = new ArrayList<PascalFileEntry>();
        byte[] byArray = this.readDirectory();
        int n = 26;
        int n2 = AppleUtil.getWordValue(byArray, 16);
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
            arrayList.add(new PascalFileEntry(byArray2, this));
            n3 += n;
        }
        return arrayList;
    }

    public List getDirectory() {
        ArrayList<PascalFileEntry> arrayList = new ArrayList<PascalFileEntry>();
        byte[] byArray = this.readDirectory();
        int n = AppleUtil.getWordValue(byArray, 16);
        int n2 = 0;
        for (int i = 0; i <= n; ++i) {
            byte[] byArray2 = new byte[26];
            System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
            arrayList.add(new PascalFileEntry(byArray2, this));
            n2 += 26;
        }
        return arrayList;
    }

    public void putDirectory(List list) {
        byte[] byArray = new byte[2048];
        int n = list.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte[] byArray2 = ((PascalFileEntry)list.get(i)).toBytes();
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            n2 += 26;
        }
        this.writeDirectory(byArray);
    }

    public FileEntry createFile() throws DiskFullException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        List list = this.getDirectory();
        n = list.size();
        for (int i = 1; i < n; ++i) {
            n4 = ((PascalFileEntry)list.get(i - 1)).getLastBlock();
            n5 = ((PascalFileEntry)list.get(i)).getFirstBlock();
            n6 = n5 - n4;
            if (n6 <= n3) continue;
            n3 = n6;
            n2 = i;
        }
        n4 = ((PascalFileEntry)list.get(n - 1)).getLastBlock();
        n5 = this.getBlocksOnDisk();
        n6 = n5 - n4;
        if (n6 > n3) {
            n3 = n6;
            n2 = n;
        }
        if (n6 > 0 && n < 78) {
            PascalFileEntry pascalFileEntry = (PascalFileEntry)list.get(0);
            pascalFileEntry.setFileCount(n);
            list.set(0, pascalFileEntry);
            list.add(n2, new PascalFileEntry(new byte[26], this));
            PascalFileEntry pascalFileEntry2 = (PascalFileEntry)list.get(n2);
            n5 = ((PascalFileEntry)list.get(n2 - 1)).getLastBlock();
            pascalFileEntry2.setFirstBlock(n5);
            pascalFileEntry2.setLastBlock(n5 + n3);
            pascalFileEntry2.setFiletype("data");
            pascalFileEntry2.setFilename("x");
            pascalFileEntry2.setBytesUsedInLastBlock(512);
            pascalFileEntry2.setModificationDate(new Date());
            pascalFileEntry2.setEntryIndex(n2);
            list.set(n2, pascalFileEntry2);
            this.putDirectory(list);
            return pascalFileEntry2;
        }
        throw new DiskFullException(this.textBundle.get("PascalFormatDisk.DiskFull"));
    }

    public boolean canCreateDirectories() {
        return false;
    }

    public boolean canCreateFile() {
        return true;
    }

    public byte[] readDirectory() {
        byte[] byArray = new byte[2048];
        for (int i = 0; i < 4; ++i) {
            System.arraycopy(this.readBlock(2 + i), 0, byArray, i * 512, 512);
        }
        return byArray;
    }

    public void writeDirectory(byte[] byArray) {
        if (byArray == null || byArray.length != 2048) {
            throw new IllegalArgumentException(this.textBundle.get("PascalFormatDisk.InvalidPascalDirectory"));
        }
        for (int i = 0; i < 4; ++i) {
            byte[] byArray2 = new byte[512];
            System.arraycopy(byArray, i * 512, byArray2, 0, 512);
            this.writeBlock(2 + i, byArray2);
        }
    }

    public boolean canHaveDirectories() {
        return false;
    }

    public int getFreeSpace() {
        return this.getFreeBlocks() * 512;
    }

    public int getFreeBlocks() {
        List list = this.getFiles();
        int n = this.getBlocksOnDisk() - 6;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                PascalFileEntry pascalFileEntry = (PascalFileEntry)list.get(i);
                n -= pascalFileEntry.getBlocksUsed();
            }
        }
        return n;
    }

    protected byte[] getVolumeEntry() {
        byte[] byArray = this.readBlock(2);
        byte[] byArray2 = new byte[26];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public int getBlocksOnDisk() {
        return AppleUtil.getWordValue(this.getVolumeEntry(), 14);
    }

    public int getFilesOnDisk() {
        return AppleUtil.getWordValue(this.getVolumeEntry(), 16);
    }

    public int getFirstBlock() {
        return AppleUtil.getWordValue(this.getVolumeEntry(), 18);
    }

    public Date getLastAccessDate() {
        return AppleUtil.getPascalDate(this.getVolumeEntry(), 18);
    }

    public Date getMostRecentDateSetting() {
        return AppleUtil.getPascalDate(this.getVolumeEntry(), 20);
    }

    public int getUsedSpace() {
        return this.getUsedBlocks() * 512;
    }

    public int getUsedBlocks() {
        List list = this.getFiles();
        int n = 6;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                PascalFileEntry pascalFileEntry = (PascalFileEntry)list.get(i);
                n += pascalFileEntry.getBlocksUsed();
            }
        }
        return n;
    }

    public String getDiskName() {
        return AppleUtil.getPascalString(this.readBlock(2), 6) + ":";
    }

    public void setDiskName(String string) {
        byte[] byArray = this.readDirectory();
        AppleUtil.setPascalString(byArray, 6, string.toUpperCase(), 7);
        this.writeDirectory(byArray);
    }

    public int[] getBitmapDimensions() {
        return null;
    }

    public int getBitmapLength() {
        return this.getBlocksOnDisk();
    }

    public FormattedDisk.DiskUsage getDiskUsage() {
        return new PascalDiskUsage();
    }

    public String[] getBitmapLabels() {
        return new String[]{this.textBundle.get("Block")};
    }

    public List getDiskInformation() {
        List list = super.getDiskInformation();
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("TotalBlocks"), this.getBlocksOnDisk()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("FreeBlocks"), this.getFreeBlocks()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("UsedBlocks"), this.getUsedBlocks()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("PascalFormatDisk.FilesOnDisk"), this.getFilesOnDisk()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("PascalFormatDisk.LastAccessDate"), this.getLastAccessDate()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("PascalFormatDisk.MostRecentDateSetting"), this.getMostRecentDateSetting()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("PascalFormatDisk.FirstBlock"), this.getFirstBlock()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("PascalFormatDisk.VolumeDate"), this.getLastAccessDate()));
        return list;
    }

    public List getFileColumnHeaders(int n) {
        ArrayList<FormattedDisk.FileColumnHeader> arrayList = new ArrayList<FormattedDisk.FileColumnHeader>();
        switch (n) {
            case 2: {
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Modified"), 8, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Blocks"), 3, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Filetype"), 8, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 15, 1));
                break;
            }
            case 3: {
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Modified"), 8, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Blocks"), 3, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("PascalFormatDisk.BytesInLastBlock"), 3, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("SizeInBytes"), 6, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Filetype"), 8, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 15, 1));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("PascalFormatDisk.FirstBlock"), 3, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("PascalFormatDisk.LastBlock"), 3, 3));
                break;
            }
            default: {
                arrayList.addAll(super.getFileColumnHeaders(n));
            }
        }
        return arrayList;
    }

    public boolean supportsDeletedFiles() {
        return false;
    }

    public boolean canReadFileData() {
        return true;
    }

    public boolean canWriteFileData() {
        return true;
    }

    public boolean canDeleteFile() {
        return true;
    }

    public byte[] getFileData(FileEntry fileEntry) {
        if (!(fileEntry instanceof PascalFileEntry)) {
            throw new IllegalArgumentException(this.textBundle.get("PascalFormatDisk.IncorrectFileEntryError"));
        }
        PascalFileEntry pascalFileEntry = (PascalFileEntry)fileEntry;
        int n = pascalFileEntry.getFirstBlock();
        int n2 = pascalFileEntry.getLastBlock();
        byte[] byArray = new byte[pascalFileEntry.getSize()];
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            byte[] byArray2 = this.readBlock(i);
            if (i == n2 - 1) {
                System.arraycopy(byArray2, 0, byArray, n3, pascalFileEntry.getBytesUsedInLastBlock());
            } else {
                System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
            }
            n3 += byArray2.length;
        }
        return byArray;
    }

    public void format() {
        this.getImageOrder().format();
        this.writeBootCode();
        byte[] byArray = this.readDirectory();
        AppleUtil.setWordValue(byArray, 0, 0);
        AppleUtil.setWordValue(byArray, 2, 6);
        AppleUtil.setWordValue(byArray, 4, 0);
        int n = this.getImageOrder().getBlocksOnDevice();
        AppleUtil.setWordValue(byArray, 14, n);
        AppleUtil.setWordValue(byArray, 16, 0);
        AppleUtil.setWordValue(byArray, 18, 0);
        AppleUtil.setPascalDate(byArray, 20, new Date());
        this.writeDirectory(byArray);
    }

    public int getLogicalDiskNumber() {
        return 0;
    }

    public String getSuggestedFilename(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!Character.isLetter(string.charAt(0))) {
            stringBuffer.append('A');
        }
        for (int i = 0; stringBuffer.length() < 15 && i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '.') continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString().toUpperCase().trim();
    }

    public String getSuggestedFiletype(String string) {
        String string2 = DATAFILE;
        int n = string.lastIndexOf(".");
        if (n > 0) {
            String string3 = string.substring(n + 1);
            if ("txt".equalsIgnoreCase(string3)) {
                string2 = TEXTFILE;
            } else if ("pas".equalsIgnoreCase(string3)) {
                string2 = CODEFILE;
            }
        }
        return string2;
    }

    public String[] getFiletypes() {
        return filetypes;
    }

    public boolean needsAddress(String string) {
        return false;
    }

    public boolean supportsDiskMap() {
        return true;
    }

    public void changeImageOrder(ImageOrder imageOrder) {
        AppleUtil.changeImageOrderByBlock(this.getImageOrder(), imageOrder);
        this.setImageOrder(imageOrder);
    }

    public void setFileData(FileEntry fileEntry, byte[] byArray) throws DiskFullException {
    }

    public DirectoryEntry createDirectory() throws DiskFullException {
        throw new UnsupportedOperationException(this.textBundle.get("DirectoryCreationNotSupported"));
    }

    private class PascalDiskUsage
    implements FormattedDisk.DiskUsage {
        private int location = -1;
        private BitSet bitmap = null;

        private PascalDiskUsage() {
        }

        public boolean hasNext() {
            return this.location == -1 || this.location < PascalFormatDisk.this.getBlocksOnDisk() - 1;
        }

        public void next() {
            if (this.bitmap == null) {
                this.bitmap = new BitSet(PascalFormatDisk.this.getBlocksOnDisk());
                for (int i = 6; i < PascalFormatDisk.this.getBlocksOnDisk(); ++i) {
                    this.bitmap.set(i);
                }
                Iterator iterator = PascalFormatDisk.this.getFiles().iterator();
                while (iterator.hasNext()) {
                    PascalFileEntry pascalFileEntry = (PascalFileEntry)iterator.next();
                    for (int i = pascalFileEntry.getFirstBlock(); i < pascalFileEntry.getLastBlock(); ++i) {
                        this.bitmap.clear(i);
                    }
                }
                this.location = 0;
            } else {
                ++this.location;
            }
        }

        public boolean isFree() {
            return this.bitmap.get(this.location);
        }

        public boolean isUsed() {
            return !this.bitmap.get(this.location);
        }
    }
}

