/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.diskimage;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.diskimage.DiskImageNamePane;
import com.webcodepro.applecommander.ui.swt.wizard.diskimage.DiskImageWizard;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DiskImageSizePane
extends WizardPane {
    private TextBundle textBundle = UiBundle.getInstance();
    private DiskImageWizard wizard;
    private Composite control;
    private Composite parent;

    public DiskImageSizePane(Composite composite, DiskImageWizard diskImageWizard) {
        this.parent = composite;
        this.wizard = diskImageWizard;
    }

    public WizardPane getNextPane() {
        return new DiskImageNamePane(this.parent, this.wizard);
    }

    public void open() {
        this.control = new Composite(this.parent, 0);
        this.wizard.enableNextButton(true);
        this.wizard.enableFinishButton(false);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.justify = true;
        rowLayout.marginBottom = 5;
        rowLayout.marginLeft = 5;
        rowLayout.marginRight = 5;
        rowLayout.marginTop = 5;
        rowLayout.spacing = 3;
        this.control.setLayout((Layout)rowLayout);
        Label label = new Label(this.control, 64);
        label.setText(this.textBundle.get("DiskImageSizePrompt"));
        RowLayout rowLayout2 = new RowLayout(512);
        rowLayout2.justify = true;
        rowLayout2.spacing = 3;
        Composite composite = new Composite(this.control, 0);
        composite.setLayout((Layout)rowLayout2);
        this.createRadioButton(composite, this.textBundle.get("DiskImageSize140Kb"), 143360, this.textBundle.get("DiskImageSize140KbText"));
        this.createRadioButton(composite, this.textBundle.get("DiskImageSize800Kb"), 819264, this.textBundle.get("DiskImageSize800KbText"));
        if (this.wizard.getFormat() == 3) {
            this.createRadioButton(composite, this.textBundle.get("DiskImageSize5Mb"), 0x500000, this.textBundle.get("DiskImageSize5MbText"));
            this.createRadioButton(composite, this.textBundle.get("DiskImageSize10Mb"), 0xA00000, this.textBundle.get("DiskImageSize10MbText"));
            this.createRadioButton(composite, this.textBundle.get("DiskImageSize20Mb"), 0x1400000, this.textBundle.get("DiskImageSize20MbText"));
            this.createRadioButton(composite, this.textBundle.get("DiskImageSize32Mb"), 33553920, this.textBundle.get("DiskImageSize32MbText"));
        }
    }

    protected void createRadioButton(Composite composite, String string, final int n, String string2) {
        Button button = new Button(composite, 16);
        button.setText(string);
        button.setToolTipText(string2);
        button.setSelection(this.wizard.getSize() == n);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskImageSizePane.this.getWizard().setSize(n);
            }
        });
    }

    public void dispose() {
        this.control.dispose();
    }

    protected DiskImageWizard getWizard() {
        return this.wizard;
    }
}

