/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.nakedos;

import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.filters.BinaryFileFilter;
import com.webcodepro.applecommander.storage.os.nakedos.NakedosFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class NakedosFileEntry
implements FileEntry {
    private TextBundle textBundle = StorageBundle.getInstance();
    private NakedosFormatDisk disk;
    private int fileNumber;
    private int size;

    public NakedosFileEntry(NakedosFormatDisk nakedosFormatDisk, int n, int n2) {
        this.disk = nakedosFormatDisk;
        this.fileNumber = n;
        this.size = n2;
    }

    public String getFilename() {
        return AppleUtil.getFormattedByte(this.fileNumber);
    }

    public int getFileNumber() {
        return this.fileNumber;
    }

    public void setFilename(String string) {
    }

    public String getFiletype() {
        return "B";
    }

    public void setFiletype(String string) {
    }

    public boolean isLocked() {
        return false;
    }

    public void setLocked(boolean bl) {
    }

    public int getSize() {
        return this.size * 256;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isDeleted() {
        return false;
    }

    public void delete() {
    }

    public List getFileColumnData(int n) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (n) {
            case 2: {
                arrayList.add(this.isLocked() ? "*" : " ");
                arrayList.add(this.getFiletype());
                numberFormat.setMinimumIntegerDigits(3);
                arrayList.add(numberFormat.format(this.getSize() / 256));
                arrayList.add(this.getFilename());
                break;
            }
            case 3: {
                arrayList.add(this.isLocked() ? "*" : " ");
                arrayList.add(this.getFiletype());
                arrayList.add(this.getFilename());
                arrayList.add(numberFormat.format(this.getSize()));
                numberFormat.setMinimumIntegerDigits(3);
                arrayList.add(numberFormat.format(this.getSize() / 256));
                arrayList.add(this.isDeleted() ? this.textBundle.get("Deleted") : "");
                break;
            }
            default: {
                arrayList.add(this.getFilename());
                arrayList.add(this.getFiletype());
                arrayList.add(numberFormat.format(this.getSize()));
                arrayList.add(this.isLocked() ? this.textBundle.get("Locked") : "");
            }
        }
        return arrayList;
    }

    public byte[] getFileData() {
        return this.disk.getFileData(this);
    }

    public void setFileData(byte[] byArray) throws DiskFullException {
        this.disk.setFileData(this, byArray);
    }

    public FileFilter getSuggestedFilter() {
        return new BinaryFileFilter();
    }

    public FormattedDisk getFormattedDisk() {
        return this.disk;
    }

    public int getMaximumFilenameLength() {
        return 2;
    }

    public boolean needsAddress() {
        return false;
    }

    public void setAddress(int n) {
    }

    public boolean canCompile() {
        return false;
    }

    public boolean equals(Object object) {
        return this.getFilename().equals(((NakedosFileEntry)object).getFilename());
    }
}

