/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.gutenberg;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.gutenberg.GutenbergFileEntry;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.util.ArrayList;
import java.util.List;

public class GutenbergFormatDisk
extends FormattedDisk {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int TRACK_LOCATION_INDEX = 0;
    public static final int SECTOR_LOCATION_INDEX = 1;
    public static final int CATALOG_TRACK = 17;
    public static final int VTOC_SECTOR = 7;
    public static final int TRACK_SECTOR_PAIRS = 122;
    private static final String[] filetypes = new String[]{"T"};

    public GutenbergFormatDisk(String string, ImageOrder imageOrder) {
        super(string, imageOrder);
    }

    public static GutenbergFormatDisk[] create(String string, ImageOrder imageOrder) {
        GutenbergFormatDisk gutenbergFormatDisk = new GutenbergFormatDisk(string, imageOrder);
        gutenbergFormatDisk.format();
        return new GutenbergFormatDisk[]{gutenbergFormatDisk};
    }

    public String getFormat() {
        return this.textBundle.get("Gutenberg");
    }

    public List getFiles() {
        ArrayList<GutenbergFileEntry> arrayList = new ArrayList<GutenbergFileEntry>();
        int n = 17;
        int n2 = 7;
        while (n < 40) {
            byte[] byArray = this.readSector(n, n2);
            for (int i = 32; i < 255; i += 16) {
                if (byArray[i] == -96) continue;
                arrayList.add(new GutenbergFileEntry(this, n, n2, i));
            }
            n = AppleUtil.getUnsignedByte(byArray[4]);
            n2 = AppleUtil.getUnsignedByte(byArray[5]);
        }
        return arrayList;
    }

    public FileEntry createFile() throws DiskFullException {
        byte[] byArray = this.readVtoc();
        int n = AppleUtil.getUnsignedByte(byArray[1]);
        int n2 = AppleUtil.getUnsignedByte(byArray[2]);
        while (n2 != 0) {
            byte[] byArray2 = this.readSector(n, n2);
            for (int i = 11; i < 255; i += 16) {
                int n3 = AppleUtil.getUnsignedByte(byArray2[i]);
                if (n3 != 0 && n3 != 255) continue;
                return new GutenbergFileEntry(this, n, n2, i);
            }
            n = byArray2[1];
            n2 = byArray2[2];
        }
        throw new DiskFullException(this.textBundle.get("DosFormatDisk.NoMoreSpaceError"));
    }

    public boolean canCreateDirectories() {
        return false;
    }

    public boolean canCreateFile() {
        return false;
    }

    public int getFreeSpace() {
        return this.getFreeSectors() * 256;
    }

    public int getFreeSectors() {
        return 0;
    }

    public int getUsedSpace() {
        return 143360;
    }

    public int getUsedSectors() {
        return this.getTotalSectors() - this.getFreeSectors();
    }

    public int getTotalSectors() {
        int n = this.getTracks();
        int n2 = this.getSectors();
        return n * n2;
    }

    public String getDiskName() {
        return AppleUtil.getString(this.readVtoc(), 6, 9).trim();
    }

    protected byte[] readVtoc() {
        return this.readSector(17, 7);
    }

    protected void writeVtoc(byte[] byArray) {
        this.writeSector(17, 7, byArray);
    }

    public FormattedDisk.DiskUsage getDiskUsage() {
        return new WPDiskUsage();
    }

    public int getTracks() {
        byte[] byArray = this.readVtoc();
        return AppleUtil.getUnsignedByte(byArray[52]);
    }

    public int getSectors() {
        byte[] byArray = this.readVtoc();
        return AppleUtil.getUnsignedByte(byArray[53]);
    }

    public int[] getBitmapDimensions() {
        int n = this.getTracks();
        int n2 = this.getSectors();
        return new int[]{n, n2};
    }

    public int getBitmapLength() {
        return this.getTotalSectors();
    }

    public String[] getBitmapLabels() {
        return new String[]{this.textBundle.get("DosFormatDisk.Track"), this.textBundle.get("DosFormatDisk.Sector")};
    }

    public List getDiskInformation() {
        List list = super.getDiskInformation();
        return list;
    }

    public List getFileColumnHeaders(int n) {
        ArrayList<FormattedDisk.FileColumnHeader> arrayList = new ArrayList<FormattedDisk.FileColumnHeader>();
        switch (n) {
            case 2: {
                arrayList.add(new FormattedDisk.FileColumnHeader(" ", 1, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.Type"), 1, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.SizeInSectors"), 3, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 30, 1));
                break;
            }
            case 3: {
                arrayList.add(new FormattedDisk.FileColumnHeader(" ", 1, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.Type"), 1, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 30, 1));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("SizeInBytes"), 6, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.SizeInSectors"), 3, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DeletedQ"), 7, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.TrackAndSectorList"), 7, 2));
                break;
            }
            default: {
                arrayList.addAll(super.getFileColumnHeaders(n));
            }
        }
        return arrayList;
    }

    public boolean supportsDeletedFiles() {
        return true;
    }

    public boolean canReadFileData() {
        return true;
    }

    public boolean canWriteFileData() {
        return false;
    }

    public boolean canHaveDirectories() {
        return false;
    }

    public boolean canDeleteFile() {
        return false;
    }

    public byte[] getFileData(FileEntry fileEntry) {
        if (!(fileEntry instanceof GutenbergFileEntry)) {
            throw new IllegalArgumentException(this.textBundle.get("DosFormatDisk.InvalidFileEntryError"));
        }
        GutenbergFileEntry gutenbergFileEntry = (GutenbergFileEntry)fileEntry;
        int n = gutenbergFileEntry.getSectorsUsed();
        byte[] byArray = null;
        if (n <= 0) {
            byArray = new byte[]{};
            return byArray;
        }
        byArray = new byte[gutenbergFileEntry.getSectorsUsed() * 256];
        int n2 = gutenbergFileEntry.getTrack();
        int n3 = gutenbergFileEntry.getSector();
        int n4 = 0;
        while (n2 < 128) {
            byte[] byArray2 = this.readSector(n2, n3);
            n2 = AppleUtil.getUnsignedByte(byArray2[4]);
            n3 = AppleUtil.getUnsignedByte(byArray2[5]);
            System.arraycopy(byArray2, 6, byArray, n4, byArray2.length - 6);
            n4 += byArray2.length - 6;
        }
        return byArray;
    }

    public void setFileData(FileEntry fileEntry, byte[] byArray) throws DiskFullException {
        this.setFileData((GutenbergFileEntry)fileEntry, byArray);
    }

    protected void setFileData(GutenbergFileEntry gutenbergFileEntry, byte[] byArray) throws DiskFullException {
        int n = (byArray.length + 256 - 1) / 256;
        int n2 = n + (n + 122 - 1) / 122;
        if (n2 > this.getFreeSectors() + gutenbergFileEntry.getSectorsUsed()) {
            throw new DiskFullException(this.textBundle.format("DosFormatDisk.NotEnoughSectorsError", n2, this.getFreeSectors()));
        }
        byte[] byArray2 = this.readVtoc();
        int n3 = gutenbergFileEntry.getTrack();
        int n4 = gutenbergFileEntry.getSector();
        if (n3 == 0 || n3 == 255) {
            n3 = 1;
            n4 = 0;
            while (!this.isSectorFree(n3, n4, byArray2)) {
                if (++n4 < this.getSectors()) continue;
                ++n3;
                n4 = 0;
            }
            gutenbergFileEntry.setTrack(n3);
            gutenbergFileEntry.setSector(n4);
        }
        this.setSectorUsed(n3, n4, byArray2);
        byte[] byArray3 = new byte[256];
        int n5 = 0;
        int n6 = 12;
        int n7 = 0;
        int n8 = 1;
        int n9 = 0;
        while (n5 < byArray.length) {
            while (!this.isSectorFree(n8, n9, byArray2)) {
                if (++n9 < this.getSectors()) continue;
                ++n8;
                n9 = 0;
            }
            this.setSectorUsed(n8, n9, byArray2);
            if (n6 >= 256) {
                byArray3[1] = (byte)n8;
                byArray3[2] = (byte)n9;
                this.writeSector(n3, n4, byArray3);
                byArray3 = new byte[256];
                n6 = 12;
                n3 = n8;
                n4 = n9;
            } else {
                byArray3[n6] = (byte)n8;
                byArray3[n6 + 1] = (byte)n9;
                n6 += 2;
                byte[] byArray4 = new byte[256];
                int n10 = Math.min(256, byArray.length - n5);
                System.arraycopy(byArray, n5, byArray4, 0, n10);
                this.writeSector(n8, n9, byArray4);
                n5 += 256;
            }
            ++n7;
        }
        this.writeSector(n3, n4, byArray3);
        gutenbergFileEntry.setSectorsUsed(++n7);
        this.writeVtoc(byArray2);
    }

    public void format() {
        this.getImageOrder().format();
        this.format(15, 35, 16);
    }

    protected void format(int n, int n2, int n3) {
        int n4;
        this.writeBootCode();
        byte[] byArray = new byte[256];
        for (n4 = n; n4 > 0; --n4) {
            if (n4 > 1) {
                byArray[1] = 17;
                byArray[2] = (byte)(n4 - 1);
            } else {
                byArray[1] = 0;
                byArray[2] = 0;
            }
            this.writeSector(17, n4, byArray);
        }
        byArray[1] = 17;
        byArray[2] = (byte)n;
        byArray[3] = 3;
        byArray[6] = -2;
        byArray[39] = 122;
        byArray[48] = 18;
        byArray[49] = 1;
        byArray[52] = (byte)n2;
        byArray[53] = (byte)n3;
        byArray[55] = 1;
        for (n4 = 0; n4 < n2; ++n4) {
            for (int i = 0; i < n3; ++i) {
                if (n4 == 0 || n4 == 17) {
                    this.setSectorUsed(n4, i, byArray);
                    continue;
                }
                this.setSectorFree(n4, i, byArray);
            }
        }
        this.writeVtoc(byArray);
    }

    public boolean isSectorFree(int n, int n2, byte[] byArray) {
        this.checkRange(n, n2);
        byte by = byArray[this.getFreeMapByte(n, n2)];
        return AppleUtil.isBitSet(by, this.getFreeMapBit(n2));
    }

    public boolean isSectorUsed(int n, int n2, byte[] byArray) {
        return !this.isSectorFree(n, n2, byArray);
    }

    public void setSectorFree(int n, int n2, byte[] byArray) {
        this.checkRange(n, n2);
        int n3 = this.getFreeMapByte(n, n2);
        byte by = byArray[n3];
        byArray[n3] = by = AppleUtil.setBit(by, this.getFreeMapBit(n2));
    }

    public void setSectorUsed(int n, int n2, byte[] byArray) {
        this.checkRange(n, n2);
        int n3 = this.getFreeMapByte(n, n2);
        byte by = byArray[n3];
        byArray[n3] = by = AppleUtil.clearBit(by, this.getFreeMapBit(n2));
    }

    protected int getFreeMapByte(int n, int n2) {
        int n3 = n * 4;
        int n4 = 1 - ((n2 & 8) >> 3);
        return 56 + n3 + n4;
    }

    protected int getFreeMapBit(int n) {
        int n2 = n & 7;
        return n2;
    }

    protected void checkRange(int n, int n2) {
        if (n > 50 || n2 > 32) {
            throw new IllegalArgumentException(this.textBundle.format("DosFormatDisk.InvalidTrackAndSectorCombinationError", n, n2));
        }
    }

    public int getLogicalDiskNumber() {
        return 0;
    }

    public String getSuggestedFilename(String string) {
        int n = Math.min(string.length(), 12);
        return string.toUpperCase().substring(0, n).trim();
    }

    public String getSuggestedFiletype(String string) {
        return "T";
    }

    public String[] getFiletypes() {
        return filetypes;
    }

    public boolean needsAddress(String string) {
        return "B".equals(string);
    }

    public boolean supportsDiskMap() {
        return true;
    }

    public void changeImageOrder(ImageOrder imageOrder) {
        AppleUtil.changeImageOrderByTrackAndSector(this.getImageOrder(), imageOrder);
        this.setImageOrder(imageOrder);
    }

    public DirectoryEntry createDirectory() throws DiskFullException {
        throw new UnsupportedOperationException(this.textBundle.get("DirectoryCreationNotSupported"));
    }

    private class WPDiskUsage
    implements FormattedDisk.DiskUsage {
        private int[] location = null;

        private WPDiskUsage() {
        }

        public boolean hasNext() {
            return this.location == null || this.location[0] < GutenbergFormatDisk.this.getTracks() && this.location[1] < GutenbergFormatDisk.this.getSectors();
        }

        public void next() {
            if (this.location == null) {
                this.location = new int[2];
            } else {
                this.location[1] = this.location[1] + 1;
                if (this.location[1] >= GutenbergFormatDisk.this.getSectors()) {
                    this.location[1] = 0;
                    this.location[0] = this.location[0] + 1;
                }
            }
        }

        public boolean isFree() {
            if (this.location == null || this.location.length != 2) {
                throw new IllegalArgumentException(StorageBundle.getInstance().get("DosFormatDisk.InvalidDimensionError"));
            }
            return false;
        }

        public boolean isUsed() {
            return !this.isFree();
        }
    }
}

