/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.dos33;

import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.dos33.DosFormatDisk;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.TextBundle;

public class OzDosFormatDisk
extends DosFormatDisk {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int OZDOS_DISK_1 = 0;
    public static final int OZDOS_DISK_2 = 256;
    private int logicalOffset;

    public OzDosFormatDisk(String string, ImageOrder imageOrder, int n) {
        super(string, imageOrder);
        this.logicalOffset = n;
    }

    public static DosFormatDisk[] create(String string, ImageOrder imageOrder) {
        OzDosFormatDisk ozDosFormatDisk = new OzDosFormatDisk(string, imageOrder, 0);
        OzDosFormatDisk ozDosFormatDisk2 = new OzDosFormatDisk(string, imageOrder, 256);
        ozDosFormatDisk.format();
        ozDosFormatDisk2.format();
        return new OzDosFormatDisk[]{ozDosFormatDisk, ozDosFormatDisk2};
    }

    public String getDiskName() {
        if (this.logicalOffset == 0) {
            return this.textBundle.format("DiskNameN", super.getDiskName(), 1);
        }
        if (this.logicalOffset == 256) {
            return this.textBundle.format("DiskNameN", super.getDiskName(), 2);
        }
        return super.getDiskName();
    }

    public int getLogicalDiskNumber() {
        if (this.logicalOffset == 0) {
            return 1;
        }
        if (this.logicalOffset == 256) {
            return 2;
        }
        return 0;
    }

    public void format() {
        this.getImageOrder().format();
        this.format(31, 50, 32);
    }

    public byte[] readSector(int n, int n2) throws IllegalArgumentException {
        byte[] byArray = this.readBlock(this.getBlockNumber(n, n2));
        byte[] byArray2 = new byte[256];
        System.arraycopy(byArray, this.logicalOffset, byArray2, 0, 256);
        return byArray2;
    }

    public void writeSector(int n, int n2, byte[] byArray) throws IllegalArgumentException {
        int n3 = this.getBlockNumber(n, n2);
        byte[] byArray2 = this.readBlock(n3);
        System.arraycopy(byArray, 0, byArray2, this.logicalOffset, 256);
        this.getImageOrder().writeBlock(n3, byArray2);
    }

    protected int getBlockNumber(int n, int n2) {
        return n * 32 + n2;
    }
}

