/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swing;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.UserPreferences;
import com.webcodepro.applecommander.ui.swing.DiskExplorer;
import com.webcodepro.applecommander.ui.swing.EmulatorFileFilter;
import com.webcodepro.applecommander.util.TextBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;

public class SwingAppleCommander
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -3302293994498495537L;
    private UserPreferences userPreferences = UserPreferences.getInstance();
    private TextBundle textBundle = UiBundle.getInstance();
    private JTabbedPane tabPane;
    private JLabel titleLabel;

    public static void main(String[] stringArray) {
        new SwingAppleCommander().launch();
    }

    public void launch() {
        JMenuBar jMenuBar = this.createMenuBar();
        JToolBar jToolBar = new JToolBar();
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tabPane = new JTabbedPane(1);
        jPanel.add((Component)jMenuBar, "North");
        jPanel.add((Component)jToolBar, "South");
        JButton jButton = new JButton(this.textBundle.get("OpenButton"), new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/webcodepro/applecommander/ui/images/opendisk.gif"))));
        jButton.setToolTipText(this.textBundle.get("SwtAppleCommander.OpenDiskImageTooltip"));
        jButton.setHorizontalTextPosition(0);
        jButton.setVerticalTextPosition(3);
        jButton.addActionListener(this);
        jToolBar.add(jButton);
        JButton jButton2 = new JButton(this.textBundle.get("CreateButton"), new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/webcodepro/applecommander/ui/images/newdisk.gif"))));
        jButton2.setToolTipText(this.textBundle.get("SwtAppleCommander.CreateDiskImageTooltip"));
        jButton2.setHorizontalTextPosition(0);
        jButton2.setVerticalTextPosition(3);
        jButton2.addActionListener(this);
        jToolBar.add(jButton2);
        JButton jButton3 = new JButton(this.textBundle.get("CompareButton"), new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/webcodepro/applecommander/ui/images/comparedisks.gif"))));
        jButton3.setToolTipText(this.textBundle.get("SwtAppleCommander.CompareDiskImageTooltip"));
        jButton3.setHorizontalTextPosition(0);
        jButton3.setVerticalTextPosition(3);
        jButton3.addActionListener(this);
        jToolBar.add(jButton3);
        JButton jButton4 = new JButton(this.textBundle.get("AboutButton"), new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/webcodepro/applecommander/ui/images/about.gif"))));
        jButton4.setToolTipText(this.textBundle.get("SwtAppleCommander.AboutTooltip"));
        jButton4.setHorizontalTextPosition(0);
        jButton4.setVerticalTextPosition(3);
        jButton4.addActionListener(this);
        jToolBar.add(jButton4);
        SwingAppleCommander swingAppleCommander = new SwingAppleCommander();
        swingAppleCommander.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/webcodepro/applecommander/ui/images/diskicon.gif")));
        swingAppleCommander.setTitle(this.textBundle.get("SwtAppleCommander.AppleCommander"));
        this.titleLabel = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/webcodepro/applecommander/ui/images/AppleCommanderLogo.gif"))));
        this.addTitleTabPane();
        swingAppleCommander.getContentPane().add((Component)jPanel, "North");
        swingAppleCommander.getContentPane().add((Component)this.tabPane, "Center");
        swingAppleCommander.setDefaultCloseOperation(3);
        swingAppleCommander.pack();
        swingAppleCommander.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(this.textBundle.get("AboutButton"))) {
            this.showAboutAppleCommander();
        } else if (actionEvent.getActionCommand().equals(this.textBundle.get("OpenButton")) || actionEvent.getActionCommand().equals(this.textBundle.get("SwingAppleCommander.MenuFileOpen"))) {
            this.openFile();
        } else if (actionEvent.getActionCommand().equals(this.textBundle.get("SwingAppleCommander.MenuFileClose"))) {
            this.closeFile();
        } else if (actionEvent.getActionCommand().equals(this.textBundle.get("SwingAppleCommander.MenuFileQuit"))) {
            UserPreferences.getInstance().save();
            this.setVisible(false);
            this.dispose();
            System.exit(0);
        } else {
            System.out.println("Unhandled action: " + actionEvent.getActionCommand());
        }
    }

    JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(this.textBundle.get("SwingAppleCommander.MenuFile"));
        JMenuItem jMenuItem = new JMenuItem(this.textBundle.get("SwingAppleCommander.MenuFileOpen"));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(this.textBundle.get("SwingAppleCommander.MenuFileClose"));
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(this.textBundle.get("SwingAppleCommander.MenuFileNew"));
        jMenuItem3.addActionListener(this);
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem(this.textBundle.get("SwingAppleCommander.MenuFileQuit"));
        jMenuItem4.addActionListener(this);
        jMenu.add(jMenuItem4);
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    void addTitleTabPane() {
        this.tabPane.add(this.textBundle.get("SwtAppleCommander.AppleCommander"), this.titleLabel);
    }

    protected void openFile() {
        JFileChooser jFileChooser = new JFileChooser();
        String string = this.userPreferences.getDiskImageDirectory();
        if (null == string) {
            string = "";
        }
        jFileChooser.setCurrentDirectory(new File(string));
        EmulatorFileFilter emulatorFileFilter = new EmulatorFileFilter();
        jFileChooser.setFileFilter(emulatorFileFilter);
        int n = jFileChooser.showDialog(this, this.textBundle.get("Open"));
        if (n == 0) {
            this.userPreferences.setDiskImageDirectory(jFileChooser.getSelectedFile().getParent());
            UserPreferences.getInstance().save();
            this.addDiskExplorerTab(jFileChooser.getSelectedFile());
        }
    }

    protected void addDiskExplorerTab(File file) {
        if (this.tabPane.getTitleAt(0).equals(this.textBundle.get("SwtAppleCommander.AppleCommander"))) {
            this.tabPane.remove(0);
        }
        this.tabPane.add(file.getName(), new DiskExplorer());
        this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
    }

    protected void closeFile() {
        if (!this.tabPane.getTitleAt(0).equals(this.textBundle.get("SwtAppleCommander.AppleCommander"))) {
            this.tabPane.remove(this.tabPane.getSelectedIndex());
        }
        if (this.tabPane.getTabCount() == 0) {
            this.addTitleTabPane();
        }
    }

    public void showAboutAppleCommander() {
        JOptionPane.showMessageDialog(null, this.textBundle.format("SwtAppleCommander.AboutMessage", new Object[]{"1.3.5.10", this.textBundle.get("Copyright")}), this.textBundle.get("SwtAppleCommander.AboutTitle"), 1);
    }
}

