/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.cpm;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.cpm.CpmFileEntry;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class CpmFormatDisk
extends FormattedDisk {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int CPM_SECTORSIZE = 128;
    public static final int CPM_BLOCKSIZE = 1024;
    public static final int CPM_SECTORS_PER_CPM_BLOCK = 8;
    public static final int CPM_BLOCKS_PER_TRACK = 4;
    public static final int PHYSICAL_SECTORS_PER_BLOCK = 4;
    public static final int PHYSICAL_BLOCK_TRACK_START = 3;
    public static final int[] sectorSkew = new int[]{0, 6, 12, 3, 9, 15, 14, 5, 11, 2, 8, 7, 13, 4, 10, 1};

    public CpmFormatDisk(String string, ImageOrder imageOrder) {
        super(string, imageOrder);
    }

    public static CpmFormatDisk[] create(String string, ImageOrder imageOrder) {
        CpmFormatDisk cpmFormatDisk = new CpmFormatDisk(string, imageOrder);
        cpmFormatDisk.format();
        return new CpmFormatDisk[]{cpmFormatDisk};
    }

    public String getDiskName() {
        return this.textBundle.get("CpmFormatDisk.DiskName");
    }

    public String getFormat() {
        return this.textBundle.get("CpmFormatDisk.Cpm");
    }

    public int getFreeSpace() {
        return this.getPhysicalSize() - this.getUsedSpace();
    }

    public int getUsedSpace() {
        int n = this.getBlocksUsed();
        return n * 1024 + 12288;
    }

    public int getBlocksUsed() {
        List list = this.getFiles();
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            CpmFileEntry cpmFileEntry = (CpmFileEntry)list.get(i);
            n = cpmFileEntry.getBlocksUsed();
        }
        return n;
    }

    public int[] getBitmapDimensions() {
        return null;
    }

    public int getBitmapLength() {
        return this.getPhysicalSize() / 1024;
    }

    public FormattedDisk.DiskUsage getDiskUsage() {
        boolean[] blArray = new boolean[this.getBitmapLength()];
        int n = 12;
        for (int i = 0; i < n + 2; ++i) {
            blArray[i] = true;
        }
        List list = this.getFiles();
        for (int i = 0; i < list.size(); ++i) {
            CpmFileEntry cpmFileEntry = (CpmFileEntry)list.get(i);
            int[] nArray = cpmFileEntry.getAllocations();
            for (int j = 0; j < nArray.length; ++j) {
                int n2 = n + nArray[j];
                blArray[n2] = true;
            }
        }
        return new CpmDiskUsage(blArray);
    }

    public String[] getBitmapLabels() {
        return new String[]{this.textBundle.get("CpmFormatDisk.BitmapLabel")};
    }

    public boolean supportsDeletedFiles() {
        return true;
    }

    public boolean canReadFileData() {
        return true;
    }

    public boolean canWriteFileData() {
        return false;
    }

    public boolean canHaveDirectories() {
        return false;
    }

    public boolean canDeleteFile() {
        return true;
    }

    public byte[] getFileData(FileEntry fileEntry) {
        CpmFileEntry cpmFileEntry = (CpmFileEntry)fileEntry;
        int[] nArray = cpmFileEntry.getAllocations();
        byte[] byArray = new byte[nArray.length * 1024];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n <= 0) continue;
            byte[] byArray2 = this.readCpmBlock(n);
            System.arraycopy(byArray2, 0, byArray, i * 1024, 1024);
        }
        return byArray;
    }

    public void format() {
        int n;
        this.getImageOrder().format();
        byte[] byArray = new byte[256];
        for (n = 0; n < 256; ++n) {
            byArray[n] = -27;
        }
        for (n = 0; n < 35; ++n) {
            for (int i = 0; i < 16; ++i) {
                this.writeSector(n, i, byArray);
            }
        }
    }

    public int getLogicalDiskNumber() {
        return 0;
    }

    public String getSuggestedFilename(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        string = stringTokenizer.nextToken();
        StringBuffer stringBuffer = new StringBuffer();
        if (!Character.isLetter(string.charAt(0))) {
            stringBuffer.append('A');
        }
        for (int i = 0; stringBuffer.length() < 8 && i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '.') continue;
            stringBuffer.append(c);
        }
        while (stringBuffer.length() < 8) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString().toUpperCase().trim();
    }

    public String getSuggestedFiletype(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        stringTokenizer.nextToken();
        string = "";
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() > 0 && !Character.isLetter(string.charAt(0))) {
            stringBuffer.append('A');
        }
        for (int i = 0; stringBuffer.length() < 3 && i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '.') continue;
            stringBuffer.append(c);
        }
        while (stringBuffer.length() < 3) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString().toUpperCase().trim();
    }

    public String[] getFiletypes() {
        return null;
    }

    public boolean needsAddress(String string) {
        return false;
    }

    public List getFiles() {
        ArrayList<CpmFileEntry> arrayList = new ArrayList<CpmFileEntry>();
        HashMap<String, CpmFileEntry> hashMap = new HashMap<String, CpmFileEntry>();
        for (int i = 0; i < 64; ++i) {
            int n = i * 32;
            CpmFileEntry cpmFileEntry = new CpmFileEntry(this, n);
            if (cpmFileEntry.isEmpty()) continue;
            String string = cpmFileEntry.getFilename().trim() + "." + cpmFileEntry.getFiletype().trim() + ":" + cpmFileEntry.getUserNumber(0);
            if (hashMap.containsKey(string)) {
                cpmFileEntry = (CpmFileEntry)hashMap.get(string);
                cpmFileEntry.addOffset(n);
                continue;
            }
            arrayList.add(cpmFileEntry);
            hashMap.put(string, cpmFileEntry);
        }
        return arrayList;
    }

    public FileEntry createFile() throws DiskFullException {
        return null;
    }

    public boolean canCreateDirectories() {
        return false;
    }

    public boolean canCreateFile() {
        return false;
    }

    public byte[] readCpmBlock(int n) {
        byte[] byArray = new byte[1024];
        int n2 = this.computeTrack(n);
        int n3 = this.computeSector(n);
        for (int i = 0; i < 4; ++i) {
            System.arraycopy(this.readSector(n2, sectorSkew[n3 + i]), 0, byArray, i * 256, 256);
        }
        return byArray;
    }

    protected int computeTrack(int n) {
        return 3 + n / 4;
    }

    protected int computeSector(int n) {
        return n % 4 * 4;
    }

    public void writeCpmBlock(int n, byte[] byArray) {
        int n2 = this.computeTrack(n);
        int n3 = this.computeSector(n);
        byte[] byArray2 = new byte[256];
        for (int i = 0; i < 4; ++i) {
            System.arraycopy(byArray, i * 256, byArray2, 0, 256);
            this.writeSector(n2, sectorSkew[n3 + i], byArray2);
        }
    }

    public List getFileColumnHeaders(int n) {
        ArrayList<FormattedDisk.FileColumnHeader> arrayList = new ArrayList<FormattedDisk.FileColumnHeader>();
        switch (n) {
            case 2: {
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 8, 1));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Type"), 3, 1));
                break;
            }
            case 3: {
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 8, 1));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Type"), 3, 1));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("SizeInBytes"), 6, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("CpmFormatDisk.UserNumber"), 4, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DeletedQ"), 7, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("LockedQ"), 6, 2));
                break;
            }
            default: {
                arrayList.addAll(super.getFileColumnHeaders(n));
            }
        }
        return arrayList;
    }

    public boolean supportsDiskMap() {
        return true;
    }

    public void changeImageOrder(ImageOrder imageOrder) {
        AppleUtil.changeImageOrderByTrackAndSector(this.getImageOrder(), imageOrder);
        this.setImageOrder(imageOrder);
    }

    public void setFileData(FileEntry fileEntry, byte[] byArray) throws DiskFullException {
    }

    public DirectoryEntry createDirectory() throws DiskFullException {
        throw new UnsupportedOperationException(this.textBundle.get("DirectoryCreationNotSupported"));
    }

    public class CpmDiskUsage
    implements FormattedDisk.DiskUsage {
        int block = -1;
        boolean[] usage = null;

        public CpmDiskUsage(boolean[] blArray) {
            this.usage = blArray;
        }

        public boolean hasNext() {
            return this.block < this.usage.length - 1;
        }

        public void next() {
            ++this.block;
        }

        public boolean isFree() {
            return !this.isUsed();
        }

        public boolean isUsed() {
            return this.usage[this.block];
        }
    }
}

