/* ABINLOAD.c by bill buckels 2007        */
/* a picture viewer for the apple //e     */
/* written in Manx Aztec C65 Version 3.2b */
/* runs under PRODOS 8                    */
/* displays BSaved HIRES Images           */
/* requires a text script called piclist  */

#include <console.h>
#include <stdio.h>
#include <fcntl.h>
#include <prodos.h>
#include <sgtty.h>
#include <device.h>
#include <sysfunc.h>

#define TEXTMODE  0
#define GRAFMODE  2  /* graphics only           */

int getch();
#define clearscreen() fbox(0,0,39,191,0)


main()
{
    FILE *fp;
    int idx,row,bsaved;
    char picname[66];

   setcrtmode(GRAFMODE);
   if (getch() == 27)goto ENDER;
   setcrtmode(TEXTMODE);
   scr_clear();

 STARTER:;
   row = 1;
   scr_curs(row,0);
   printf("ABINLOAD.SYSTEM by Bill Buckels 2007");
   row+=2;
   scr_curs(row,0);
   printf("Picture Names :                  ");
   row++;

   if((fp=fopen("PICLIST","r"))==NULL)goto ENDER;
   fgets(picname,66,fp); /* get the first filename */

   while(picname[0]>' ' && picname[0] < '{')
   {
        idx=0;  /* replace carriage return with null */
        while(picname[idx]!=0)
         {
         if(picname[idx]< ' ')picname[idx]= 0;
         else idx++;
         }
    row++;
    scr_curs(row,10);
    printf(picname);
    fgets(picname,66,fp);
    }
    fclose(fp);


    /* now that we are displaying the picture list we accept input */
   row+=2;
   scr_curs(row,0);
   printf("Enter Picture Name: ");
   scr_curs(row,22);
   gets(picname,66,fp); /* get the filename */

   idx=0;
   bsaved=1;
   while(picname[idx]!=0)
        {

 			if(picname[idx] == '.') {
 			   if (picname[idx+1] == 'B' && picname[idx+2] == 'O' && picname[idx+3] == 'T')
 			      bsaved = 0;
 			   else  if (picname[idx+1] == 'T' && picname[idx+2] == 'O' && picname[idx+3] == 'P')
 			      bsaved = 0;
  			   else  if (picname[idx+1] == 'R' && picname[idx+2] == 'A' && picname[idx+3] == 'G')
 			      bsaved = 0;
			}

            if(picname[idx]<' ')picname[idx]=0;
            else idx++;
        }

   if (picname[0] == 0)goto ENDER;

   clearscreen();
   setcrtmode(GRAFMODE);
   if (bsaved == 0) piclode(picname);
   else bload(picname);

   scr_clear();
   if(getch()==27)goto ENDER;
   setcrtmode(TEXTMODE);
   goto STARTER;

  ENDER:;
    setcrtmode(TEXTMODE);
    _exit();
}


bload(name)
char *name;
{
   int fh;

   fh = open(name,O_RDONLY,0x04); /* open a binary file */
   read(fh,(char *)0x4000,0x2000);
   close(fh);

}

piclode(name)
char *name;
{
   int fh,y,y1=0,x1,temp,bos;
   char buffer[41];

   int height,packet;
   char tempchar[2];

   fh = open(name,O_RDONLY,0x04); /* open a binary file */

   read(fh,tempchar,2);

   packet= (int)tempchar[0];
   height= (int)tempchar[1];

   /* center the picture in the screen */

   x1 = 20-(packet/2); /* break on even byte boundaries */
   if((x1%2)!=0)x1--;

   if(height<192)
   {
    clearscreen();
    sprintf(buffer,"Now Displaying %s",name);
    dofont(buffer,180,10);
   }
   bos=y1+height;

   for(y=y1;y<bos;y++)
   {
     gethibase(y,&temp);
     read(fh,(char *)(temp+x1),packet); /* read each raster to the screen */
     }
   close(fh);

}

dofont(str,y,x)
char *str;
int y,x;
{
    char c;
    while((c=*str++)!=0)plotchar(c,x++,y);
}


