         lst   off

* UNIX getopt library utility
*
* 1992, tao Developer Project

         rel
         xc
         xc
         mx    %00

         put   memory.h   ;memory manager defines
         put   env.h      ;run-time environment settings

         use   datatype.mac ;HLL data type macros
         use   env.mac    ;run-time environment macros
         use   memory.mac ;memory manager macros
         use   utility.mac ;utility macros
         use   texttool.mac ;text toolset macros


option   mac
         cStr  ]1         ;name of option
         Short ]2         ;if option has arguments
         ShortPtr ]3      ;flags
         Short ]4         ;value of variable if no option assigned
         eom

shorta   mac
         mx    %10
         sep   %00100000
         eom
longa    mac
         mx    %00
         rep   %00100000
         eom
incr     mac              ;longword inc
         if    1,]0
         inc   ]1
         bne   end
         inc   ]1+2
         else
         clc
         lda   ]2
         adc   ]1
         sta   ]2
         bcc   end
         inc   ]2+2
end      fin
         eom

_DebugStr mac
         pea   #^]1
         pea   #]1
         ldx   #$09ff
         jsl   $e10000
         eom

OTHER_OPTION_EDGE equ 70  ;right edge to display alternate partial matches

TAB_CHAR equ   $09        ;tab character
EOF      equ   $ffff
UNRECOGNIZED_OPT equ '?'

                          ;option data structure offsets
`has_arg equ   $00        ;if option has arguments
`flag    equ   `has_arg+2 ;pointer to variable to set
`val     equ   `flag+4    ;default value of option
`name    equ   `val+2     ;long name of option

                          ;argv data structure offsets
`lo      equ   $00        ;handle to array of command-line
`hi      equ   $04        ;options


**************************************************
* initialize command-line arguments. setup argc  *
* value and argv pointers.                       *
* ---------------------------------------------- *
* (input)                                        *
*  a - userID of calling program.                *
*  x - LOW of pointer to command-line.           *
*  y - HOW of pointer to command-line.           *
**************************************************
init_getopt ent
]argv_lo =     $01
]argv_hi =     ]argv_lo+4
]argc    =     ]argv_hi+4
]db      =     ]argc+4
]dp      =     ]db+2
]rtl     =     ]dp+1
]userID  =     ]rtl+3
]command_line = ]userID+2

         phd              ;save direct page
         phb              ;save data bank register

         sec
         tsc
         sbc   #]dp-3     ;make local dp space
         tcs
         tcd

         phk
         plb

         incr  #8;]command_line ;update command-line to first
                          ;character in command-line
         lda   #1
         sta   ]argc
         ldy   #0
         lda   #0
:loop    shorta
         lda   []command_line],y
         longa
         beq   :make_argv
         cmp   #' '       ;spaces and TABS separate arguments
         beq   :0
         cmp   #TAB_CHAR
         beq   :0
         iny
         bra   :loop
:0       iny              ;test next character. if it is also
         shorta           ;a space or tab, then the next
         lda   []command_line],y ;argument hasn't begun. keep scanning.
         longa
         beq   :zero_last ;if at end of command-line, zero
         cmp   #' '       ;previous space/tab
         beq   :1
         cmp   #TAB_CHAR
         bne   :next_arg
:zero_last dey
         shorta
         lda   #0
         sta   []command_line],y
         longa
         bra   :make_argv
:1       dey
         shorta
         lda   #0         ;pad extra spaces with zeros
         sta   []command_line],y
         iny
         sta   []command_line],y
         longa
         bra   :0
:next_arg dey
         inc   ]argc
         shorta
         lda   #0         ;separate arguments with 0
         sta   []command_line],y
         longa
         iny
         bra   :loop

:make_argv pha            ;long - space for result
         pha
         lda   ]argc      ;long - size of block
         sta   argc
         asl
         sta   ]argc
         pea   #0
         pha
         pei   ]userID    ;word - userID to associate with block
         pea   #attrNoSpec+attrLocked
         pha
         pha
         _NewHandle
         plx
         ply
         stx   ]argv_lo
         sty   ]argv_lo+2
         ldy   #2
         lda   []argv_lo],y
         tay
         lda   []argv_lo]
         sta   argv+`lo
         sty   argv+`lo+2
         sta   ]argv_lo
         sty   ]argv_lo+2

         pha              ;long - space for result
         pha
         pea   #0         ;long - size of block
         pei   ]argc
         pei   ]userID    ;word - userID to associate with block
         pea   #attrNoSpec+attrLocked
         pha
         pha
         _NewHandle
         plx
         ply
         stx   ]argv_hi
         sty   ]argv_hi+2
         ldy   #2
         lda   []argv_hi],y
         tay
         lda   []argv_hi]
         sta   argv+`hi
         sty   argv+`hi+2
         sta   ]argv_hi
         sty   ]argv_hi+2

         ldx   #0         ;argument counter
:2       ldy   #$ffff     ;create pointers to command-line arguments
         lda   #0
:3       iny
         shorta
         lda   []command_line],y
         longa
         bne   :3
         txa
         inc              ;always take last argument
         inc
         cmp   ]argc
         beq   :5
:4       iny
         shorta
         lda   []command_line],y
         longa
         beq   :4
:5       phy
         txy
         lda   ]command_line
         sta   []argv_lo],y
         lda   ]command_line+2
         sta   []argv_hi],y
         clc
         pla
         adc   ]command_line
         sta   ]command_line
         bcc   :6
         inc   ]command_line+2
:6       inx
         inx
         cpx   ]argc
         bne   :2

         lda   #1         ;initialize index into command-line arguments
         sta   optind
         sta   argind
         stz   first_nonopt
         stz   last_nonopt
         stz   optarg
         stz   optarg+2

         lda   ]rtl,s     ;move return address to top of stack
         sta   ]command_line+1,s
         lda   ]rtl+1,s
         sta   ]command_line+2,s

         clc
         tsc
         adc   #]dp-3
         tcs

         plb
         pld

         clc
         tsc
         adc   #]command_line-]rtl+1
         tcs
         rtl


**************************************************
* retrieve short options from command-line.      *
* ---------------------------------------------- *
* (input)                                        *
*  shortopts - C-string of options to search     *
*              for.                              *
* (output)                                       *
*  a - option found.                             *
**************************************************
getopt   ent

         rts


**************************************************
* parse argument list by scanning for short      *
* options.                                       *
**************************************************
parse_argument_1 equ *

         rts


**************************************************
* retrieve long-options and short-options from   *
* command-line.                                  *
* ---------------------------------------------- *
* (input)                                        *
*  shortopts - C-string of options to search     *
*              for.                              *
*  longopts - pointer to long-option structure.  *
*  longind - index into long options.            *
* (output)                                       *
*  a - option found.                             *
**************************************************
getopt_long ent
]buffer  =     $01
]argv_lo =     ]buffer+4
]argv_hi =     ]argv_lo+4
]argv    =     ]argv_hi+4
]option_struct = ]argv+4
]long_option_name = ]option_struct+4
]db      =     ]long_option_name+4
]dp      =     ]db+2
]rtl     =     ]dp+1
]longind =     ]rtl+3
]longopts =    ]longind+4
]shortopts =   ]longopts+4
]retValue =    ]shortopts+4

         phd              ;save direct page
         phb              ;save data bank register

         sec
         tsc
         sbc   #]dp-3     ;make local dp space
         tcs
         tcd

         phk
         plb

         lda   #EOF
         sta   ]retValue

         lda   argc       ;end if no arguments to parse
         cmp   #1
         beq   :0

         jsr   parse_argument_2

:0       lda   ]rtl,s     ;move return address to first
         sta   ]retValue-3,s ;parameter
         lda   ]rtl+1,s
         sta   ]retValue-2,s

         clc
         tsc
         adc   #]dp-3
         tcs

         plb
         pld

         clc
         tsc
         adc   #]retValue-]longind
         tcs
         rtl


**************************************************
* parse argument list by scanning for short      *
* and long options.                              *
**************************************************
parse_argument_2 equ *

         ldx   argv+`lo
         ldy   argv+`lo+2
         stx   ]argv_lo
         sty   ]argv_lo+2
         ldx   argv+`hi
         ldy   argv+`hi+2
         stx   ]argv_hi
         sty   ]argv_hi+2
         lda   #0
         shorta
         lda   []shortopts]
         sta   shortopt_len
         longa

:loop    lda   optind
         cmp   argc
         blt   :1
         lda   first_nonopt
         beq   :0
         sta   optind
:0       rts              ;end, no more arguments to parse

:1       asl
         tay
         lda   []argv_lo],y
         sta   ]argv
         lda   []argv_hi],y
         sta   ]argv+2

         lda   #0
         shorta
         lda   []argv]
         longa
         cmp   #'-'       ;parse short options
         bne   :2
         jsr   parse_short
         bra   :4
:2       cmp   #'+'       ;parse long options
         bne   :3
         jsr   parse_long
         bra   :4
:3       lda   first_nonopt
         bne   :set_last
         lda   optind
         sta   first_nonopt
:set_last lda  optind
         sta   last_nonopt
         sec
:4       longa
         bcc   :end       ;if a matching argument was found,
         inc   optind     ;return it, else search next argument
         lda   #1
         sta   argind
         bra   :loop
:end     rts


**************************************************
* parse short options.                           *
* ---------------------------------------------- *
* (output)                                       *
*  c - set if match found. clear if not.         *
**************************************************
parse_short equ *

         jsr   exchange_argv ;move option before non-options
         shorta
         ldy   argind
         lda   []argv],y
         beq   :end_argind
         ldy   shortopt_len
:test_shortopt cmp []shortopts],y
         beq   :arg_found
         dey
         bne   :test_shortopt
:end_opt longa
         and   #$ff
         pha              ;invalid option character.
         jsr   get_progname ;option not found. display error
         phy              ;message and return '?' to user
         phx              ;indicating unrecognized option.
         _WriteCString
         pea   #^unrecognized_opt
         pea   #unrecognized_opt
         _WriteCString
         pea   #'-'
         _WriteChar
         _WriteChar
         pea   #'''
         _WriteChar
         put_cr
         lda   #UNRECOGNIZED_OPT ;return '?' to user
         sta   ]retValue
         clc
         rts
:arg_found longa          ;argument found so return value
         sta   ]retValue  ;and prepare to parse next option
         inc   argind     ;character
         clc
         rts
:end_argind longa         ;at end of current option string.
         sec              ;set to parse next option string
         rts


**************************************************
* parse long options.                            *
**************************************************
parse_long equ *

         stz   :option_offset
         stz   :option_found
         stz   :print_partial
         stz   :offset
         stz   :option_name_len
         jsr   exchange_argv ;move option before non-options

:loop    lda   :option_offset
         asl
         tay
         lda   []longopts],y
         sta   ]option_struct
         clc
         adc   #`name
         sta   ]long_option_name
         shorta
         lda   (]long_option_name)
         sta   :option_name_len
         longa
         bne   :test_longopt ;end of long-options
         brl   :end

:test_longopt ldy #1
         shorta
:0       lda   []argv],y
         beq   :1
         cmp   (]long_option_name),y
         beq   :next_char
         brl   :6
:next_char iny
         cpy   :option_name_len
         blt   :0
         beq   :0
:1       ldy   :option_found ;if first option found, test other
         bne   :2         ;options for partial matches.
         ldy   :option_offset ;mark first option as found
         iny
         sty   :option_found
         brl   :6
:2       longa
         lda   :print_partial
         beq   :print_option
         brl   :3
:print_option jsr get_progname
         phy
         phx
         phy
         phx
         _WriteCString
         pea   #^partial_match
         pea   #partial_match
         _WriteCString
         lda   optind
         asl
         tay
         lda   []argv_hi],y
         pha
         lda   []argv_lo],y
         pha
         _WriteCString
         pea   #'''
         _WriteChar
         put_cr
         _WriteCString
         pea   #^other_options
         pea   #other_options
         _WriteCString
         lda   :option_found
         dec
         asl
         tay
         lda   []longopts],y
         clc
         adc   #`name
         pei   ]longopts+2
         pha
         clc
         lda   #0
         tay
         shorta
         lda   (1,s),y
         longa
         adc   #20
         sta   :offset
         _WriteString
         inc   :print_partial
:3       inc   :print_partial
         clc
         lda   :offset
         adc   #3
         adc   :option_name_len
         sta   :offset
         cmp   #OTHER_OPTION_EDGE
         blt   :4
         pea   #','
         _WriteChar
         put_cr
         jsr   get_progname
         phy
         phx
         _WriteCString
         pea   #':'
         _WriteChar
         pea   #' '
         _WriteChar
         lda   :option_name_len
         inc
         sta   :offset
         bra   :5
:4       pea   #','
         _WriteChar
         pea   #' '
         _WriteChar
:5       pea   #'+'
         _WriteChar
         pei   ]longopts+2
         pei   ]long_option_name
         _WriteString
:6       longa
         inc   :option_offset
         brl   :loop

:end     lda   :option_found ;error if no options found
         beq   :error
         ldx   :print_partial
         bne   :multiple_opt
         dec
         asl
         tay
         lda   []longopts],y
         sta   ]option_struct
         ldy   #`val      ;return short-option of default
         lda   (]option_struct),y ;long-option or short-option
         sta   ]retValue
         inc   optind     ;prepare to search next argument next
         lda   #1         ;time through getopt
         sta   argind
         clc
         rts

:error   jsr   get_progname ;option not found. display error
         phy              ;message and return '?' to user
         phx              ;indicating unrecognized option.
         _WriteCString
         pea   #^unrecognized_opt
         pea   #unrecognized_opt
         _WriteCString
         lda   optind
         asl
         tay
         lda   []argv_hi],y
         pha
         lda   []argv_lo],y
         pha
         _WriteCString
         pea   #'''
         _WriteChar
:multiple_opt put_cr
         lda   #UNRECOGNIZED_OPT ;return '?' to user
         sta   ]retValue
         clc
         rts

:option_offset UnsignedShort  ;offset into long option structure
:option_name_len UnsignedShort  ;length of long option name
:option_found UnsignedShort  ;if first option (partial?) found
:print_partial UnsignedShort
:offset  UnsignedShort    ;right edge offset


**************************************************
* retrieve long-options from command-line.       *
* ---------------------------------------------- *
* (input)                                        *
*  shortopts - C-string of options to search     *
*              for.                              *
*  longopts - pointer to long-option structure.  *
*  longind - index into long options.            *
* (output)                                       *
*  opt - option found.                           *
**************************************************
getopt_long_only ent
]dp      =     $0c+3
]rtl     =     ]dp+1
]longind =     ]rtl+3
]longopts =    ]longind+4
]shortopts =   ]longopts+4
]retValue =    ]shortopts+4

         phd              ;save direct page
         phb              ;save data bank register

         sec
         tsc
         sbc   #]dp-3     ;make local dp space
         tcs
         tcd

         phk
         plb
         stz   ]retValue

         lda   ]rtl,s     ;move return address to first
         sta   ]retValue-3,s ;parameter
         lda   ]rtl+1,s
         sta   ]retValue-1,s

         clc
         tsc
         adc   #]dp-3
         tcs

         plb
         pld

         clc
         tsc
         adc   #]retValue-]longind
         tcs
         rts


**************************************************
* move non-option arguments before option        *
* arguments.                                     *
**************************************************
exchange_argv equ *

         lda   first_nonopt ;end if no exchange to take place
         beq   :end

         lda   optind     ;save pointer to current option
         asl              ;argument
         tay
         lda   []argv_lo],y
         pha
         lda   []argv_hi],y
         pha

:0       lda   last_nonopt ;move non-options up one
         asl
         tay
         lda   []argv_lo],y
         iny
         iny
         sta   []argv_lo],y
         dey
         dey
         lda   []argv_hi],y
         iny
         iny
         sta   []argv_hi],y
         dec   last_nonopt
         lda   last_nonopt
         cmp   first_nonopt
         bge   :0

         lda   first_nonopt ;store current option in first
         asl              ;non-option position. all previous
         tay              ;non-options are now after it.
         pla
         sta   []argv_hi],y
         pla
         sta   []argv_lo],y

         lda   first_nonopt
         sta   optind
         stz   first_nonopt
         stz   last_nonopt
:end     rts


**************************************************
* return pointer to program name string minus    *
* path.                                          *
* ---------------------------------------------- *
* (output)                                       *
*  x - LOW of pointer to program name.           *
*  y - HOW of pointer to program name.           *
**************************************************
get_progname equ *
]progname =    $01

         lda   []argv_lo] ;first argument on command-line is
         sta   ]progname  ;program name
         lda   []argv_hi]
         sta   ]progname+2

         shorta
:start_loop ldy #0
:loop    lda   []progname],y
         beq   :end
         cmp   #'/'
         beq   :separator
         cmp   #':'
         beq   :separator
         iny
         bra   :loop
:separator clc
         tya
         inc
         adc   ]progname
         sta   ]progname
         bcc   :start_loop
         inc   ]progname+2
         bra   :start_loop

:end     longa
         ldx   ]progname
         ldy   ]progname+2
         rts


**************************************************

* For communication from 'getopt' to the caller.
* When 'getopt' finds an option that takes an argument,
* the argument value is returned here.
* Also, when 'ordering' is RETURN_IN_ORDER,
* each non-option ARGV-element is returned here.

optarg   ent
         CharPtr

* Index in ARGV of the next element to be scanned.
* This is used for communication to and from the caller
* and for communication between successive calls to 'getopt'.
*
* On entry to 'getopt', zero means this is the first call; initialize.
*
* When 'getopt' returns EOF, this is the index of the first of the
* non-option elements that the caller should itself scan.
*
* Otherwise, 'optind' communicates from one call to the next
* how much of ARGV has been scanned so far.

optind   ent              ;index into list of arguments
         UnsignedShort
argind   UnsignedShort    ;index into argument

* Callers store zero here to inhibit the error message 'getopt' prints
* for unrecognized options.

opterr   ent
         UnsignedShort

* If nonzero, '-' can introduce long-named options.
* Set by getopt_long_only.

_getopt_long_only ent
         UnsignedShort

* The index in GETOPT_LONG_OPTIONS of the long-named option found.
* Only valid when a long-named option has been found by the most
* recent call to 'getopt'.

option_index ent
         UnsignedShort

argc     ent              ;number of command-line options
         UnsignedShort
argv     ent              ;array of pointers to command-line options
:lo      Pointer
:hi      Pointer

first_nonopt UnsignedShort  ;index to first non-option argument
last_nonopt UnsignedShort  ;index to last non-option argument
shortopt_len dw 0         ;number of short options

Getopt   str   'getopt'

unrecognized_opt asc !:   unrecognized option '!,00
partial_match asc !:      partial match found for option '!,00
other_options cStr ': other options are: +'


**************************************************
         sav   link/getopt.l
