* UNIX getopt library
* declarations for getopt
*
* albert chin-a-young ... 26285659t@servax.fiu.edu


* For communication from 'getopt' to the caller.
* When 'getopt' finds an option that takes an argument,
* the argument value is returned here.
* Also, when 'ordering' is RETURN_IN_ORDER,
* each non-option ARGV-element is returned here.

optarg ext

* Index in ARGV of the next element to be scanned.
* This is used for communication to and from the caller
* and for communication between successive calls to 'getopt'.
*
* On entry to 'getopt', zero means this is the first call; initialize.
*
* When 'getopt' returns EOF, this is the index of the first of the
* non-option elements that the caller should itself scan.
*
* Otherwise, 'optind' communicates from one call to the next
* how much of ARGV has been scanned so far.

optind ext

* Callers store zero here to inhibit the error message 'getopt' prints
* for unrecognized options.

opterr ext

* If nonzero, '-' can introduce long-named options.
* Set by getopt_long_only.

_getopt_long_only ext

* The index in GETOPT_LONG_OPTIONS of the long-named option found.
* Only valid when a long-named option has been found by the most
* recent call to 'getopt'.

option_index ext

* function calls
*
init_getopt ext ;initialize command-line arguments
getopt ext
getopt_long ext
getopt_long_only ext
envopt ext

argc ext ;number of command-line options
argv ext ;array of pointers to command-line options

;option data structure offsets
`has_arg equ $00 ;if option has arguments
`flag equ `has_arg+2 ;pointer to variable to set
`val equ `flag+4 ;default value of option
`name equ `val+2 ;long name of option

;argv data structure offsets
`lo equ $00 ;handle to array of command-line
`hi equ $04 ;options
