/*
	coff - utility to dump contents of OMF files

	1990-1992, The tao Developer Project

	albert chin-a-young ... 26285659t@servax.fiu.edu
*/

#include "types.rez"

#define USAGE		0x0001
#define USAGE_VERBOSE	0x0002
#define VERSION		0x0003
#define THANKS		0x0004
#define DEFAULT		0x0005

#if defined(MERLIN)
#define RETURN		"\n"
#elif defined(ORCA)
#define RETURN          "\n\r"
#elif defined(GNO)
#define RETURN          "\n\r"
#endif

resource rText (USAGE)
{
	$$Format (" [-vDdTxltpmoaisnfceh] <filename> [segment..] [loadsegment..]%s", RETURN)
	$$Format ("       [+version] [+nodefault] [+asm] [+tool] [+hex] [+label] [+infix]%s", RETURN)
	$$Format ("       [+postfix] [+merlin] [+orca] [+shorta] [+shorti] [+header]%s", RETURN)
	$$Format ("       [+noheader] [+nooffset] [+compress] [+exact] [+thanks] [+help]%s", RETURN)
	"\000"
};

#if defined(MERLIN)
resource rText (USAGE_VERBOSE)
{
	" [-OPTIONS] filename [segment..] [loadsegment..]\n\n"
	"     OPTIONS         DESCRIPTION\n"
	"     -v [+version]   display version number\n"
	"     -D [+nodefault] disable default options\n"
	"     -d [+asm]       dump segment body in 65816-format disassembly\n"
	"     -T [+tool]      interpret Toolbox, GS/OS, ProDOS, ROM calls\n"
	"     -x [+hex]       dump segment body in hex (can be used with '+asm')\n"
	"     -l [+label]     print expressions using labels (default is offsets)\n"
	"     -t [+infix]     display expressions in infix form\n"
	"     -p [+postfix]   display expressions in postfix form (default)\n"
	"     -m [+merlin]    format of '+asm' to use merlin opcodes (default)\n"
	"     -o [+orca]      format of '+asm' to use orca/m opcodes\n"
	"     -a [+shorta]    assume 8-bit accumulator for disassembly\n"
	"     -i [+shorti]    assume 8-bit index registers for disassembly\n"
	"     -s [+header]    dump segment headers only\n"
	"     -n [+noheader]  do not print segment headers\n"
	"     -f [+nooffset]  do not print offset into file\n"
	"     -c [+compress]  print short form of CONST, LCONST records\n"
	"     -e [+exact]     match segment, loadsegment names exactly\n"
	"        [+thanks]    those who helped in the development of coff\n"
	"     -h [+help]      print this information, then quit\n\n"
	"     filename        name of OMF file to dump\n"
	"     [segment]       names of segments in file to dump\n"
	"     [loadsegment]   names of load segments in file to dump\n\000"
};
#elif defined(ORCA)
resource rText (USAGE_VERBOSE)
{
	" [-OPTIONS] filename [segment..] [loadsegment..]\n\r\n\r"
	"     OPTIONS         DESCRIPTION\n\r"
	"     -v [+version]   display version number\n\r"
	"     -D [+nodefault] disable default options\n\r"
	"     -d [+asm]       dump segment body in 65816-format disassembly\n\r"
	"     -T [+tool]      interpret Toolbox, GS/OS, ProDOS, ROM calls\n\r"
	"     -x [+hex]       dump segment body in hex (can be used with '+asm')\n\r"
	"     -l [+label]     print expressions using labels (default is offsets)\n\r"
	"     -t [+infix]     display expressions in infix form\n\r"
	"     -p [+postfix]   display expressions in postfix form (default)\n\r"
	"     -m [+merlin]    format of '+asm' to use merlin opcodes (default)\n\r"
	"     -o [+orca]      format of '+asm' to use orca/m opcodes\n\r"
	"     -a [+shorta]    assume 8-bit accumulator for disassembly\n\r"
	"     -i [+shorti]    assume 8-bit index registers for disassembly\n\r"
	"     -s [+header]    dump segment headers only\n\r"
	"     -n [+noheader]  do not print segment headers\n\r"
	"     -f [+nooffset]  do not print offset into file\n\r"
	"     -c [+compress]  print short form of CONST, LCONST records\n\r"
	"     -e [+exact]     match segment, loadsegment names exactly\n\r"
	"        [+thanks]    those who helped in the development of coff\n\r"
	"     -h [+help]      print this information, then quit\n\r\n\r"
	"     filename        name of OMF file to dump\n\r"
	"     [segment]       names of segments in file to dump\n\r"
	"     [loadsegment]   names of load segments in file to dump\n\r\000"
};
#elif defined(GNO)
resource rText (USAGE_VERBOSE)
{
	" [OPTIONS] filename [segment..] [loadsegment..]\n\r\n\r"
	"\tOPTIONS\t\tDESCRIPTION\n\r"
	"\t-v [+version]\tdisplay version number\n\r"
	"\t-D [+nodefault]\tdisable default options\n\r"
	"\t-d [+asm]\tdump segment body in 65816-format disassembly\n\r"
	"\t-T [+tool]\tinterpret Toolbox, GS/OS, ProDOS, ROM calls\n\r"
	"\t-x [+hex]\tdump segment body in hex (can be used with '+asm')\n\r"
	"\t-l [+label]\tprint expressions using labels (default is offsets)\n\r"
	"\t-t [+infix]\tdisplay expressions in infix form\n\r"
	"\t-p [+postfix]\tdisplay expressions in postfix form (default)\n\r"
	"\t-m [+merlin]\tformat of '+asm' to use merlin opcodes (default)\n\r"
	"\t-o [+orca]\tformat of '+asm' to use orca/m opcodes\n\r"
	"\t-a [+shorta]\tassume 8-bit accumulator for disassembly\n\r"
	"\t-i [+shorti]\tassume 8-bit index registers for disassembly\n\r"
	"\t-s [+header]\tdump segment headers only\n\r"
	"\t-n [+noheader]\tdo not print segment headers\n\r"
	"\t-f [+nooffset]\tdo not print offset into file\n\r"
	"\t-c [+compress]\tprint short form of CONST, LCONST records\n\r"
	"\t-e [+exact]\tmatch segment, loadsegment names exactly\n\r"
	"\t   [+thanks]\tthose who helped in the development of coff\n\r"
	"\t-h [+help]\tprint this information, then quit\n\r\n\r"
	"\tfilename\tname of OMF file to dump\n\r"
	"\t[segment]\tnames of segments in file to dump\n\r"
	"\t[loadsegment]\tnames of load segments in file to dump\n\r\000"
};
#endif

resource rText (VERSION)
{
	$$Format ("v1.1%s1990-1992, tao Developer Project%s%s", RETURN, RETURN, RETURN)
	"\000"
};

resource rText (THANKS)
{
	$$Format ("Special thanks to the following:%s", RETURN)
	$$Format ("Jawaid Bazyar : Beta Tester, GNO support%s", RETURN)
	$$Format ("Soenke Behrens: Reviewing manual%s", RETURN)
	$$Format ("Gregg Brekke  : Reviewing manual%s", RETURN)
	$$Format ("Morgan Davis  : Beta Tester, alt Toolbox entry option%s", RETURN)
	$$Format ("Dave Lyons    : Permission to use NiftyList 'nlist.data' file data%s", RETURN)
	$$Format ("Tim Meekins   : Beta Tester, minimal parentheses option%s", RETURN)
	$$Format ("Jerry Penner  : Beta Tester, +compress option, reviewing manual%s", RETURN)
	$$Format ("Rose Miller   : Thanks%s%s", RETURN, RETURN)
	"\000"
};

resource rText (DEFAULT)
{
	"+label\000"
	"+infix\000"
	"+tool\000"
};

resource rVersion (0x0001)
{
	{
		0x01,				// version 1.1
		0x01,				// no minor release
		0x00,				// bug version
		final,				// final release
		0x00,				// non-final release number
	},
	verUS,					// USA version
	"coff",
	"1990-1992, tao Developer Project"
};

resource rComment (0x0001)
{
	"coff, an Object Module Format (OMF) disassembler.\n\n"
	"post:\tAlbert Chin-A-Young\n"
	"\tP.O. Box 4133\n"
	"\tMiramar, Florida 33083-4133\n\n"
	"email:\trichard@serss0.fiu.edu\n"
	"\t26285659t@servax.fiu.edu"
};
