* UNIX coff utility
* defines
*
* 1990-1992, The UNIX Consortium Developer Project
*
* albert chin-a-young ... 26285659t@servax.fiu.edu


NULL equ 0
EOF equ $ffff
FALSE equ 0 ;boolean false value
TRUE equ 1 ;boolean true value

CTRL_C equ $03 ;ctrl-c keypress (cancel)

MERLIN_16 equ %00000001 ;output code for Merlin 16
ORCA_M equ %00000010 ;output code for Orca/M

;error messages
ERROR_STRING equ %00000001_00000000 ;parameter to error is C-String
ERROR_LHEX_VALUE equ %00000010_00000000 ;parameter to error is long hex value
ERROR_DEC_VALUE equ %00000100_00000000 ;parameter to error is decimal value
NO_FILENAME equ ERROR_STRING+$00 ;no OMF filename given
INVALID_FILENAME equ ERROR_STRING+$02 ;filename given is incorrect
PREMATURE_END equ ERROR_STRING+$04 ;premature end of file
OMF_VERSION equ ERROR_DEC_VALUE+$06 ;invalid OMF version
INVALID_LENGTH equ ERROR_LHEX_VALUE+$08 ;invalid length of OMF file
MORE_DATA equ ERROR_STRING+$0a ;not enough data in file to make sense of

MERLIN equ %00000001 ;merlin assembler
ORCA equ %00000010 ;orca assembler

ERROR equ $ffff
LOADNAME_LEN equ 10 ;length of loadname in OMF header
KIND_LEN equ 40 ;length of kind descriptor
DC equ $0100
HEADER_LEN equ $38 ;approximate length of OMF header

HEADER_EDGE equ 15
ADDRESS_EDGE equ 36
CHAR_EDGE equ 40
CONST_EDGE equ 10
DOUBLE_EDGE equ 36
EXTENDED_EDGE equ 36
FLOAT_EDGE equ 36
HEX_EDGE equ 20
INT_EDGE equ 36
INFIX_EDGE equ 32
POSTFIX_EDGE equ 30
SOFT_REFERENCE_EDGE equ 36
SUPER_EDGE equ 11
INVALID_NAME_EDGE equ 65

TRUE_OFFSET equ $80
FALSE_OFFSET equ $81
LIBRARY equ $b2 ;library file

USAGE equ $0001 ;short usage parameters
USAGE_VERBOSE equ $0002 ;verbose usage parameters
VERSION equ $0003 ;coff version number
THANKS equ $0004 ;those who helped in development of coff
DEFAULT equ $0005 ;default options

GSOS_INLINE equ $e100a8 ;GS/OS inline entry
GSOS_STACK equ $e100b0 ;GS/OS stack entry
PRODOS_MLI equ $bf00 ;ProDOS 8 MLI entry
TOOL_STACK equ $e10000 ;ToolBox stack entry
TOOL_STACK_ALT equ $e10004 ;alt ToolBox stack entry

KBD equ $e0c000 ;read keyboard
KBDSTRB equ $e0c010 ;clear keyboard

* segment type subfield
*
CODE equ $0000
DATA equ $0001
JUMP_TABLE equ $0002
PATHNAME equ $0004
LIBRARY_DICTIONARY equ $0008
INITIALIZATION equ $0010
ABSOLUTE_BANK_SEG equ $0011
DIRECT_PAGE equ $0012

* segment attributes bits
*
BANK_RELATIVE equ $0100
SKIP equ $0200
RELOAD equ $0400
ABSOLUTE_BANK equ $0800
POSITION_INDEPENDENT equ $2000
PRIVATE equ $4000
DYNAMIC equ $8000

* segment-body record types
*
END equ $00
ALIGN equ $e0
ORG equ $e1
RELOC equ $e2
INTERSEG equ $e3
USING equ $e4
STRONG equ $e5
GLOBAL equ $e6
GEQU equ $e7
MEM equ $e8
EXPR equ $eb
ZEXPR equ $ec
BEXPR equ $ed
RELEXPR equ $ee
LOCAL equ $ef
EQU equ $f0
DS equ $f1
LCONST equ $f2
LEXPR equ $f3
ENTRY equ $f4
cRELOC equ $f5
cINTERSEG equ $f6
SUPER equ $f7
GENERAL equ $fb

SUPER_RELOC2 equ 0
SUPER_RELOC3 equ 1

* expressions
*
ADD equ $01
SUB equ $02
MUL equ $03
DIV equ $04
MOD equ $05
NEGATION equ $06
BIT_SHIFT equ $07
AND equ $08
OR equ $09
EOR equ $0a
NOT equ $0b
LESS_EQUAL equ $0c
GREATER_EQUAL equ $0d
NOT_EQUAL equ $0e
LESS equ $0f
GREATER equ $10
EQUAL equ $11
LOGICAL_AND equ $12
INCLUSIVE_OR equ $13
EXCLUSIVE_OR equ $14
COMPLEMENT equ $15

LEFT equ 0
RIGHT equ 1
LEFT_RIGHT equ 2

LOCATION_COUNTER equ $80
CONSTANT_OPERAND equ $81
LABEL_WEAK equ $82
LABEL_VALUE equ $83
LABEL_LENGTH equ $84
LABEL_TYPE equ $85
LABEL_COUNT equ $86
RELATIVE_OFFSET equ $87

LONGI equ $10
LONGA equ $20

ASL equ $0a
INC equ $1a
ROL equ $2a
DEC equ $3a
LSR equ $4a
ROR equ $6a

JSR equ $20
JSL equ $22
LDX equ $a2
PEA equ $f4

BPL equ $10
BMI equ $30
BVC equ $50
BVS equ $70
BRA equ $80
BCC equ $90
BCS equ $b0
REP equ $c2
BNE equ $d0
SEP equ $e2
BEQ equ $f0

* addressing modes
*
ABSOLUTE equ $01
ABSOLUTE_INDEX_X equ $02
ABSOLUTE_INDEX_Y equ $03
ABSOLUTE_INDEX_INDIRECT equ $04
ABSOLUTE_INDIRECT equ $05
ABSOLUTE_INDIRECT_LONG equ $06
ABSOLUTE_LONG equ $07
ABSOLUTE_LONG_INDEX_X equ $08
ACCUMULATOR equ $09
BLOCK_MOVE equ $0a
DP equ $0b
DP_INDEX_X equ $0c
DP_INDEX_Y equ $0d
DP_INDEX_INDIRECT_X equ $0e
DP_INDIRECT equ $0f
DP_INDIRECT_LONG equ $10
DP_INDIRECT_INDEX_Y equ $11
DP_INDIRECT_LONG_INDEX_Y equ $12
IMMEDIATE equ $13
IMPLIED equ $14
PC_RELATIVE equ $15
PC_RELATIVE_LONG equ $16
STACK_ABSOLUTE equ $17
STACK_DP_INDIRECT equ $18
STACK_INTERRUPT equ $19
STACK_PC_RELATIVE equ $1a
STACK_PULL equ $1b
STACK_PUSH equ $1c
STACK_RTI equ $1d
STACK_RTL equ $1e
STACK_RTS equ $1f
STACK_RELATIVE equ $20
SR_INDIRECT_INDEX_Y equ $21
WDM equ $22

;@label structure references
`label_name equ $00 ;name of label
`expr_name equ `label_name+4 ;expression label evaluates to
`type equ `expr_name+4 ;GLOBAL or LOCAL label
`next equ `type+2 ;next label reference
`prev equ `next+4 ;previous label reference
`last equ `prev+4

;@stack structure references
stack`str equ $00 ;handle to expression name (string)
stack`oper equ stack`str+4 ;if expression is an operator

;@label data structure offsets
`lo equ $00 ;handle to array of labels
`hi equ `lo+4

;offsets to elements in binary tree
`str equ $00
`oper equ `str+4
`left equ `oper+2 ;left tree
`right equ `left+2 ;right tree

   ;@btree data structure offsets
`ptr equ $00 ;pointer to array of binary trees

;~operator data structure offsets
`prec equ $00 ;operator precedence
`assoc equ `prec+2 ;operator associativity

;~opcodes data structure offsets
`num_bytes equ $00 ;number of bytes the opcode takes
`m equ `num_bytes+2 ;if 16-bit mode accumulator
`i equ `m+2 ;if 16-bit mode index registers
`mode equ `i+2 ;addressing mode
`syntax equ `mode+2 ;how to format opcode

;@omf data structure offsets
`offset equ $00 ;offset from beginning of file for this segment
`bytecnt equ `offset+4 ;number of bytes in file that segment requires
`resspc equ `bytecnt+4 ;number of bytes of zeros to add to end of segment
`length equ `resspc+4 ;memory size of segment
`kind equ `length+4 ;type and attributes of segment
`lablen equ `kind+2 ;length of each name or label record in segment
`numlen equ `lablen+2 ;length of each number field in segment body
`version equ `numlen+2 ;version number of OMF segment is compatible with
`revision equ `version+2 ;revision number of OMF v2.0 segment is compatible with
`banksize equ `revision+2 ;maximum memory-bank size for segment
`org equ `banksize+4 ;absolute address at which to load segment
`align equ `org+4 ;boundary on which to align segment
`numsex equ `align+4 ;order of bytes in a number field
`lcbank equ `numsex+2 ;load segment into language card
`segnum equ `lcbank+2 ;segment number
`entry equ `segnum+2 ;offset into segment that corresponds to entry point
`dispname equ `entry+4 ;displacement of the loadname field within segment header
`dispdata equ `dispname+2 ;displacement from start of segment header to start of segment body
`temporg equ `dispdata+2 ;temporary origin of object segment for OMF v2.0
`loadname equ `temporg+4 ;name of load segment
`segname equ `loadname+LOADNAME_LEN ;name of segment
`displacement equ `segname+4
`counter equ `displacement+4
`library equ `counter+4 ;if file is a library
`refNum equ `library+2 ;reference number associated with file

;global/local data parsing structure
`on equ $00 ;test if parsing on
`data_type equ `on+2 ;type of data to parse
`count equ `data_type+2 ;number of records to parse
`edge equ `count+2 ;right margin for output of data

;@stack data structure offsets
`lo equ $00 ;array of handles containing stack
`hi equ `lo+4 ;elements
`size equ `hi+4 ;number of elements in stack

;@expr_list data structure offsets
`lo equ $00 ;array of handles containing stack
`hi equ `lo+4 ;elements
`size equ `hi+4 ;number of elements in stack

;offset for @Close data structure
Close`pCount equ $00
Close`refNum equ Close`pCount+2

;offset for @Open data structure
Open`pCount equ $00
Open`refNum equ Open`pCount+2
Open`pathname equ Open`refNum+2
Open`requestAccess equ $08
Open`resourceNumber equ $0a
Open`access equ $0c
Open`fileType equ $0e
Open`auxType equ $10
Open`storageType equ $14
Open`createDateTime equ $16
Open`modDateTime equ $1e
Open`optionList equ $26
Open`eof equ $2a
Open`blocksUsed equ $2e
Open`resourceEOF equ $32
Open`resourceBlocks equ $36

;offset for @SetMark data structure
SetMark`pCount equ $00
SetMark`refNum equ SetMark`pCount+2
SetMark`base equ SetMark`refNum+2
SetMark`displacement equ SetMark`base+2

;offset for @GetMark data structure
GetMark`pCount equ $00
GetMark`refNum equ $02
GetMark`position equ $04

;offset for @Quit data structure
Quit`pCount equ $00
Quit`pathname equ $02
Quit`flags equ $06

;offset for @Read data structure
Read`pCount equ $00
Read`refNum equ $02
Read`dataBuffer equ $04
Read`requestCount equ $08
Read`transferCount equ $0c
Read`cachePriority equ $10

GSOSstack equ $e100b0 ;gs/os stack entry point

Open equ $2010 ;Open call number
Read equ $2012 ;Read call number
Close equ $2014 ;Close call number
SetMark equ $2016 ;SetMark call number
GetMark equ $2017 ;GetMark call number
Quit equ $2029 ;Quit call number
