# Passport
a verification and copy program for
5.25-inch Apple II floppy disks

Minimum system requirements:
- Apple //e, //c, IIgs, or ][+ with 64K
- Two 5.25-inch disk drives(*)

(*) fully compatible with floppy drive
emulators like CFFA3000 and FloppyEMU.

## Some fun facts about copy protection

1. Many companies, especially smaller
   ones, outsourced their protection.
   I have seen byte-for-byte identical
   copy protection on disks from seven
   different companies!

2. Even companies that wrote their own
   copy protection would try to re-use
   it on multiple disks to get the most
   "bang for the buck."

3. Not everything has been cracked!
   Because there was so much piracy in
   the 1980s, some people assume that
   everything ever published has been
   cracked, digitized, and preserved in
   an emulator-friendly format. In
   reality, there are hundreds of disks
   that have never been cracked. Thirty
   years later, these programs are
   still trapped on physical media,
   literally rotting away.

## Usage

Using Passport is simple. After running
the program, put an original disk in
slot 6, drive 1 and a blank formatted
disk in any other drive. If necessary,
press `S` to cycle through your drives.
Then press `C` to start the cracking.

If all goes well, Passport will read
your original disk and write a copy in
a standard format, then remove any
protection checks from the copy. The
copy will boot and run just as well as
the original disk, but it will be
copyable with COPYA or any full-disk
copy program.

If all does not go well, Passport will
tell you where it all went wrong.

During the process, you can press any
key to cancel immediately.

If you have a two-sided disk where only
one side is bootable, after the first
side completes, you can press `2` to
reuse the captured RWTS on the second
side.

If Passport stops because of read errors
but you suspect the errors are due to
physical damage (as opposed to just copy
protection), you can retry the process
ignoring errors by pressing `Ctrl-R`.
The resulting copy may or may not be
usable.

In any case, Passport will NEVER write
to or alter your original disk in any
way. And neither should you! Don't
reduce the number of original disks in
the world; they aren't making any more
of them.

## Supported protections

Passport targets common protection
schemes that were reused by multiple
companies. These types of protection
were common in educational software.

- Abracadata
  e.g. Design Your Own Home series

- Allyn and Bacon
  e.g. CAAT Skill Tester series

- American Guidance Service
  e.g. SocMate Analogies Games

- Apple "Special Delivery"
  e.g. Ernie's Quiz, Instant Zoo

- ArtSci
  e.g. AceCalc, Magicalc

- Blue Chip Software
  e.g. Squire, Baron, Tycoon

- BrainBank
  e.g. BackAid

- Davidson & Associates
  e.g. Math Blaster Plus, Read N Roll

- DC Heath
  e.g. What Makes A Dinosaur Sore,
  Buzz Bang Harvey

- DesignWare
  e.g. Spellicopter, Crypto Cube

- Developmental Learning Materials
  e.g. Curious George in Outer Space,
  Alien Addition

- Didatech Software
  e.g. Crosscountry USA, Crosscountry
  Canada

- Edu-Ware
  e.g. Decimals, Algebra 2

- Ellen Nelson Learning Library
  e.g. Science (series), House-a-fire!

- EME
  e.g. Metric System Tutor,
  Water in the Air, Complex Circuits

- Encyclopaedia Britannica
  e.g. Problem Solving in Algebra,
  Math Skills: Elementary Level

- Enlightenment
  e.g. Paul Whitehead Teaches Chess,
  Living Chess Library

- Focus Media
  e.g. The Time Tunnel (series),
  Travels with Za-Zoom

- Gamco Publishing
  e.g. Math Leap Frog, Math Football

- Grolier Publishing
  e.g. NoteCard Maker, EduCalc

- Hartley Courseware
  e.g. Chariots, Cougars, and Kings;
  Tim and the Cat and the Big Red Hat

- Hayden Software
  e.g. SAT Score Improvement System,
  Microscopic Journey

- Heartsoft
  e.g. Electric Chalkboard, Tommy the
  Time-Telling Turtle

- Hoffman
  e.g. Good Thinking! series

- Houghton-Mifflin
  e.g. Game Frame One, Math Masters

- HRM Software
  e.g. Gene Machine, Heredity Dog

- Josten Learning Systems
  e.g. Building Reading Skills,
  Explorations in Science

- Krell Software
  e.g. Time Traveler, College Boards

- Laureate Learning Systems
  e.g. Concentrate on Words & Concepts

- The Learning Company
  e.g. Bumble Games, Gertrude's Secrets

- Learning Multi-Systems
  e.g. Solar Reading

- Learning Technologies
  e.g. Animal Hotel, Bike Hike

- McCarthy-McCormack
  e.g. Vowel Corral, Library Magic

- Marshware
  e.g. Squeegee Learns About Drugs

- Mastery Development
  e.g. Mastery Arithmetic Games

- MECC
  e.g. Word Munchers, Clock Works

- Media Basics
  e.g. Return to Reading (series)

- Methods & Solutions
  e.g. Fantasy Land, Behind The Wheel

- Micrograms Publishing
  e.g. Wild West Math, Granny
  Applebee's Cookie Factory

- Millennium Group
  e.g. The Brain Game, Concentration

- Milliken Publishing
  e.g. Math Sequences

- MindPlay
  e.g. Fraction-oids, Dyno-Quest

- Mindscape
  e.g. The Halley Project, Paperboy

- MUSE
  e.g. RobotWar, Caverns of Freitag

- National Geographic Society
  e.g. The Botanist's Apprentice

- Neosoft
  e.g. Comparison Kitchen, Animal Photo
  Fun

- Optimum Resource
  e.g. Stickybear Math, Car Builder

- PDI
  e.g. Leadsheeter, Polywriter

- Pelican Software
  e.g. Dino Days, Graphics Converter

- Phoenix Software
  e.g. Zoom Grafix

- Polarware
  e.g. The Electric Crayon (series),
  The Spy's Adventures (series)

- Quest Learning Systems
  e.g. Bingo Bugglebee Presents Home
  Alone, Outdoor Safety

- Queue
  e.g. Force and Motion, Practical
  Grammar

- Random House
  e.g. Snoopy to the Rescue, Charlie
  Brown's ABCs

- Reader's Digest
  e.g. Key Lingo, Cogito

- Scholastic
  e.g. Math Shop, Microzine

- Science Research Associates
  e.g. Computer Drill and Instruction

- Scott, Foresman and Company
  e.g. Addition and Subtraction 4,
  Decimals 3, Dinosaurs and Squids

- Silicon Valley Systems
  e.g. Rapid Reader, E-Z Learner

- Softsmith
  e.g. Astro Attack, Dinner on a Disk

- Software Publishing Corporation
  e.g. PFS File, PFS Graph, PFS Write

- Spinnaker Software
  e.g. Snooper Troops, KidWriter

- Springboard Software
  e.g. Early Games for Young Children,
  Puzzle Master, Mask Parade

- Sunburst Communications
  e.g. M-ss-ng L-nks, The Incredible
  Laboratory

- Thunder Mountain
  e.g. Pathwords, Quink

- Troll Associates
  e.g. Dino Dig, Make A Face

- Unicorn Software
  e.g. Magical Myths, Ten Little Robots

- Woodbury Software
  e.g. PlayWriter (series)

Passport can also recognize and defeat
the copy protection used by some game
companies. In general there was more
variation and "one-off" protection in
games than in educational software, so
your mileage may vary.

- Accolade
  e.g. Hardball, Law of the West

- Activision (patcher by TRex)
  e.g. Hacker, Rampage

- Adventure International
  e.g. Adventureland, Strange Odyssey

- Atari
  e.g. Defender, Gremlins

- Baudville
  e.g. Blazing Paddles, Take 1

- Border
  e.g. Arena, Early Bird

- Broderbund
  e.g. Where in Time Is Carmen Sandiego,
  Choplifter

- Coastal
  e.g. The Chalice of Mostania

- Dakin-5
  e.g. MIRV, Rings of Saturn

- Datasoft
  e.g. Canyon Climber, Fathoms 40

- Data East
  e.g. Ikari Warriors, Batman

- Earthware
  e.g. Black Belt, Zoo Master

- Electronic Arts (patcher by qkumba)
  e.g. The Bard's Tale, Skyfox

- Epyx
  e.g. Summer Games, Deathsword

- Gebelli
  e.g. Horizon V, Russki Duck

- HAL Labs
  e.g. Sheila, Super Taxman II

- Infocom
  e.g. Planetfall, Zork I/II/III

- Interplay
  e.g. Borrowed Time, Tracer Sanction

- Leisure Genius
  e.g. Clue Master Detective, RISK

- MicroFun
  e.g. Crown of Arthain, Miner 2049er

- Origin Systems
  e.g. Ultima V, Times of Lore

- Penguin Software
  e.g. Xyphus, Thunder Bombs

- Phoenix Software
  e.g. Sherwood Forest, Masquerade

- Polarware
  e.g. Oo-topos, The Crimson Crown

- Professional Software
  e.g. Trivia Fever

- Softape
  e.g. Photar

- Sierra On-Line (patcher by qkumba)
  e.g. BC's Quest for Tires, Sammy
  Lightfoot

- Strategic Simulations
  e.g. The Eternal Dagger, The Shard of
  Spring, Roadwar Europa, Warship

- Trillium
  e.g. Rendezvous with Rama, Fahrenheit
  451

- TSR
  e.g. Dawn Patrol, Dungeon

- Voyager Software
  e.g. Starship Commander

## License

Passport is open source and is
distributed under the MIT license.

Passport
Copyright (c) 2016-2023 by 4am

Permission is hereby granted, free of
charge, to any person obtaining a copy
of this software and associated
documentation files (the "Software"),
to deal in the Software without
restriction, including without
limitation the rights to use, copy,
modify, merge, publish, distribute,
sublicense, and/or sell copies of the
Software, and to permit persons to whom
the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this
permission notice shall be included in
all copies or substantial portions of
the Software.

THE SOFTWARE IS PROVIDED "AS IS",
WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED
TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.

## History

2023-07-28
- NEW: patchers/didatech.a (fixes
  Crosscountry USA, Crosscountry
  Canada, Crosscountry California)
- NEW: patchers/microlearn.a (fixes
  US Constitution Tutor, SAT English 1)
- NEW: patchers/probs5.a (fixes
  Decimals Analyzer, Whole Numbers
  Analyzer)
- NEW: patchers/t00_neosoft.a (fixes
  Comparison Kitchen, Animal Photo Fun)
- NEW: patchers/t00_scottforesman.a
  (fixes Addition and Subtraction 4,
  Decimals 3, Dinosaurs and Squids)
- NEW: patchers/t00_scottforesman_
  dos33.a (fixes Addition and
  Subtraction 3, Decimals 2)
- NEW: unexpected 5&3 track detection
  (fixes Real Math, Mathosaurus)
- IMPROVED: patchers/d5d5f7.a (fixes
  Les Sports)
- IMPROVED: patchers/gamco.a (fixes
  Percent)
- IMPROVED: patchers/sierra.a (fixes
  secondary anti-tamper check in
  The General Manager)
- IMPROVED: patchers/sigcheck.a (fixes
  Water Pollution)
- IMPROVED: patchers/t00_rwtslog.a
  (ATILA variant of LSR $6A detection
  fixes The Treasure of Forest Isle,
  TAY/BIT detection fixes Rapid
  Reader and E-Z Learner)
- Matching updates to the
  [Passport test suite](https://github.com/a2-4am/passport-test-suite)

2022-07-12
- NEW: patchers/mak.a (fixes "Kittens,
  Kids, and a Frog")
- NEW: patchers/t00_baudville.a (fixes
  Blazing Paddles, Take 1)
- NEW: patchers/t00_sigcheck.a (fixes
  Hardball, Law of the West)
- NEW: patchers/pfs.pascal.a (fixes
  pfs:* Pascal titles)
- NEW: patchers/pfs.prodos.a (fixes
  pfs:* ProDOS titles)
- NEW: patchers/enlightenment.a (fixes
  Paul Whitehead Teaches Chess)
- IMPROVED: id/555.a (fixes Fax,
  Funbunch College Prep)
- IMPROVED: patchers/ea.a (fixes
  Boulder Dash II) (by qkumba)
- IMPROVED: patchers/holle.a (fixes
  Sherwood Forest)
- IMPROVED: patchers/jmpbb03.a (fixes
  Pacific 231)
- IMPROVED: patchers/jmpb400.a (fixes
  Rebus Writer, Writer's Helper)
- IMPROVED: patchers/jmpb4bb.a (fixes
  Half Time)
- IMPROVED: patchers/sierra.a (fixes
  Ultima II)
- IMPROVED: patchers/sigcheck.a (fixes
  Inca, Holy Grail)
- IMPROVED: RW18 sector verification
  (fixes Toy Shop)
- Detect extra wide tracks anywhere,
  not just on track 6
- Matching updates to the
  [Passport test suite](https://github.com/a2-4am/passport-test-suite)

2021-09-04
- IMPROVED: patchers/universale7.a
  cracks now work on //c and IIgs
  (fixes Commando, Animate, &c.)
- IMPROVED: patchers/ea.a (fixes
  Mind Mirror) (by qkumba)
- Autonumbered .DSK files now go to 11
- Matching updates to the
  [Passport test suite](https://github.com/a2-4am/passport-test-suite)

2021-07-12
- Target can be a hard disk, which will
  save an autonumbered .DSK file in
  PASSPORT subdirectory (by qkumba)
- If the log scrolls off the screen,
  you can scroll back with arrows
  (by qkumba)
- NEW: patchers/555.a (Agent USA,
  Jumpman, many Softsmith) (by qkumba)
- NEW: patchers/earthware.a (Black
  Belt, Zoo Master)
- NEW: patchers/tsr.a (Dawn Patrol,
  Dungeon, Theseus and the Minotaur)
- NEW: patchers/datasoft2.a (Canyon
  Climber, Fathom's 40)
- NEW: patchers/jmpb500.a (Starship
  Commander)
- NEW: patchers/woodbury.a (PlayWriter)
- NEW: patchers/meccdqc.a (MECC
  DataQuest Composer)
- NEW: patchers/b4bbbasic.a (SocMate
  Analogies Games)
- NEW: patchers/jsrb6cc.a (Kidwriter)
- NEW: patchers/mastery.a (Mastery
  Arithmetic Games)
- NEW: patchers/leisure.a (Clue, RISK)
- NEW: patchers/errord51.a (Granny
  Applebee's Cookie Factory, Uncle
  Clyde's Consonant Slides)
- NEW: patchers/sigcheck.a (Advanced
  Electricity, Complex Circuits)
- IMPROVED: patchers/mecc.a to erase
  site license information from final
  generation of MECC disks (by qkumba)
- IMPROVED: patchers/rwtsswapmecc.a
  (fixes Zoyon Patrol, Word Wizards)
- IMPROVED: patchers/prodosmecc.a
  (fixes Miner's Cave)
- IMPROVED: patchers/rwtslog.a (fixes
  La Guillotine, GATO v1.3)
- IMPROVED: patchers/ssi.a (fixes
  Sixgun Shootout)
- IMPROVED: id/d5d5f7.a (fixes Trivia
  Fever)
- IMPROVED: patchers/jmpbbfe.a (fixes
  The Desecration, Depreciation Log)
- "BB00 protection" renamed to its
  marketing name "Lock-It-Up"
- Serial numbers will be erased while
  cracking Lock-It-Up disks, if present
- Update Passport disk to ProDOS 2.4.2
- Matching updates to the
  [Passport test suite](https://github.com/a2-4am/passport-test-suite)

2020-07-20
- NEW: patchers/harvey.a (Buzz Bang
  Harvey, Harvey by Primes)
- NEW: patchers/jmp2012.a (BackAid)
- NEW: patchers/pdi.a (Leadsheeter,
  Polywriter)
- NEW: patchers/rps.a (Pac-Man Thunder
  Mountain release, Problem Solving
  in Algebra)
- IMPROVED: patchers/ssprot.a (fixes
  Metric System Tutor)
- IMPROVED: patchers/bb03.a (fixes
  Spanish for Mastery)
- IMPROVED: patchers/sierra.a (fixes
  Mission Asteroid)
- IMPROVED: patchers/ea.a (fixes
  One on One)
- Passport will now quit gracefully if
  you manage to launch it with less
  than 64K
- Matching updates to the
  [Passport test suite](https://github.com/a2-4am/passport-test-suite)

2019-06-16
- NEW: verify pure 13-sector disks
  (by qkumba)
- NEW: verify Infocom 18-sector disks
  (by qkumba)
- NEW: patchers/artsci.a (AceCalc,
  Magicalc, Photar)
- NEW: patchers/choplifter.a (Russki
  Duck, Choplifter) (by qkumba)
- NEW: patchers/dakin5.a (Neutrons,
  MIRV, Rings of Saturn)
- NEW: patchers/e7everywhere.a (Curious
  George series, Garfield Trivia Game)
- NEW: patchers/hallabs.a (Sheila,
  Super Taxman II)
- NEW: patchers/hoffman.a (Good
  Thinking! series)
- NEW: patchers/holle.a (Crime Wave,
  Sherwood Forest)
- NEW: patchers/muserwts.a (Caverns of
  Freitag, The Function Game)
- NEW: patchers/springboard.a (The
  Newsroom, The Chalice of Mostania)
- NEW: patchers/zoomgrafix.a (Zoom
  Grafix - all versions)
- IMPROVED: id/trace33p.a (fixes Kaves
  of Karkhan)
- IMPROVED: patchers/diskvol.a (fixes
  Diet Analysis Program)
- [test suite](https://github.com/a2-4am/passport-test-suite)

2018-10-14
- NEW: 13-sector MUSE support
- NEW: 13-sector Sierra support (by
  qkumba)
- NEW: 13-sector RDOS support (SSI) (by
  qkumba)
- NEW: PanglosDOS (per-file encryption)
  (by qkumba)
- NEW: Dinkey-DOS support (Ultima V)
- NEW: Interplay support (The Tracer
  Sanction, Borrowed Time)
- NEW: Davidson & Associates support
  (Math Blaster Plus)
- NEW: Penguin RWTS (Xyphus)
- NEW: MicroFun RWTS (Crown of Arthain)
- NEW: Swordthrust RWTS
- NEW: patchers/f7f6.a (Might & Magic)
- NEW: patchers/trillium (Rendezvous
  with Rama, Fahrenheit 451)
- NEW: patchers/fbffencrypted.a
  (Clue, RISK, ESL Writer)
- NEW: patchers/fbffpascal.a
  (Widespread, The Typewriter)
- NEW: patchers/polarware.a
  (Oo-topos, The Crimson Crown)
- NEW: patchers/microfun.a (The Heist,
  Station 5, Miner 2049er)
- NEW: print volume name on ProDOS,
  Pascal, and DOS 3.3 + variants
- IMPROVED: patchers/jmpb4bb.a
  (fixes Rubik's Cube Unlocked)
- IMPROVED: id/advint.a
  (fixes The Curse of Crowley Manor)
- IMPROVED: detection of unformatted
  tracks (fixes Thunder Bombs)
- IMPROVED: Micrograms detection
  (fixes Shapes and Patterns)
- IMPROVED: patchers/bbf9.a
  (fixes Magic Slate II 20-column)
- IMPROVED: patchers/memory.config.a
  (fixes Where Did My Toothbrush Go)
- IMPROVED: patchers/c9ff.a
  (fixes Swiss Family Robinson)
- IMPROVED: patchers/bb03.a
  (fixes Alice in Wonderland)
- IMPROVED: patchers/optimum.a
  (fixes Fat City)
- IMPROVED: logging track and sector
  when switching to built-in RWTS

2017-11-14
- Supports ProDOS RAM disks to read an
  entire disk at once (IIgs RAM disk,
  RAMFactor, RAMWorks, modern clones)
- NEW: DOS 3.2 support (MUSE, Edu-Ware,
  Hartley, Krell, Hayden, DLM)
- NEW: patchers/advint.a, an encrypted
  nibble check (Scott Adams adventures)
- NEW: patchers/bbf9.a, a desync
  bitstream (late Sunburst disks)
- NEW: patchers/jmpb400.a, a self-
  decrypting nibble check in late boot
  (Mindscape, DLM, Thunder Mountain)
- NEW: patchers/memory.config.a, ProDOS
  startup program with nibble check
  (DC Heath, Marshware)
- NEW: patchers/pascalrwts.a
  (Learning Multi-Systems)
- NEW: patchers/sra.a (SRA)
- NEW: patchers/rwtslog.a, refactored
  and expanded log of RWTS variants
- NEW: id/micrograms.a (Micrograms)
- NEW: id/rdos.a (SSI)
- NEW: support for early Infocom disks
- IMPROVED: patchers/a6bc95.a
  (fixes Friendly Filer)
- IMPROVED: patchers/jmpbeb1.a
  (fixes Spelling Rules)
- IMPROVED: patchers/sierra.a
  (fixes Winnie The Pooh)
- IMPROVED: id/laureate.a
  (fixes Sound Ideas)

2017-05-14
- NEW: patcher for Activision (by TRex)
- NEW: patcher for Electronic Arts (by
  qkumba)
- NEW: patcher for Sierra On-Line (by
  qkumba, replaces old patcher)
- NEW: patcher for Optimum Resource (by
  qkumba, replaces old patcher)
- NEW: patcher for Gamco Software
- NEW: patcher for Border Software
- NEW: patcher for Blue Chip Software
- NEW: patcher for Houghton-Mifflin
- NEW: patcher for Milliken Publishing
- NEW: patcher for Methods & Solutions
- NEW: patcher for Laureate Learning
- NEW: detection of LSR $6A ProDOS RWTS
- NEW: identification of Pronto-DOS,
  Diversi-DOS, David DOS, and Quick-DOS
- IMPROVED: patcher for MECC
  (fixes Word Munchers v1.1)
- IMPROVED: patcher for Scholastic
  (fixes Bank Street Writer II)
- IMPROVED: patcher for Grolier
  (fixes Countries of the World)
- migrated build to ACME assembler and
  source code to GitHub (by qkumba)

2016-12-30
- add support for DOS 3.3P
  e.g. Ernie's Quiz, Instant Zoo
- improve support for disks created
  with MECC Database
- faster detection of 4-and-4 encoding
  and 5-and-3 encoding (neither is
  supported)
- various speed improvements

2016-09-02
- add support for Protected.DOS
  e.g. Moebius, Math Blaster
- add support for "JMP $B660" RWTS
  e.g. Verb Viper, Master Match
- add support for Datasoft encrypted
  bootloader
  e.g. Tomahawk, Video Title Shop
- fix bug in boot sector detection that
  erroneously claimed some disks were
  unreadable
- add informational messages about some
  RWTS variants (LSR $6A, BCS $08)
- refactor code in /id/ directory

2016-07-12
- initial release
