'=========================================================================
'                                R M N U L L
'
'                               by Dean Fick
'=========================================================================
'
'Change history:
'
' Aug 21 '91, rmnull101.bas:
'    first version
'
' Sep 2 "91, rmnull102.bas:
'    changed file type detection logic.  RMNULL now renames ANY file type
'    other than txt to "a1".  Example: a file is named a0 and it is a CMD
'    file.  It is renamed to "a1" since rmnull can't open it to find out
'    when it was created.  Before only BIN files were detected.
'
'=========================================================================

#define	IDENT_PROG "rmnull"
#define	IDENT_VERS "1.0"
#define	IDENT_DATE "2sep91"
#define	IDENT_NAME "Dean_Fick"

#include <proline/proline.h>

#define EndofData             5
#define MaxSites              300
#define SubDirType            15

     gosub AppInit

     if not SuperUser then
          print argv$[0]": can't run"
          goto Exit
     endif

     if argc > 1 then
          if argc => 2 then
               & lcase (argv$[1])
               if argv$[1] = "-a" then
                    gosub Dimension_Arrays
                    gosub Get_Site_Count
                    Limit = CountofSites
                    gosub Remove_Nulls
                    goto Exit
               endif
               gosub Dimension_Arrays
               for Lydia = 1 to argc-1
                    SiteName$[Lydia] = argv$[Lydia]
               next
               & sort (SiteName$, argc - 1)
               Limit = argc - 1
               gosub Remove_Nulls
               goto Exit
          endif
     else
          goto ArgAbort
     endif

' ****************************************************************
' **
' ** Dimension arrays
' **
' **
' **

Dimension_Arrays:

     dim BadPrefix$[3], Prefix$[3], SiteName$[MaxSites]
     return

' ****************************************************************
' **
' ** Define several prefixes for evaluating the resource
' ** file lines in the SiteName$[] array.
' **
' **

Remove_Nulls:

          BadPrefix$[1] = "pro."
          BadPrefix$[2] = "gnh."
          BadPrefix$[3] = "rti."

          Prefix$[1] = "pro-"
          Prefix$[2] = "gnh-"
          Prefix$[3] = "rti-"

' ****************************************************************
' **
' ** Change site names in the SiteName$[] array that are defined as
' ** legal ProDOS names into true site names.  Example: change
' ** "pro.carolina" into "pro-carolina".
' **

         for Counter2 = 1 to Limit

              & lcase (SiteName$[Counter2])

              UnixNameFound = False

               for Counter3 = 1 to 3

                    & pos (SiteName$[Counter2], BadPrefix$[Counter3]),\
                    Position

                    if Position then

                         RightLineLength = len (SiteName$[Counter2]) \
                         - Position - 3

                         RightLine$ = right$ (SiteName$[Counter2], \
                         RightLineLength)

                         SiteName$[Counter2] = left$ (BadPrefix$[Counter3],\
                         3) + "-" + RightLine$


                    endif

' ****************************************************************
' **
' ** Look at each resource file line in SiteName$[] searching for
' ** Unixnames-style site names.  Convert a Unixname into a legal
' ** ProDOS name (exchange the "-" for a ".") for use in scanning
' ** directories in the $/mdss/* series.

                    & pos (SiteName$[Counter2], Prefix$[Counter3]), Position

                    if Position then

                         UnixNameFound = True

                         RightLineLength = len (SiteName$[Counter2]) \
                         - Position - 3

                         RightLine$ = right$ (SiteName$[Counter2], \
                         RightLineLength)

                         LegalName$ = left$ (Prefix$[counter3], 3) +"."\
                         + RightLine$

                    endif

               next

               if not UnixNameFound then LegalName$ = SiteName$[Counter2]

               CurrentMDSSDir$ = MDSS_PATH + LegalName$

               & getinfo CurrentMDSSDir$, Info$

               if Info$ = "" then
                    print argv$[0]": skipping "SiteName$[Counter2]\
                    " (not a direct site)"
                    goto EndOfLoop
               endif

' ****************************************************************
' **
' ** Find out if a file named "a0" exists in the current MDSS dir.
' ** If so, either delete it or rename it to its original name
' ** based on header date and time.  If the "a0" file is not a
' ** text file, then rename it to "a1".
' **
' **

               CurrentNullFile$ = MDSS_PATH + LegalName$ + "/a0"

               & getinfo CurrentNullFile$, Info$

               if Info$ = "" then
                    print argv$[0] ": no null for " SiteName$[Counter2]
                    goto EndofLoop
               else
                    if asc (mid$ (Info$, 5, 1)) <> 4 then
                         NewName$ = MDSS_PATH + LegalName$ + "/a1"
                         fRename CurrentNullFile$ "," NewName$
                         goto PrintConfirmation
                    endif
                    gosub Check_Null_File
               endif

               If Its_A_Mknull_File then
                    fDelete CurrentNullFile$
               else
                    gosub Find_Original_Name
                    OriginalName$ = MDSS_PATH + LegalName$ + "/" +\
                    UniqueName$
                    fRename CurrentNullFile$ "," OriginalName$
               endif

PrintConfirmation:

               print argv$[0]": " SiteName$[Counter2] " null removed"

EndOfLoop:
          next
          return

' ****************************************************************
' **
' ** Abort if arguments inappropriate
' **
' **
' **

ArgAbort:
          print "Usage: " argv$[0] " sitename ...  See 'man " argv$[0]\
          "' for help."
          goto Exit

' ****************************************************************
' **
' ** Figure out how many sites there are in $/mdss, and put those
' ** subdirectory names found in $/mdss in the SiteName$[] array.
' **
' **

Get_Site_Count:

          MDSSdir$ = MDSS_PATH

          & files (MDSSdir$, SiteName$, SubDirType), CountofSites,\
          ActualFiles

          & sort (SiteName$, CountofSites)
          return

' ****************************************************************
' **
' ** Find out if mknull made the Currentnullfile.
' **
' **
' **
' **
'
Check_Null_File:

     fOpen CurrentNullFile$
     fRead CurrentNullFile$

     Its_A_Mknull_File = False

     onerr goto TrapEoF

     repeat
          & get HeaderLine$
          if left$ (HeaderLine$, 18) = "X-Mailer: Mknull (" then
               Its_A_Mknull_File = True
          endif
     until HeaderLine$ = ""

     fClose CurrentNullFile$

     return

' ****************************************************************
' **
' ** Find out the original name of a queued file by reading the
' ** mail header, reconstructing the clock info when it was made,
' ** and running that through the "MakeUniqueName" routine
' ** Morgan Davis wrote.
' **

Find_Original_Name:

     HeaderErrFlag = False

     fOpen CurrentNullFile$
     fRead CurrentNullFile$

     & get HeaderLine$

     fClose CurrentNullFile$

     if left$ (HeaderLine$, 5) <> "From " then
         HeaderErrFlag = True
     endif

     OldPosition = 0
     for SpaceCounter = 1 to 2
          & pos (OldPosition + 1, HeaderLine$, " "), SpacePosition
          OldPosition = SpacePosition
     next

     if not SpacePosition then
          HeaderErrFlag = True
     endif

     if HeaderErrFlag then
          print argv$[0] ": header err, " CurrentNullFile$
          pop
          goto EndofLoop
     endif

     DateLine$ = right$ (HeaderLine$, len (HeaderLine$) - SpacePosition)
     Day$ =  left$ (DateLine$, 3)
     Month$ = mid$ (DateLine$, 5, 3)
     Date$ = mid$ (DateLine$, 9, 2)
     Time$ = mid$ (DateLine$, 12, 8)
     Year$ = right$ (DateLine$, 2)

     FileTimeString$ = Day$ + ", " + Date$ + " " + Month$ + " " +\
                       Year$ + " " + Time$
     gosub MakeUniqueName
     return

' ************************************************************ *****
' **
' ** Build a filename (UniqueName$) from FileTimeString$ in the format:
' **
' ** ddSSSSSXX
' **
' ** Where dd is an alphabetic variant of the combined month and date
' ** values, and SSSSS are the number of seconds that have elapsed since
' ** midnight.
' **
' ** These two subroutines copyright (c) 1990 Morgan Davis Group
' ** (Used with permission.  Slightly modified.)

MakeUniqueName:
     & pos ("?anebarprayunulugepctovec", mid$ (FileTimeString$, 10, 2)), w
     w = w / 2
     l = val (mid$ (FileTimeString$,6))
     & right$ (str$(val(mid$(FileTimeString$,16)) * 3600 + \
          val(mid$ (FileTimeString$, 19)) * 60 + \
          val(right$ (FileTimeString$, 2))), 5, 48), UniqueName$
     UniqueName$ = chr$ (64 + w) + chr$ (48 + l + 7 * (l > 9)) + UniqueName$
return

' ****************************************************************
' **
' ** Catch a corrupt mail header on CurrentNullFile$
' **
' **
' **

TrapEoF:

     & onerr ErrCode, ErrLine
     fClose
     if ErrCode = EndofData then
        print argv$[0] ": corrupt header on " CurrentNullFile$
        pop
        onerr goto HandleError
        goto EndofLoop
     endif
     print argv$[0]": err "ErrCode" at "ErrLine
     goto Exit

' *****************************************************************
' **
' ** Standard ProLine library routines
' **
' **
' **

#include <proline/proline.lib>
