' ************************************************************
' *
' *  postnews.b		Local news poster for ProLine
' *			(C)opyright 1994 Morgan Davis
' *
' * History:
' *
' * 22nov89 mwd	1.0 	Creation
' * 24apr90 mwd	1.1	Fixed field position assumption bug
' * 01aug91 mwd	1.2	Added over-limit alert
' *			Added newstracker checking
' *			Improved header parsing speed, also keeps
' *			Newsgroups and Message-ID fields.
' * 14aug91 mwd		Put header fields into a resource for sysop editing
' * 05sep91 mwd		Strips spaces off field arguments.
' * 04sep93 mwd 1.3	Minor tweaks
' * 07dec93 mwd		Ignores posting of "cmsg cancel" subject articles
' *
' ************************************************************

#define	IDENT_PROG "postnews"
#define	IDENT_VERS "1.3"
#define	IDENT_DATE "7dec93"
#define	IDENT_NAME "Morgan_Davis"

#include <prodos.h>
#include <proline/proline.h>

#define	TRACK_POSTNEWS	3

#define	DATE_FIELD		1
#define	FROM_FIELD		2
#define	SUBJECT_FIELD		3
#define CONTROL_FIELD		4

#define	CANCEL_ARTICLE		"Control: cancel"

#define	DEFAULT_FIELD_COUNT	4
#define	DEFAULT_FIELDS		"01=Date:"\
				"02=From:"\
				"03=Subject:"\
				"04=Control:"


	gosub AppInit
	if not SuperUser then
		print argv$[0]": can't run"
		goto Exit
	endif
	
	' ==============================
	' Pathnames
	' ==============================
	
	newsLogFile$	= SPOOL_LOGS_PATH + "newslog"
	newsysFile$	= ETC_PATH + "newsys"
	newspoolDir$	= SPOOL_NEWS_PATH
	resourceFile$	= RSRC_PATH + "postnews.rsrc"
	csDirFile$	= RSRC_PATH + "cs.rsrc"
	trackerFile$	= SysInfo$[plTempDir] + "newstracker"
	
	isPlural$[1]	= "s"
	fields$		= DEFAULT_FIELDS
	rnewsMarker$	= "#! rnews "
	rnewsMarkLen	= 9
	cancelArticle$	= CANCEL_ARTICLE
	cancelArtLen	= len(cancelArticle$)
	
	' ==============================
	' Find system files
	' ==============================
	
	&GETINFO newsysFile$, info$
	if info$ = "" then
		print argv$[0]": "newsysFile$" not found"
		goto Exit
	endif
	
	&GETINFO csDirFile$, info$
	if info$ = "" then
		print argv$[0]": CS not installed"
		goto Exit
	endif
	
	&GETINFO trackerFile$, info$
	if info$ > "" then
		& mid$(info$, 5) = chr$(TRACK_POSTNEWS)
		& SETINFO trackerFile$, info$
	else
		fCreate trackerFile$ ",T" TRACK_POSTNEWS
	endif
	
	&fn fnCarrier, initialDCD	' Save carrier state
	&chk stop			' then turn carrier loss checking off
	& page def initialPage		' Save paging state
	& page stop			' then turn it off
	
	
	fieldCount = DEFAULT_FIELD_COUNT
	
	&GETINFO resourceFile$, info$
	if info$ > "" then
		fOpen resourceFile$
		fRead resourceFile$
		onerr goto rsrcEOF
		do
			& get a$
			if mid$(a$,1,1) <> "#" then
				fieldCount = fieldCount + 1
				& right$(str$(fieldCount),2,48),info$
				fields$ = fields$ + info$ + "=" + a$ + ":"
			endif
		loop
		rsrcEOF:
		& onerr
		fClose
		onerr goto HandleError
	endif
	
	dim dirEntries$[1]
	dim Header$[fieldCount]
	
	&files (newspoolDir$, dirEntries$, 4), i, i
	entry$ = "POSTNEWS ~ (" + str$(i) + " group" + isPlural$[i <> 1] + ")"
	gosub UpdateLog
	
	fOpen csDirFile$
	fRead csDirFile$
	& get csDir$
	fClose
	if right$(csDir$, 1) <> "/" then csDir$ = csDir$ + "/"
	
	fOpen newsysFile$

next_entry:
	onerr goto newsysEOF
	gosub GetNextEntry
	if localPostInfo$ = "" then next_entry

	&GETINFO newspoolDir$ + alias$, info$
	if info$ = "" then goto next_entry

	maxMsgs = 100
	&pos (localPostInfo$, " "), p
	if p then
		conftop$ = left$(localPostInfo$, p - 1)
		maxMsgs = val(mid$(localPostInfo$, p + 1))
	else
		conftop$ = localPostInfo$
	endif

	batchFile$ = newspoolDir$ + alias$
	gosub NewCSPost
	&ioctl (ioCR)
	&ioctl (ioClearEOS)
	entry$ = "^I~ posted " + str$(posted) + " " + group$ + \
		" to " + conftop$ + ", expired " + str$(expired)
	gosub UpdateLog
	if posted > maxMsgs then
		entry$ = "^I~ <ALERT: exceeded " + conftop$ + \
			" topic limit by " + str$(posted - maxMsgs) + ">"
		gosub UpdateLog
	endif
	fDelete batchFile$
	goto next_entry

newsysEOF:
	&onerr errCode, lineNum
	onerr goto HandleError
	&pop
	fClose
	gosub check_error
	fDelete trackerFile$
	
	&fn fnCarrier, currentDCD	' Check for DCD loss
	&chk on

	if initialDCD and not currentDCD then goto Logout
	if initialPage then & page on
goto Exit


' ======================================================================
' NewCSPost
'
' Input:
'	csDir$		= path to CS area
'	batchFile$	= path of batched news file to unpack
'	conftop$	= "conf/topic" to post news to
'	maxMsgs		= total messages to queue before expiration
'
' Output:
'	posted		= number of messages posted
'	expired		= number of messages expired
'
' ======================================================================

NewCSPost:
	fFre
	posted = 0
	expired = 0

	&pos (conftop$, "/"), p
	confName$ = left$(conftop$, p - 1)
	topicName$ = mid$(conftop$, p + 1)

	ctPrefix$ = csDir$ + conftop$ + "/"
	indexFile$ = csDir$ + confName$ + "/i.."

	&GETINFO ctPrefix$, info$	' Make sure there's an area to post to
	if info$ = "" then
		entry$ = "^I~ <ERROR: " + ctPrefix$ + " not found>"
		goto UpdateLog
	endif

	gosub getIndexInfo
	if not topicIndex then
		entry$ = "^I~ <ERROR: topic index not found>"
		goto UpdateLog
	endif

	gosub doPostNews
	&ioctl(ioCR)
	&ioctl(ioClearEOS)

	nextMsg[topicIndex] = nextMsg[topicIndex] + posted
	over = nextMsg[topicIndex] - maxMsgs
	if over > firstMsg[topicIndex] then
		&rept
			file$ = ctPrefix$ + "msg" + str$(firstMsg[topicIndex])
			&GETINFO file$, info$
			if info$ > "" then
				fDelete file$
			endif
			&ioctl (ioCR)
			expired = expired + 1
			print "^IExpiring #" firstMsg[topicIndex] \
				" in " conftop$ "...";
			firstMsg[topicIndex] = firstMsg[topicIndex] + 1
		&until (firstMsg[topicIndex] >= over)
	endif

	gosub writeIndexInfo
return


' ==============================
' Subroutines
' ==============================

doPostNews:
	onerr goto dpnEOF
	fOpen batchFile$
    skip_next:
	fRead batchFile$
	repeat
		& get a$		' get #! rnews xxxx line
	until mid$(a$, 1, rnewsMarkLen) = rnewsMarker$

    post_next:
	gosub getFields
	if Header$[CONTROL_FIELD] > "" then
		if left$(Header$[CONTROL_FIELD], cancelArtLen) = cancelArticle$ then goto skip_next
	endif

	posted = posted + 1
	fFre
	&ioctl(ioCR)
	print "^IPosting #" posted + nextMsg[topicIndex] " in " conftop$ "...";

	fAppend msgFile$
	print CS_ID$
	for i = DATE_FIELD to fieldCount
		if Header$[i] > "" then print Header$[i]
	next
	print

    post_copy:
	fRead batchFile$
	& get a$
	if left$ (a$, rnewsMarkLen) <> rnewsMarker$ then 
		fWrite msgFile$
		print a$
		goto post_copy
	endif
	fClose msgFile$
	goto post_next

    dpnEOF:
    	&onerr errCode, errLine
	onerr goto newsysEOF
	fClose batchFile$
	fClose msgFile$
	gosub check_error
return

getFields:
	size = val (mid$(a$, 10))		' #! rnews xxxx
	& time(date$)
	Header$[DATE_FIELD] = "Date:" + mid$(date$, 5) + " " + SysInfo$[plZone]
	Header$[FROM_FIELD] = "From: Unknown User"
	Header$[SUBJECT_FIELD] = "Subject: (none)"
	if fieldCount > SUBJECT_FIELD then
		for i = SUBJECT_FIELD + 1 to fieldCount
			Header$[i] = ""
		next
	endif

	fRead batchFile$
	repeat
		&get a$
		& pos (a$, ":"), q
		if q then
			& pos (fields$, "=" + mid$(a$,1,q)), p
			if p then
				&spc (mid$(a$,q + 1)),i$
				Header$[val(mid$(fields$,p - 2))] = \
					left$(a$, q) + " " + i$
			endif
		endif
	until a$ = ""

	msgID$ = str$ (posted + nextMsg[topicIndex])
	msgFile$ = ctPrefix$ + "msg" + msgID$
	CS_ID$ = "CS-ID: #" + msgID$ + "." + confName$ + "/" + \
		topicName$ + "@" + SysInfo$[plNode] + \
		", " + str$(size) + " chars"
return

getIndexInfo:
	fOpen indexFile$		' Get Index file information
	fRead indexFile$
	&get moderator$
	input confType, numTopics
	for y = 1 to numTopics
		&get a$
		&pos (a$,":"),p
		if not p then 
			p = len (a$) + 1
		endif
		topicName$[y] = left$ (a$,p - 1)
		topicAddress$[y] = mid$ (a$,p)
		input readOnlyFlag[y], firstMsg[y], nextMsg[y]
	next 
	fClose indexFile$

	topicIndex = 0
	for y = 1 to numTopics
		if topicName$ = topicName$[y] then 
			topicIndex = y
			y = numTopics
		endif
	next
return

writeIndexInfo:
	fOpen indexFile$
	fWrite indexFile$
	print moderator$
	print confType "," numTopics
	for y = 1 to numTopics
		print topicName$[y] topicAddress$[y]
		print readOnlyFlag[y]","firstMsg[y]","nextMsg[y]
	next 
	fClose indexFile$
return

GetNextEntry:
	fRead newsysFile$
	&get group$
	if group$ = "" then goto GetNextEntry

	&pos (group$, "="),p
	if p then
		alias$ = mid$(group$, p + 1)
		group$ = left$(group$, p - 1)
	else
		alias$ = group$
	endif

	if len (alias$) > 15 then
		alias$ = right$(alias$, 15)
	endif

	&spc (group$), group$
	&spc (alias$), alias$

	localPostInfo$ = ""
	onerr goto gneEOF

    next_address:
	&get a$
	&spc (a$),a$		' Strip spaces
	&spc (a$,9),a$		' Strip tabs
	if a$ = "" then goto noErr

	if localPostInfo$ = "" and left$(a$, 3) = "#L " then
		localPostInfo$ = mid$(a$, 4)
	endif
	goto next_address

    gneEOF:
    	&onerr errCode, lineNum
    	gosub check_error

    noErr:
	onerr goto newsysEOF
return

check_error:
	if errCode <> 5 then
		entry$ = "^I~ <ERROR #" + str$(errCode) + " at " + \
			str$(lineNum) + ">"
		gosub UpdateLog
		goto Exit
	endif
return

time_index:
	&time (time$)
	& pos ("?anebarprayunulugepctovec", mid$ (time$, 10, 2)),index
	index = index / 2
return

small_time:
	gosub time_index
	time$ = str$ (index) + "/" + str$ (val(mid$(time$,6))) + \
		"-" + mid$ (time$,16,8)
return

UpdateLog:
	&pos (entry$, "~"),p
	if p then
		gosub small_time
		entry$ = mid$(entry$, 1, p - 1) + time$ + mid$(entry$, p + 1)
	endif
	fAppend newsLogFile$
	print entry$
	fClose newsLogFile$
	print entry$
return

#include <proline/proline.lib>
