' **********************************************************************
' ***
' ***	poll.b		Poll remote sites to exchange mail
' ***			(C)opyright 1994 Morgan Davis
' ***
' ***	Options:
' ***
' ***		-i	Ignore poll time restrictions
' ***		-p x	Set progress mode override
' ***
' ***	Poll commands:
' ***
' ***	\[x]		Wait 45 seconds for "x"
' ***	\[x]n		Wait n seconds for "x"
' ***	\[x]n-y-[z]m	Wait n seconds for "x", if found then next command
' ***			  else send "y" then wait m seconds for "z"
' ***	\c		Clear buffer
' ***	\d		Delay
' ***	\b		Break
' ***	\!		Launch
' ***	\px		Progress mode x, where x is:
' ***			0 = <default> show connections in real-time
' ***			1 = summarize activity
' ***
' ***	History:
' ***
' *** 21may90 mwd 2.0	Converted to MD-BASIC
' *** 30may90 mwd 2.1	Major internal changes
' ***  9jun90 mwd 2.2	Fixed bug in End= time range handling
' *** 22jun90 mwd 2.3	Redesigned command system
' *** 28jun90 mwd 2.31  Fixed bug in stripping quotes
' *** 05nov91 mwd 2.4	Beefed up error handling
' *** 28nov91 mwd	Added 5 second pause after no dialtone result
' *** 22feb92 mwd 2.5	Updated for MW3
' *** 25feb93 mwd 2.5.1	Dials 2nd number if 1st is busy
' ***  9sep93 mwd 2.6	Returns actual connect speed
' ***

#define	IDENT_PROG "poll"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "26feb94"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <proline/proline.h>
#include <proline/parse.h>

#define	MAXARGS		128	' Max macro arguments
#define	MAXRANGES	10	' Max time range specifiers

#define	COMMANDS	"!cbd[p"

#define	mTimeRange	1
#define	mSpeed		2
#define	mNumber		3
#define	mLDService	4
#define	mFirst		5


' Main
	gosub AppInit
	gosub SetUp
	repeat
		gosub FindSite
		if margc then
			gosub ValidPollTime
			if okTime then
				gosub PollSite
				if connected then gosub ExecuteMacros
			endif
		endif
continue:
	until EOF
	if not found then 
		gosub GetTime
		e$ = "POLL " + a$ + " " + site$ + " <ERROR: NOT IN " + LsysFile$ + ">"
		gosub UpdateLog
	endif
goto Exit


SetUp:	
	dim range$[MAXRANGES], margv$[MAXARGS]

	mdssLog$ = SPOOL_LOGS_PATH + "mdsslog"
	LsysFile$ = ETC_PATH + "L.sys"

	& pos right$(AppPath$, "/"), p
	AppHome$ = left$(AppPath$, p)
	
	options$ = "ip:?"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "?" then showUsage = TRUE
		if optchar$ = "i" then demand = TRUE
		if optchar$ = "p" then
			progressOverride = TRUE
			progress = val(optarg$)
		endif
	until optchar$ = ""
	
	if nargc < 2 or showUsage then 
		print "Usage: " argv$[0] " [-i] [-p mode] site"
		goto ExitError
	endif

	& fn fnCarrier, DCD
	if DCD then 
		print argv$[0] ": port in use"
		goto ExitError
	endif

	sep$ = "|"			'Multi-number separator

	result$[wfcCancelled]	= "CANCELLED"
	result$[wfcNoConnect]	= "NO CONNECT"
	result$[wfcBusy]	= "BUSY"
	result$[wfcNoDialTone]	= "NO DIAL TONE"
	result$[wfcNoAnswer]	= "NO ANSWER"
	result$[wfcVoice]	= "VOICE ANSWER"

	site$ = nargv$[1]
	& lcase(site$)

	& load get SysInfo$[plModulesDir] + PARSER_NAME, i
	if i and i <> 19 then
		print argv$[0]": can't load parser"
		goto ExitError
	endif

	fOpen LsysFile$
	nxtLine$ = ""
return


FindSite:
	EOF = FALSE
        margc = 0
	onerr goto lsysEOF
	repeat
		if nxtLine$ = "" then
			repeat
				fRead LsysFile$
				& get a$
				& pos (a$, "#"), p
				if p then & spc(mid$(a$, 1, p - 1)), a$
			until mid$(a$,1,1) > " "
		else
			a$ = nxtLine$
			nxtLine$ = ""
		endif
		& pos (a$, " "), p
		if p then i$ = left$ (a$, p - 1)
		& lcase(i$)
	until i$ = site$
	found = TRUE
	repeat
		if a$ > "" then gosub ParseMacros
		fRead LsysFile$
		& get a$
		& pos (a$, "#"), p
		if p then & spc(mid$(a$, 1, p - 1)), a$
	until mid$(a$,1,1) > " "
	nxtLine$ = a$
	return
	
	lsysEOF:
	&onerr errCode, errLine
	fClose
	onerr goto HandleError
	if errCode <> 5 then
		print argv$[0]": error " errCode " at " errLine
		goto ExitError
	endif
	EOF = TRUE
return


ValidPollTime:
	okTime = FALSE
	&lcase(margv$[mTimeRange])
	if margv$[mTimeRange] = "never" then return
	if margv$[mTimeRange] = "any" or demand then
		okTime = TRUE
		return
	endif

	if margv$[mTimeRange] = "dead" then
		okTime = demand
		return
	endif
	
	op = 1
	j = 0
	& rept
		& pos (op,margv$[mTimeRange] + ",",","),p
		j = j + 1
		range$[j] = mid$(margv$[mTimeRange], op,p - op)
		op = p + 1
	& until(op > len (margv$[mTimeRange]))
	& time(a$)
	today$ = left$(a$,3)
	&lcase (today$)
	isWeekEnd = asc(today$) = 115		' s
	a$ = mid$ (a$,16,2) + mid$ (a$,19,2)
	for i = 1 to j
		day$ = today$
		if asc(range$[i]) > $39 then		' we have a day?
			day$ = left$(range$[i],3)
			&lcase (day$)
			range$[i] = mid$(range$[i],5)
			if range$[i] = "" then
				range$[i] = "0000-2359"
			endif
		endif
		if day$ <> today$ then
			if day$ = "any" then day$ = today$
			if (day$ = "end" and isWeekEnd) or \
				(day$ = "day" and not isWeekEnd) then
				day$ = today$
			endif
		endif
		if len (range$[i]) <> 9 or mid$ (range$[i],5,1) <> "-" then 
			range$ = range$[i]
			gosub GetTime
			e$ = "POLL " + a$ + " " + margv$[0] + \
				" <ERROR: BAD TIME RANGE '" + range$ + "'>"
			gosub UpdateLog
			goto ExitError
		endif
		okTime = day$ = today$ and \
			a$ => left$(range$[i],4) and a$ < right$(range$[i],4)
		if okTime then i = j
	next
return


PollSite:
	speeds$ = "0=300;1=1200;2=2400;3=9600;4=19200;5=38400;6=57600"
	& in ioConsole
	& pr ioConsole
	tries = 0
	& pos (speeds$, margv$[mSpeed]), p
	if p then
		dialSpeed = val(mid$(speeds$, p - 2))
		& speed dialSpeed
	endif
	ph$[0] = margv$[mNumber]
	ph$[1] = margv$[mNumber]
	& pos (ph$[0], sep$),p
	if p then 
		ph$[0] = left$ (ph$[0],p - 1)
		ph$[1] = mid$ (ph$[1],p + 1)
	endif

	repeat
		print argv$[0] ": dialing " site$ " (" ph$[tries] ") ";
		& call ph$[tries]
		tries = tries + 1
		& wait for carrier, wfcResult
		connected = not wfcResult
		gosub GetTime
		e$ = "POLL " + a$ + " " + site$ + " "
		if wfcResult = wfcCancelled then tries = 2
		if connected then 
			&on hangup goto DCD_Lost
			gosub GetConnectSpeed
			print "-- connect " connectSpeed
			if connectSpeed < val(margv$[mSpeed]) then
				& hangup
				e$ = e$ + "<ALERT: CONNECT " + str$(connectSpeed) + \
					" SLOWER THAN " + margv$[mSpeed] + ">"
				gosub UpdateLog
				wfcResult = tries < 2
				connected = FALSE
			endif
		else
			print "-- " result$[wfcResult]
			if wfcResult = wfcBusy then
				tries = tries + (ph$[0] = ph$[1])
			endif
			if tries > 1 then
				e$ = e$ + "<" + result$[wfcResult] + ">"
				gosub UpdateLog2
				if wfcResult = wfcCancelled then goto ExitError
				wfcResult = 0
			else
				& wait 3 + (6 * (wfcResult = wfcNoDialTone))
			endif
		endif
	until not wfcResult
return


ExecuteMacros:
	& page stop
	macro = mFirst
	running = TRUE
	while (macro < margc) and running
		a$ = margv$[macro]
		ch = asc(a$)
		if ch > 127 then
			ch$ = chr$(ch - 128)
			& lcase (ch$)
			& pos (COMMANDS, ch$), p
			if not p then
				gosub SendText
			else
				on p gosub Sublaunch, ClearBuffer, SendBreak, \
					MacroPause, Handshake, SetProgress
			endif
		else
			gosub SendText
		endif
		macro = macro + 1
	wend
return

SetProgress:
	if not progressOverride then
		progress = val(mid$(a$, 2))
	endif
return

Sublaunch:
	e$ = e$ + str$(connectSpeed) + " " + margv$[mLDService]
	gosub UpdateLog2
	a$ = mid$(a$,2)
	& asc(a$)
	if progress then print site$ ": exec (" a$ ")"
	Launch(a$, "", FALSE)
	print argv$[0]": can't launch '"a$"'"
return


DCD_Lost:
	e$ = e$ + "<ALERT: LOST CARRIER>"
	gosub UpdateLog
	&pop
goto continue


UpdateLog:
	& pr ioConsole
	print e$
UpdateLog2:
	fAppend mdssLog$
	print e$
	fClose mdssLog$
return 


Handshake:
	gosub HSOne
	if j% then return			' Good!
	if hspos < len(a$) then
		& pos (hspos, a$, "-"), hspos
		& pos (hspos + 1, a$, "-"), q
		if not hspos or not q then
			i$ = "<ERROR: MISSING '-' IN HANDSHAKE>"
			goto MacroError
		endif
		hs$ = mid$(a$, q + 1)
		if hspos + 1 = q then
			a$ = "^M;"
		else
			a$ = mid$(a$, hspos + 1, q - hspos - 1)
		endif
		gosub SendText
		a$ = hs$
		gosub HSOne
		if j% then return		' Good!
	endif
	i$ = "<ALERT: NO MATCH ON '" + hs$ + "'>"

MacroError:
	e$ = e$ + i$
	if progress then
		gosub UpdateLog2
	else
		gosub UpdateLog
	endif
	& hangup
	running = FALSE
return
	

HSOne:
	& pos (a$,"]"),hspos
	if not hspos then
		i$ =  "<ERROR: MISSING ']' AFTER '[" + hs$ + "'>"
		pop
		goto MacroError
	endif
	hs$ = mid$(a$,2, hspos - 2)
	q% = 45
	if hspos < len (a$) then
		q% = val (mid$ (a$,hspos + 1))
		if q% then
			hspos = hspos + len(str$(q%))
		else
			q% = 45
		endif
	endif
	& asc(hs$)
	if progress then
		print site$ ": wait " q% " seconds for";
		p$ = hs$
		gosub specialString
		q% = -q%
	endif
	& wait q% for hs$,j%
	if progress then
		if j% then
			print " -- got it"
		else
			print " -- failed!"
		endif
	endif
return

	
SendText:
	& asc (a$)
	if right$ (a$,1) <> ";" then 
		a$ = a$ + chr$(13)
	else
		a$ = left$(a$, len(a$)-1)
	endif

	if progress then
		print site$ ": send";
		p$ = a$
		gosub specialString
		print
	endif
	& put (a$)
return 


MacroPause:
	j% = 1
	if (len (a$) > 1) then 
		j% = val (mid$ (a$,2))
	endif
	if progress then
		print site$ ": wait " j% " seconds"
	endif
	& wait j%
return 

SendBreak:
	if progress then
		print site$ ": send break"
	endif
	& break
return 

ClearBuffer:
	if progress then
		print site$ ": kill input"
	endif
	& clear 
return 


specialString:
	print " " chr$(34);
	for ss = 1 to len(p$)
		c = asc(mid$(p$, ss, 1))
		if c < 32 or c = 127 then
			print "^~" + chr$(c + 64);
		else
			print chr$(c);
		endif
	next
	print chr$(34);
return


GetTime:
	& time(a$)
	& pos ("?anebarprayunulugepctovec", mid$ (a$,10,2)),i
	a$ = str$ (i / 2) + "/" + str$ (val (mid$ (a$,6))) \
		+ "-" + mid$ (a$,16,8)
return 


ParseMacros:
	ParseBackslashes(a$, a$)
	ParseControls(a$, a$)
	ParseQuotes(34, a$, a$)
	ParseSpaces(a$, a$)
	ParseTrim(a$, a$)
	repeat
                & pos (a$, " "),p
                if not p then p = 255
		margv$[margc] = left$(a$,p - 1)
		margc = margc + 1
		a$ = mid$(a$, p + (p < 255))
        until a$ = ""
return



' ==============================
  GetConnectSpeed:
' ==============================
	& fn fnModemType, connectSpeed
	if connectSpeed then
		& fn fnConnectSpeed, i$
	else
		& fn fnPortSpeed, connectSpeed
		connectSpeed = connectSpeed - ((connectSpeed > 5) * 6)
		i$ = mid$("  3  6 12 18 24 36 48 72 96192384576", \
			connectSpeed * 3 + 1, 3) + "00"
	endif
	connectSpeed = val(i$)
return

#define APP_AT_EXIT cleanup
cleanup:
	fClose
	& load fre PARSER_ID
return

#include <proline/proline.lib>
#define LAUNCH_NO_EXEC_PERM
#define LAUNCH_PARSE
#include <proline/launch.lib>
#include <proline/getopt.lib>
