'=========================================================================
'                               M K S I G
'
'                             by Dean K. Fick
'=========================================================================
'
' History:
'
' When    Who Ver   What
' ======= === ===== ======================================================
'05aug91  dkf 1.0   Creation
'07aug91  dkf 1.0   Modified FindRealName subroutine to look up the real name
'                   of users in $/etc/passwd rather than $/etc/adm.  Added
'                   a few & pops here and there.  Made mksig say its name
'                   when dealing with a request to generate only one
'                   signature.  Arguments must now be either _exactly_ "-e"
'                   or "-a" or a username or else the program exits.
'08aug91  dkf 1.0   Modified the error message printed when no passwd
'                   file is found.  Previously, the message could possibly
'                   come out as "mksig: mksig: $/etc/passwd not found".
'08dec91  dkf 1.1   Added ability for users to modify their own
'                   signature file only, by calling mksig with no argument.
'02may92  mwd 1.2   Updated to use new default signature pathname
'20jun92  dkf 1.2   Internal changes for use with ProLine 2.0
'=========================================================================

#define	IDENT_PROG "mksig"
#define	IDENT_VERS "1.3"
#define	IDENT_DATE "15may94"
#define	IDENT_NAME "Dean_Fick_&_Morgan_Davis"

#include <proline/proline.h>

#define Name                  0   ' SigVar$[] and NewName$[] array boxes
#define Login                 1
#define Host                  2
#define Domain                3

#define MaxDefSigLines        10        ' max number of lines allowed in
                                        ' default sig

#define MaxUsers              1000      ' max number of users in $/usr

#define SubDirType            15        ' ProDOS subdir file type value

#define EndOfData             5         ' end of data error message value
#define FileTypeMismatch      13        ' file type mismatch error msg value

#define existing              0         ' set up ReDoSigs argument values
#define all                   1
#define one                   2         ' who says one can't be two?


#define ReDoSigs(string)      Flag = string : gosub _ReDoSigs

#define FindRealName(string)  UserName$ = string : gosub _Find_Real_Name

' ****************************************************************
' **
' **  Initialize, check shell arguments and branch to proper
' **  place.
' **
' **

     gosub AppInit

     if argc = 1  then
          argv$[1] = id$[uName]
          goto Remake_Own_Sig
     endif

     if (argc = 2) and (not SuperUser) then
          print argv$[0] ": can't run"
          goto ExitError
     endif

     if argc > 2 then goto ShellArgAbort

     & lcase (argv$[1])

     & pos (argv$[1], "-a"), Position
     if Position then
          if argv$[1] = "-a" then
               goto  Remake_All_Sigs
          else
               goto ShellArgAbort
          endif
     endif

     & pos (argv$[1], "-e"), Position
     if Position then
          if argv$[1] = "-e" then
               goto Remake_Existing_Sigs
          else
               goto ShellArgAbort
          endif
     endif

     gosub Verify_User
     gosub Setup_Stuff
     gosub Evaluate_DefSig_Info
     ReDoSigs (one)
     goto Exit

Remake_Own_Sig:

     gosub CheckSig_and_PromptUser
     gosub Setup_Stuff
     gosub Evaluate_DefSig_Info
     ReDoSigs (one)
     goto Exit

Remake_All_Sigs:

     gosub Setup_Stuff
     gosub Evaluate_DefSig_Info
     ReDoSigs (all)
     goto Exit

Remake_Existing_Sigs:

     gosub Setup_Stuff
     gosub Evaluate_DefSig_Info
     ReDoSigs (existing)
     goto Exit

' ****************************************************************
' **
' ** Make sure user wants to remake his own signature file.
' **
' **

CheckSig_and_PromptUser:

     & getinfo USR_PATH + argv$[1] + "/signature", Info$
     if Info$ > "" then
          print "ready to overwrite your old signature file";
     else
          print "ready to make your signature file";
     endif
     print "? (y/n) ";
     repeat
          get YN$
          & lcase (YN$)
     until YN$ = "y" or YN$  = "n"
     print YN$
     if YN$ = "y" then
          return
     else
          goto Exit
     endif

' *****************************************************************
' **
' ** Check for the $/etc/default/signature file and load it into the
' ** DefSigLine$[] array.
' **
' **

Setup_Stuff:

     DefSigFile$ = DEFAULT_PATH + "signature"

     & getinfo DefSigFile$, Info$
     if Info$ = "" then
          & pop
          print argv$[0]": " DefSigFile$ " not found"
          goto ExitError
     endif

     dim DefSigLine$[MaxDefSigLines + 2], ColonPosition[2]

     onerr goto Bad_DefSig_File_Type

     fOpen DefSigFile$
     fRead DefSigfile$

     onerr goto Trap_End_Of_DefSig

     DefSigLineCounter = 1
     repeat
          & get DefSigLine$[DefSigLineCounter]
          DefSigLineCounter = DefSigLineCounter + 1
     until DefSigLineCounter = MaxDefSigLines + 2

     fClose

     if DefSigLineCounter > MaxDefSigLines + 1 then
          & pop
          print argv$[0]": too many lines in signature"
          goto ExitError
     endif

     if DefSigLineCounter = MaxDefSigLines + 1 then
          DefSigLineCounter = MaxDefSigLines
     endif

Onward_and_Upward:

     onerr goto HandleError
     return


' **********************************************************************
' CODE FROM ADDUSER WHICH DOES THIS MUCH MORE EFFICIENTLY...ONE DAY
' **********************************************************************

#if 0
		if GetsSignature then
			f$ = SysInfo$[plDir] + homeDir$ + "/" + SignatureFile$
			fOpen Default$ SignatureFile$
			fOpen f$
			onerr goto sigEOF
			do
				fRead Default$ SignatureFile$
				& get a$
				repeat
					&pos (a$, "<LOGIN>"), p
					if p then a$ = mid$(a$, 1, p - 1) + \
						Login$ + mid$(a$, p + 7)
				until not p
				repeat
					&pos (a$, "<NAME>"), p
					if p then a$ = mid$(a$, 1, p - 1) + \
						Name$ + mid$(a$, p + 6)
				until not p
				repeat
					&pos (a$, "<HOST>"), p
					if p then a$ = mid$(a$, 1, p - 1) + \
						SysInfo$[plNode] + mid$(a$, p + 6)
				until not p
				repeat
					&pos (a$, "<DOMAIN>"), p
					if p then a$ = mid$(a$, 1, p - 1) + \
						SysInfo$[plDomain] + mid$(a$, p + 8)
				until not p
				fWrite f$
				print a$
			loop
			sigEOF:
			&onerr
			onerr goto HandleError
			fClose
			gosub MakeInvisible
		endif
#endif

     

' *****************************************************************
' **
' ** Check the defsig file lines in the DefSigLine$[] array for the
' ** <HOST> and <DOMAIN> keywords.  Replace the keywords with
' ** site-specific info.
' **
' **

Evaluate_DefSig_Info:

     dim SigVar$[4]

     SigVar$[0] = "<NAME>"
     SigVar$[1] = "<LOGIN>"
     SigVar$[2] = "<HOST>"
     SigVar$[3] = "<DOMAIN>"

     dim NewName$[4]

     NewName$[Host] = SysInfo$[plNode]
     NewName$[Domain] = SysInfo$[plDomain]

     for CounterB = 2 to 3
          for CounterC = 1 to DefSigLineCounter
               repeat
                    & pos (DefSigLine$[CounterC], \
                    SigVar$[CounterB]), Position
                    if Position then

                         if Position = 1 then
                              LeftLine$ = ""
                         else
                              LeftLine$ = LEFT$ (DefSigLine$[CounterC], \
                              Position - 1)
                         endif

                         RightLineLength = LEN (DefSigLine$[CounterC]) \
                         - Position - LEN (SigVar$[CounterB]) + 1

                         if not RightLineLength then
                              RightLine$ = ""
                         else
                              RightLine$ = RIGHT$ (DefSigLine$[CounterC], \
                              RightLineLength)
                         endif

                         DefSigLine$[CounterC] = LeftLine$ + \
                         NewName$[CounterB] + RightLine$

                    endif
               until not Position
          next
     next

     return


' *****************************************************************
' **
' ** 1. Load user directory names into the User$[] array if shell
' **    arguments dictate and set looping limit.
' **
' ** 2. Copy DefSigLine$[] info into the SigLine$[] array.
' **
' ** 3. Replace SigLine$[] array keywords <NAME> and <LOGIN> with
' **    the real user-specific values.
' **
' ** 4. Write the new signature from SigLine$[] to the user directory.
' **

_ReDoSigs:

     if Flag < 2 then
          dim User$[MaxUsers]

          & files (SysInfo$[plDir] + "usr", User$, SubDirType), Count
          & srt (User$, Count)

          for SortCounter = 1 to Count
               & lcase (User$[SortCounter])
          next

          Limit = Count
          Countdown = Count
      else
          Limit = 1
          Countdown = 0
      endif

      dim SigLine$[MaxDefSigLines]

      for CounterA = 1 to Limit

          if Flag < 2 then
               LoginName$ = User$[CounterA]
          else
               LoginName$ = argv$[1]
          endif

          if Countdown then
               print "[ "Countdown" ] ";
          else
               print argv$[0]": ";
          endif

          CurrentSigFile$ = USR_PATH + LoginName$ + "/signature"

          & getinfo CurrentSigFile$, Info1$

          if not Flag then
               if Info1$ = "" then
                    print "skipping "LoginName$
                    goto EndOfLoop
               endif
          endif

          NewName$[Login] = LoginName$

          if Info1$ <> "" then fDelete CurrentSigFile$

          for CounterD = 0 to DefSigLineCounter
               SigLine$[CounterD] = DefSigLine$[CounterD]
          next

          CounterF = 1
          repeat
               & pos (SigLine$[CounterF], \
               SigVar$[Name]), Position
               if Position then
                    FindRealName (LoginName$)
                    goto Make_the_Sig
               endif
               CounterF = CounterF + 1
          until CounterF = DefSigLineCounter

Make_the_Sig:
          onerr goto HandleError

          for CounterB = 0 to 1
               for CounterC = 1 to DefSigLineCounter
                    repeat
                         & pos (SigLine$[CounterC], \
                         SigVar$[CounterB]), Position
                         if Position then

                              if Position = 1 then
                                   LeftLine$ = ""
                              else
                                   LeftLine$ = LEFT$ (SigLine$[CounterC], \
                                   Position - 1)
                              endif

                              RightLineLength = LEN (SigLine$[CounterC]) \
                              - Position - LEN (SigVar$[CounterB]) + 1

                              if not RightLineLength then
                                   RightLine$ = ""
                              else
                                   RightLine$ = RIGHT$ (SigLine$[CounterC], \
                                   RightLineLength)
                              endif

                              SigLine$[CounterC] = LeftLine$ + \
                              NewName$[CounterB] + RightLine$
                         endif
                    until not Position
               next
          next
          print "Making signature file for "LoginName$
          fAppend CurrentSigFile$

          for CounterE = 1 to DefSigLineCounter
               print SigLine$[CounterE]
          next

          fClose CurrentSigFile$

EndofLoop:

          if Countdown then Countdown = Countdown - 1

     next
     return


' *****************************************************************
' **
' ** Find a user's real name from info in the $/etc/passwd file.
' **
' **
' **

_Find_Real_Name:

     onerr goto Trap_End_Of_Passwdfile

     Passwdfile$ = ETC_PATH + "passwd"

     & getinfo PasswdFile$, Info$
     if Info$ = "" then
          & pop
          print "ABORTED -- "PasswdFile$" not found"
          goto ExitError
     endif

     if UserName$ = "guest" then
          print "skipping guest"
          pop
          goto EndofLoop
     endif

     UsernameLength = len (UserName$)

     fOpen Passwdfile$
     fRead Passwdfile$

     repeat
          & get Passwdline$
     until left$ (Passwdline$, Usernamelength) = UserName$

     OldPosition = 0

     for ColonCounter = 1 to 5
          & pos (OldPosition + 1, PasswdLine$, ":"), ColonPosition
          if ColonCounter > 3 then
               ColonPosition[ColonCounter - 3] = ColonPosition
          endif
          OldPosition = ColonPosition
     next

     RealNameLength = ColonPosition[2] - ColonPosition[1] - 1

     NewName$[Name] = mid$ (Passwdline$, ColonPosition[1] + 1,\
         RealNameLength)

     fClose Passwdfile$

     return


' *****************************************************************
' **
' ** Verify that a user directory given in argv$[1] exists.  Abort
' ** to exit if not.
' **
' **

Verify_User:

     & getinfo USR_PATH + argv$[1], Info$
     if Info$ = "" then
          & pop
          print argv$[0]": user "argv$[1]" not found"
          goto ExitError
     endif
     return


' *****************************************************************
' **
' ** Exit if $/etc/default/signature file is not a text file.
' **
' **
' **

Bad_DefSig_File_Type:
     & onerr errCode, errLine
     fClose
     if errCode = FileTypeMismatch then
          & pop
          print argv$[0]": " DefSigFile$ " is not a text file"
     endif
     goto ExitError


' *****************************************************************
' **
' ** Catch end of $/etc/default/signature file.
' **
' **
' **

Trap_End_Of_Defsig:
     & onerr errCode, errLine
     fClose
     if errCode = EndOfData then
          DefSigLineCounter = DefSigLineCounter - 1
          goto Onward_and_Upward
     endif
     goto ExitError

' *****************************************************************
' **
' ** Catch end of $/etc/passwd file.
' **
' **
' **

Trap_End_Of_Passwdfile:

     & onerr errCode, errLine
     fClose
     if errCode = EndOfData then
          pop
          print "skipping "LoginName$" (no passwd file entry)"
          goto EndofLoop
     endif
     goto ExitError

' *****************************************************************
' **
' ** Abort if shell argument count is not 1 or if argument is not
' ** -a, -e, or a username.
' **

ShellArgAbort:
     PRINT "Usage: " argv$[0] " [ -ae ] [ user ]"
GOTO Exit


' *****************************************************************
' **
' ** Standard ProLine library routines
' **
' **
' **

#include <proline/proline.lib>
