' ======================================================================
' 
' batch.b	Mail to news batching program
'		(C)opyright 1994 Morgan Davis
' 
' History:
'
' 03-Sep-93 mwd 2.0	Creation (replaces Jeff Jungblut's batch 1.0)
' 16-Jan-94 mwd 3.0	Launch/IDENT update
' 
' ======================================================================

#define	IDENT_PROG "batch"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "16jan94"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <prodos.h>
#include <proline/proline.h>

#define	STD_FIELDS	"a:Path;b:From;c:Date;d:Message-ID;e:Organization;"\
			"f:Newsgroups;g:Distribution;h:Sender;i:Reply-To;"\
			"j:Subject;k:Followup-To;l:References;m:Summary;"\
			"n:Keywords;o:Lines;"
#define	FIELD_COUNT	15
#define	FIX_FIELDS	"abc"
#define	MUST_FIELDS	"abcdfgj"

#define	POUND_SIGN	35
#define	MAX_GROUPS	256

	gosub AppInit
	if not SuperUser then
		print argv$[0]": can't run"
		goto Exit
	endif
	
	' ==============================
	' Pathnames
	' ==============================
	
	newsLogFile$	= SPOOL_LOGS_PATH + "newslog"
	newsysFile$	= ETC_PATH + "newsys"
	newspoolDir$	= SPOOL_NEWS_PATH
	mailDir$	= MAIL_PATH
	rnewsFile$	= mailDir$ + "rnews"
	
	' ==============================
	' Header Markers
	' ==============================
	
	rnewsMarker$	= "#! rnews "
	rnewsMarkLen	= 9
	fromMarker$	= "From "
	fromMarkLen	= 5
	Newsgroups$	= "Newsgroups:"

	dim group$[MAX_GROUPS], alias$[MAX_GROUPS]
	
	fields$		= STD_FIELDS	
	
	' ==============================
	' Find system files
	' ==============================

	&getinfo newsysFile$, info$
	if info$ = "" then
		print argv$[0]": "newsysFile$" not found"
		goto Exit
	endif

	&fn fnCarrier, initialDCD	' Save carrier state
	&chk stop			' then turn carrier loss checking off
	&page def initialPage		' Save paging state
	&page stop			' then turn it off

	entry$ = "BATCH ~ finding local newsgroups..."
	gosub PrintLogEntry
	gosub findGroups
	entry$ = "BATCH ~ (" + str$(groupCount) + " group" + \
		mid$("s", 2 - (groupCount <> 1)) + ")"

	if not groupCount then
		gosub PrintLogEntry
	else
		gosub UpdateLog
	
		for group = 1 to groupCount
			newsgroupName$ = group$[group]
			mailbox$ = mailDir$ + alias$[group]
			newsgroupFile$ = newspoolDir$ + alias$[group]
			group$[group] = ""
			alias$[group] = ""
			gosub batchGroup
			entry$ = "^I~ batched " + str$(articles) + " " + newsgroupName$
			gosub UpdateLog
		next
	endif

	&fn fnCarrier, currentDCD	' Check for DCD loss
	&chk on

	CommandLine$ = ""
	if argv$[1] <> "-x" then
		& getinfo rnewsFile$, info$
		if info$ > "" then
			CommandLine$ = "unbatch"
		else
			if articles then CommandLine$ = "rnews"
		endif
	endif

	if initialDCD and not currentDCD then
		if CommandLine$ = "" then goto Logout
		&restore ProgStack_Cell to a$
		& pos right$(a$, ":"), p
		ReturnPath$ = mid$(a$, p + 1)
		&store "" to ProgStack_Cell
	else
		ReturnPath$ = ""
	endif
	if initialPage then &page on
	if CommandLine$ > "" then goto _Launch
goto Exit

batchGroup:
	fOpen mailbox$
	mboxRefNum = peek(_OREFNUM)
	poke _SREFNUM, mboxRefNum

	articles = 0
	repeat
		articles = articles + 1
		entry$ = "^I~ batching " + newsgroupName$ + ": " + str$(articles)
		gosub PrintLogEntry
		gosub next_article
		&ioctl(ioUp)
	until realEOF%

	fClose mailbox$
	fDelete mailbox$
return
	
next_article:
	fFre
	hdr$[0] = ""
	&erase(hdr$)
	dim hdr$[FIELD_COUNT]

	fRead mailbox$
	repeat
		& get line$
	until left$(line$,fromMarkLen) = fromMarker$

	repeat
		& get a$
		& pos (a$, ":"), p
		if p then
			i$ = left$(a$, p - 1)
			&spc(mid$(a$, p + 1)), j$
			&pos(fields$, ":" + i$ + ";"), p
			if p then
				fieldID$ = mid$(fields$, p - 1, 1)
				hdr = asc(fieldID$) - 96
				&pos(FIX_FIELDS, fieldID$), p
				on p gosub fixPath, fixFrom, fixDate
				hdr$[hdr] = i$ + ": " + j$
			endif
		endif
	until a$ = ""

	for i = 1 to FIELD_COUNT
		&pos (MUST_FIELDS, chr$(96 + i)), p
		if p and (hdr$[i] = "") then
			on p gosub addPath, addFrom, addDate, addID, \
				addNewsgroups, addDistribution, addSubject
		endif
	next
	
	&MLI (_GET_MARK, _SGETMRK), errCode
	filePos = peek24(_SMARK)
	lines = 0
	size = 0
	a$ = ""
	realEOF% = TRUE
	onerr goto articleEOF
	repeat
		& get a$
		size = size + len(a$) + 1
		lines = lines + 1
	until left$(a$, fromMarkLen) = fromMarker$
	lines = lines - 1
	size = size - len(a$) - 1
	realEOF% = FALSE
	error(5)
	articleEOF:
	&onerr errCode, lineNum
	gosub test_for_eof2

	hdr$[FIELD_COUNT] = "Lines: " + str$(lines)

	for i = 1 to FIELD_COUNT
		j = len(hdr$[i])
		if j then size = size + j + 1
	next
	
	&MLI (_SET_MARK, _SGETMRK), errCode
	poke24(_SMARK, filePos)

	fAppend newsgroupFile$
	print rnewsMarker$ size + 1	' add 1 for line between header/body
	for i = 1 to FIELD_COUNT
		if hdr$[i] > "" then
			print hdr$[i]
		endif
	next
	print
	for i = 1 to lines
		fRead mailbox$
		& get a$
		fWrite newsgroupFile$
		print a$
	next
	fClose newsgroupFile$
return 


fixPath:
	a$ = SysInfo$[plNode] + "!"
	if left$(j$, len(a$)) <> a$ then j$ = a$ + j$
return

fixDate:
	if mid$(j$,4,1) = "," then j$ = mid$(j$, 6)
return

fixFrom:
	& pos (j$,"!"),p
	if not p then
		& pos (j$,"@"),p
		if not p then
			& pos (j$," ("),p
			if not p then p = 255
			j$ = left$(j$,p - 1) + "@" + SITE_NAME + mid$(j$,p)
		endif
	endif
return


addPath:
	& pos (line$," "),q
	& pos (q + 1,line$," "),p
	hdr$[i] = "Path: " + SysInfo$[plNode] + "!" + mid$(line$,q + 1,p - q - 1)
return

addFrom:
	hdr$[i] = "From: unknown@" + SITE_NAME + " (Unknown User)"
return

addDate:
	& time(a$)
	hdr$[i] = "Date:" + mid$(a$, 5) + " " + SysInfo$[plZone]
return

addID:
	gosub get_unique_filename
	hdr$[i] = "Message-ID: <" + file$ + "@" + SITE_NAME + ">"
return

addNewsgroups:
	hdr$[i] = "Newsgroups: " + newsgroupName$
return

addDistribution:
	hdr$[i] = "Distribution: world"
return

addSubject:
	hdr$[i] = "Subject: none"
return

	
findGroups:
	onerr goto newsys_EOF
	fOpen newsysFile$
	fRead newsysFile$

	groupCount = 0
	
	new_alias:
		&get line$
		if line$ = "" then goto new_alias
		if asc(line$) = POUND_SIGN then goto new_alias
		&pos (line$, "="),p
		if p then
			& spc(left$(line$, p - 1)), group$
			& spc(mid$(line$, p + 1)), alias$
		else
			&spc(line$), group$
			alias$ = ""
			if len(group$) > 15 then alias$ = line$
		endif
		if len(alias$) > 15 then alias$ = right$(alias$, 15)
		if alias$ = "" then alias$ = group$
		& getinfo mailDir$ + alias$, i$
		if i$ > "" then
			groupCount = groupCount + 1
			alias$[groupCount] = alias$
			group$[groupCount] = group$
		endif
		repeat
			&get line$
			& spc(line$), line$
		until line$ = ""
	goto new_alias

	newsys_EOF:
	&onerr errCode, lineNum
	gosub test_for_eof
	&ioctl(ioUp)
return

test_for_eof:
	fClose
test_for_eof2:
	onerr goto HandleError
	if errCode <> 5 then
		fClose
		entry$ = "^I~ <ERROR: " + str$(errCode) + " at " + \
			str$(lineNum) + ">"
		gosub UpdateLog
		goto Exit
	endif
return

get_unique_filename:
	gosub time_index
	j = val (mid$ (time$,6))
	& right$ (str$(val(mid$(time$,16)) * 3600 + \
		val(mid$(time$,19)) * 60 + val(right$(time$,2))), 5, 48), a$
	file$ = chr$(64 + index) + chr$(48 + j + 7 * (j > 9)) + a$ + "n"
	& lcase (file$)
	if file$ = lastFile$ then
		seq$ = "." + str$(fnSeq)
		fnSeq = fnSeq + 1
	else
		fnSeq = 0
		seq$ = ""
	endif
	lastFile$ = file$
	file$ = file$ + seq$
return


time_index:
	&time (time$)
	& pos ("?anebarprayunulugepctovec", mid$ (time$, 10, 2)),index
	index = index / 2
return

small_time:
	gosub time_index
	time$ = str$ (index) + "/" + str$ (val(mid$(time$,6))) + \
		"-" + mid$ (time$,16,8)
return

UpdateLog:
	gosub SetEntry
	fAppend newsLogFile$
	print entry$
	fClose newsLogFile$

PrintLogEntry:
	gosub SetEntry
	& ioctl (ioClearEOL)
	& print entry$
return

SetEntry:
	&pos (entry$, "~"),p
	if p then
		gosub small_time
		entry$ = mid$(entry$, 1, p - 1) + time$ + mid$(entry$, p + 1)
	endif
return

#define LAUNCH_NO_EXEC_PERM
#include <proline/launch.lib>
#include <proline/proline.lib>

