' **********************************************************************
' ***
' ***	Setup.b		ProLine Installer/Upgrader
' ***			(C)opyright 1994 Morgan Davis Group
' ***

#reserve EXIT$, DISK$, VDIR$, REST$, OS%	' Used by babybackup

#define	VERSION	"ProLine Installer 3.0"
#define OLDEXT	".v20"

#include <omm.h>
#include <appleio.h>
#include <romcall.h>
#include <basic.h>
#include <amperworks.h>
#include <fileio.h>
#include <ctype.h>
#include <errors.h>

#define	QUIT_PROG	"Startup"
#define BB_PROG		"Install/babyBACKUP"
#define	CONFIG_DATA	AppPrefix$ + "Config.Data"
#define	VDIR_TAG	"ProLine."
#define	MAINDISK	VDIR_TAG "1"
#define	UPGRADE_SCRIPT	"upgrade"
#define	UPGRADE_FROM	AppPrefix$ + "Scripts/" UPGRADE_SCRIPT
#define	UPGRADE_TO	SysDir$ + "/etc/" UPGRADE_SCRIPT

	onerr goto HandleError
	vtab 3
	gosub GetAppPrefix

	ConfigFile$ = CONFIG_DATA
	VDIR$ = "/" VDIR_TAG
	
	a$ = "INSTALL/UPGRADE"
	i$ = "Main Menu"
	gosub NewScreen
	vtab 24
	title$ = "Install a new system or Upgrade an old one?"
	iCount = 3
	item$[1] = "Install"
	item$[2] = "Upgrade"
	item$[3] = "Cancel"
	gosub HMenu
	poke _CH80, 0
	call _CLREOL
	if theItem = 3 then goto ExitToShell
	Install = theItem = 1
	what$ = item$[theItem]
	gosub InstallNotes
again:
	gosub GetBBSource
	gosub newPage
	
	if Install then
		gosub GetSysDir
		if i$ = "" then
			if ERR = NoSuchFileErr then
				fCreate SysDir$
			else
				& get (0), "The path you entered is invalid or does not exist.  Press RETURN "
				goto again
			endif
		endif
		gosub CopySystem
		gosub UpdateSysDir
		goto RunBB		
	else
		gosub GetConfigData
		gosub GetSysDir
		if i$ > "" then & getinfo SysDir$ + "/etc/rsrc", i$
		if i$ = "" then
			print "ProLine is not installed there...";
			goto ExitToShell
		endif
		gosub newPage
		print "Preparing for the upgrade by saving your important files ";
		spinner$ = "|/-|/-\"
		spin = 1
		
		a$ = "etc/badlogin"		: gosub Backup
		a$ = "etc/cshrc"		: gosub Backup
		a$ = "etc/crontab"		: gosub Backup
		a$ = "etc/motd"			: gosub Backup
		a$ = "etc/default/cshrc"	: gosub Backup
		a$ = "etc/default/login"	: gosub Backup
		a$ = "etc/default/mail"		: gosub Backup
		a$ = "etc/default/signature"	: gosub Backup
		a$ = "etc/plush.m"		: gosub Backup
		a$ = "etc/rc"			: gosub Backup
		a$ = "etc/welcome"		: gosub Backup
		a$ = "sys/pcs/cs.herald"	: gosub Backup
		a$ = "pub/index"		: gosub Backup
		a$ = "pub/proline/index"	: gosub Backup

		' Directories
		
		a$ = "bin"			: gosub Backup
		a$ = "etc/help"			: gosub Backup
		a$ = "sys/bin"			: gosub Backup
		a$ = "sys/man"			: gosub Backup

		poke _CH80, 0
		call _CLREOL
		print "Copying the " UPGRADE_SCRIPT " script...";
		& copy (UPGRADE_FROM to UPGRADE_TO)
		gosub CopySystem
		gosub UpdateSysDir
		goto RunBB
	endif

ExitToShell:
	a$ = QUIT_PROG
	fLaunch a$


Backup:
	gosub spinit
	a$ = SysDir$ + "/" + a$
	& getinfo a$, i$
	j$ = a$ + OLDEXT
	gosub spinit
	& getinfo j$, k$
	if i$ > "" and k$ = "" then
		gosub spinit
		fRename a$ "," j$
	endif
return

spinit:
	print mid$(spinner$, spin, 1) "^H";
	spin = spin + 1
	if spin > len(spinner$) then spin = 1
return


RunBB:
	vtab 24
	poke _CH80, 0
	call _CLREOL
	print "One moment...";
	poke $200, len(VDIR$)
	if len(VDIR$) then
		for i = 1 to len(VDIR$)
			poke $200 + i, asc(mid$(VDIR$, i))
		next
	endif
	poke $280, len(SysDir$)
	for i = 1 to len(SysDir$)
		poke $280 + i, asc(mid$(SysDir$, i))
	next
	poke $00, OS%
	clear
	OS% = peek($00)
	if peek($200) then
		for I = $201 TO $200 + PEEK($200)
			VDIR$ = VDIR$ + CHR$(PEEK(I))
		next
	endif
	for I = $281 TO $280 + PEEK($280)
		REST$ = REST$ + CHR$(PEEK(I))
	next
	EXIT$ = QUIT_PROG
	DISK$ = MAINDISK
fChain BB_PROG


InstallNotes:
	vtab Install * 3 + 6
	print spc(17)"Important:  Read This Before You " what$ "!"
	print
	print spc(8)"Making a complete backup of your system is a smart thing to do"
	print spc(8)"before installing any kind of software, especially ProLine."
	print spc(8)"If you need to make a backup, answer No to the question below."
	print spc(8)"Then run your disk backup program.  Optimize your hard drive, too."
if not Install then
	print
	print spc(8)"After the new files are installed, choose Run ProLine from the"
	print spc(8)VERSION " Main Menu.  When it starts up, ProLine will"
	print spc(8)"complete the upgrade procedure with a little help from you."
endif
	print
	print spc(8)"About 1.5MB of free disk space is needed for this procedure."
	vtab 24
	title$ = "Do you wish to continue? "
	gosub GetYN
	if not Yes then goto ExitToShell
return

CopySystem:
	vtab 24
	poke _CH80, 0
	call _CLREOL
	title$ = "Copy ProDOS-8 and BASIC.System to " + SysDir$ + "? "
	gosub GetYN
	OS% = Yes
return
	

UpdateSysDir:
	vtab 24
	poke _CH80, 0
	call _CLREOL
	gosub PrepWrite
	print SysDir$
	fClose
	poke _CH80, 0
	call _CLREOL
return

PrepWrite:
	print "Updating " VERSION " information...";
	onerr goto pwErr
	& getinfo ConfigFile$, i$
	if i$ > "" then fDelete ConfigFile$
	fAppend ConfigFile$
	onerr goto HandleError
return

pwErr:
	& onerr e, l
	onerr goto HandleError
	if e = WriteProtErr then
		vtab 24
		poke _CH80, 0
		call _CLREOL
		& get (0),"Please write-enable the " MAINDISK " disk, then press RETURN "
		poke _CH80, 0
		call _CLREOL
		goto PrepWrite
	endif
	error(e)

	
GetYN:
	iCount = 2
	item$[1] = "No"
	item$[2] = "Yes"
	gosub HMenu
	Yes = theItem - 1
	poke _CH80, 0
	call _CLREOL
return

GetBBSource:
	gosub newPage
	vtab  8
	print spc(8)"You can " what$ " from the supplied Disks or from a Folder"
	print spc(8)"containing the contents of those disks.  To do this using the"
	print spc(8)"Folder method, you should have the ProLine disks copied into"
	print spc(8)"their own folders within a folder on your hard disk or RAM"
	print spc(8)"disk.  The folders should have the same names as the disks."
	vtab 24
	poke _CH80, 0
	title$ = what$ + " ProLine from:"
	iCount = 3
	item$[1] = "Disks"
	item$[2] = "Folder"
	item$[3] = "Cancel"
	gosub HMenu
	poke _CH80, 0
	call _CLREOL
	if theItem = 3 then goto ExitToShell

	if theItem = 2 then
		vtab 24
		poke _CH80, 0
		call _CLREOL
		poke _WNDTOP, 23
		& read (64),"Where are the ProLine disk folders stored? ", VDIR$
		poke _WNDTOP, 0
		if VDIR$ = "" then goto ExitToShell
		if right$(VDIR$, 1) <> "/" then VDIR$ = VDIR$ + "/"
		VDIR$ = VDIR$ + VDIR_TAG
		& getinfo VDIR$ + "1", i$
		if i$ = "" then
			print VDIR$ "1 not found! ^G";
			get i$
			goto GetBBSource
		endif	
	endif
return


GetSysDir:
	gosub newPage
	vtab  8
	print spc(23)"The ProLine System Directory"
	print
if Install then
	print spc(8)"Enter the path to a directory which will hold the ProLine system"
	print spc(8)"software.  If the path you enter leads to a non-existent"
	print spc(8)"directory, it will be created for you.  If the directory already"
	print spc(8)"exists, the ProLine software will be copied into it without"
	print spc(8)"disturbing other files that may reside there."
else
	print spc(8)"Enter the path to the directory in which ProLine is installed."
endif
	vtab 24
	poke _WNDTOP, 23
	i$ = SysDir$
	& read (-64, i$), "ProLine System Directory: ", SysDir$
	poke _WNDTOP, 0
	if SysDir$ = "" then goto ExitToShell
	if right$(SysDir$, 1) = "/" then
		SysDir$ = left$(SysDir$, len(SysDir$) - 1)
	endif
	& getinfo SysDir$, i$
return


newScreen:
	home
	print VERSION;
	htab 40 - len(a$) / 2
	print a$;
	htab 76 - len(i$)
	print "Esc: " i$;

newPage:
	vtab 2
	poke _CH80, 0
	print chr$(cMTextOn) chr$(cInverse);
	& hlin 80, 88
	normal
	call _CLREOP
	inverse
	vtab 23
	& hlin 80, 89
	print chr$(cMTextOff) chr$(cNormal);
return


' ====================
  HMenu:
' ====================
	hmKeys$ = ""
	for i = 1 to iCount
		hmKeys$ = hmKeys$ + left$(item$[i], 1)
	next
	& lcase (hmKeys$)
	theItem = 1
	print title$" ";
	menuX = peek(_CH80)
	repeat
		gosub DrawHMenu
		wait _KBD, 128
		i = peek(_KBD)
		poke _KBDSTRB, 0
		if i = 136 then
			theItem = theItem - 1
			if theItem < 1 then theItem = iCount
		else
			if i = 149 then
				theItem = theItem + 1
				if theItem > iCount then theItem = 1
			else
				if i <> 141 then
					i$ = chr$(i - 128)
					& lcase(i$)
					& pos (hmKeys$, i$), i
					if i then
						theItem = i
						gosub DrawHMenu
						i = 141
					endif
				endif
			endif
		endif
	until i = 141
return

DrawHMenu:
	poke _CH80, menuX
	for i = 1 to iCount
		if i = theItem then inverse
		print " " item$[i] " ";
		normal
	next
return


' ====================
  HandleError:
' ====================
	& pop
	fClose
	vtab 24
	poke _CH80, 0
	call _CLREOL
	print "^GError #" ERR " at " ERL;
	& get (1),", Press RETURN "
goto ExitToShell


' ====================
  GetConfigData:
' ====================
	& getinfo ConfigFile$, i$
	if i$ > "" then
		fOpen ConfigFile$
		fRead ConfigFile$
		& get SysDir$
		fClose
	else
		SysDir$ = ""
	endif
return


' ====================	
  GetAppPrefix:
' ====================
'
' This obtains the path to this program so that its
' prefix can be extracted.  Then it can find its files.
'
	AppPath$ = ""
	for I = $281 TO $280 + PEEK($280)
		AppPath$ = AppPath$ + CHR$(PEEK(I))
	next
	if asc(AppPath$) <> 47 then
		fPrefix
		input A$
		AppPath$ = A$ + AppPath$
	endif
	if right$(AppPath$, 1) = "/" then
		AppPath$ = left$(AppPath$, len(AppPath$) - 1)
	endif
	p = len(AppPath$)
	while mid$(AppPath$, p, 1) <> "/"
		p = p - 1
	wend
	AppPrefix$ = mid$(AppPath$, 1, p)
return
