' **********************************************************************
' ***
' ***	configure.b	ModemWorks Configure program
' ***			(C)opyright 1994 Morgan Davis Group
' ***

#define	VERSION	"ProLine Installer 3.0"

#include <omm.h>
#include <appleio.h>
#include <romcall.h>
#include <basic.h>
#include <amperworks.h>
#include <fileio.h>
#include <ctype.h>
#include <errors.h>

#define	QUIT_PROG	"Startup"
#define	CONFIG_DATA	"Config.Data"
#define	MC_PATH		SysDir$ + "/sys/modemcaps/"
#define	MC_CONTENTS	MC_PATH + "Contents"

#define	MAX_MODULES	22

#define	CFG_MODEM	1
#define	CFG_MSLOT	2
#define	CFG_MSPKR	3
#define	CFG_PRINTER	4
#define	CFG_PSLOT	5
#define	CFG_SITE	6
#define	CFG_DOMAIN	7
#define	CFG_LOGIN	8
#define	CFG_NAME	9
#define	CFG_ZONE	10
#define	CFG_TEMP	11
#define	CFG_SPOOL	12
#define CFG_LAST	12

data	"",15,\
	"",1,\
	"Modem control number (see manual)",2,\
	"",15,\
	"",1,\
	"Site name (i.e. pro-test)",12,\
	"Domain (keep blank if none)",40
data	"Sysop's login name",15,\
	"Sysop's full name",25,\
	"Time zone abbreviation",3,\
	"Temporary files directory",30,\
	"Spool files directory",30

	onerr goto HandleError
	vtab 3
	gosub GetAppPrefix

	dim prompt$[CFG_LAST], maxLen[CFG_LAST], \
		Config$[CFG_LAST], module$[MAX_MODULES]

	for i = 1 to CFG_LAST
		read prompt$[i], maxLen[i]
	next

	spkr$[1] = "Always Off"
	spkr$[2] = "On For Connections Only"
	spkr$[3] = "Always On"
	
	gosub GetConfigData
	changes = FALSE
do
	& pop
	gosub DrawMainScreen
	print "Select a letter (A to L, or Escape): ";
	repeat
		get a$
		& ucase(a$)
		& pos ("ABCDEFGHIJKL^[", a$), cfg
	until cfg
	poke _CH80, 0
	call _CLREOL
	if a$ <> "^[" then changes = TRUE
	on cfg gosub doModem, doMdmSlot, doMdMSPKR, doPrinter, \
		doPrntrSlot, doHost, doDomain, doLogin, doName, \
		doZone, doTemp, doSpool, quit
loop


doModem:
	i$ = Config$[CFG_MODEM]
dm2:	poke _WNDTOP, 23
	& read (-15,i$),"Select a modem file (? for a list): ",i$
	poke _WNDTOP, 0
	if i$ = "?" then
		a$ = "MODEMCAP FILES"
		i$ = "Select Modem"
		theFile$ = MC_CONTENTS
		gosub pageFile
		gosub DrawMainScreen
		goto doModem
	endif
	& getinfo MC_PATH + i$, a$
	if a$ = "" then
		call _BELL
		goto dm2
	endif
	Config$[CFG_MODEM] = i$
	& lcase(i$)
	if i$ = "datalink.1200" or i$ = "datalink.2400" then
		if left$(module$[4], 6) = "Serial" then
			module$[4] = "SerialDL"
		endif
	else
		if module$[4] = "SerialDL" then
			module$[4] = "Serial|GS"
		endif
	endif
	if i$ = "modem.emulator" and module$[6] = "Modem" then
		module$[6] = "NoModem"
	else
		if module$[6] = "NoModem" then
			module$[6] = "Modem"
		endif
	endif
return

doMdmSlot:
	title$ = "Modem Slot:"
	gosub getSlot
	Config$[CFG_MSLOT] = item$[theItem]
return

doMdMSPKR:
	iCount = 3
	item$[1] = spkr$[1]
	item$[2] = spkr$[2]
	item$[3] = spkr$[3]
	title$ = "Modem Speaker:"
	gosub HMenu
	Config$[CFG_MSPKR] = str$(theItem + 2)
return


doPrinter:
	iCount = 3
	item$[1] = "NoPrinter"
	item$[2] = "Printer"
	item$[3] = "ParallelPrinter"
	title$ = "Printer:"
	gosub HMenu
	Config$[CFG_PRINTER] = item$[theItem]
return

doPrntrSlot:
	title$ = "Printer Slot:"
	gosub getSlot
	Config$[CFG_PSLOT] = item$[theItem]
return


getSlot:
	iCount = 7
	for i = 1 to iCount
		item$[i] = str$(i)
	next
goto HMenu


doHost:
	i$ = Config$[cfg]
	i = maxLen[cfg]
	j = len(i$)
	if j > i then
		i = j
	else
		if i$ = "" then i$ = "pro-"
	endif
	gosub  _lineEdit
	if a$ > "" then
		& lcase(a$)
		& pos (a$, "."), q
		& getinfo mid$(a$, 5), i$
		if left$(a$, 4) <> "pro-" or q or ERR = 16 then
			call _BELL
			goto doHost
		endif
	endif
return

	
doLogin:
doTemp:
doSpool:
	gosub doName
	& getinfo a$, i$
	if ERR = 16 then
		call _BELL
		Config$[cfg] = ""
		goto doLogin
	endif
return
		

doName:
doDomain:
doZone:
	i = maxLen[cfg]
	i$ = Config$[cfg]
_lineEdit:
	poke _WNDTOP, 23
	print prompt$[cfg]": ";
	& read (-i, i$),a$
	poke _WNDTOP, 0
	Config$[cfg] = a$
return


' ====================
  quit:
' ====================

	Incomplete = FALSE
	for i = 1 to CFG_LAST
		if i <> CFG_DOMAIN and Config$[i] = "" then
			Incomplete = TRUE
			i = CFG_LAST
		endif
	next
	if Incomplete then
		title$ = "Incomplete configuration.  Do you wish to cancel?"
		iCount = 2
		item$[1] = "No"
		item$[2] = "Yes"
		gosub HMenu
		if theItem = 1 then return
	else
		print "One moment please...";
		if changes then gosub SaveChanges
	endif

ExitToShell:
	a$ = QUIT_PROG
	fLaunch a$

SaveChanges:
	& getinfo ResourceFile$, i$
	if i$ > "" then fDelete ResourceFile$
	fAppend ResourceFile$
	print moduleCount%
	for i = 1 to moduleCount%
		print module$[i]
	next
	& lcase (Config$[CFG_LOGIN])
	& lcase (Config$[CFG_SITE])
	& ucase (Config$[CFG_ZONE])
	& lcase (Config$[CFG_TEMP])
	& lcase (Config$[CFG_SPOOL])
	for i = 1 to CFG_LAST
		print Config$[i]
	next
	fClose

	f$ = SysDir$ + "/etc/herald"
	& getinfo f$, i$
	if i$ = "" then
		fAppend f$
		print "ProLine [" Config$[CFG_SITE]"]"
		fClose
	endif
	f$ = SysDir$ + "/etc/aliases"
	& getinfo f$, i$
	if i$ = "" then
		fAppend f$
		print "root: ~"		Config$[CFG_LOGIN]
		print "mdss: ~"		Config$[CFG_LOGIN]
		print "postmaster: ~"	Config$[CFG_LOGIN]
		print "sysop: ~"	Config$[CFG_LOGIN]
		print "rnews: ~rnews"
		print "null: ~"
		fClose
	endif
return


' ====================
  pageFile:
' ====================
	gosub NewScreen
	fOpen theFile$
	fRead theFile$
	onerr goto notesEOF

	gosub InitMore
	k$ = "More"
	cancelled = FALSE
	repeat
		& get a$
		again:
		print a$;
		call _CLREOL
		print
		lc = lc + 1
		if lc = 20 then
			gosub More
			goto again
		endif
	until cancelled
	error(EOFErr)

	notesEOF:
	& onerr
	onerr goto HandleError
	fClose
	if not cancelled then
		while lc < 20
			call _CLREOL
			print
			lc = lc + 1
		wend
		k$ = "End"
		gosub More
	endif
return


More:
	vtab 24
	inverse
	print "--" k$ "--";
	normal
	wait _KBD,128
	i = peek(_KBD)
	poke _KBDSTRB,0
	poke _CH80,0
	call _CLREOL
	cancelled = i = $9B
InitMore:
	lc = 0
	vtab 3
return
	
' ====================
  DrawMainScreen:
' ====================
	a$ = "CONFIGURE"
	i$ = "Main Menu"
	gosub NewScreen
	vtab 5
	htab 20 : print "A. Modem:          " Config$[CFG_MODEM]
	htab 20 : print "B. Modem Slot:     " Config$[CFG_MSLOT]
	i = val(Config$[CFG_MSPKR])
	if i then i = i - 2
	htab 20 : print "C. Modem Speaker:  " spkr$[i]
	print
	htab 20 : print "D. Printer:        " Config$[CFG_PRINTER]
	htab 20 : print "E. Printer Slot:   " Config$[CFG_PSLOT]
	print
	htab 20 : print "F. Site Name:      " Config$[CFG_SITE]
	htab 20 : print "G. Domain:         " Config$[CFG_DOMAIN]
	print
	htab 20 : print "H. Sysop's Login:  " Config$[CFG_LOGIN]
	htab 20 : print "I. Sysop's Name:   " Config$[CFG_NAME]
	print
	htab 20 : print "J. Time Zone:      " Config$[CFG_ZONE]
	print
	htab 20 : print "K. Temp Files:     " Config$[CFG_TEMP]
	htab 20 : print "L. Spool Files:    " Config$[CFG_SPOOL]
	vtab 24
return


newScreen:
	home
	print VERSION;
	htab 40 - len(a$) / 2
	print a$;
	htab 76 - len(i$)
	print "Esc: " i$;
	print chr$(cMTextOn) chr$(cInverse);
	& hlin 80, 88
	vtab 23
	& hlin 80, 89
	print chr$(cMTextOff) chr$(cNormal);
return


' ====================
  HMenu:
' ====================
	hmKeys$ = ""
	for i = 1 to iCount
		hmKeys$ = hmKeys$ + left$(item$[i], 1)
	next
	& lcase (hmKeys$)
	theItem = 1
	print title$" ";
	menuX = peek(_CH80)
	repeat
		gosub DrawHMenu
		wait _KBD, 128
		i = peek(_KBD)
		poke _KBDSTRB, 0
		if i = 136 then
			theItem = theItem - 1
			if theItem < 1 then theItem = iCount
		else
			if i = 149 then
				theItem = theItem + 1
				if theItem > iCount then theItem = 1
			else
				if i <> 141 then
					i$ = chr$(i - 128)
					& lcase(i$)
					& pos (hmKeys$, i$), i
					if i then
						theItem = i
						gosub DrawHMenu
						i = 141
					endif
				endif
			endif
		endif
	until i = 141
return

DrawHMenu:
	poke _CH80, menuX
	for i = 1 to iCount
		if i = theItem then inverse
		print " " item$[i] " ";
		normal
	next
return


' ====================
  HandleError:
' ====================
	call _STKINI
	fClose
	print "^GError #" ERR " at " ERL
end


' ====================
  GetConfigData:
' ====================
	ConfigFile$ = AppPrefix$ + CONFIG_DATA
	& getinfo ConfigFile$, i$
	if i$ > "" then
		fOpen ConfigFile$
		fRead ConfigFile$
		& get SysDir$
		fClose
	     findagain:
	     	& getinfo SysDir$ + "/etc", i$
	     	if i$ > "" then
			ResourceDir$ = SysDir$ + "/etc/rsrc/"
			ResourceFile$ = ResourceDir$ + "startup.rsrc"
			& getinfo ResourceDir$, i$
			if i$ > "" then
				& getinfo ResourceFile$, i$
				if i$ > "" then
					vtab 1
					goto LoadResources
				endif
			else
				fCreate ResourceDir$
			endif
			goto NewResources
		endif
	endif
	gosub WhereIsProLine
goto findagain


WhereIsProLine:
	vtab 24
	poke _CH80, 0
	call _CLREOL
	print "Where is ProLine installed? ";
	iCount = 2
	item$[1] = "Oops, It Isn't!"
	item$[2] = "I'll Tell You"
	gosub HMenu
	poke _CH80, 0
	call _CLREOL
	if theItem = 1 then goto ExitToShell

	poke _WNDTOP, 23
	i$ = SysDir$
	& read (-64, i$), "Where is ProLine installed? ", a$
	poke _WNDTOP, 0
	& getinfo a$ + "/etc/rsrc", i$
	if i$ > "" then
		SysDir$ = a$
		& getinfo ConfigFile$, i$
		if i$ > "" then fDelete ConfigFile$
		fAppend ConfigFile$
		print SysDir$
		fClose
	endif
return


LoadResources:
	fOpen ResourceFile$
	fRead ResourceFile$
	onerr goto rsrcEOF
	input moduleCount%
	for i = 1 to moduleCount%
		& get module$[i]
	next
	for i = 1 to CFG_LAST
		& get Config$[i]
	next
	goto rsrcClose
	
rsrcEOF:
	& onerr
rsrcClose:
	onerr goto HandleError
	fClose

NewResources:
	if not moduleCount%
		moduleCount% = 6
		module$[1] = "Store|GS"
		module$[2] = "ModemWorks"
		module$[3] = "Time|GS"
		module$[4] = "Serial|GS"
		module$[5] = "Console"
		module$[6] = "Modem"
	endif
return
	


' ====================	
  GetAppPrefix:
' ====================
'
' This obtains the path to this program so that its
' prefix can be extracted.  Then it can find its files.
'
	AppPath$ = ""
	for I = $281 TO $280 + PEEK($280)
		AppPath$ = AppPath$ + CHR$(PEEK(I))
	next
	if asc(AppPath$) <> 47 then
		fPrefix
		input A$
		AppPath$ = A$ + AppPath$
	endif
	if right$(AppPath$, 1) = "/" then
		AppPath$ = left$(AppPath$, len(AppPath$) - 1)
	endif
	p = len(AppPath$)
	while mid$(AppPath$, p, 1) <> "/"
		p = p - 1
	wend
	AppPrefix$ = mid$(AppPath$, 1, p)
return
