' **********************************************
' **                                          **
' **              Robots 1.3                  **
' **                                          **
' **      A ProLine Game by Morgan Davis      **
' **                                          **
' **********************************************

#define	IDENT_PROG "robots"
#define	IDENT_VERS "1.3"
#define	IDENT_DATE "25dec92"
#define	IDENT_NAME "Morgan_Davis"

#define	COPYRIGHT	"Robots " IDENT_VERS " (C) 1988-1994 Morgan Davis"

#include <appleio.h>
#include <proline/proline.h>

#define	EMPTY	0
#define	THE_MAN	1
#define	A_ROBOT	2
#define	RUBBLE	3


' ==============================
' Main
' ==============================

GOSUB AppInit

& IOCTL (ioGotoXY),I
IF NOT I THEN
	PRINT "Terminal emulation is required to play this game."
	GOTO Exit
ENDIF

& pos right$ (AppPath$, "/"), p
GamesLib$ = left$(AppPath$, p) + "lib/"

GOSUB SetupGame
GOSUB DrawScreen
GOSUB NewLevel
GOSUB PlayIt
GOSUB EndGame
GOTO Exit


' ==============================
' End Of Game
' ==============================

EndGame:
	MaxFame = 15
	DIM Fame$[MaxFame]

	& IOCTL (ioClearScreen)

	FF$ = GamesLib$ + "robot.scores"
	& GETINFO FF$,I$
	IF I$ > "" THEN
		fOpen FF$
		fRead FF$
		INPUT Fame
		FOR I = 1 TO Fame
			& GET Fame$[I]
		NEXT
		fClose
	ENDIF

	IF Score% > 0 THEN
		& TIME(A$)
		& LEFT$ ( STR$ (Level%),2),J$
		& RIGHT$ ( STR$ (Score%),6),I$
		Fame$ = I$ + "  #" + J$ + " " + MID$ (A$,6,15)\
			+ "  " + ID$[uName]
		IF Fame < MaxFame THEN
			Fame = Fame + 1
			Fame$[Fame] = Fame$
			MOD = TRUE
		ELSE
			FOR I = 1 TO Fame
				IF VAL(Fame$) >= VAL(Fame$[I]) THEN
					Fame$[MaxFame] = Fame$[I]
					Fame$[I] = Fame$
					MOD = TRUE
					I = Fame
				ENDIF
			NEXT
		ENDIF
	ENDIF

	IF Fame THEN
		& SRT (Fame$, Fame)
		IF MOD THEN
			fOpen FF$
			fWrite FF$
			PRINT Fame
			FOR I = Fame TO 1 STEP -1
				PRINT Fame$[I]
			NEXT
			fClose
		ENDIF

		PRINT
		& IOCTL (ioInverse)
		& STR$ (11,32)
		PRINT "Robots Hall of Fame";
		& STR$ (11,32)
		& IOCTL (ioNormal)
		PRINT
		FOR I = Fame TO 1 STEP -1
			PRINT Fame$[I]
		NEXT
		& STR$ (40,45)
		PRINT
	ENDIF

	PRINT
	PRINT COPYRIGHT
	PRINT
RETURN


' ==============================
' Draw The Screen
' ==============================

DrawScreen:
	& IOCTL (ioClearScreen)
	& IOCTL (ioGotoXY, 0, 1)
	PRINT "+";
	& STR$ (60,45)
	PRINT "+"
	FOR I = 2 TO 22
		PRINT "|";
		& IOCTL (ioGotoXY, 61, I)
		PRINT "|"
		& PAGE CLEAR
	NEXT
	PRINT "+";
	& STR$ (60,45)
	PRINT "+";
	& IOCTL (ioGotoXY, 64, 2)
	& IOCTL (ioInverse)
	PRINT " R O B O T S ";
	& IOCTL (ioNormal)

	& IOCTL (ioGotoXY, 66, 16) : PRINT   "7y  8u  9i";
	& IOCTL (ioGotoXY, 67, 17) : PRINT    "\  |  /";
	& IOCTL (ioGotoXY, 64, 19) : PRINT "4h -- 5j -- 6k";
	& IOCTL (ioGotoXY, 67, 21) : PRINT    "/  |  \";
	& IOCTL (ioGotoXY, 66, 22) : PRINT   "1n  2m  3,";
	& IOCTL (ioGotoXY, 65, 4)  : PRINT "Score:";
	& IOCTL (ioGotoXY, 65, 5)  : PRINT "Bombs:";
	& IOCTL (ioGotoXY, 65, 6)  : PRINT "Lives:";
	& IOCTL (ioGotoXY, 65, 7)  : PRINT "Level:";
	& IOCTL (ioGotoXY, 63, 9)  : PRINT "Q: Quit Game";
	& IOCTL (ioGotoXY, 63, 10) : PRINT "T: Teleport";
	& IOCTL (ioGotoXY, 63, 11) : PRINT "Z: Zap Bomb";
	& IOCTL (ioGotoXY, 63, 12) : PRINT "G: Game Info";
	GOSUB UpdateStats

YourMove:
	& IOCTL (ioGotoXY, 65, 14) : PRINT "Your Move?";
	RETURN


' ==============================
' Set Up The Game
' ==============================

SetupGame:
	Level% = 0
	Score% = 0
	Bombs% = 3
	Lives% = 1
	MapItems% = 0
	H = 1
	V = 2
	W = 59
	R = 20
	MaxItems% = 100
	KeyPad$ = "123456789"
	KeyBoard$ = "nm,hjkyui"
	NewLifeLevel% = 100
	GameOver$[0] = " L O S T   O N E   L I F E"
	GameOver$[1] = "    G A M E    O V E R    "
	Man$ = "@"
	Item$[EMPTY] = " "
	Item$[THE_MAN] = Man$
	Item$[A_ROBOT] = "R"
	Item$[RUBBLE] = "#"
	Dead = FALSE
	DIM Map%[W,R], X%[MaxItems%], Y%[MaxItems%]
	X[1] = -1 : X[2] = 0 : X[3] = 1
	X[4] = -1 : X[5] = 0 : X[6] = 1
	X[7] = -1 : X[8] = 0 : X[9] = 1
	Y[1] = 1  : Y[2] = 1 : Y[3] = 1
	Y[4] = 0  : Y[5] = 0 : Y[6] = 0
	Y[7] = -1 : Y[8] = -1 :Y[9] = -1
RETURN
	
NewLevel:
	Level% = Level% + (Level% < 99)
	MapItems% = MapItems% + 5 * (MapItems% < MaxItems%)
	RobotCount% = MapItems%
	FOR I = 1 TO MapItems%
		& REPT
			X = RND (1) * W
			Y = RND (1) * R
		& UNTIL(NOT Map%[X,Y])
		Map%[X,Y] = A_ROBOT
		X%[I] = X
		Y%[I] = Y
	NEXT
	GOSUB FindSafeSpot
	GOSUB DrawMapItems
	& REPT
		& CLEAR
		& FN 5, I
	& UNTIL (PEEK(_KBD) < 128 AND I < 128)
	
UpdateStats:	& IOCTL (ioGotoXY, 72, 7) : PRINT Level%;
UpdateBombs:	& IOCTL (ioGotoXY, 72, 5) : PRINT Bombs%" ";
UpdateLives:	& IOCTL (ioGotoXY, 72, 6) : PRINT Lives%" ";
UpdateScore:	& IOCTL (ioGotoXY, 72, 4) : PRINT Score%" ";
		OldScore% = Score%
RETURN

' ==============================
' New Score Calculations
' ==============================

NewScore:
	IF Score% >= NewLifeLevel% AND OldScore% < NewLifeLevel% THEN
		Lives% = Lives% + 1
		NewLifeLevel% = NewLifeLevel% + Level% * 100
		GOTO UpdateLives
	ENDIF
	GOTO UpdateScore


' ==============================
' Map Routines
' ==============================

EraseMap:
	FOR I = 0 TO MapItems%
		IF Map%[X%[I],Y%[I]] THEN
			Map%[X%[I],Y%[I]] = EMPTY
			& IOCTL (ioGotoXY, X%[I] + H, Y%[I] + V)
			PRINT " ";
		ENDIF
	NEXT
RETURN

EraseMapItems:
	FOR I = 0 TO MapItems%
		& IOCTL (ioGotoXY, X%[I] + H, Y%[I] + V)
		PRINT " ";
	NEXT
RETURN

DrawMapItems:
	FOR I = 1 TO MapItems%
		& IOCTL (ioGotoXY, X%[I] + H, Y%[I] + V)
		PRINT Item$[Map%[X%[I],Y%[I]]];
	NEXT
	GOSUB ShowMan
RETURN

' ==============================
' Play The Game!
' ==============================

PlayIt:
	& IOCTL (ioGotoXY, 76, 14)
	& GET (1)," ^H",A$
	& LCASE(A$)
	& POS (KeyPad$,A$), K
	IF NOT K THEN & POS (KeyBoard$,A$),K
	IF K THEN
		GOSUB Move
	ELSE
		& POS ("qtzg",A$),K
		IF K THEN ON K GOSUB QuitGame, TelePort, ZapBomb, GameInfo
	ENDIF

	IF Dead THEN
		& IOCTL (ioGotoXY, X%[0] + H, Y%[0] + V)
		PRINT "X";
		& IOCTL (10)
		Lives% = Lives% - 1
		GOSUB UpdateStats
		& IOCTL (ioGotoXY, 18, 11)
		& IOCTL (ioInverse)
		PRINT GameOver$[NOT Lives%];
		& IOCTL (ioNormal)
		GET A$
		IF NOT Lives% THEN RETURN

		& IOCTL (ioGotoXY, 18, 11)
		FOR I = 18 TO 44
			PRINT Item$[Map%[I-H,11-V]);
		NEXT
		Dead = FALSE
		GOSUB TelePort
	ENDIF

	IF NOT RobotCount% THEN
		GOSUB EraseMap
		GOSUB NewLevel
		& CLEAR
	ENDIF

	GOTO PlayIt


' ==============================
' Quit Game
' ==============================

QuitGame:
	& IOCTL (ioGotoXY, 65, 14)
	PRINT "Quit Game?  ^H";
	GET A$
	& LCASE(A$)
	IF A$ = "y" THEN
		POP
	ELSE
		GOSUB YourMove
	ENDIF
RETURN

EraseMan:
	& IOCTL (ioGotoXY, X%[0] + H, Y%[0] + V)
	PRINT " ";
	Map%[X%[0],Y%[0]] = EMPTY
RETURN


TelePort:
	GOSUB EraseMan
	GOSUB FindSafeSpot
	OutLine$ = "+"
	GOSUB OutLineMan
	GOSUB ShowMan
	GOSUB UnOutLineMan
	GOTO MoveRobots

FindSafeSpot:
	& REPT
		X = RND (1) * W
		Y = RND (1) * R
	& UNTIL(NOT Map%[X,Y])
	X%[0] = X
	Y%[0] = Y
	Map%[X,Y] = THE_MAN
RETURN
	
ShowMan:
	& IOCTL (ioGotoXY,X%[0] + H,Y%[0] + V)
	& IOCTL (ioInverse)
	PRINT Man$;
	& IOCTL (ioNormal)
RETURN

' ==============================
' Move Man
' ==============================

Move:
	IF K = 5 THEN GOTO MoveRobots

	X = X%[0] + X[K]
	Y = Y%[0] + Y[K]
	IF X < 0 OR Y < 0 OR X > W OR Y > R THEN
		& IOCTL (ioBeep)
		RETURN
	ENDIF

	IF Map%[X,Y] = RUBBLE THEN
		& IOCTL (ioBeep)
		Score% = Score% - 1
		GOTO UpdateScore
	ENDIF

	GOSUB EraseMan
	X%[0] = X
	Y%[0] = Y
	IF Map%[X,Y] = A_ROBOT THEN
		Dead = TRUE
		Map%[X,Y] = RUBBLE
		RobotCount% = RobotCount% - 1
		RETURN
	ELSE
		Map%[X,Y] = THE_MAN
	ENDIF

	GOSUB ShowMan
'
' Fall into MoveRobots
'
' ==============================
' Move Robots
' ==============================

MoveRobots:
	X = X%[0]
	Y = Y%[0]
	FOR I = 1 TO MapItems%
		IF Map%[X%[I],Y%[I]] <> RUBBLE THEN
			N = X%[I] + (X%[I] < X) - (X%[I] > X)
			P = Y%[I] + (Y%[I] < Y) - (Y%[I] > Y)
			Map%[X%[I],Y%[I]) = EMPTY
			& IOCTL (ioGotoXY, X%[I] + H, Y%[I] + V)
			PRINT " ";
			X%[I] = N
			Y%[I] = P
			IF Map%[N,P] = THE_MAN THEN
				Dead = TRUE
				I = MapItems%
				Map%[N,P] = RUBBLE
			ENDIF

			IF Map%[N,P] = RUBBLE THEN
				RobotCount% = RobotCount% - 1
				Score% = Score% + 1
			ELSE
				IF Map%[N,P] = A_ROBOT THEN
					RobotCount% = RobotCount% - 2
					Map%[N,P] = RUBBLE
					Score% = Score% + 2
				ELSE
					Map%[N,P] = A_ROBOT
				ENDIF

				& IOCTL (ioGotoXY, N + H,P + V)
				PRINT Item$[Map%[N,P]];
			ENDIF
		ENDIF
	NEXT
	IF OldScore% < Score% THEN GOTO NewScore
RETURN


' ==============================
' Drop A Zap Bomb
' ==============================

ZapBomb:
	IF Bombs% THEN
		Bombs% = Bombs% - 1
		OutLine$ = "*"
		GOSUB OutLineMan
		GOSUB UnOutLineMan
	ELSE
		& IOCTL (ioBeep)
	ENDIF

	GOSUB UpdateBombs
	GOTO MoveRobots

OutLineMan:
	FOR K = 1 TO 9
		IF K <> 5 THEN
			X = X%[0] + X[K]
			Y = Y%[0] + Y[K]
			IF X >= 0 AND Y >= 0 AND X <= W AND Y <= R THEN
				& IOCTL (ioGotoXY, X + H, Y + V)
				PRINT OutLine$;
				IF OutLine$ = "*" AND Map%[X,Y] = A_ROBOT THEN
					Map%[X,Y] = RUBBLE
					RobotCount% = RobotCount% - 1
					Score% = Score% + 1
				ENDIF
			ENDIF
		ENDIF
	NEXT
RETURN

UnOutLineMan:
	FOR K = 1 TO 9
		IF K <> 5 THEN
			X = X%[0] + X[K]
			Y = Y%[0] + Y[K]
			IF X >= 0 AND Y >= 0 AND X <= W AND Y <= R THEN
				& IOCTL (ioGotoXY, X + H, Y + V)
				PRINT Item$[Map%[X,Y]];
			ENDIF
		ENDIF
	NEXT
RETURN

' ==============================
' Game Information
' ==============================

GameInfo:
	GOSUB EraseMapItems
	I = V
	RESTORE
	& REPT
		READ A$
		IF A$ <> "." THEN
			& IOCTL (ioGotoXY, H + 3, I)
			PRINT A$
		ENDIF
		I = I + 1
	& UNTIL (A$ = ".")
	
	& IOCTL (ioGotoXY, H + 3, I)
	PRINT "Press A Key ";
	GET A$
	GOSUB DrawScreen
	GOSUB DrawMapItems	
RETURN

DATA "    G  A  M  E      I  N  F  O  R  M  A  T  I  O  N"
DATA ""
DATA ""
DATA "			@ ... You"
DATA ""
DATA "			R ... Robot"
DATA ""
DATA "			# ... Dead Robots"
DATA ""
DATA "Move around the grid in such a way as to cause the"
DATA "robots to crash into one another; avoid being caught."
DATA "When all the robots have crashed, you go onto the"
DATA "next level.  Each new level adds five more robots."
DATA ""
DATA "As you move around, the robots get closer in an"
DATA "attempt to catch you, so avoid moving next to one."
DATA "If you're in a tight spot, you can risk Teleporting"
DATA "to a new location.  If things get really bad, you"
DATA "can zap the robots adjacent to you with a Zap bomb."
DATA "."

#include <proline/proline.lib>
