' **********************************************************************
' **
' **	cyber.b		Adapted from Planet of the Robots
' **			Originally by Daniel Tobias, November 1981
' **
' **  When    Who Ver	What
' **  ------- --- ----- ------------------------------------------------
' **  06oct93 mwd 1.0	Converted to MD-BASIC, ProLine rewrite
' **

#define	IDENT_PROG "cyber"
#define	IDENT_VERS "1.0"
#define	IDENT_DATE "6oct93"
#define	IDENT_NAME "Morgan_Davis"

#define	SAVE_VERSION	"1.0"

#include <proline/proline.h>
#include <BASIC.h>
#include <ProDOS.h>

#define	CYBER_DATA	"cyber.data"
#define	CYBER_SAVE	"cyber.save"

#define	MAX_DESC_LINES	24

#define	MAX_HERNIA	150	' Heaviest weight we can carry
#define	MAX_HUNGER	100	' When we get hungry
#define	MAX_STARVED	130	' When we die from hunger

#define	NOT_SEEN	0
#define	TAKEN		-1
#define	LOST		-2

#define	STANDARD_BOT	1	' (15)
#define	SECURITY_BOT	2	' (16)
#define	KILLER_BOT	3	' (17)

#define	CLOSET_ROOM	29

#define	ishere(x)	(loc[x] = TAKEN or loc[x] = here)


	gosub AppInit

	& pos right$ (AppPath$, "/"), p
	GamesLib$ = left$(AppPath$, p) + "lib/"

	gosub Splash
	quitting = FALSE

	repeat
		if lastRec% <> here then
			gosub LoadRoom
			gosub showRoom
		endif
		repeat
			gosub getInput
			if not verb then 
				print "Huh?  (Type 'help' for commands)"
			endif
		until verb

		on verb gosub doMove, doGet, doDrop, doLook, doInventory, \
			doSave, doWeigh, doExamine, doShoot,doBuy, \
			doCall, doPlay, doEat, doBreak, doAttack, doOpen,\
			doHelp, doOn, doQuit, doRestore, doScore
		turns% = turns% + 1
	until quitting

EndGame:
	print "^MCyber World ends.  Your final score:^M"
	gosub doScore
goto Exit

doScore:
	print "Turns:", turns%
	print "Money:",
	if money > 0 then
		print "$" money
	else
		print "$0"
	endif
	print "Health:",
	if (turns% - hunger%) < MAX_HUNGER then
		print "OK"
	else
		print "Weak"
	endif
return

doQuit:
	& read (1), "Do you really want to quit? (Y/N) ", i$
	quitting = i$ = "Y" or i$ = "y"
return


getInput:
	verb = 0
	object = 0
	print
	repeat
		& read "> ",i$
		& spc(i$), i$
	until i$ > ""
	print

getInput2:
	& lcase(i$)
	a = 0
	repeat
		c = a + 1
		& pos (c, i$ + " ", " "), a
		wd$ = mid$(i$, c, a - c)
		x = 0
		for b = 1 to nw
			if wd$[b] = wd$ then
				verb$ = wd$
				verb = w%[b, 0]
				object = w%[b, 1]
				object$ = "NONE"
				b = nw
				x = 1
			endif
		next
		if not x then gosub parseObject
	until a > len (i$)
return 

parseObject:
	object$ = wd$
	for q = 1 to gameItems%
		if loc[q] then
			if ishere(q) then
				a$ = item$[q]
				& lcase(a$)
				& pos (";"+a$+";", ";"+wd$+";"), p
				if p then
					object = q
					q = gameItems%
				endif
			endif
		endif
	next
return



LoadRoom:
	filePos = dbpos[here]
	gosub fseek

	& get room$
	& pos (room$, ">"), p
	room$ = mid$(room$, p + 1)

	& get exits$

	descLines% = 0
	robot% = 0
	repeat
		& get i$
		if i$ <> "." then
			if mid$(i$, 1, 1) = "-" then
				gosub parseItem
			else
				descLines% = descLines% + 1
				ld$[descLines%] = i$
			endif
		endif
	until i$ = "."
	
	fFre
	lastRec% = here
return


parseItem:
	& pos (i$, "="), p
	item$ = mid$(i$, 2, p - 2)
	iref% = val(mid$(i$, p + 1))
	isRobot% = iref% < 0
	if isRobot% then
		iref% = abs(iref%)
		if loc[iref%] >= NOT_SEEN then
			robot% = TRUE
			loc[iref%] = NOT_SEEN
			robotRef% = iref%
		endif
	endif
	if loc[iref%] = NOT_SEEN then
		loc[iref%] = here
		& pos (p + 2, i$, ";"), a
		& pos (p + 2, i$, ","), p
		if a then item$ = item$ + mid$(i$, a, p - a)
		item$[iref%] = item$
		iw[iref%] = val(mid$(i$, p + 1))
		& pos (p + 2, i$, ","), p
		q = val(mid$(i$, p + 1))
		if isRobot% then
			robot% = q
			q = -1
		endif
		price[iref%] = q
		& pos (p + 2, i$, ","), p
		idesc$[iref%] = mid$(i$, p + 1)
	endif
return


doLook:
	if object$ <> "NONE" then goto doExamine

showRoom:
	print room$
	if descLines% then
		for a = 1 to descLines%
			print ld$[a]
		next
	endif

	if here = 28 then
		if not jailOpen% then
			print "The ancient cell door is barred and locked."
		else
			& pos (exits$, "O"), p
			if not p then exits$ = exits$ + " O=27"
			print "The bars are broken leaving a path out."
		endif
	endif

	if (turns% - hunger%) >  MAX_STARVED then
		print "You finally starved to death."
		goto EndGame
	endif
	if (turns% - hunger%) >= MAX_HUNGER then print "You are hungry."

	i$ = "Contents:"
	itemSelector% = here
	gosub showContents

	if exits$ > "" then
		print "Obvious exits:^M    ";
		p = 0
		repeat
			& pos (p + 1, exits$, "="), p
			if p then
				i$ = mid$(exits$, p - 1, 1)
				& pos (directions$, i$), a
				print dn$[a] "  ";
			endif
		until not p
		print
	endif
return


showContents:
	x = 0
	for a = 1 to gameItems%
		if loc[a] = itemSelector% then
			if not x then
				print i$
				x = TRUE
			endif
			& pos(item$[a], ";"), p
			if not p then p = 255
			print "    " left$(item$[a], p - 1);
			if price[a] > 0 then print " (price: $" price[a] ")";
			print
		endif
	next
return


doMove:
	if not object then
		print "Where?"
		return 
	endif
	if verb$ = "break" then goto doBreak
	& pos (exits$, mid$(directions$, object, 1) + "="), p
	if not p then
		print "You can't go that way."
		return
	endif
	x = val(mid$(exits$, p + 2))
	idRequired% = x < 0
	x = abs(x)
	if x < 1 or x > gameRooms% then 
		print "% Error in exits for room #" here
		goto EndGame
	endif
	if robot% = KILLER_BOT then
		i = 23
		gosub showLongText
		goto EndGame
	endif
	if x = 6 then
		if loc[7] <> TAKEN then 
			print "ROBOT: Excuse me, we have a dress code here.";
			return
		endif
		if money < 80 then 
			print "ROBOT: Sorry, but a net-worth scan shows you to be a credit risk."
			return
		endif
	endif
	if robot% and idRequired% then
		print "ROBOT: ";
		if loc[12] = TAKEN then 
			print "I.D. accepted.  Good day, Mr. Smith.^M"
		else
			print "You cannot pass without an I.D. card."
			return
		endif
	endif

	if here = 39 and x = 39 and rnd (1) < .35 then 
		pl = 1 - pl
		x = 35
		if not pl then x = 40
	endif
	if x = 17 then
		if not ishere(22) then
			print "ROBOT: The information booth is broken.  If you can't help, go away!"
			return
		endif
	endif
	if here = 36 and x = 37 then 
		& read "Enter combination: ",a$
		if val(a$) < > cm% then 
			print "Incorrect."
			return 
		endif
		print
	endif
	if x = 38 then goto timeMachine
	if x = 39 then lastRec% = 0
	here = x
return 

mustObject:
	if object$ = "NONE" then
		if verb$ = "on" or verb$ = "off" then verb$ = "turn " + verb$
		print "Tell me what you want to " verb$ "."
		pop
	else
		if not ishere(object) then 
			print "I don't see any " object$ " here."
			pop
		endif
	endif
return


doGet:
	gosub mustObject
	if loc[object] = TAKEN then 
		print "You're already carrying it!"
		return 
	endif
	if price[object] > 0
		if robot% then print "ROBOT: Hey!!!  ";
		print "You can't take that without paying for it!"
		return 
	endif
	if iw[object] < 0 then 
		print "It is securely fastened."
		return 
	endif
	if iw[object] > MAX_HERNIA then 
		print "Too heavy for you to lift."
		return 
	endif
	if burden + iw[object] > MAX_HERNIA then 
		print "Too heavy.  You must drop something first."
		return 
	endif
	loc[object] = TAKEN
	burden = burden + iw[object]
	print "Taken."
	if object = 10 then money = abs(money)
return 


doDrop:
	gosub mustObject
	if loc[object] <> TAKEN then 
		print "You are not carrying that."
		return 
	endif
	loc[object] = here
	burden = burden - iw[object]
	print "Dropped."
	if robot% = KILLER_BOT then
		print "The robot takes your " object$ "."
		loc[object] = CLOSET_ROOM
	endif
	if here = 39 then 
		print "It slides into a sandy crevice and is lost forever."
		loc[object] = LOST
	endif
		
	if object = 10 then money = -abs(money)
return 


doInventory:
	i$ = "You are carrying:"
	itemSelector% = TAKEN
	gosub showContents
	if money > 0 then
		if not x then print i$
		print "    $" money " in cash"
	endif
	if money < 1 and not x then print "You're empty handed."
return 

	
doWeigh:
	if not ishere(2) or object = 2 then
		print "You need a scale to weigh that."
		return 
	endif
	gosub mustObject
	print "The scale reads: " iw[object] " pounds"
return 


doExamine:
	gosub mustObject
	i$ = idesc$[object]
	if i$ = "" then
		print "You see nothing unusual about it."
	else
		i = val(i$)
		if i then
			gosub showLongText
			if object = 13 then
				print "	The password to the file is '" pw$[pw%] "'.  The lab is room #" rm% "."
			endif
		else
			print
			print i$
		endif
	endif
return 


fseek:
	fRead GamesLib$ CYBER_DATA
	i% = filePos / 65536
	&poke _SREFNUM, dbRefNum, \
			filePos - int(filePos / 256) * 256, \
			int(filePos - i% * 65536) / 256, i%
	&MLI (_SET_MARK, _SSETMRK), errCode
return


showLongText:
	filePos = longpos[i]
	gosub fseek
	repeat
		& get i$
		a = i$ = "."
		if not a then print i$
	until a
	fFre
return


trial_jail:
	i = 6
	gosub showLongText
	print "JUDGE: You are charged with ";
	if ch = 1 then 
		print "assault";
	else
		print "theft";
	endif
	print ".  How do you plead?"
	print 
	& read "DEFENDANT: ",i$
	& lcase(i$)
	print 
	if mid$(i$,1,6) = "guilty" then goto _2310_
	print "JUDGE: The district attorney will now present his case.^M"
	print "D.A.: Your Honor, I call upon the ";
	if robot% = STANDARD_BOT then
		print "clerk";
	else
		print "guard";
	endif
	print " robot, serial #" int ( rnd (1) * 999999)", to testify.^M"
	if ch < > 1 then goto _2130_
	print "ROBOT: This human assaulted me with a ";
	if loc(9) = TAKEN then
		print "blaster."
	else
		print "knife."
	endif
	gosub WhenDidThisHappen
goto _2220_


WhenDidThisHappen:
	print "^MD.A.: When did this happen?^M"
	print "ROBOT: Just "; int ( rnd (1) * 29)" minutes, " rnd (1) * 59 \
		" seconds ago.^M"
	print "D.A.: I rest my case.^M"
return


_2130_:
	' THEFT OF SERVICES
	i = 7
	gosub showLongText
	gosub WhenDidThisHappen

_2220_:
	' YOUR REPLY
	print "JUDGE: What does the defendant have to say?^M"
	& read "DEFENDANT: ",i$
	print "^MJUDGE: The jury will now reach a verdict."
	& wait 5
	i = 8
	gosub showLongText

_2310_:
	' SENTENCING
	if ch = 1 then 
		i = 9
	else
		i = 10
	endif
	gosub showLongText
	if ch = 1 then goto EndGame
	here = 28
	for a = 1 to gameItems%
		if loc[a] = TAKEN then loc[a] = CLOSET_ROOM	' Closet
		money = -abs(money)
	next
return 


doShoot:
	if loc[9] < > TAKEN then 
		print "With what?"
		return 
	endif
	gosub mustObject
	if not robot% then 
		print "The robot-seeking blaster clicks without any effect."
		return 
	endif
	if object <> robotRef% then
		print "The robot thinks you're attacking it!"
		ch = 1
		goto trial_jail
	endif
	if robot% < > KILLER_BOT then 
		print "The robot's force field repels the ray."
		ch = 1
		goto trial_jail
	endif
	i = 11
	gosub showLongText
	loc[robotRef%] = LOST
	robot% = 0
return 


doBuy:
	gosub mustObject
	if loc[object] = TAKEN then 
		print "You already own that!"
		return 
	endif
	if price[object] < 0 then
		print "It's not for sale!"
		return
	endif
	if not price[object] then
		print "No price tag.  What a bargain!"
		goto doGet
	endif
	p = price[object]
	if p > money then 
		print "You don't have enough money."
		return 
	endif
	money = money - p
	price[object] = 0
goto doGet

' doOff:
doOn:
	gosub mustObject
	if (object <> 4 and object <> 24) or verb$ = "off" then
		print "You can't turn that " verb$ "."
		return 
	endif
doOn2:
	if object = 24 then
		i = 21
	else
		i = 12
	endif
	gosub showLongText
	if object = 24 then return
	do
		print
		repeat
			& read "]",i$
			& spc(i$), i$
		until i$ > ""
		& lcase(i$)
		if i$ = "off" then
			print "^MYou flip the power switch off and the computer shuts down.^M"
			goto showRoom
		endif
		if i$ = "ftp" then
			gosub _2740_
		else
			if i$ = "help" then
				print
				gosub doHelp
			else
				i = int ( rnd (1) * 5) + 1
				& pos (errors$, str$(i)), p
				& pos (p, errors$, ";"), a
				print "?" mid$(errors$, p + 1, a - p - 1) " ERROR^G"
			endif
		endif
	loop


_2740_:
	' MODEM
	print 
	&read "Enter server name: ",i$
	& lcase(i$)
	& wait 3
	if i$ < > "gov" then
		print "Connection failed; link to " i$ " timed out."
		return
	endif
	i = 13
	gosub showLongText
	& read "File name: ",i$
	& lcase(i$)
	if i$ = "pop" then 
		i = 4
		gosub showLongText
	else
		if i$ = "chronos" then
			& read "Enter password: ",i$
			& wait 3
			if i$ < > pw$[pw%] then
				print "Access denied."
			else
				print "The combination is " cm%
			endif
		else
			print "File not found."
		endif
	endif
	print "^MConnection closed by foriegn host."
return


orderFood:
	i = 5
	gosub showLongText

	repeat
		print 
		& read "Your order (1-3): ",i$
		if i$ = "" then return
		
	until i$ > "0" and i$ < "4"
	print "^MYou are served and find it delicious.^M"
	print "ROBOT: Here is your check.^M"
	& wait 3
	print "A sinking feeling overwhelms you.  You do not have enough money!"
	hunger% = turns%
	ch = 0
goto trial_jail


doCall:
	if not robot% then 
		print "You're talking to yourself."
		return 
	endif
	if here = 36 then goto _3460_
	if robot% < > STANDARD_BOT then goto _3350_
	if here = 6 then goto orderFood
	if here = 34 then goto _3410_
	if here = 3 then 
		print "ROBOT: Would you like to try this computer?"
		& read (1), "YOU: ", i$
		if i$ = "y" or i$ = "Y" then
			object = 4
			goto doOn2
		endif
		return
	endif
	print "ROBOT: How can I help you?"

	repeat
		& read "YOU: ",i$
		& spc(i$), i$
	until i$ > ""
	gosub getInput2
	if verb = 10 then goto doBuy
	if object = 4 and here = 3 then goto doOn
	print "ROBOT: I am not programmed to answer queries of this type."
return 


_3350_:
	' GUARD AND BERZERK ROBOTS
	if robot% = KILLER_BOT then 
		i = 14
		gosub showLongText
		goto EndGame
	endif
	print "ROBOT: Yes?"
	&read "YOU: "
	print "ROBOT: Tell that to the judge!"
return 


_3410_:
	' UNIVERSITY
	print "ROBOT: What room number do you need?"
	& read "YOU: ", i$
	if val (i$) < > rm% then 
		print "ROBOT: Sorry, that room is not available now."
		return 
	endif
	i = 15
	gosub showLongText
	here = 36
return 


_3460_:
	' HALL
	& read (1),"ROBOT: Do you want to go back to the lobby? ", i$
	if i$ = "y" or i$ = "Y" then here = 34
return 


doPlay:
	print 
	if money < 2.5 then 
		print "You can't afford to play games."
		return 
	endif
	money = money - 2.5
	i = 16
	gosub showLongText	
	& wait 3
	if not int(rnd(1) * 2) then
		print "You win the game!  You get $5 back!"
		money = money + 5
	else
		print "You lost.  Try your luck again?"
	endif
return 


timeMachine:
	print "You are in the time machine!  Now set the controls.^M"
	& read "Year: ",i$
	y = val(i$)
	& read "Month: ",i$
	& read "Day: ",i$
	print "^MThe machine whirs...";
	& wait 4
	print "you have arrived!"
	if y > = 1970 and y < 2000 then 
		print "Back in the 20th century at last!  You win!"
	endif
	if y < 1970 and y > = 1900 then 
		print "You made it to the 20th century, but you'll have to wait"
		print "a while for the modern computer age."
		if y < 1939 then 
			print "P.S.: Buy Action Comics #1 for 10 cents when it comes out."
		endif
	endif
	if y < 1900 or y > 1999 then 
		print "You end up in the year " y "."
		print "Sadly for you, the time machine is out of power.  You're stuck here."
	endif
goto EndGame


doEat:
	gosub mustObject
	if here = 6 then goto orderFood
	if iw(object) > 2 then 
		print "Don't be ridiculous."
		return 
	endif
	if object = 3 then 
		print "Mmm, mmm good!"
		hunger% = turns%
	else
		speed 30
		print "CHOMP! CHOMP! CHOMP!"
		speed 255
		print "It could have used a little salt."
		if (turns% - hunger%) => MAX_HUNGER then print "You're still hungry, however."
	endif
	loc[object] = LOST
	if object = 10 then money = 0
return 

doBreak:
	if here < > 28 then 
		print "You're not confined here."
		return 
	endif
	print "The rusty, weakened bars give way and there is an opening out."
	jailOpen% = 1
return 

doAttack:
	' ATTACK
	if loc(9) <> TAKEN then goto doShoot
	if not robot% then 
		print "Nothing to attack."
		return 
	endif
	if loc(1) < > TAKEN then 
		print "With your bare hands?  You regain your sanity."
		return 
	endif
	print "The knife shatters against the robot's tough side."
	if robot% = KILL_BOT then 
		print "The robot kills you."
		goto EndGame
	endif
	loc[1] = LOST
	ch = 1
goto trial_jail


doOpen:
	print "The doors open and close automatically.  There is no need to"
	print "open or close them."
return 


doHelp:
	print "Commands:^M"
	for i = 1 to nw
		print wd$[i];
		x = mod(i, 5)
		if x then
			print,
		else
			print
		endif
	next
	if x then print
return 


' ====================
  Splash:
' ====================
	
	& ioctl(ioClearScreen)
	dataFile$ = GamesLib$ + CYBER_DATA
	fOpen dataFile$
	dbRefNum = peek(_OREFNUM)

	displayFlag% = TRUE
	gosub DisplayToEnd
	
	print	"^M^ICyber World " IDENT_VERS \
		" by Morgan Davis and Daniel Tobias^M^M" \
		"^IInstructions? (Y/N) ";
	get i$
	displayFlag% = i$ = "Y" or i$ = "y"
	& ioctl(ioClearScreen)
	gosub DisplayToEnd
	if displayFlag% then
		print
		& read (0), "^IPress RETURN to begin "
		& ioctl(ioClearScreen)
	endif

	print "Now materializing in cyberspace.";

	fRead dataFile$
	gosub getDatum			' Get data version
	dataVersion$ = i$
	
	gosub getDatum			' Get directions
	directions$ = i$
	i = len(i$)
	dim dn$[i]
	for a = 1 to i
		& get dn$[a]
	next

	gosub getDatum			' Get locations
	gameRooms% = val(i$)
	dim dbpos[gameRooms%]
	input gameItems%		' get item count
	i = gameRooms%
	q = TRUE
	gosub getTextMarks

	gosub getDatum			' Get passwords
	np = val(i$)
	dim pw$[np]
	for a = 1 to np
		& get pw$[a]
	next

	gosub getDatum			' Get verbs
	nw = val(i$)
	dim wd$[nw], w%[nw, 1]
	for a = 1 to nw
		input wd$[a], w%[a,0], w%[a,1]
	next

	gosub getDatum			' Get long descriptions
	i = val(i$)
	dim longpos[i]
	q = FALSE
	gosub getTextMarks
	
	fFre
	print "...you have arrived!^M"
	
	dim ld$[MAX_DESC_LINES]
	dim item$[gameItems%], loc[gameItems%], iw[gameItems%],\
		price[gameItems%], idesc$[gameItems%]
	lastRec% = -1

	errors$ = "1SYNTAX;2IMPROPER DELIMITER;3UNBALANCED COORDINATE;"\
		"4UNFORMATTED REFERENCE;5UNINDEXABLE ADDRESS;"

	here		= 1
	turns%		= 1
	hunger% 	= 0
	burden	 	= 0
	money		= -119
	jailOpen%	= 0

	pw% = rnd(1) * np + 1
	cm% = rnd(1) * 9999
	rm% = rnd(1) * 900 + 100

	& time(i$)
	x = rnd(-(val(mid$(i$,19)) * 60 + val(right$(i$,2)))) + rnd(-rnd(9))
return


DisplayToEnd:
	fRead dataFile$
	repeat
		& get a$
		if displayFlag% and a$ <> "." then & print a$
	until a$ = "."
	fFre
return


getDatum:
	print ".";
	repeat
		& get i$
	until mid$(i$, 1, 1) <> "#"
return


getTextMarks:
	poke _SREFNUM, dbRefNum
	for a = 1 to i
		&MLI (_GET_MARK, _SGETMRK), errCode
		filePos = peek24(_SMARK)
		if q then
			dbpos[a] = filePos
		else
			longpos[a] = filePos
		endif
		repeat
			& get i$
		until i$ = "."
	next
return

doSave:
	print "Saving...";
	i$ = ADM_PATH + ID$[uName] + "/" + CYBER_SAVE
	& getinfo i$, a$
	if a$ > "" then fDelete i$
	fAppend i$
	print SAVE_VERSION
	print dataVersion$
	print here "," turns% "," hunger% "," burden "," money "," jailOpen%
	print pw% "," cm% "," rm% "," robot% "," robotRef%
	for a = 1 to gameItems%
		if loc[a] then
			print a
			print item$[a]
			print loc[a] "," iw[a] "," price[a]
			print idesc$[a]
		endif
	next
	print 0
	fClose i$
	print "done"
return 

doRestore:
	i$ = ADM_PATH + ID$[uName] + "/" + CYBER_SAVE
	& getinfo i$, a$
	if a$ = "" then
		print "No game saved."
		return
	endif
	print "Restoring...";
	fOpen i$
	fRead i$
	& get a$
	& get verb$
	if a$ <> SAVE_VERSION or verb$ <> dataVersion$ then
		print "failed."
		print "Settings are incompatible with this version."
		fClose i$
		return
	endif
	input here, turns%, hunger%, burden, money, jailOpen%
	input pw%, cm%, rm%, robot%, robotRef%
	repeat
		input a
		if a then
			& get item$[a]
			input loc[a], iw[a], price[a]
			& get idesc$[a]
		endif
	until not a
	fClose i$
	print "done^M"
	lastRec% = -1
return 


#include <proline/proline.lib>
