' **********************************************************************
' ***
' ***	Startup.b	ProLine Startup program
' ***			(C)opyright 1994 Morgan Davis Group
' ***

#define	VERSION	"3.0"
#define	VERSTR	"ProLine Installer " VERSION
#define	COPR	"(C)opyright 1994 Morgan Davis Group, All Rights Reserved"

#define	IDENT_PROG "startup"
#define	IDENT_VERS VERSION
#define	IDENT_DATE "30mar94"
#define	IDENT_NAME "Morgan_Davis"

#include <proline/proline.h>
#include <appleio.h>
#include <romcall.h>
#include <basic.h>
#include <ctype.h>
#include <errors.h>

#define	INSTALL		"Install/"
#define	NOTES_FILE	"Install/Read.Me.First"
#define	SETUP_PROG	"Setup"
#define	CONFIG_PROG	"Configure"
#define	QUIT_PROG	"Launcher"
#define	CONFIG_DATA	"Install/Config.Data"
#define	OMM_LOADER	"sys/OMM.Loader"
#define	MODULES		"sys/modules"
#define	BOOTSTRAP	"ProLine"
#define	STARTUP_RSRC	"etc/rsrc/startup.rsrc"

	onerr goto HandleError
	
	if peek(-1101) <> 6 then
		print "APPLE IIE OR NEWER REQUIRED."
		end
	endif

	poke _WNDTOP, 0
	vtab 3
	gosub GetAppPrefix
	onerr goto pfxerror

	if peek(_WNDWID) < 80 then fOutport 3

	fVerify AppPrefix$
	goto pfxgood

pfxerror:
	fPrefix
	input AppPrefix$

pfxgood:
	onerr goto HandleError
	fPrefix AppPrefix$
	
	onerr goto ommInstall
	poke _INBUF, 0
	& load peek ommInfo, AmperWorks_ID, i$
	if i$ > "" then goto awgood
	& load notrace
	& load fre 0
	
ommInstall:
	onerr goto HandleError
	gosub Splash
awgood:
	onerr goto HandleError
	OneMoment$ = "One moment please..."
	
do
	& pop
	gosub DrawMainScreen
	print "Select a number (1 to 5): ";
	repeat
		get a$
		& pos ("12345^[", a$), p
	until p
	poke _CH80, 0
	call _CLREOL
	print OneMoment$;
	on p gosub readNotes, setup, configure, runPL, quit, quit
loop

getSysDir:
	f$ = CONFIG_DATA
	& getinfo f$, i$
	if i$ > "" then
		fOpen f$
		fRead f$
		& get SysDir$
		fClose
	endif
return

runPL:
	if SysDir$ = "" then gosub getSysDir
	f$ = SysDir$ + "/" STARTUP_RSRC
	& getinfo f$, i$
	if i$ = "" then goto configure

	f$ = SysDir$ + "/" BOOTSTRAP
	& getinfo f$, i$
	if i$ = "" then return
fLaunch f$
	


' ====================
  configure:
' ====================
	a$ = CONFIG_PROG
	goto runProg

' ====================
  setup:
' ====================
	a$ = SETUP_PROG
	goto runProg

' ====================
  quit:
' ====================
	& load notrace
	a$ = QUIT_PROG
runProg:
	fLaunch INSTALL a$


' ====================
  readNotes:
' ====================
	a$ = "IMPORTANT NOTES"
	i$ = "Main Menu"
	gosub NewScreen
	fOpen NOTES_FILE
	fRead NOTES_FILE
	onerr goto notesEOF

	gosub InitMore
	k$ = "More"
	cancelled = FALSE
	repeat
		& get a$
		again:
		print a$;
		call _CLREOL
		print
		lc = lc + 1
		if lc = 20 then
			gosub More
			goto again
		endif
	until cancelled
	error(EOFErr)

	notesEOF:
	onerr goto HandleError
	& onerr
	fClose
	if not cancelled then
		while lc < 20
			call _CLREOL
			print
			lc = lc + 1
		wend
		k$ = "End"
		gosub More
	endif
return


More:
	vtab 24
	inverse
	print "--" k$ "--";
	normal
	wait _KBD,128
	i = peek(_KBD)
	poke _KBDSTRB,0
	poke _CH80,0
	call _CLREOL
	cancelled = i = $9B
InitMore:
	lc = 0
	vtab 3
return
	
' ====================
  DrawMainScreen:
' ====================
	a$ = "MAIN MENU"
	i$ = "Quit"
	gosub NewScreen
	vtab 7
	htab 26 : print "1. Read Important Notes"
	print
	print
	htab 26 : print "2. Install/Upgrade ProLine"
	print
	print
	htab 26 : print "3. Configure ProLine"
	print
	print
	htab 26 : print "4. Run ProLine"
	print
	print
	htab 26 : print "5. Quit"
	vtab 24
return


newScreen:
	home
	print VERSTR;
	htab 40 - len(a$) / 2
	print a$;
	htab 76 - len(i$)
	print "Esc: " i$;
	print chr$(cMTextOn) chr$(cInverse);
	& hlin 80, 88
	vtab 23
	& hlin 80, 89
	print chr$(cMTextOff) chr$(cNormal);
return

' ====================
  HandleError:
' ====================
	call _STKINI
	fClose
	print "^GError #" ERR " at " ERL
end


' ====================	
  GetAppPrefix:
' ====================
'
' This obtains the path to this program so that its
' prefix can be extracted.  Then it can find its files.
'
	AppPath$ = ""
	for I = $281 TO $280 + PEEK($280)
		AppPath$ = AppPath$ + CHR$(PEEK(I))
	next
	if asc(AppPath$) <> 47 then
		fPrefix
		input A$
		AppPath$ = A$ + AppPath$
	endif
	if right$(AppPath$, 1) = "/" then
		AppPath$ = left$(AppPath$, len(AppPath$) - 1)
	endif
	p = len(AppPath$)
	while mid$(AppPath$, p, 1) <> "/"
		p = p - 1
	wend
	AppPrefix$ = mid$(AppPath$, 1, p)
return

Splash:
	text
	speed 255
	normal
	home
	print VERSTR
	print
	print COPR
	vtab 20
	fLaunch OMM_LOADER
	& load get MODULES "/AmperWorks"
	vtab 20
	call _CLREOP
	gosub getSysDir
	if SysDir$ > "" then
		& getinfo SysDir$ + "/etc/rsrc/startup.rsrc", i$
		if i$ > "" then gosub AutoStart
	endif
return

spinit:
	print mid$(spinner$, spin, 1) "^H";
	spin = spin + 1
	if spin > len(spinner$) then spin = 1
return

AutoStart:
	spinner$ = "|/-|/-\"
	spin = 1
	inverse
	print " ProLine Auto-Start Mode "
	normal
	print "^MPress ESC to cancel or RETURN to run ProLine now ";
	for i = 1 to 100
		gosub spinit
		x = peek(_KBD)
		if x > 128 then
			poke _KBDSTRB, 0
			i = 100
			if x = $9B then spin = 0
		else
			for j = 1 to 256 : next
		endif
	next
	htab 1
	vtab 20
	call _CLREOP
	if not spin then return
goto runPL
