'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'	rmtopic.b	Removes topics in a conference  
'			Original program by Daniel Davidson
'			Modifications by Morgan Davis
'
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'
' 1.0 - First version of rmtopic. Worked with cs verisons before 2.0, but
'       was never released.
'
' 1.1 - First release version. Added suport for the new data file format
'       of cs verison 2.0. Introduced new bug in the handling of conferences
'       with multiple networked topics. It striped the network info from
'       all of the topics
'
' 1.1a- Fixed topic striping bug of 1.1
'
' 1.2 - This is the first verison of rmtopic to be converted to to MD-Basic.
'       and as such has a smaller executable than verison 1.1 Also added
'       better handling of user interupts. Before it just ended with out
'       restoring the current prefix. Now it exits more gracfuly, and restores
'       the prefix as it should. At this pont the maual page was also updated.
'
' 1.3 - rmtopic now looks in  $/etc/rsrc/cs.rsrc for the location of the CS
'       instead of looking in $/sys/pcs/cs.dir. Also corrected path creation
'       bug that gave error 16's when used with PL 2.0
'
' 1.4 - Major rework by Morgan Davis to fix a number of problems.
'
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define	IDENT_PROG "rmtopic"
#define	IDENT_VERS "1.4"
#define	IDENT_DATE "11mar93"
#define	IDENT_NAME "Daniel_Davidson_&_Morgan_Davis"

#include <proline/proline.h>

	GOSUB AppInit

	' Check If the user is Root level (ie. Sysop), If not, end the program
	
	IF NOT SuperUser THEN 
		PRINT argv$[0]": can't execute"
		GOTO Exit
	ENDIF
	
	' Diminsion a array of 100 string variables for putting file names in
	' during various parts of the program
	
	DIM Filename_List$[100]
	
	' Check what prefix the conference system is in by reading the
	' ProLine standard CS.DIR file
	
	CS$ = RSRC_PATH + "cs.rsrc"
	fVerify CS$
	fOpen CS$
	fRead CS$
	& GET CS$
	fClose

	IF (RIGHT$(CS$,1) <> "/") THEN CS$ = CS$+"/"
	
	' If there are any shell arguments, goto the argument handler
	
	IF argc > 1 THEN
		GOSUB Arg_Handler
	ELSE
		GOSUB Interactive
	ENDIF	

	& LCASE(CN$)		' For display and matching sensitivity
	& LCASE(TN$)


'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
' This does the actual work of removing the topic from the cs.
' It removes all refrences from the apropriate i.. file, and removes the 
' messages and then teh subdirectory for the topic.
'
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	DIM J[6,3],NA$[6]
	T$ = CS$ + CN$ + "/i.."
	fOpen T$
	fRead T$
	& GET M$
	INPUT R,N
	FOR I = 1 TO N
		& GET NA$[I]
		INPUT J[I,1],J[I,2],J[I,3]
	NEXT 
	fClose

	' If there is only one topic left, refuse to deal with it,
	' and generate and error

	N = N - 1
	IF NOT N THEN
		PRINT argv$[0]": can't remove last topic (use rmconf)"
		GOTO Exit
	ENDIF
	
	& getinfo T$ + "i",I$
	IF I$ > "" THEN fDelete T$ + "i"

	fOpen T$ + "i"
	fWrite T$ + "i"
	PRINT M$
	PRINT R","N
	FOR I = 1 TO N + 1
		IF TN$ + ":" < > LEFT$ (NA$[I] + ":", LEN(TN$) + 1) THEN 
			PRINT NA$[I]
			PRINT J[I,1] "," J[I,2] "," J[I,3]
		ENDIF
	NEXT
	fClose
	fDelete T$
	fRename T$ "i," T$

	PRINT argv$[0]": removing "CN$"/"TN$" ";
	& IOCTL(ioInverse)
	PRINT " Do Not Interrupt ";
	& IOCTL(ioNormal) 
	T$ = CS$ + CN$ + "/" + TN$ + "/"

	REPEAT
		& FILES(T$,Filename_List$), Count, Actual
		IF Count THEN
			FOR I = 1 TO Count
				fDelete T$ Filename_List$(I)
			NEXT 
		ENDIF
	UNTIL Count = Actual
	fDelete T$

	PRINT "...done"
GOTO Exit


Arg_Handler:
	' Make sure only one argument exists, and contains a slash

	& POS (argv$[1],"/"),P
	IF (argc > 2) OR NOT P THEN 
		PRINT "Usage: "argv$[0]" [ conf/topic ]"
		GOTO Exit
	ENDIF

	' Make sure specified conf/topic exists

	CN$ = LEFT$(argv$[1],P - 1)
	TN$ = MID$(argv$[1], P + 1)

	& getinfo CS$ + CN$,I$
	& getinfo CS$ + CN$ + "/" + TN$,T$
	IF I$ = "" OR T$ = "" THEN
		PRINT argv$[0]": "CN$"/"TN$" not found"
		GOTO Exit
	ENDIF
RETURN


Interactive:
	' List the current conferences and prompt the user for the conference to 
	' delete a topic from. If the user does not enter a conference name,
	' then exit the program back to the ProLine Shell.
	
	& IOCTL(ioClearScreen)              ' clear the screen
	
	PRINT "The current conferences are: "
	PRINT
	I$ = CS$ + CN$
	GOSUB List_Names	
	& READ "Remove topic from which conference? ",CN$
	IF CN$ = "" THEN GOTO Exit

	' Verify that the conference requested by the user does in fact exsist
	' If not then tell the user, and end the program.
	
	& getinfo CS$ + CN$,I$
	IF I$ = "" THEN
		PRINT "No such conference."
		GOTO Exit
	ENDIF
	
	' If we've gotten this far, then the conference does exsit
	' Clear the screen, and print a list of topics in the requested conference.
	
	& IOCTL(ioClearScreen)
	PRINT "The topics in "CN$" are: "
	PRINT
	I$ = CS$ + CN$ + "/" + TN$
	GOSUB List_Names
	
	' If there is only one topic left, refuse to deal with it,
	' and generate and error
	
	IF Count = 1 THEN
		PRINT "Can't remove the last topic. Use rmconf."
		GOTO Exit
	ENDIF
	
	' Get the topic name, and if there is not one, end the program
	
	& READ "Name of topic to remove? ",TN$
	IF TN$ = "" THEN GOTO Exit

	' Verifiy that the topic realy exists, and if not inform the user and 
	' Exit the program. 
	
	& getinfo CS$ + CN$ + "/" + TN$,I$
	IF I$ = "" THEN 
		PRINT "No such topic."
		GOTO Exit
	ENDIF
RETURN


List_Names:
	& FILES(I$,Filename_List$,15),Count	' Get the list of files
	& SRT(Filename_List$,Count)		' Sort the List
	FOR I = 1 TO Count
		& LEFT$ (Filename_List$[I],19),Filename_List$(I)           
		& LCASE(Filename_List$[I])
		PRINT Filename_List$[I];
		IF (I / 4) = INT(I / 4) THEN PRINT 
	NEXT
	PRINT
	IF (Count / 4) <> INT(Count / 4) THEN PRINT 
RETURN

#include <proline/proline.lib>

