' ************************************************************************
' **									**
' **  mount.b 		Mount a device on the filesystem		**
' **			(C)opyright 1994 Morgan Davis Group		**
' **									**
' ** When    Who Ver	What						**
' ** ======= === ======	==============================================  **
' ** 26may91 mwd 1.0	Created.					**
' **									**
' ************************************************************************

#define	IDENT_PROG "mount"
#define	IDENT_VERS "1.0"
#define	IDENT_DATE "26may91"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <prodos.h>
#include <proline/proline.h>

#define	NODEV	$BF20

#define	DRV1LST	$BF10
#define	DRV2LST	$BF20

#define	DBFILE	RSRC_PATH + "mount.rsrc"

' ====================
' Mount
' ====================

	gosub AppInit
	if not SuperUser then
		print argv$[0] ": cannot execute"
		goto Exit
	endif

	if argc < 2 then
		print "Usage: " argv$[0] " device..."
		goto Exit
	endif

	deviceDB$ = DBFILE
	
	& getinfo deviceDB$, i$

	if i$ > "" then
		fOpen deviceDB$
		fRead deviceDB$
		for slot = 1 to 7
			input volnam$[slot,1],volnam$[slot,2]
			input id[slot,1],addr[slot,1],id[slot,2],addr[slot,2]
		next
		fClose
	else
		print argv$[0]": mount.rsrc not found"
		goto Exit
	endif		

	noDevAddr = peek16(NODEV)
	for optind = 1 to argc - 1
		a$ = argv$[optind]
		gosub mount
	next
goto Exit

mount:
	if left$(a$,1) = "/" then
		& pos (2,a$,"/"),p
		if p then a$ = left$(a$,p - 1)
		& getinfo a$ + "/foo", i$
		if ERR = 7 then
			print argv$[0]": " a$ " is already online"
			return
		endif
		& lcase(a$)
		volName$ = a$
		slot = 0
		for i = 1 to 7
			for j = 1 to 2
				if volName$ = volnam$[i,j] then
					drive = j
					slot = i
					i = 7
					j = 2
				endif
			next
		next
		if not slot then
			print argv$[0]": " volName$ " not in mount.rsrc"
			return
		endif
	else
		slot = val(left$(a$,1))
		drive = 0
		if len(a$) > 1 then drive = val(right$(a$,1))
	endif

	if slot < 1 or slot > 7 then
		print argv$[0] ": invalid slot #" slot
		return
	endif

	if drive > 2 then
		print argv$[0] ": invalid drive #" drive
		return
	endif

	if not drive then
		drive = 1
		gosub addunit
		drive = 2
	endif
	gosub addunit
return

addunit:
	if not addr[slot,drive] then
		print argv$[0]": no mount info for " slot "." drive
		return
	endif
	if drive = 2 then
		i = DRV2LST
	else
		i = DRV1LST
	endif
	tblAddr = i + slot * 2
	devaddr = peek16(tblAddr)
	if devaddr = noDevAddr then
		poke16(tblAddr, addr[slot,drive])
		devices = peek(_DEVCNT) + 1
		poke _DEVLST + devices, id[slot,drive]
		poke _DEVCNT, devices
	endif
	gosub getVolName
	print argv$[0] ": "volName$ " ("slot "." drive ") mounted"
return

getVolName:
	unit = slot * 16 + (128 * (drive = 2))
	& poke _SUNITNUM, unit, $80, $02
	& MLI (_ONLINE, _SONLINE), errCode
	volName$ = "?"
	if not errCode then
		volName$ = "/"
		& poke $300,$A9,peek($280),$29,$0F,$85,$00,$60
		call $300
		for v = 1 to peek(0)
			volName$ = volName$ + chr$(peek($280 + v))
		next
		& lcase (volName$)
	endif
return

#include <proline/proline.lib>
