' ************************************************************************
' **									**
' **  adduser.b 	Add user (and other) accounts to the system	**
' **			(C)opyright 1994 Morgan Davis Group		**
' **									**
' ** When    Who Ver	What						**
' ** ======= === ======	==============================================  **
' ** 18sep90 mwd 2.0	Converted old adduser to MD-BASIC.		**
' ** 27sep90 mwd 2.1	Fixed bug in handling interpreter argument	**
' ** 17jan91 mwd 2.2	Removed code that assumed first acct is root	**
' ** 21feb92 mwd 2.3	Reads account info from resource file		**
' ** 15mar93 mwd 2.3.1	Added leniency level for foriegn sites		**
' ** 04sep93 mwd 2.4	Asks user if resides in USA if lenient = -1	**
' ** 20mar94 mwd 3.0	IDENT update, copies default cshrc file		**
' ** 14may94 mwd	Gutted lots of code in favor of mkuser script	**
' **									**
' ************************************************************************

#define	IDENT_PROG "adduser"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "14may94"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <prodos.h>
#include <proline/proline.h>

#define	PROGRAM "ProLine Account Registration " IDENT_VERS

	' ====================
	' Constants
	' ====================

#define	MAX_ACCOUNTS	1500
#define	OLDEST_DATE	"Wed, 31 Dec 69 16:00:00"
#define	DEFAULT_INTERP	"csh"

#if 0
#define SIGNATURE_FILE	"signature"	' defaults
#define LOGIN_FILE	"login"
#define	CSHRC_FILE	"cshrc"
#define	MAIL_FILE	"mail"
#endif

#define ctTotalMins     1       ' adduser.rsrc lines
#define ctGrace         2
#define ctCharge        3
#define ctMaxUsers      4
#define	ctLenient	5
#define ctLast		5

#define	DFLT_MINS	1200	' Default settings
#define	DFLT_GRACE	60
#define	DFLT_CHARGE	0
#define	DFLT_ACCTS	200
#define	DFLT_LENIENT	-1


' ****************************************
' **
' ** main
' **
' ** Initialize the application and environment.
' ** Exit if not invoked with SuperUser status.
' **

	gosub AppInit
	gosub Setup
	gosub CheckAccounts
	gosub GetNewInfo
	gosub CreateAccount
goto Exit


' ****************************************
' **
' ** Setup
' **
' ** Sets up variables and environment
' **

Setup:
	& int stop 
	if not SuperUser then 
		print "cannot execute"
		goto Exit
	endif

	' =======================
	' Parse flags
	' =======================
	'
	' r, s, m, g	- Root, staff, mail, guest groups
	' a		- don't give an ADM record (UID is zero)
	' l		- no login file
	' u		- don't prompt for user information (phone #, etc.)
	' n 		- don't allow network mail access
	' i		- don't create a signature file
	' w		- don't mail a welcome letter

	GID		= Staff_ID	' Assume staff level account
	GetsADMRec	= TRUE		' Gets an ADM record
	GetsLoginFile	= TRUE		' Gets a login file
	GetUserInfo	= TRUE		' Get user info
	HasMailPriv	= TRUE		' Can send network mail
	GetsSignature	= TRUE		' Gets a signature file
	GetsWelcome	= TRUE		' Gets a welcome letter
	
	if argc > 1 then
		a$ = argv$[1]
		if asc (a$) <> 45 then 
			Interpreter$ = a$
		else
			& lcase(a$)
			for j = 2 to len(a$)
				& pos ("rsmgaluniw", mid$(a$,j,1)),p
				if p and p < 5 then GID = p - 1
				if p = 5 then GetsADMRec = FALSE
				if p = 6 then GetsLoginFile = FALSE
				if p = 7 then GetUserInfo = FALSE
				if p = 8 then HasMailPriv = FALSE
				if p = 9 then GetsSignature = FALSE
				if p = 10 then GetsWelcome = FALSE
			next 
			if argc = 3 then Interpreter$ = argv$[2]
		endif
		& spc(Interpreter$), Interpreter$
	endif
	
	if Interpreter$ = "" then Interpreter$ = DEFAULT_INTERP

	if GID = Mail_ID then 
		GetsADMRec = FALSE
		GetUserInfo = FALSE
	endif


	' ==============================
	' Define functions for encoding
	' ==============================
	
	def fn sub(x) = x - 44 * (x > 90 and x < 97) - 70 * (x > 122)
	def fn add(x) = x + 44 * (x < 53) + 70 * (x > 52 and x < 59)
	def fn low(x) = x - 32 * (x > 95)

	dim PWEntry$[MAX_ACCOUNTS], UID%[MAX_ACCOUNTS], ctime[ctLast]

	PasswdFile$	= ETC_PATH + "passwd"
	PwTemp$		= PasswdFile$ + ".tmp"
	ADMFile$	= ETC_PATH + "adm"
	AliasFile$	= ETC_PATH + "aliases"
	Default$	= ETC_PATH + "default/"
	AddUserLog$	= SPOOL_LOGS_PATH + "adduser.log"
	resourceFile$	= RSRC_PATH + "adduser.rsrc"
#if 0
	SignatureFile$	= SIGNATURE_FILE
	LoginFile$	= LOGIN_FILE
	CshRCFile$	= CSHRC_FILE	
	MailFile$	= MAIL_FILE
#endif
	
	& fn fnOutputMode, ioAlt

	' ====================
	' Display Banner
	' ====================

	& ioctl(ioNormal)
	& ioctl(ioClearScreen)
	print PROGRAM
	print
return


' ****************************************
' **
' ** CheckAccounts
' **
' ** Displays a message to the user while
' ** determining if there is room in the inn.
' **

CheckAccounts:
	if GID <> Mail_ID then
		if GID = Staff_ID or GID = Guest_ID then
			& page on
			& list HELP_PATH + "adduser"
			print
			& page stop
		endif

		ctime[ctTotalMins] = DFLT_MINS
		ctime[ctGrace] = DFLT_GRACE
		ctime[ctCharge] = DFLT_CHARGE
		ctime[ctMaxUsers] = DFLT_ACCTS
		ctime[ctLenient] = DFLT_LENIENT

		onerr goto rfEOF
		fOpen resourceFile$
		fRead resourceFile$
		for i = 1 to ctLast
			& get a$
			ctime[i] = val(a$)
		next
		error(5)
		rfEOF:
		onerr goto HandleError
		&onerr
		fClose
	endif

	print "Wait...";
	if ctime[ctMaxUsers] > MAX_ACCOUNTS then 
		ctime[ctMaxUsers] = MAX_ACCOUNTS
	endif

	' =====================
	' Read in names and IDs
	' =====================
	
	fOpen PasswdFile$
	fRead PasswdFile$
	entries = 0
	onerr goto pwEOF

	do
		& get a$
		entries = entries + 1
		& pos (a$,":"),p
		PWEntry$[entries] = left$(a$,p - 1)
		UID%(entries) = val (mid$(a$,p + 15))
	loop

	pwEOF:
	& onerr
	fClose
	onerr goto HandleError

	' ===========================
	' Find the next available UID
	' ===========================
	
	if not entries then 
		UID = 1
	else
		UID = 0
		if GetsADMRec then 
			& srt (UID%, entries)
			j = UID%[1]
			for i = 1 to entries
				if UID%[i] - j >= 2 then 
					i = entries
				else
					if UID%[i] > j then 
						j = UID%[i]
					endif
				endif
			next 
			UID = j + 1
		endif
	endif

	if GID = Root_ID or GID = Mail_ID then 
		ctime[ctTotalMins] = 0
		ctime[ctGrace] = 0
	endif

	& hlin 7, 8
	if GID = Staff_ID or GID = Guest_ID then
		if entries >= ctime[ctMaxUsers] then 
			print "System full.  Try later."
			goto Exit
		endif
		if not ctime[ctCharge] then 
			print "No charge for system access."
		else
			i = 60 * ctime[ctCharge] + .5
			j = int (i / 100)
			a$ = str$(int (i - j * 100))
			& left$ (a$,2,48), a$
			a$ = str$(j) + "." + a$
			print "A $" a$ " per hour (" ctime[ctCharge] \
				" cents per minute) charge applies."
		endif
	else
		print spc(7)
	endif
	print
return


' ****************************************
' **
' ** GetNewInfo
' **
' ** Get new user/account information
' **

GetNewInfo:
	& int on 
	& int = 3, 27
	& on int goto Cancelled

	repeat
		gosub getName
		gosub getLogin
		gosub getPassword
		gosub getLocation

		i$ = chr$(9)
		print
		if Name$ > "" then print i$ Name$
		if Address$ > "" then
			print i$ Address$
			print i$ City$ " " Zip$
			print i$ Phone$
		endif
		print i$ "You will login as '"Login$"'^M"

		print "Correct";
		gosub getYN
	until yes

	& int stop 
	if GetsADMRec then print "^MPlease memorize your login name and password."
return

getYN:
	print "? (Y/N) ";
	repeat
		get a$
		& ucase(a$)
		& pos ("NY",a$), yes
	until yes
	print a$
	yes = yes - 1
return


getName:	
	repeat
		if not GetsADMRec then 
			& read (22),"Description: ",a$
		else
			if entries then
				i$ = ""
			else
				i$ = SysInfo$[plAdminFull]
			endif
			& read (-22,i$),"Your first and last name   : ",a$
		endif
		gosub EatSpaces
		& pos (a$,"/"),p
		& pos (a$,":"),i
	until not (p or i)

	& pos (a$," "), p
	on (not p) and GetsADMRec and GetUserInfo goto getName

	if a$ > "" then 
		gosub MixedCase
		Name$ = a$
	endif
return

getLogin:
	if GID = Mail_ID then
		dl$ = ""
	else
		if entries then
			n$ = Name$
			& lcase(n$)
			& pos (n$, " "),p
			dl$ = n$
		
			' ==============================
			' Build a suggested login name
			' based on user's first and last
			' name.  Pick the shortest one.
			' ==============================
			
			if p then 
				dl$ = left$ (n$,1) + mid$ (n$,p + 1)
				da$ = left$ (n$,p - 1) + mid$ (n$,p + 1,1)
				if len(da$) < len(dl$) then 
					i$ = dl$
					dl$ = da$
					da$ = i$
				endif
			endif
		
			' ====================
			' Check for existence
			' ====================
		
			& GETINFO USR_PATH + dl$,i$
			if i$ > "" then 
				dl$ = da$
				& GETINFO USR_PATH + dl$,i$
				if i$ > "" then dl$ = ""
			endif
		else
			dl$ = SysInfo$[plAdmin]
		endif
	endif

	
	loginLoop:
	do
		repeat
			& read (15,dl$),"Enter your LOGIN identifier: ",Login$
			& spc(Login$), Login$
		until Login$ > ""
		Login$ = left$ (Login$,15)
		& lcase(Login$)
		& pos (Login$, "/"),p
		if p then goto badChar
		
		print "Checking...";
		& GETINFO USR_PATH + Login$, i$
	
		if i$ = "" then
			if ERR <> 7 then goto badChar
		
			i = entries
			if not i then return
			repeat
				j = Login$ = PWEntry$[i]
				i = i - 1
			until not i or j
			if not j then
				& GETINFO AliasFile$, i$
				if i$ = "" or GID = Root_ID or GID = Mail_ID then return
				onerr goto aliasEOF
				fOpen AliasFile$
				fRead AliasFile$
				repeat
					& get i$
					& pos (i$, ":"),p
					if p then i = Login$ = left$(i$,p - 1)
				until i
				error(5)	
				aliasEOF:
				& onerr
				fClose
				onerr goto HandleError
				if not i then return
			endif
		endif
		print Login$" is in use, pick another."
		dl$ = ""
		print
	loop
	
badChar:
	print "login names contain only letters and numbers."
	print "Please try another."
goto loginLoop


getPassword:
	& hlin 11, 8
	repeat
		repeat
			print "Enter your PASSWORD choice : ";
			& pr ioNone
			& read (8), i$
			& pr ioAlt
			print 
			& spc(i$), Password$
			if len (Password$) < 4 then 
				print "Four characters minimum."
				print 
			endif
		until (len(Password$) > 3)

		print "Please type it in again    : ";
		& pr ioNone
		& read (8), a$
		& pr ioAlt
		print 
		if a$ <> Password$ then
			print "They don't match, try again."
			print
		endif
	until a$ = Password$
	
	if not GetsADMRec or not GetUserInfo then 
		print "Home directory: " SysInfo$[plDir];
		& read (60),homeDir$
	else
		homeDir$ = "usr/" + Login$
	endif
return

getLocation:
	if not GetsADMRec or not GetUserInfo then return
	print 
	if ctime[ctLenient] = -1 then
		print "Do you live in the United States";
		gosub getYN
		ctime[ctLenient] = not yes
	endif

	print "Please enter the following information:^M"

	repeat
		& read (33),"Address (with box or apt #): ",a$
		gosub EatSpaces
		& pos (a$," "),p
	until (len(a$) > 6) and p
	gosub MixedCase
	Address$ = a$

	repeat
		repeat
			if ctime[ctLenient]
				a$ = "City and country           "
			else
				a$ = "City, state (e.g. Nome, AK)"
			endif
			print a$": ";
			& read(22), a$
			gosub EatSpaces
		until len(a$) > 6
	
		if not ctime[ctLenient] then
			& pos right$(a$, ","), p
			if p then & mid$(a$, p) = " "
			gosub EatSpaces
			gosub MixedCase
			i$ = a$
			a$ = ""
			& pos right$(i$, " "), p
			if p > 2 then
				j$ = mid$(i$, p + 1, 2)
				if len(j$) = 2 then
					& ucase(j$)
					& spc(left$(i$, p - 1)), i$
					a$ = i$ + ", " + j$
				endif
			endif
		endif
	until a$ > ""
	City$ = a$

	repeat
		if ctime[ctLenient]
			a$ ="Postal or mail routing code"
		else
			a$ ="ZIP code (please use ZIP+4)"
		endif
		print a$ ": ";
		& read (10),a$
		& spc(a$),Zip$
	until (len(Zip$) > 4) or ctime[ctLenient]

	repeat
		i = (ctime[ctLenient] > 0) * 2
		& read (14 - i),"Area code, and phone number: ",a$
		& spc(a$),a$
		i = len(a$)
		if not ctime[ctLenient] then
			if i > 9 then
				i$ = ""
				i = FALSE
				for i = 1 to len(a$)
					j = asc (mid$ (a$,i))
					if j > 47 and j < 58 then i$ = i$ + chr$(j)
				next 
				i = not ((len(i$) <> 10) or \
					(left$(i$,3) = "000") or \
					(mid$ (i$,4,3) = "555") or \
					(mid$ (i$,4,3) = "000"))
				if i then
					a$ = left$ (i$,3) + "/" + mid$ (i$,4,3) + \
						"-" + mid$ (i$,7)
				endif
			else
				i = 0
			endif
		endif
	until i
	Phone$ = a$
return


' ****************************************
' **
' ** CreateAccount
' **

CreateAccount:
	if ctime[ctGrace] then 
		print "To keep your account, call at least once every " \
			ctime[ctGrace] " days."
	endif

	if ctime[ctCharge] then 
		print "Be timely in making your monthly access charge payments."
	endif

	if ctime[ctTotalMins] then
		print "You have " int(ctime[ctTotalMins] / 60) \
			" hours per month for system access (" \
			int (ctime[ctTotalMins] / 30) " minutes a day)."
		print "Time allowances are renewed at the start of each month."
	endif

#if 0
	if GID <> Mail_ID then 
		print "Your cancel key is initially set to Control-C."
		print
		print "Login now in order to activate your account."
	endif
#endif

	& erase (PWEntry$)
	fFre
	print 
	print "Wait...";
	gosub MakePW
	& time(t$)
#if 0
	if GetsADMRec and (GID <> Mail_ID) and (homeDir$ > "") then 
		fCreate SysInfo$[plDir] homeDir$
		fCreate ADM_PATH Login$
		if GetsLoginFile then 
			f$ = SysInfo$[plDir] + homeDir$ + "/" + LoginFile$
			& copy (Default$ + LoginFile$ to f$)
			gosub MakeInvisible
			f$ = SysInfo$[plDir] + homeDir$ + "/" + CshRCFile$
			& copy (Default$ + CshRCFile$ to f$)
			gosub MakeInvisible
		endif
		if not HasMailPriv then
			fCreate ADM_PATH Login$ "/mailstop,t4"
		endif
		if GetsSignature then
			& GETINFO Default$ + SignatureFile$, i$
			GetsSignature = i$ > ""
		endif
		if GetsSignature then
			f$ = SysInfo$[plDir] + homeDir$ + "/" + SignatureFile$
			fOpen Default$ SignatureFile$
			fOpen f$
			onerr goto sigEOF
			do
				fRead Default$ SignatureFile$
				& get a$
				repeat
					&pos (a$, "<LOGIN>"), p
					if p then a$ = mid$(a$, 1, p - 1) + \
						Login$ + mid$(a$, p + 7)
				until not p
				repeat
					&pos (a$, "<NAME>"), p
					if p then a$ = mid$(a$, 1, p - 1) + \
						Name$ + mid$(a$, p + 6)
				until not p
				repeat
					&pos (a$, "<HOST>"), p
					if p then a$ = mid$(a$, 1, p - 1) + \
						SysInfo$[plNode] + mid$(a$, p + 6)
				until not p
				repeat
					&pos (a$, "<DOMAIN>"), p
					if p then a$ = mid$(a$, 1, p - 1) + \
						SysInfo$[plDomain] + mid$(a$, p + 8)
				until not p
				fWrite f$
				print a$
			loop
			sigEOF:
			&onerr
			onerr goto HandleError
			fClose
			gosub MakeInvisible
		endif
		if GetsWelcome then
			& GETINFO Default$ + MailFile$, i$
			if i$ > "" then gosub SendMsgFile
		endif
	endif
#endif

	thisEntry$ = Login$ + ":" + Password$ + ":" + str$(UID) + ":" + \
		str$(GID) + ":" + Name$ + ":" + homeDir$ + ":" + Interpreter$

	& GETINFO PwTemp$, i$
	if i$ > "" then fDelete PwTemp$

	fOpen PasswdFile$
	fOpen PwTemp$
	onerr goto newpwEOF

	do
		fRead PasswdFile$
		& get a$
		fWrite PwTemp$
		if thisEntry$ > "" and thisEntry$ < a$ then
			print thisEntry$
			thisEntry$ = ""
		endif
		print a$
	loop

	newpwEOF:
	& onerr
	onerr goto HandleError
	if thisEntry$ > "" then
		fWrite PwTemp$
		print thisEntry$
	endif
	fClose
	fDelete PasswdFile$
	fRename PwTemp$ "," PasswdFile$
	
	if UID then
		fAppend AddUserLog$
			gosub MiniTime
			i$ = chr$(9)
			print "ADDUSER " a$ " " Login$ \
				" (uid:" UID " gid:" GID " shell:" Interpreter$ ")"
			print i$ Name$ ", " Phone$
			print i$ Address$ ", " City$"  "Zip$
		fClose
	endif

	if UID then
		& GETINFO ADMFile$,i$
		fOpen ADMFile$ ",L256"
		for j = 0 to (i$ = "")
			fWrite ADMFile$ ",R" UID
			& left$ (Login$,15),a$		: print a$
			& left$ (Name$,22),a$		: print a$
			& left$ (Address$,33),a$	: print a$
			& left$ (City$,22),a$		: print a$
			& left$ (Zip$,10),a$		: print a$
			& left$ (Phone$,12),a$		: print a$
			print "     "
			print "     "
			print t$
			& left$ ("0,0,0",12),a$		: print a$
			print OLDEST_DATE
			& pos ("?anebarprayunulugepctovec", mid$ (t$,10,2)),i
			cmn = i / 2
			& left$ ("0,0," + str$(cmn) + ",0,0," + \
				str$(ctime[ctTotalMins]) + "," + \
				str$(ctime[ctGrace]), 36), a$
				print a$
			UID = 0
		next
	endif
	fClose
	
	if GetsADMRec and (GID <> Mail_ID) and (homeDir$ > "") then
		& pos (Interpreter$, " "), p
		if not p then p = 256
		i$ =	left$(Interpreter$, p - 1) + " " + \
			str$(GetsLoginFile) + " " + \
			str$(HasMailPriv) + " " + \
			str$(GetsSignature) + " " + \
			str$(GetsWelcome)

		' Suck out initials -- just First Last
		& pos (Name$, " "), p
		& pos right$ (Name$, " "), q
		Name$ = left$(Name$, p) + mid$(Name$, q + 1)
		if asc(homeDir$) <> $2F then
			homeDir$ = SysInfo$[plDir] + homeDir$
		endif
		CommandLine$ = "mkuser " + \
			Login$ + " " + \
			str$(GID) + " " + \
			str$(UID) + " " + \
			Name$ + " " + \
			homeDir$ + " " + \
			i$ 			
		Launch(CommandLine$, "", TRUE)
	endif

	& hlin 7, 8
	print spc(7)
	& hlin 7, 8

#if 0	
	& restore ProgStack_Cell to a$
	& pos (a$,":"),q
	if not q then 
		print 
		& read (1),"Press RETURN to continue: "
		& store a$ + ":" + a$ to ProgStack_Cell
	endif
#endif

return

EatSpaces:
	& spc(a$), a$
	repeat
		& pos(a$, "  "), p
		if p then a$ = mid$(a$, 1, p) + mid$(a$, p + 2)
	until not p
return

#if 0
' ****************************************
' **
' ** MakeInvisibe
' **

MakeInvisible:
	& GETINFO f$, i$
	& MID$(i$, 4) = chr$(OS_INVIS_ACCESS)
	& SETINFO f$, i$
return
#endif


' ****************************************
' **
' ** MakePW
' **

MakePW:
	& left$ (Password$,8),a$
	for i = 1 to 8
		j = asc ( mid$ (a$,i))
		& mid$ (a$,i) = chr$(fn low(j) + 32 * (j < 64))
	next
	k$ = ""
	for i = 1 to 5
		j = 63 * rnd(1) + 65
		k$ = k$ + chr$(fn sub(j))
	next 
	p$ = a$
	a$ = ""
	j = 0
	for i = 1 to 8
		j = j + 1
		if j > 5 then j = 1
		a$ = a$ + chr$( \
			fn sub( \
				asc(mid$(p$,i)) + \
				fn low(fn add(asc (mid$ (k$,j)))) - 64 \
			) \
		)
	next 
	Password$ = mid$(k$,3,1) + mid$ (a$,2,1) + left$ (a$,1) + \
		right$ (k$,1) + mid$ (a$,4,1) + mid$ (k$,2,1) + \
		mid$ (a$,3,1) + mid$ (k$,4,1) + mid$ (a$,5,1) + \
		mid$ (a$,8,1) + mid$ (a$,7,1) + left$ (k$,1) + mid$ (a$,6,1)
return 


' ****************************************
' **
' ** Cancelled
' **

Cancelled:
	& pr ioAlt
	print
	print "Registration Cancelled."
goto Exit


' ****************************************
' **
' ** MixedCase
' **

MixedCase:
	p = 0
	i$ = a$
	& ucase(i$)
	if i$ = a$ then & lcase(a$)

	repeat
		i = asc (mid$ (a$,p + 1))
		if i > 96 then & mid$ (a$,p + 1) = chr$ (i - 32)
		& pos (p + 1,a$," "),p
	until not p
return

#if 0
' ***************************************************
' **
' ** SendMsgFile - Create mailbox header and send greeting
' **

SendMsgFile:
	& time (theTime$)
	theFile$ = MAIL_PATH + Login$
	fAppend theFile$
	print "From " SysInfo$[plAdmin] " " left$(theTime$,3) \
		mid$(theTime$,8,5) mid$(theTime$,6,3) right$(theTime$,8) \
		" 19" mid$(theTime$,13,3)
	print "Date: " left$(theTime$,5) val(mid$(theTime$,6)) \
	      mid$(theTime$,8) " " SysInfo$[plZone]
	print "From: " SysInfo$[plAdmin] " (" SysInfo$[plAdminFull] ")"
	print "To: " Login$
	print "Subject: Welcome to " SysInfo$[plNode] "!"
	print 
	fClose
	&add (Default$ + MailFile$ to theFile$)
return
#endif

' ************************************************************
' **
' ** Time routines:
' **
' ** MiniTime: Return a time string in a$ in this format:  mm/dd-hh:mm
' **

MiniTime:
	& time (theTime$)
	& pos ("?anebarprayunulugepctovec", mid$ (theTime$, 10, 2)), i
	i = i / 2
	a$ = str$ (i) + "/" + str$ (val (mid$ (theTime$,6))) + \
		 "-" + mid$ (theTime$,16,8)
return 


#include <proline/proline.lib>
#define LAUNCH_PARSE
#define LAUNCH_NO_EXEC_PERM
#include <proline/launch.lib>
