' **********************************************************************
' ***
' ***	Window.h	TextToolbox Window Manager interfaces
' ***			Copyright (C) 1993 Morgan Davis Group
' ***

#pragma once

#define documentWin	0	' Document window with lined title bar
#define docSolidWin	1	' Document window with solid title bar
#define dBoxWin 	2	' Plain box rectangle
#define dTextPort	3	' Port with no frame
#define dFileCard	4	' File card style

#define MouseTextOn	print chr$(cMTextOn) chr$(cInverse);
#define MouseTextOff	print chr$(cMTextOff) chr$(cNormal);

#define GotoXY(x,y)	poke _CH80, x : vtab y + 1
#define GetXY(x,y)	x = peek(_CH80) : y = peek(_CV)
#define MoveTo(x,y)	GotoXY (x, wmTop[wmCurPortInd] + y)
#define WindowHeight	peek(_WNDBOT) - peek(_WNDTOP) - off
#define OffBottom(off)	WindowHeight - off
#define WindowCenter(w) peek(_WNDWID)/2 - w/2
#define Center(s)	poke _CH80, WindowCenter(len(s))
#define CenterPrint(s)	wmTmp$ = s : Center(wmTmp$) : print wmTmp$
#define RightPrint(s)	wmTmp$ = s : poke _CH80, peek(_WNDWID)-len(wmTmp$) :\
			print wmTmp$
#define TruncPrint(s)	print mid$(s, 1, peek(_WNDWID) - 1)

#define SetPort(id) \
		fID = id : gosub _SetPort

#define PortRect(left, top, bottom, right) \
		poke _WNDLFT, left : poke _WNDWID, right - left + 1:\
		poke _WNDTOP, top : poke _WNDBOT, bottom + 1 :\
		GotoXY (0, top)

#define InsetPort(id, dh, dv) \
		fID = id : dhOff = dh : dvOff = dv : gosub _InsetPort

#define NewWindow(left, top, bottom, right, title, type, drawID, id) \
		nwTop = top : nwLeft = left : nwBottom = bottom :\
		nwRight = right : nwTitle$ = title : nwType = type :\
		nwDrawID = drawID : gosub _NewWindow : id = wmWinSeq

#define CloseWindow(id, updateOthers) \
		fID = id : cwUpdateFlag = updateOthers : gosub _CloseWindow

#define CloseAllWindows \
		gosub _CloseAll

#define DrawWindow(id)	\
		fID = id : gosub _DrawWindow

#define UpdateWindows \
		gosub _UpdateWindows

#define FindWindow(id, index) \
		fID = id : gosub _FindWindow : index = windex

#define HideWindow(id) \
		fID = id : gosub _HideWindow

#define WindowStartup \
		gosub _WindowStartup

#define WindowShutdown \
		gosub _WindowShutdown
