' **********************************************************************
' ***
' *** TextToolbox.h	Interfaces for the TextToolbox functions
' ***			(C)opyright 1993 Morgan Davis Group
' ***
' **********************************************************************
'
' These macros are interfaces for the TextToolbox (TTB) module --
' an OMM (Object Module Manager) extension that enhances programs
' programs written in MD-BASIC that use the TTB.
'
' PrintString(n, c) -- Prints character c multiple times n horizontally
'
' PrintStringV(n, c) -- Prints character c multiple times n vertically
'
' strchr(str, off, c, x) -- Searches string str starting at offset off
'		for character c, returning position into variable x.
'
' strrchr(str, off, c, x) -- Same as strchr, except the search goes from
'		right to left.
'
' Sound(pitch, dur) -- Plays simple tone based on pitch and duration given.
'
' GetColors(fg, bg, brdr) -- Sets IIGS text display colors for the foreground
' 		text, background, and border.
'
' SetColors(fg, bg, brdr) -- Sets IIGS text display colors for the foreground
'
' Pause(ticks, abort) -- Pauses for ticks (1/60th seconds) with ability
'               to terminate early if abort flag set.
'
' seconds(secs) -- For use with Pause to produce second-long pauses
'
' LineInput(sv) -- Input anything into string variable sv.
'
' FixStack -- Fixes the stack after an ONERR branch occurs
'
' Note that the AmperWorks module that comes with OMM includes many
' routines such as these, although more powerful, and with nicer ampersand
' command names (not just numbers).
' ______________________________________________________________________

#define TTB_ID         $6F64	' Module ID

#define	PrintString(n, c)	&# 0, c, n
#define	PrintStringV(n, c)	&# 1, c, n
#define	strchr(str, off, c, x)	&# 2, str, off, c, x
#define	strrchr(str, off, c, x)	&# 3, str, off, c, x
#define	Sound(pitch, dur)	&# 4, pitch, dur
#define	GetColors(fg, bg, brdr)	&# 5, fg, bg, brdr
#define	SetColors(fg, bg, brdr)	&# 6, fg, bg, brdr
#define Pause(ticks, abort)	&# 7, ticks, abort
#define LineInput(sv)		&# 8, sv
#define FixStack		&# 9

#define	seconds(secs)		secs * 60
