'======================================================================
'
' proline.h	Header file for ProLine applications
'		(C)opyright 1994 Morgan Davis Group
'
'======================================================================

#pragma	once

#include <omm.h>
#include <amperworks.h>
#include <modemworks.h>
#include <fileio.h>

#define Root_ID 	0	' Group IDs
#define Staff_ID	1
#define Mail_ID 	2
#define Guest_ID	3

#define UserID_Cell	0	' Storage cell ID's
#define ProgStack_Cell	1
#define ShellArgs_Cell	2
#define SysInfo_Cell	3

#define uItemCount	7	' Number of elements in ID$[]

#define uName		1	' ID$ array indexes
#define uUID		2
#define uGID		3
#define uFullName	4
#define uHome		5
#define uCallerID	6
#define uEditor 	7

#define plItemCount	10	' Number of elements in SysInfo$[]

#define plDir		1	' SysInfo$ array indexes
#define plNode		2
#define plAdmin 	3
#define plZone		4
#define plTempDir	5
#define plAdminFull	6
#define plSpoolDir	7
#define plVersion	8
#define plDomain	9
#define plModulesDir	10

#define xqtSuperUser	1		' Launch flags
#define xqtArgc		2
#define xqtStatus	3
#define xqtReturnFlag	4

#define accRead 	1		' Access permission modes
#define accWrite	2
#define accDelete	4
#define accDestroy	4
#define accExecute	8

#define stty		$bee2		' STTY bytes in BASIC global page

#define sttyCancel	stty		' 3 = Control-C
#define sttyTabs	stty + 1	' 1 = Expand tabs
#define sttyNulls	stty + 2	' 0 = No nulls
#define sttyShell	stty + 3	' x = Shell level x (0 = no shell)
#define sttyReserved1	stty + 4	' <reserved>
#define sttyReserved2	stty + 5	' <reserved>
#define sttyReserved3	stty + 6	' <reserved>
#define sttyReserved4	stty + 7	' <unused>
#define sttyReserved5	stty + 8	' <unused>

#define admLogin	0	' Login name (ADM File field offsets)
#define admName 	16	' Real name
#define admStreet	39	' Street Address
#define admCityST	73	' City, State Abbreviation
#define admZIP		96	' ZIP Code
#define admPhone	107	' Phone Number
#define admBlank1	120	' Blank field #1
#define admBlank2	126	' Blank field #2
#define admDateEst	132	' Date account established
#define admAcctInfo	156	' ADM accounting info
#define admLastLogin	169	' Date of last login
#define admTimeInfo	193	' ADM time info
#define	admRecordLength	256	' Length of ADM record

#define ADM_PATH	SysInfo$[plDir] + "adm/"
#define BIN_PATH	SysInfo$[plDir] + "bin/"
#define DEFAULT_PATH	SysInfo$[plDir] + "etc/default/"
#define ETC_PATH	SysInfo$[plDir] + "etc/"
#define GAMES_PATH	SysInfo$[plDir] + "games/"
#define GAMES_LIB_PATH	SysInfo$[plDir] + "games/lib/"
#define	GAMES_HELP_PATH	SysInfo$[plDir] + "games/lib/help"
#define MAIL_PATH	SysInfo$[plDir] + "sys/mail/"
#define MAN_PATH	SysInfo$[plDir] + "sys/man/"
#define MAPS_PATH	SysInfo$[plDir] + "sys/maps/"
#define MDSS_PATH	SysInfo$[plDir] + "mdss/"
#define NEWS_PATH	SysInfo$[plDir] + "sys/news/"
#define HELP_PATH	SysInfo$[plDir] + "etc/help/"
#define RSRC_PATH	SysInfo$[plDir] + "etc/rsrc/"
#define SPOOL_PATH	SysInfo$[plSpoolDir]
#define SPOOL_MAIL_PATH SysInfo$[plSpoolDir] + "mail/"
#define SPOOL_NEWS_PATH SysInfo$[plSpoolDir] + "news/"
#define SPOOL_LOGS_PATH SysInfo$[plSpoolDir] + "logs/"
#define SYS_PATH	SysInfo$[plDir] + "sys/"
#define SYS_BIN_PATH	SysInfo$[plDir] + "sys/bin/"
#define SYS_LOCAL_BIN_PATH SysInfo$[plDir] + "sys/local/bin/"
#define TEMP_PATH	SysInfo$[plTempDir]
#define USR_PATH	SysInfo$[plDir] + "usr/"

#define LOGIN_PATH	BIN_PATH + "login"

#define SITE_NAME	SysInfo$[plNode] + SysInfo$[plDomain]

#define PATH_LIST	SysInfo$[plDir] + "bin " + \
			SysInfo$[plDir] + "sys/bin " + \
			ID$[uHome] + "/bin " + \
			SysInfo$[plDir] + "sys/local/bin " + \
			". " + \
			SysInfo$[plDir] + "etc " + \
			SysInfo$[plDir] + "games"

#define MAN_LIST	"ADM:C:S:NET:CP:CT:M:F:HW:L:G"


	' Program identification

#define	IDENT_MARK		"@(#)"
#define IDENT(w,x,y,z)		rem IDENT_MARK " " w " " x " " y " " z " " IDENT_MARK
#ifdef IDENT_PROG
	IDENT (IDENT_PROG, IDENT_VERS, IDENT_DATE, IDENT_NAME)
#endif


	' Handy subroutine macros
	
#define	System(c)		Launch(c, AppPath$, FALSE)
#define	Launch(c,r,m)		CommandLine$ = c : \
				ReturnPath$ = r : \
				SetRoot = m : \
				gosub _Launch
