' **********************************************************************
' ***
' ***	callbox.h	- Call Box interfaces for MD-BASIC
' ***			Copyright (C) 1993 Morgan Davis Group
' ***

#pragma once

	' Standard variable names for Call Box commands

#reserve AR, AY, CU, DI, EV, GS, LC, LN, ME, OV, PE, PL, PN
#reserve PO, PT, QF, RE, RR, SB, SC, SF, TL, TX, UA, UL, WN

	' Special Call Box characters

#reserve !, _, @, \\

#define  {	\`\[\`
#define  }	\`\]\`

	' Code macros for Call Box commands
        
#define BigPeek 	call PE,
#define BigPoke 	call PO,
#define LongCall	call LC,
#define LongCall2	call LC
#define CBShutDown	call QF

#define FrameArc	call AR,0,
#define PaintArc	call AR,1,
#define EraseArc	call AR,2,
#define InvertArc	call AR,3,
#define FillArc 	call AR,4,

#define UndimArray	call AY,0,
#define DimArray	call AY,1,
#define GetArrayValue	call AY,2,
#define SetArrayValue	call AY,3,
#define SetAllValues	call AY,4,

#define HideCursor	call CU,0
#define ShowCursor	call CU,1
#define ArrowCursor	call CU,2
#define WaitCursor	call CU,3
#define SetCursor	call CU,4,
#define LoadCursor	call CU,5,
#define PlotIcon	call CU,6,
#define LoadIcon	call CU,7,

#define LoadDialog	call DI,0,
#define DrawDialog	call DI,1,
#define WaitDItemHit	call DI,2,
#define CloseDialog	call DI,3,
#define GetDItemValue	call DI,4,
#define SetDItemValue	call DI,5,
#define GetDItemText	call DI,6,
#define SetDItemText	call DI,7,
#define GetDialogPtr	call DI,8,

#define GetNextEvent	call EV,
#define TaskMaster	call EV,@,

#define Line		call LN,

#define LoadMenu	call ME,0,
#define InsertMenu	call ME,1,
#define CheckEditMenu	call ME,2,
#define DeleteMenu	call ME,3,
#define VisibleMenu	call ME,4,
#define EnableMItem	call ME,5,
#define CheckMItem	call ME,6,
#define HiliteMItem	call ME,7,
#define SetMItemStyle	call ME,8,
#define GetMenuPtr	call ME,9,

#define FrameOval	call OV,0,
#define PaintOval	call OV,1,
#define EraseOval	call OV,2,
#define InvertOval	call OV,3,
#define FillOval	call OV,4,

#define SetColor	call PL,0,
#define GetColor	call PL,1,
#define SetStdPalette	call PL,2,
#define LoadPalette	call PL,3,

#define HidePen 	call PN,0
#define ShowPen 	call PN,1
#define MovePen 	call PN,2,
#define PenColor	call PN,3,
#define PenPat		call PN,4,
#define PenSize 	call PN,5,
#define PenMode 	call PN,6,
#define PenNormal	call PN,7
#define LoadPenPat	call PN,8,

#define SetPort 	call PT,0,
#define OpenPort	call PT,1,
#define LoadPort	call PT,2,
#define PPToPort	call PT,4,
#define DrawPicture	call PT,5,
#define GlobalToLocal	call PT,6,
#define LocalToGlobal	call PT,7,

#define FrameRect	call RE,0,
#define PaintRect	call RE,1,
#define EraseRect	call RE,2,
#define InvertRect	call RE,3,
#define FillRect	call RE,4,

#define FrameRRect	call RR,0,
#define PaintRRect	call RR,1,
#define EraseRRect	call RR,2,
#define InvertRRect	call RR,3,
#define FillRRect	call RR,4,

#define SetSCBs 	call SB,0,
#define GetSCB		call SB,1,

#define GrafOff 	call SC,0
#define GrafOn		call SC,1
#define GrafMode	call SC,2,
#define ClearScreen	call SC,3,

#define StartUpOneTool	call TL,0,
#define StartUpTools	call TL,2,

#define DrawString	call TX,0,
#define TextColors	call TX,1,
#define TextFace	call TX,2,
#define FontMode	call TX,3,
#define LoadFont	call TX,4,
#define StringWidth	call TX,5,

#define LoadWindow	call WN,0,
#define OpenWindow	call WN,1,
#define CloseWindow	call WN,2,
#define RefreshDesktop	call WN,3
#define ShowHide	call WN,4,
#define ContentOrigin	call WN,5,
#define SetWTitle	call WN,6,
#define CopyWindow	call WN,7,
#define GetWMgrPort	call WN,8,

#define LoadFile	call GS,0,
#define SaveFile	call GS,1,
#define ExpandPath	call GS,2,
#define GSCreate	call GS,3,
#define GSOpen		call GS,4,
#define GSRead		call GS,5,
#define GSWrite 	call GS,6,
#define GSClose 	call GS,7,
#define InitialLoad	call GS,8,
#define GoNative	call GS,9,

#define GetStdFile	call SF,0,
#define PutStdFile	call SF,1,
#define UnHookStdFile	call SF,2
