' **************************************************
' ***
' *** ctype.h -- character types
' ***
' *** Copyright (C) 1993 by Morgan Davis Group
' ***
' **************************************************

#pragma once

#define cNull		0
#define cBreak		3
#define cDOS		4
#define cBell		7
#define cBackspace	8
#define cLeftArrow	8
#define cTab		9
#define cLF		10
#define cDownArrow	10
#define cClearEOS	11
#define cUpArrow	11
#define cClearScreen	12
#define cCR		13
#define cReturn 	13
#define cNormal 	14
#define cInverse	15
#define c40Columns	17
#define c80Columns	18
#define cPause		19
#define cKill80 	21
#define cRightArrow	21
#define cScrollDown	22
#define cScrollUp	23
#define cMTextOff	24
#define cHomeCursor	25
#define cClearLine	26
#define cEscape 	27
#define cMTextOn	27
#define cCursorRight	28
#define cClearEOL	29
#define cSetCursor	30
#define cCursorUp	31
#define cSpace		32
#define cDelete 	127

#define isupper(c)	(c>64 and c<91)
#define islower(c)	(c>96 and c<123)
#define isalpha(c)	(isupper(c) or islower(c))
#define isdigit(c)	(c>47 and c<58)
#define isxdigit(c)	(isdigit(c) or (c>64 and c<70) or (c>96 and c<103))
#define isalnum(c)	(isdigit(c) or isalpha(c))
#define isspace(c)	(c=32)
#define ispunct(c)	((c>32 and c<48) or (c>57 and c<65) or\
			(c>90 and c<97) or (c>122 and c<127))
#define isprint(c)	(c>31 and c<127)
#define iscntrl(c)	(c>=0 and c<32)
#define isascii(c)	(c>=0 and c<128)
#define iswhite(c)	(c=32 or c=9)
#define toupper(c)	(c - islower(c) * 32)
#define tolower(c)	(c + isupper(c) * 32)
#define toascii(c)	(c - (c>127) * 128)
