' ***************************************************************************
' **
' ** dow.b	Day of week algorithms
' **		Collected from various contributors
' **

#include <amperworks.h>
#include <basic.h>

	print "^DPR#3"
	home
	print "This program demonstrates various algorithms for calculating"
	print "the day of the week from the date.  Try a few of the critical"
	print "leap years such as 1900, 2000, and 2100."
	print
	a$ = "2"
	& read (-2,a$),"Enter the month (1-12): ",i$
	M = val(i$)
	a$ = "28"
	& read (-2,a$),"Enter the date (1-31):  ",i$
	D = val(i$)
	a$ = "1992"
	& read (-4,a$),"Enter the full year:    ",i$
	Y = val(i$)
	print
	
	gosub e_r_moyer
	gosub e_r_moyer_simple
	gosub fred_condo
	gosub dmz
end

' All routines use the following constants for testing:
'
' Y = Year (1582 - ?)
' M = Month (1 - 12)
' D = Day (1 - 31)


#if 0
___________________________________________________________________________

[> mac.hack/code #176 e.r.ermoyer 3000 30Jul91 08:27 O=173

The following algorithm will convert a year, month, and day to a
Julian date, relative to the start of the Julian calendar.  That
is, the function will return, for the given date, the number of
days "J" that have elapsed since October 15, 1582.  (A different
calendar system, the Gregorian calendar, was employed prior to
this date, so the function as written will not return useful
values for earlier dates.)

This type of "absolute date" value is very useful for determining
the time elapsed between two events, or for validating manually
entered dates.  For example, to discover how many days old you are,
use the algorithm to find the "J" values for today's date and the
date of your birth and simply subtract.  To find the "day-of-the-
year" for a given date, calculate the difference between the "J"
values for the desired date and for January 1st of the same year.
Also, to see if a particular year/month/day combination is valid,
make sure the corresponding "J" value is LESS than the "J" value
for the first day of the following month.  (For example, the "J"
value for February 29, 1991 should _NOT_ be less than that for
March 1, 1991 since 1991 is _NOT_ a leap year.)

The algorithm will also calculate the day-of-the-week for the
given date.  This is expressed as an integer value "W" ranging
from 0 to 6, inclusive, where 0 represents Sunday, 1 Monday, etc.

Note that it is possible to convert "J" values _BACK_ into year,
month, and day numbers, though the algorithm to do so is slightly
more complex, requiring an iterative "estimate-and-verify" method.
If you ask, I'll be happy to provide example code in another post.

-- E.R.Moyer
___________________________________________________________________________
#endif

e_r_moyer:
'
'  Returns:	J = Julian Date (where 0 = October 15, 1582)
'  		W = Day Of Week (where 0 = Sunday)
'
	X = Y - (M < 3)
	J = (Y * 365) + INT(X / 4) - INT(X / 100) + INT(X / 400) + \
		  (M * 31) - VAL(MID$("003344555667",M,1)) + D - 578132
	W = (J + 5) - (INT((J + 5) / 7) * 7)

	print "E.R. Moyer:"
	print "    Day of week = " w " (0=Sun), " \
		"Julian date = " j " (from 15-Oct-1582)"
	print
return

#if 0
___________________________________________________________________________

If you are interested only in the day-of-the-week, the function
may be reduced as shown below.  (In this algorithm, the value "J"
is not useful for anything other than for calculating "W".)  This
reduction is handy since the intermediate values will be of lesser
magnitude, allowing the use of 16-bit integer variables and arith-
metic operations, which are handled more rapidly in most BASIC
environments.  Also, changing the VAL(MID$(...)) statement to an
array reference such as K[M] may speed things up, though it will
require an extra variable and an array initialization loop.
___________________________________________________________________________
#endif

e_r_moyer_simple:	
'
' This variation simply calculates the day of week in W
'
	X = Y - (M < 3)
	J = Y + INT(X / 4) - INT(X / 100) + INT(X / 400) + \
		(M * 3) - VAL(MID$("003344555667",M,1)) + D + 3
  	W = J - (INT(J / 7) * 7)

	print "E.R. Moyer2:"
	print "    Day of week = " w " (0=Sun)"
	print
return


#if 0
___________________________________________________________________________

Date: Sun, 28 Oct 90 00:43:49 PDT
From: fredc@pro-humanist.cts.com (Fred Condo, sysop)

Here's a routine to calculate the day of the week. Don't ask me how it works.
It's magic. I found it in a book or a magazine a decade ago, and the only
thing I remember about it is that it works for any date after 1752 (because
that's the year they switched from the Julian to the Gregorian calendar).
Despite the fact that I never bothered to figure out its logic in detail, I
used it successfully in several programs. I am quite sure that it will work
forever, as I've tested it for the critical dates around Feb. 28 in 1900,
2000, and 2100, as well as for a great variety of dates in the past and the
distant future.
___________________________________________________________________________
#endif

fred_condo:
'
' Returns:	W = day of week (0=Sun)
'
	K = INT(1 / M + .6)
	L = Y - K
	Z = INT(13 * (12 * K + M + 1) / 5) \
		+ INT(5 * L / 4) \
		- INT(L / 100) \
		+ INT(L / 400) \
		+ D - 1
	W = Z - 7 * INT(Z / 7)

	print "Fred Condo:"
	print "    Day of week = " w " (0=Sun)"
	print
return


#if 0
___________________________________________________________________________

Date: Nov 13 1990 22:42:15 (EST)
From: dzimmerman@gnh-tff.cts.com (Daniel Zimmerman)

I found the following in a reference book that came with my calculator.
W corresponds to the day of the week where 0=Sat, 1=Sun . . . 6=Fri.

Daniel M. Zimmerman

**** NOTE:  THIS ALGORITHM FAILS IN CRITICAL LEAP YEARS. -- Morgan Davis ****
___________________________________________________________________________
#endif

dmz:
'
' Returns:	W = day of week (0=Sat, 1=Sun, Fri=6)
'
	T1 = 365 * Y + 31 * (M - 1) + D
	T2 = int(.75 * (int(Y / 100) + 1))
	if M < 3 then
		W = T1 + int((Y - 1) / 4) - T2
	else
		W = T1 - int(.4 * M + 2.3) + int(Y / 4) - T2
	endif
	W = W - int(W / 7) * 7

	print "Daniel Zimmerman (fails on critical leap years):"
	print "    Day of week = " w " (0=Sat, 1=Sun, Fri=6)"
	print
return

#if 0
___________________________________________________________________________

Date: Sun, 28 Oct 90 15:47:14 EST
From: alphalpha!pro-angmar!achilles (David Holland)

Not Applesoft Basic, unfortunately, but... 
 
/* C. Returns 0 for Sun., 7 for Sat., etc. */
 
int q(int mon, int day, int year) {
  int months[12] = {0, 3, 3, 6, 1, 4, 6, 2, 5, 0, 3, 5};
  return 
   (year + months[mon-1] + day + year/4 - (year%4==0 && mon<3 ? 1 : 0)) % 7;
}
 

(* Pascal. Returns the same. *)
 
function q(mon, day, year : integer) : integer;
 const months : array[1..12] of integer = (0, 3, 3, 6, 1, 4, 6, 2, 5, 0, 3, 5);
 var x : integer;
 begin
   x := year + months[mon] + day + year div 4;
   if (year mod 4 = 0) and (mon <3) then x := x-1;
   q := x mod 7;
end;
 
 
/* Note that both these functions expect year-1900; also neither has been 
programmed for the fact that though 2000 is a leap year, 1900, 2100, 2200, 
etc. are not. */

David A. Holland
___________________________________________________________________________
#endif
 

