' **********************************************************************
' ***
' ***	whatis.b	Describe what a command is
' ***

#define	IDENT_PROG "whatis"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "20mar94"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <proline/proline.h>

	gosub AppInit

	whatisDB$ = HELP_PATH + "whatis"
	
	options$ = "?mq"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "q" then quietMode% = TRUE
		if optchar$ = "m" then makeMode% = TRUE
		if optchar$ = "?" then
			& print "Usage: " argv$[0] " [-m]"
			goto ExitError
		endif
	until optchar$ = ""
	
	if makeMode% then goto MakeWhatis

	if argv$[1] = "" or argv$[1] = "*" or argv$[1] = "?" then 
		& list whatisDB$
		goto Exit
	endif


	fOpen whatisDB$
	fRead whatisDB$
	onerr goto whatisEOF

	whatFound = FALSE
	do
		& get a$
		& pos (a$,")"),p
		i$ = left$ (a$,p)
		for i = 1 to argc - 1
			& pos (i$,argv$[i]),p
			if p then 
				print a$
				whatFound = TRUE
			endif
		next
	loop

	whatisEOF:
	& onerr e,l
	onerr goto HandleError
	fClose
	if not whatFound then 
		& print "I don't know what " argv$[1] " is."
		goto ExitError
	endif
goto Exit


MakeWhatis:
	if not SuperUser then
		& print argv$[0]": can't run"
		goto ExitError
	endif

	order$ = MAN_LIST
	a$ = RSRC_PATH + "man.rsrc"
	& getinfo a$, i$
	if i$ > "" then
		fOpen a$
		fRead a$
		& get order$
		fClose
	endif

	dim t$[400]

	& getinfo whatisDB$,i$
	if i$ > "" then fDelete whatisDB$

	orderLen = len(order$)
	curDir = 1
	repeat
		& pos (curDir, order$, ":"), p
		if not p then p = orderLen + 1
		tag$ = mid$(order$, curDir, p - curDir)
		curDir = p + 1
		manDir$ = MAN_PATH + "man." + tag$ + "/"
		& getinfo manDir$, i$
		if i$ > "" then gosub DoManDir
	until curDir > orderLen
goto Exit


DoManDir:	
	& files(manDir$,t$,4),f
	if not f then return

	& sort(t$,f)
	fAppend whatisDB$
	for i = 1 to f
		&lcase(t$[i])
		n$ = t$[i] + " - Unknown"

		onerr goto manEOF
		fOpen manDir$ t$[i]
		fRead manDir$ t$[i]
		repeat
			& get a$
		until a$ = ".SH Name"
		& get n$
		goto gotName

		manEOF:
		& onerr e,l
	gotName:
		onerr goto HandleError
		fClose manDir$ t$[i]
		& pos (n$,"-"),p
		& spc( left$ (n$,p - 1)),i$
		& left$ (i$, len (i$) + (3 - len (i$) / 7),9),i$
		fWrite whatisDB$
		print i$ "(" tag$ ") " mid$ (n$,p)
		if not quietMode% then
			print chr$(4)
			& print i$ "(" tag$ ") " mid$ (n$,p)
		endif
	next i
	fClose
return

#include <proline/proline.lib>
#include <proline/getopt.lib>
