' ************************************************************************
' **
' **  whereis.b		Locate source, binary, and/or manual for a program
' **			(C)opyright 1994 Morgan Davis Group
' **
' ** When    Who Ver	What
' ** ======= === ======	==============================================
' ** 14sep93 mwd 1.0	Created
' **
' ************************************************************************

#define	IDENT_PROG "whereis"
#define	IDENT_VERS "1.0"
#define	IDENT_DATE "20jan94"
#define	IDENT_NAME "Morgan_Davis"

#include <proline/proline.h>


	gosub AppInit

	options$ = "?sbm"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "?" then showUsage = TRUE
		if optchar$ = "s" then
			' sflag = TRUE
			& print argv$[0] ": -s flag not completed"
		endif
		if optchar$ = "b" then bflag = TRUE
		if optchar$ = "m" then
			mflag = TRUE
			a$ = RSRC_PATH + "man.rsrc"
			& getinfo a$, i$
			if i$ > "" then
				fOpen a$
				fRead a$
				& get order$
				fClose
			else
				order$ = MAN_LIST
			endif
			orderLen = len(order$)
		endif
	until optchar$ = ""
	
	if showUsage or (nargc < 2) then
		& print "Usage: "argv$[0]" [ -sbm ] name..."
		goto Exit
	endif

	if not (sflag + bflag + mflag) then bflag = TRUE
	
	for i = 1 to nargc - 1
		i$ = nargv$[i]
		& pos right$ (i$, "/"), p
		if p then i$ = mid$(i$, p + 1)
		& pos right$ (i$, "."), p
		if p then i$ = mid$(i$, 1, p - 1)
		if sflag then gosub where_s
		if bflag then gosub where_b
		if mflag then gosub where_m
	next
goto Exit

where_s:
return

where_b:
	k$ = PATH_LIST
	q2 = len(k$)
	p = 0
	found = FALSE
	repeat
		&pos (p+1, k$ + " ", " "), q1
		j$ = mid$(k$, p + 1, q1 - p - 1) + "/"
		if j$ = "./" then
			fPrefix
			& get j$
			& lcase(j$)
		endif
		& getinfo j$ + i$, info$
		if info$ > "" then
			print j$ + i$
			found = TRUE
		endif
		p = q1
	until p > q2

	if not found then &print i$": command not found"
return

where_m:
	curDir = 1
	found = FALSE
	repeat
		& pos (curDir, order$, ":"), p
		if not p then p = orderLen + 1
		tag$ = "." + mid$(order$, curDir, p - curDir)
		curDir = p + 1
		manFile$ = MAN_PATH + "man" + tag$ + "/" + i$
		manFile$ = manFile$ + tag$
		& getinfo manFile$, a$
		if a$ > "" then
			print manFile$
			found = TRUE
		endif
	until curDir > orderLen
	if not found then &print i$": manual not found"
return


#include <proline/proline.lib>
#include <proline/getopt.lib>
