' ************************************************************************
' **
' **  version.b		Print version number of files
' **			(C)opyright 1994 Morgan Davis Group
' **
' ** When    Who Ver	What
' ** ======= === ======	==============================================
' ** 20jan94 mwd 1.0	Created
' **
' ************************************************************************

#define	IDENT_PROG "version"
#define	IDENT_VERS "1.0"
#define	IDENT_DATE "16mar94"
#define	IDENT_NAME "Morgan_Davis"

#include <proline/proline.h>

	gosub AppInit

	gosub testOutput
	if accFile$ > "" then
		on not AccOK goto Exit
		if k = 1 and accMode > accWrite then fDelete accFile$
		outputFile$ = accFile$
	endif

	header% = TRUE
	ignore% = TRUE

	options$ = "?hi"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "?" then showUsage = TRUE
		if optchar$ = "h" then header% = FALSE
		if optchar$ = "i" then ignore% = FALSE
	until optchar$ = ""
	
	if showUsage then
		& print "Usage: "argv$[0]" [ -hi ] path..."
		goto Exit
	endif

	width[1] = 15 : rightjust[1] = 0
	width[2] = 10 : rightjust[2] = 1
	width[3] = 7  : rightjust[3] = 1
	
	if outputFile$ > "" then fAppend outputFile$

	if header% then
		ver$ = "Program Version Date Name"
		gosub print_vers
	endif

	if nargc = 1 then
		ver$ = "ProLine " + SysInfo$[plVersion] + " (C) Morgan_Davis_Group"
		gosub print_vers
	else
		for i = 1 to nargc - 1
			i$ = nargv$[i]
			gosub show_version
		next
	endif
goto Exit

show_version:
	& getinfo i$, info$
	if info$ = "" then
		& pos (i$, "/"), p
		if not p then
			gosub where_b
		else
			found = FALSE
		endif
		if not found then
			& print argv$[0]": " i$ " not found"
			return
		endif
	endif

	theType = asc(mid$(info$, 5))
	
	if theType = 15 then
		if outputFile$ > "" then fClose outputFile$
		file$[0] = ""
		& files(i$, file$), x, count
		if count then
			& erase(file$)
			dim file$[count]
			& files(i$, file$), count
			& sort(file$, count)
			path$ = i$
			if right$(path$, 1) <> "/" then path$ = path$ + "/"
			if outputFile$ > "" then fAppend outputFile$
			for j = 1 to count
				theFile$ = path$ + file$[j]
				& lcase(theFile$)
				gosub do_file
			next
			& erase(file$)
		endif
	else
		theFile$ = i$
		gosub do_file2
	endif
return

do_file:
	& getinfo theFile$, info$
	theType = asc(mid$(info$, 5))
do_file2:
	fOpen theFile$ ",T" theType
	fRead theFile$
	& get (255), a$
	fClose theFile$

	& pos (a$, IDENT_MARK), p
	& pos(p + 5, a$, IDENT_MARK), q
	if p and q then
		& spc(mid$(a$, p + 5, q - p - 5)), ver$
		gosub print_vers
	else
		if not ignore% then
			if outputFile$ > "" then fWrite outputFile$
			print argv$[0] ": no identifier in " theFile$
		endif
	endif
return


print_vers:
	q = 1
	field = 1
	if outputFile$ > "" then fWrite outputFile$
	repeat
		& pos(q, ver$ + " ", " "), p
		a$ = mid$(ver$, q, p - q)
		repeat
			& pos (a$, "_"), u
			if u then & mid$(a$, u) = " "
		until not u
		if field < 4 then
			if rightjust[field] then
				& right$(a$, width[field]), a$
			else
				& left$(a$, width[field]), a$
			endif
			a$ = a$ + "  "
		endif
		print a$;
		q = p + 1
		field = field + 1
	until q > len(ver$)
	print
return


testOutput:
	accFile$ = ""
	if asc(argv$[argc-1]) = 62 then
		argc = argc - 1
		accFile$ = argv$[argc]
		k = len(accFile$)
		& spc (accFile$, 62), accFile$
		k = k - len(accFile$)
		gosub testAccFile
	endif
return

testAccFile:
	& getinfo accFile$,i$
	accMode = accWrite + accWrite * (i$ > "")
	gosub CheckAccess
	if not accOK then
		print argv$[0] ": can't open " accFile$
		status% = -1
	endif
return


where_b:
	k$ = PATH_LIST
	q2 = len(k$)
	p = 0
	found = FALSE
	repeat
		&pos (p+1, k$ + " ", " "), q1
		j$ = mid$(k$, p + 1, q1 - p - 1) + "/"
		if j$ = "./" then
			fPrefix
			& get j$
			& lcase(j$)
		endif
		& getinfo j$ + i$, info$
		if info$ > "" then
			found = TRUE
			i$ = j$ + i$
			return
		endif
		p = q1
	until p > q2
return


#include <proline/proline.lib>
#include <proline/getopt.lib>
#include <proline/access.lib>
