' ======================================================================
'
' vedit.b	Visual Editor for ProLine
'		(C)opyright 1994 Morgan Davis
'
' Revision History:
'
' 11nov89 mwd	Creation
' 24dec89 mwd	Added RAM freespace checking during file loading
' 16apr90 mwd	Changed ESC-S to Save and exit.
'		Added rudimentary word wrap.
'		Fixed bug in pressing RETURN after first line of new file.
' 23sep90 mwd	Fixed unbound control-key (err 53) bug.
'		Added safety net (save modified buffer) if fatal error
'		Fixed SuperUser security toggle for application usage.
'
' 04jan91 mwd	Work done on word-wrap.  Fixed bug in appending file to
'		empty buffer which caused vedit to forgot about the
'		invoked file's name.
'
' 12apr91 mwd	Added emul support for Heath19's lack of char insert
' 30jul91 mwd	Fixed bug in Quit when user saved changes and the session
'		involved appending a file.  Changes would be saved to the
'		appended file!  (nasty bug)
' 03aug91 mwd	Added help screens.
' 09aug91 mwd	CR didn't set modified flag.
' 23aug93 dig	Fixed bug involving displaying lines exactly 80 chars wide
'		Improved scrolling routines to take advantage of ioctl
'		routines instead of replying on DrawTextWindow
' 24aug93 dig	Fixed logic bug in deleting ^M at end of 3rd-to-last line
' 15sep93 dig	Added TAB character support
' 28sep93 mwd	Fixed $-ended line printing, improved modeline, info command
'
' ======================================================================

#define	IDENT_PROG "vedit"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "20jan94"
#define	IDENT_NAME "Morgan_Davis"

#include <ctype.h>
#include <basic.h>
#include <prodos.h>
#include <appleio.h>
#include <errors.h>
#include <proline/proline.h>

#define	FIRSTLINE	1
#define	LASTLINE	20
#define	STATLINE	21
#define	MSGLINE		22
#define	PAGEHEIGHT	19


	gosub AppInit
	if argc < 2 then
		print "Usage: "argv$[0]" file"
		goto Exit
	endif
	
	&ioctl (ioDeleteLine),ttyDelLine%	' Check for various emulation
	&ioctl (ioInsertChar),ttyInsChar%
	&ioctl (ioInsertOn),ttyInsMode%
	
	' Quit if certain capabilities are not present
	
	if not ttyDelLine% or not (ttyInsChar% or ttyInsMode%) then
		&print argv$[0] ": current terminal unsupported (try ansi or vt102)"
		goto Exit
	endif
	
	if not ttyInsChar% then
		insertCode = ioInsertOn
	else
		insertCode = ioInsertChar
	endif
	
	&int stop
	
	fFre
	maxlines% = fre(0) / 40 	' Roughly calculate maximum lines
	dim line$[maxlines% + 1]
	
	screenTop	= FIRSTLINE	' First row of text editing window
	lines		= 0		' Lines in buffer
	quitting	= FALSE
	modified	= FALSE

	scrollLines%	= 11
	truetab		= FALSE
	overstrike	= FALSE
	wordwrap	= TRUE
	wrapcolumn	= 78
	
	Wait$ = "Wait..."
	help$ = "  (ESC-? for help)"
	cmd$ = "^M^H^U^K^J^?^[^L^A^E^D^O^Y^X^P^N^W^T^B^G^I^F"
	
	HelpFile$ = HELP_PATH + "vedit"
	theFile$ = argv$[1]
	file$ = theFile$
	gosub DrawScreen
	gosub CheckReadAccess
	if AccOK then
		gosub ResetPointers
		gosub AppendFile
		gosub EditTheFile
	endif

VeditExit:
	&ioctl (ioGotoXY, 0, STATLINE + 1)
	print
	&int on
goto Exit

EditTheFile:
	line$ = line$[lineY]
	&ioctl (ioGotoXY, x, y)
	repeat
		get teKey$
		if msg then
			gosub ClearMessage
			&ioctl (ioGotoXY, x, y)
		endif

		ch = asc(teKey$)			
		if ch = 27 then		' translate incoming ANSI codes
			i = 0
			repeat
				& fn fnScanInput, j
				i = i + 1
			until j or i = 20
			if j = 91 then
				i = 0
				repeat
					& fn fnScanInput, j
					i = i + 1
				until j or i = 20
				if j then
					& pos ("ABCD", chr$(j)), j
					ch = asc(mid$("^[^K^J^U^H", j + 1))
					teKey$ = chr$(ch)
				endif
			endif
		endif

		if isprint(ch) then
			modified = TRUE
		 	if len(line$) <= wrapcolumn then
				line$ = mid$(line$, 1, lineX - 1) + teKey$ + \
					mid$(line$, lineX + overstrike)
				if not overstrike then &ioctl (insertCode)
				& print teKey$;
				if not overstrike and not ttyInsChar% then
					& ioctl (ioInsertOff)
				endif
				line$[lineY] = line$
				lineX = lineX + 1
				if wordwrap and len(line$) > wrapcolumn then
					gosub WrapWords
				endif
			gosub FindX
			line$ = line$[lineY]
			endif
		else
			&pos (cmd$, teKey$), cmd
			if cmd then
				line$[lineY] = line$
				on cmd gosub CR, Left, Right, Up, Down, \
					Delete,	Utilities, RefreshScreen, \
					StartOfLine, EndOfLine, DeleteForward,\
					OverToggle, DeleteEOL, EraseLine, \
					PrevScreen, NextScreen, WrapToggle, \
					BufferTop, BufferBottom, GetKillLine,\
					InsertTab, TabToggle
				&ioctl (ioGotoXY, x, y)
				line$ = line$[lineY]
			endif
		endif
	until quitting
return


WrapWords:
	if lineY = maxlines% then return
	origY = lineY
	origX = lineX
	&pos right$ (wrapcolumn, line$[lineY], " "), wp
	if wp then
		wrap$ = mid$(line$[lineY], wp + 1)
		line$[lineY] = mid$(line$[lineY], 1, wp - 1)
		&ioctl(ioGotoXY, wp, y)
		gosub ClearRight
		gosub EndOfLine
		if not lines or (lineY = lines) then
			gosub CR
		else
			gosub Right
		endif
		&ioctl (ioGotoXY, x, y)
		if line$[lineY] > "" then
			a$ = " "
		else
			if lineY < lines then
				gosub CR
				gosub Up
			endif
			a$ = ""
		endif
		textLine$ = wrap$ + a$
		gosub InsertTextLine
		if origX < wp then
			gosub Up
			lineX = origX
		else
			lineX = origX - wp
		endif
		x = lineX - 1
		&ioctl (ioGotoXY, x, y)
	endif
return


Utilities:
	msg$ = "Command (? for help): "
	gosub WriteMessage
	get a$
	&ucase (a$)
	&pos ("NSWAFRIQH?/", a$),p
	gosub ClearMessage
	on p goto NewFile, SaveFile, WriteNewFile, ReadToBufEnd, Find, \
		Replace, BufInfo, Quit, Help, Help, Help
return

Help:
	gosub DrawScreen
	& ioctl (ioGotoXY, 0, screenTop)
	fOpen HelpFile$
	fRead HelpFile$
	repeat
		& get a$
		if a$ <> "$" then
			if a$ = "." then
				fFre
				msg$ = "--More--"
				gosub WriteMessage
				get a$
				gosub DrawScreen
				& ioctl (ioGotoXY, 0, screenTop)
				fRead HelpFile$
			else
				& print a$
			endif
		endif
	until a$ = "$"
	fClose
	msg$ = "--End--"
	gosub WriteMessage
	get a$
goto RefreshScreen


GetPattern:
	gosub WriteMessage
	&read (-40, pattern$), pattern$
	searchX = lineX + (pattern$ = oldPattern$)
	searchY = lineY
	oldPattern$ = pattern$
return

Replace:
	a$ = "Replace"
	msg$ = a$ + ": "
	gosub GetPattern
	msg$ = a$ + " [" + pattern$ + "] with: "
	gosub WriteMessage
	&read (-40, replace$), replace$
	occurences = 0
	&rept
		gosub search
		if found then
			line$[searchY] = mid$(line$[searchY], 1, searchX - 1) +\
				replace$ + \
				mid$(line$[searchY], len(pattern$) + searchX)
			occurences = occurences + 1
			searchX = searchX + len(replace$)
		endif
	&until (not found)
	if occurences then
		gosub findReposition
		if not i% then gosub DrawTextWindow
		modified = TRUE
	endif
	msg$ = a$ + "d " + str$(occurences)
goto WriteMessage

Find:
	msg$ = "Find: "
	gosub GetPattern
	gosub showSearch
	if found then
		gosub findReposition
	else
		msg$ = "Not found"
		goto WriteMessage
	endif
return

findReposition:
	y = y + (searchY - lineY)
	lineY = searchY
	lineX = searchX
	x = lineX - 1
	i% = y > LASTLINE
	if i% then
		i% = PAGEHEIGHT / 2
		topLine = lineY - i%
		y = screenTop + i%
'		y = screenTop + (lineY - topLine) + 1
		gosub DrawTextWindow
	endif
return

showSearch:
	msg$ = "Searching..."
	gosub WriteMessage
	gosub search
goto ClearMessage

search:
	found = FALSE
	for i = searchY to lines
		&pos (searchX, line$[i], pattern$), searchX
		if searchX then
			found = TRUE
			searchY = i
			i = lines
		else
			searchX = 1
		endif
	next
return

QuitSave:
	if modified then
		msg$ = "Save changes? "
		gosub GetResponse
		if Yes then gosub SaveFile
	endif
return

Quit:
	gosub QuitSave
	quitting = TRUE
return

BufInfo:
	msg$ = Wait$
	gosub WriteMessage
	fFre
	a$ = line$[lineY]
	if lineX > len(a$) then
		i = 13
	else
		i = asc(mid$(a$, lineX))
	endif
	gosub FindX
	msg$ = "Line " + \
		str$(lineY) + "/" + str$(lines) + "/" + str$(maxlines%) + \
		", Col " + str$(x) + "/" + str$(len(a$)) + \
		", Char " + str$(i) + ", Free " + str$(fre(0))
goto WriteMessage

BufferTop:
	lineY = 1
	topLine = 1
	y = screenTop
	gosub StartOfLine
goto DrawTextWindow

BufferBottom:
	lineY = lines
	i% = lines - PAGEHEIGHT
	if i% < 1 then
		y = topLine + lines - 1
	else
		topLine = i%
		y = LASTLINE
		gosub DrawTextWindow
	endif
goto EndOfLine

PrevScreen:
	i% = lineY = topLine
	if i% then
		if (topLine - PAGEHEIGHT) < 1 then goto BufferTop
		topLine = topLine - PAGEHEIGHT
	endif
	lineY = topLine
	y = screenTop
	if i% then gosub DrawTextWindow
goto FixX

NextScreen:
	i% = y = LASTLINE
	if i% then
		lineY = lineY + PAGEHEIGHT
		topLine = lineY - PAGEHEIGHT
	else
		lineY = lineY + (LASTLINE - y)
	endif
	if lineY > lines then goto BufferBottom
	y = LASTLINE
	if i% then gosub DrawTextWindow
goto FixX

WrapToggle:
	wordwrap = not wordwrap
goto UpdateStatus

OverToggle:
	overstrike = not overstrike
goto UpdateStatus

TabToggle:
	truetab = not truetab
goto UpdateStatus

Delete:
	if lineX = 1 and lineY = 1 then return
	if lineX = 1 then
		a$ = line$[lineY]
		gosub DeleteLine
		if lineY < Lines then gosub Left
		line$[lineY] = line$[lineY] + a$
		goto ReDrawLine
	else
		if len(line$[lineY]) then
			gosub Left
			&ioctl (ioGotoXY, x, y)
		endif
	endif
	
DeleteForward:
	llen = len(line$[lineY])
	modified = TRUE
	if llen then
		if lineX > llen
			if lineY < lines
				gosub Right
				goto Delete
			endif
		else
			&ioctl (ioDeleteChar)
			c = asc(mid$(line$[lineY], lineX, 1))
			line$[lineY] = mid$(line$[lineY], 1, lineX - 1) + \
				mid$(line$[lineY], lineX + 1)
			if c = cTab then
				gosub FindX
				gosub RedrawLine
			endif
		endif
	else
		if lineY < lines then gosub DeleteLine
	endif
	if llen > 79 then goto ReDrawLine
return

DeleteLine:
	if lines then
		modified = TRUE
		gosub StartOfLine
		if y < LASTLINE then
			&ioctl (ioDeleteLine)
			&ioctl (ioGotoXY, 0, LASTLINE)
			&ioctl (ioInsertLine)
		endif
		lines = lines - 1
		if line$[lineY] > "" then killLine$ = line$[lineY]
		for i = lineY to lines
			line$[i] = line$[i + 1]
		next
		line$[lines + 1] = ""
		index = topLine + LASTLINE - screenTop
		if index <= lines then
			&ioctl (ioGotoXY, 0, LASTLINE)
			& print line$[index];
		endif
		if lineY > lines then
			gosub Up
			gosub EndOfLine
		endif
	endif
return

EraseLine:
	' do nothing if at bottom of buffer
	if lineY = lines and line$[lineY] = "" then return

	' do the whole line
	gosub StartOfLine
DeleteEOL:
	if line$[lineY] = "" then goto DeleteLine
TruncEOL:
	modified = TRUE
	gosub ClearRight
	if mid$(line$[lineY], lineX) > "" then
		killLine$ = mid$(line$[lineY], lineX)
	endif
	line$[lineY] = mid$(line$[lineY], 1, lineX - 1)
return


StartOfLine:
	x = 0
	lineX = 1
	&ioctl (ioGotoXY, x, y)
return

GetKillLine:
	if killLine$ = "" then return
	textLine$ = killLine$
goto InsertTextLine

InsertTab:
	if truetab then
		textLine$ = chr$(cTab)
	else
		i% = lineX
		textLine$ = " "
		&rept
			textLine$ = textLine$ + " "
			i% = i% + 1
		&until (i% / 8 = int(i% / 8))
	endif
	gosub InsertTextLine
	if wordwrap and len(line$[lineY]) >= wrapcolumn then goto WrapWords	
return

InsertTextLine:
	line$[lineY] = mid$(line$[lineY], 1, lineX - 1) + textLine$ +\
			mid$(line$[lineY], lineX)
	gosub ReDrawLine
	lineX = lineX + len(textLine$)
	gosub FindX
return

CR:	if lines >= maxlines% then
		msg$ = "Buffer full!"
		gosub WriteMessage
		&ioctl (ioBeep)
		return
	endif

	modified = TRUE
	lines = lines + 1 + (not lines)
	part$ = mid$(line$[lineY], lineX)
	trunc = lineX > 1
	if trunc then
		gosub TruncEOL
		&ioctl (ioDown)
	else
		line$[lineY] = ""
	endif

	&ioctl (ioCR)
	if y < LASTLINE then
		&ioctl (ioInsertLine)
		&ioctl (ioGotoXY, 0, STATLINE)
		&ioctl (ioDeleteLine)
	endif
	for i = lines to lineY + 1 step -1
		line$[i] = line$[i - 1]
	next
	line$[lineY + 1] = part$
	gosub StartOfLine
	gosub Down
	if trunc then
		& print part$;
	endif
return

Down:
	if lineY < lines then
		lineY = lineY + 1
		if y < LASTLINE then
			y = y + 1
		else
			&ioctl(ioGotoXY, 0, STATLINE)
			&ioctl(ioDeleteLine)
			topLine = topLine + ScrollLines%
			p = scrollLines%
			c = ioDeleteLine
			index = LineY
			gosub scrollGap
		endif
	else
		gosub EndOfLine
	endif
goto FixX

Up:
	if lineY > 1 then
		lineY = lineY - 1
		y = y - 1
		if y < screenTop then
			p = topLine
			topLine = topLine - ScrollLines%
			if topLine < 1 then topLine = 1
			p = p - topLine
			c = ioInsertLine
			index = topLine
			gosub ScrollGap
		endif
	else
		gosub StartOfLine
	endif
FixX:
	if lineX >= len(line$[lineY]) then
		gosub EndOfLine
	endif
	gosub FindX
	&ioctl (ioGotoXY, x, y)
return

ScrollGap:
	y = (lineY - topLine) + screenTop
	&ioctl (ioGotoXY, 0, screenTop)
	for i = 1 to p
		&ioctl(c)
	next
	if c = ioDeleteLine then &ioctl(ioGotoXY, 0, y)
	for i = 1 to p
		gosub DrawIndexedLine
		if i < p then
			&print
			index = index + 1
		endif
	next
	&ioctl (ioGotoXY, 0, MSGLINE)
	&ioctl (ioClearEOS)
goto UpdateStatus

Left:
	if lineX > 1 then
		LineX = LineX - 1
		gosub FindX
	else
		if lineY > 1 then
			gosub Up
			gosub EndOfLine
		endif
	endif
return

Right:
	if lineX <= len(line$[lineY]) then
		lineX = lineX + 1
		gosub FindX
	else
		if lineY < lines then
			gosub Down
			gosub StartOfLine
		endif
	endif
return
	
DrawTextWindow:
	gosub FixX
	for i = screenTop to LASTLINE
		&ioctl (ioGotoXY, 0, i)
		index = topLine + i - screenTop
		gosub DrawIndexedLine
	next
return

ReDrawLine:
	index = LineY
	&ioctl (ioGotoXY, 0, y)
DrawIndexedLine:
	if len (line$[index]) > 79
		& print left$(line$[index], 79)"$^H";
	else
		& print line$[index];
		&ioctl (ioClearEOL)
	endif
return


RefreshScreen:
	gosub DrawScreen
goto DrawTextWindow


DrawScreen:
	&ioctl (ioClearScreen)

UpdateStatus:
	& left$("== " IDENT_PROG " " IDENT_VERS " == Modes: " + \
		chr$($6F - overstrike * 32) + \
		chr$($74 - truetab * 32) + \
		chr$($77 - wordwrap * 32) + \
		" == File: " + theFile$ + " ", 80, $3D), i$
	&ioctl (ioGotoXY, 0, STATLINE)
	&ioctl (ioInverse)
	&print i$; : i$ = ""
	&ioctl (ioNormal)
goto ClearRight


EndOfLine:
	lineX = len(line$[lineY]) + 1

FindX:				' Correctly sets cursor x coordinate based 
	x = 0			' on LineX, accounting for TABs.
	strpos = 0
FindX2:
	&pos(strpos + 1, line$[lineY], chr$[cTab]), tabpos
	if tabpos => lineX then tabpos = 0
	if tabpos then
		x = int((x + tabpos - strpos + 7) / 8) * 8 
		strpos = tabpos
		goto FindX2
	endif
	x = x + LineX - strpos - 1
	if x > 79 then x = 79
return


' ==============================
' Write Buffer to File
' ==============================

SaveFile:
	if theFile$ > "" then
		quitting = TRUE
		if modified then
			file$ = theFile$
			gosub WriteBuffer
		endif
		return
	endif
'''
WriteNewFile:
	msg$ = "Write to: "
	gosub WriteMessage
	&read (-64, theFile$), file$
	&spc (file$), theFile$
	if file$ <> theFile$ then SuperUser = ID$[uGID] = "0"
	if theFile$ = "" then return
	gosub UpdateStatus
	file$ = theFile$
'''
WriteBuffer:
	&getinfo file$, I$
	errCode = peek(_ERRNUM)
	AccFile$ = file$
	if I$ > "" then
		type = asc(mid$(I$,5))
		AccMode = accWrite + accDestroy
	else
		type = 4
		AccMode = accWrite
	endif
	gosub CheckAccess
	if not AccOK or \
		(type <> 4 and type <> 240) or \
		(errCode = SyntaxErr) or \
		(errCode = NoSuchPathErr) then
		msg$ = "Can't write to " + file$ + "!"
		quitting = FALSE
		goto WriteMessage
	endif
	msg$ = "Writing..."
	gosub WriteMessage

	if AccMode = accWrite then
		fCreate file$",t"type
	endif
	fOpen file$",t"type
	fWrite file$
	for i = 1 to lines
		print line$[i]
	next

	fFlush file$
	poke _SREFNUM, peek(_OREFNUM)
	& MLI (_GET_MARK, _SSETEOF), errCode
	& MLI (_SET_EOF, _SSETEOF), errCode
	fClose
	msg$ = "[Wrote " + str$(lines + not lines) + " lines]"
	modified = FALSE
goto WriteMessage

GetResponse:
	gosub WriteMessage
	&rept
		get a$
		&ucase (a$)
	&until (a$ = "Y" or a$ = "N")
	Yes = a$ = "Y"
goto ClearMessage

' ==============================
' Append file to end of buffer
' ==============================

NewFile:
	if lines then
		gosub QuitSave
		msg$ = Wait$
		gosub WriteMessage
		for i = 1 to lines
			line$[i] = ""
		next
		lines = 0
		fFre
		gosub ResetPointers
		gosub DrawTextWindow
	endif
	theFile$ = ""
	file$ = ""
'''
ReadToBufEnd:
	msg$ = "Filename: "
	gosub GetFileName
	if not AccOK then return
'''
AppendFile:
	fFre
	modified = lines > 0

	if fileInfo$ = "" then
		msg$ = "New file." + help$
		goto WriteMessage
	endif

	msg$ = "Reading " + file$ + "..."
	gosub WriteMessage

	if theFile$ = "" then theFile$ = file$

	onerr goto hitEOF
	fOpen file$",t"type
	fFre
	fRead file$
	i = fre(0) - 256
	while i > 0
		lines = lines + 1
		&get line$[lines]
		i = i - len(line$[lines]) - 3
	wend
	errCode = 0
	goto noEOFerr

    hitEOF:
	&onerr errCode, lineNum
    noEOFerr:
	onerr goto FatalError
	fClose
	lines = lines - 1
	if errCode = EOFErr then
		msg$ = str$(lines) + " lines." + help$
	else
		msg$ = "Can't read it all!^G" + help$
		&ioctl (ioBeep)
		theFile$ = ""
	endif
	gosub UpdateStatus
	gosub WriteMessage
goto DrawTextWindow

ClearMessage:
	msg$ = ""
'''
WriteMessage:
	&ioctl (ioGotoXY, 0, MSGLINE)
	print msg$;
	msg = msg$ > ""
'''
ClearRight:
	&ioctl (ioClearEOL)
return

ResetPointers:
	topLine = 1			' Line of text at top of screen
	lineY = topLine			' Current line being edited
	lineX = 1			' Current character position
	y = topLine			' Current Y cursor position
	x = 0				' Current X cursor position
return

' ============================================================
' CheckReadAccess -- Checks for read permission on theFile$
'	returning result in AccOK.  Also checks file type for
'	TXT or CMD, as well as non-random access text file types.
' ============================================================

GetFileName:
	gosub WriteMessage
	&read (64), a$
	if a$ <> file$ then SuperUser = ID$[uGID] = "0"
	file$ = a$
'''
CheckReadAccess:
	AccMode = accRead
	AccFile$ = file$
	gosub CheckAccess
	&getinfo file$, fileInfo$
	if AccOK and fileInfo$ > "" then
		if peek (_ERRNUM) = SyntaxErr
			AccOK = FALSE
		else
			type = asc(mid$(fileInfo$,5))
			AccOK = (type = 4 or type = 240) and \
				not (asc(mid$(fileInfo$,6)) + \
				asc(mid$(fileInfo$,7)))
		endif
	endif
	if not AccOK then
		msg$ = "Can't edit " + file$
		gosub WriteMessage
	endif
return


FatalError:
	& pop
	fClose
	msg$ = "^GFatal error " + str$(ERR) + " @ " + str$(ERL)
	gosub WriteMessage
	& get (0), ", press RETURN "
	gosub QuitSave
	print
goto VeditExit

#include <proline/proline.lib>
#include <proline/access.lib>
