' ************************************************************************
' **									**
' **  tail.b 		Deliver the last part of a file			**
' **			(C)opyright 1992 Morgan Davis Group		**
' **									**
' ** When    Who Ver	What						**
' ** ======= === ======	==============================================  **
' ** 26sep90 mwd 1.0	Created.					**
' **									**
' ************************************************************************

#define IDENT_PROG "tail"
#define IDENT_VERS "1.0"
#define IDENT_DATE "26sep90"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <prodos.h>
#include <proline/proline.h>

#define	searchBack	$300

#define	LINE_UNIT	1
#define	BLOCK_UNIT	2
#define	CHAR_UNIT	3

#define	FROM_END	1
#define	FROM_START	2


' ====================
' Tail
' ====================

	gosub AppInit
	if argc < 2 or argc > 4 then
		print "Usage: " argv$[0] " [+-number[unit]] file"
		goto Exit
	endif

	size[BLOCK_UNIT] = 512
	size[CHAR_UNIT] = 1
	
	count = 10
	unit = LINE_UNIT
	offset = FROM_END
	repeat
		theFile$ = argv$[argc - 1]
		if asc(theFile$) = 62 then
			outfile$ = mid$(theFile$, 2)
			& getinfo outfile$, i$
			AccFile$ = outfile$
			AccMode = accWrite + (accDestroy * (i$ > ""))
			gosub CheckAccess
			if not AccOK then
				print argv$[0] ": can't access " theFile$
				goto Exit
			endif
			if i$ > "" then fDelete outfile$
			argc = argc - 1
		endif
	until asc(theFile$) <> 62

	if argc = 3 then
		& pos ("-+", left$(argv$[1], 1)), i
		if i then
			offset = i
			i = val(mid$(argv$[1], 2))
			if i then count = i
			& pos ("lbc", right$(argv$[1], 1)), i
			if i then unit = i
		endif
	endif

	& GETINFO theFile$, i$
	if i$ = "" then
		print argv$[0] ": " theFile$ " not found"
		goto Exit
	endif

	AccFile$ = theFile$
	AccMode = accRead
	gosub CheckAccess
	if not AccOK then
		print argv$[0] ": can't access " theFile$
		goto Exit
	endif
	
	fOpen theFile$ ",t" asc(mid$(i$, 5))
	poke _SREFNUM, peek(_OREFNUM)
	& MLI (_GET_EOF, _SGETEOF), i
	bytes = peek24(_SEOF)

	if unit = LINE_UNIT then
		if offset = FROM_START then
			fRead theFile$ ",F" count
		else
			& poke searchBack, \
				$AC,$DB,$BE, \
				$88, \
				$B9,$00,$02, \
				$C9,$0D, \
				$F0,$03, \
				$98, \
				$D0,$F5, \
				$8C,$DB,$BE, \
				$60

			poke _RWREFNUM, peek(_OREFNUM)
			poke16 (_RWDATA, $200)
			poke24 (_RWCOUNT, $100)
			seek = bytes
			count = count + 1
			repeat
				seek = seek - $100
				if seek < 0 then
					poke24 (_RWCOUNT, abs(seek))
					seek = 0
				endif
				gosub setSeek
				& MLI (_READ, _SREAD), i
				repeat
					call searchBack
					i = peek(_RWTRANS)
					if i then count = count - 1
				until not count or not i or not seek
			until not count or not seek
			if count then
				seek = 0
			else
				seek = seek + i + 1
			endif
			gosub setSeek
		endif
	else
		seek = count * size[unit]
		if offset = FROM_END then seek = bytes - seek
		if seek < 0 then seek = 0
		gosub setSeek
	endif
	gosub printFile
goto Exit

setSeek:
	poke24 (_SMARK, seek)
	& MLI (_SET_MARK, _SSETMRK), seekErr
return

printFile:
	onerr goto fileEOF
	if outfile$ = "" then
		fRead theFile$
		do
			& get a$
			& print a$
		loop
	else
		fOpen outfile$
		do
			fRead theFile$
			& get a$
			fWrite outfile$
			& spc (a$, 4), a$
			print a$
		loop
	endif
	fileEOF:
	& onerr
	fClose
return
	
#include <proline/proline.lib>
#include <proline/access.lib>
