' ************************************************************************
' **
' **  sweep.b		File utility
' **			(C)opyright 1994 Morgan Davis Group
' **
' ** When    Who Ver	What
' ** ======= === ======	==============================================
' ** 02nov93 mwd 2.0	Converted to MD-BASIC
' **
' ************************************************************************

#define	IDENT_PROG "sweep"
#define	IDENT_VERS "2.0"
#define	IDENT_DATE "2nov93"
#define	IDENT_NAME "Morgan_Davis"

#include <proline/proline.h>

#define	MAX_FILES	500

	gosub AppInit

	var$	= TEMP_PATH + "sweep.tmp"
	
	& on int goto sweep_interrupt
	onerr goto sweepError

	if ReturnFlag% then
		& getinfo var$, i$
		if i$ > "" then
			fRestore var$
			fDelete var$
			goto returnFromLaunch
		endif
	endif

	dim er$[21], f$[MAX_FILES], f%[MAX_FILES]

	tagmark$[0]	= ":"
	tagmark$[1]	= "*"

	sortFlag%	= TRUE

	warn$[0]	= ""
	warn$[1]	= " tagged files"

	cmdKeys$	= "+t^Tu^Udcmvap-er^Plq?sn"
	noFiles$	= "^Plq?sn"
	
	cmd$[0]		= "delete"
	cmd$[1]		= "lock"
	cmd$[2]		= "unlock"

	er$[4]		= "Write protected"
	er$[6]		= "Path not found"
	er$[7]		= "File not found"
	er$[8]		= "I/O error"
	er$[9]		= "Disk full"
	er$[10]		= "File locked"
	er$[17]		= "Directory full"
	er$[20]		= "File busy"

	if argc > 1 then 
		& getinfo argv$[1],i$
		if i$ > "" then
			if asc(mid$(i$,5)) = 15 then fPrefix argv$[1]
		endif
	endif

	gosub doHelp
	
reloadDir:
	fPrefix
	& get dir$
	& lcase(dir$)
	fPrefix dir$

	print "Location: "dir$;
	& tfiles(dir$, f$, , vis_and_invis), f
	print " -- "f" files."
	if sortFlag% then & sort(f$,f)

cleanList:
	if f then
		for i = 1 to f
			f%[i] = FALSE
			if right$(f$[i],1) = "*" then 
				f$[i] = left$(f$[i], len(f$[i]) - 1)
			endif
			& lcase(f$[i])
		next 
		tagged = 0
	endif

topLevel:
	p = 1

sweep_interrupt:
	& pop 
	print 

	do
		if not f then 
			print "No files, now what? ";
		else
			print spc(3 - len(str$(p))) p ": " f$[p] \
				spc(17 - len(f$[p])) tagmark$[f%[p]] " ";
		endif
		get a$
		& lcase(a$)
		& pos (cmdKeys$, a$),q
		if not q then q = 1
		if not f then
			& pos(noFiles$, a$), i
			if not i then
				print "?"
				q = 0
			endif
		endif
		on q gosub doNext,doTag,doTagAll,doUntag,doUntagAll,\
			doDelete,doCopy,doMove,doView,doAttrs,\
			doPrev,doPrev,doEdit,doRename,doPrevDir,\
			doLocation,doQuit,doHelp,doSort,doNewDir
	loop

' ===== help =====

doHelp:
	& ioctl(ioClearScreen)
	print IDENT_PROG " version " IDENT_VERS
	print 
	print "^I A:  attributes"
	print "^I C:  copy"
	print "^I D:  delete"
	print "^I E:  edit"
	print "^I L:  change location"
	print "^I M:  move"
	print "^I N:  new directory"
	print "^I P:  previous file (^~P = previous directory)"
	print "^I Q:  quit"
	print "^I R:  rename file"
	print "^I S:  sorting"
	print "^I T:  tag file (^~T = tag all)"
	print "^I U:  untag file (^~U = untag all)"
	print "^I V:  view file"
	print "^I ?:  this list"
	print "^I(any other key = next file)"
	print
	& page clear
return

' ===== new dir =====

doNewDir:
	& read (-15), "new directory: ", AccFile$
	if AccFile$ > "" then
		accMode = accWrite
		gosub testAccess2
		fCreate AccFile$
		print
		goto reloadDir
	endif
return


' ===== ren =====

doRename:
	if not tagged then 
		f%[p] = TRUE
	else
		print 
		print 
	endif
	for i = 1 to f
		if f%[i] then 
			on tagged > 1 gosub copyProgress
			& read (15),"rename: ", AccFile$
			if AccFile$ > "" then
				accMode = accDelete + accWrite
				gosub testAccess2
				fRename f$[i] "," AccFile$
			endif
		endif
	next
	print 
goto reloadDir


' ===== sort =====

doSort:
	print a$
	sortFlag% = not sortFlag%
	print
goto reloadDir


' ===== next =====

doNext:
	print "+"
doNext2:
	p = p + 1
	if p > f then 
		p = 1
		print 
	endif
return 


doPrev:
	print "-"
	p = p - 1
	if p < 1 then 
		p = f
		print 
	endif
return 


' ===== prev dir =====

doPrevDir:
	& < dir$,i$
	& read (-64,i$), "previous: ",f$
goto changeDir


'  ===== Tag =====

doTag:
	tagged = tagged + not f%[p]
	f%[p] = TRUE
goto showTag


' ===== Tag all =====

doTagAll:
	a$ = "t"
	for i = 1 to f
		f%[i] = TRUE
	next 
	tagged = f
goto showTag


' ===== untag =====

doUntag:
	tagged = tagged - f%[p]
	f%[p] = FALSE

showTag:
	& hlin 2, 8
	print tagmark$[f%[p]] " " a$ " (" tagged " tagged)"
goto doNext2


' ===== Untag all =====

doUntagAll:
	a$ = "u"
	for i = 1 to f
		f%[i] = FALSE
	next 
	tagged = 0
goto showTag


' ===== attributes =====

doAttrs:
	print "attributes"warn$(tagged > 0)": L)ock or U)nlock? ";
	get a$
	& lcase(a$)
	print a$
	& pos ("lu",a$),cmd
	on not cmd goto topLevel
goto doCmd


' ===== delete =====

doDelete:
	cmd = 0
	print "delete" warn$[tagged > 0] "? ";
	gosub getYN
	if not y then 
		print 
		return 
	endif

doCmd:
	print 
	if not tagged then f%[p] = TRUE
	AccMode = accWrite + accDestroy
	gosub testAccess
	
	for i = 1 to f
		if f%[i] then
			gosub copyProgress
			i$ = cmd$[cmd]
			print "^D" i$ dir$ f$[i]
			print i$
		endif
	next 
	print 
	if not tagged then f%[p] = FALSE
	if not cmd then
		print
		goto reloadDir
	endif
return 

testAccess:
	AccFile$ = dir$ + f$[1]
testAccess2:
	gosub CheckAccess
	if not accOK then
		print "Error: access denied"
		pop
		goto cleanList
	endif
return


' ===== copy =====

doCopy:
	m$ = "copy"
	mv = FALSE

doCpMv:
	print m$ warn$[tagged > 0] " to: ";
	& read (64), trg$
	if trg$ = "" then return 
	ap = TRUE
	nu = FALSE
	& lcase(trg$)
	& getinfo trg$,i$
	if i$ = "" then 
		e = peek (222)
		on e < > 7 goto showError
		ap = FALSE
		& pos (trg$,"/"),nu
		nu = not nu
		if tagged then
			print "Error: target directory does not exist"
			return
		endif
	else
		t = asc(mid$(i$,5))
		if t < > 15 then 
			if tagged then 
				print "Not a directory."
				return 
			endif
			ap = FALSE
			print "Overwrite "trg$"? ";
			gosub getYN
			if not y then 
				print 
				return 
			endif
		endif
	endif

	if right$ (trg$,1) < > "/" then trg$ = trg$ + "/"
	if not tagged then f%[p] = TRUE
	for i = 1 to f
		if f%[i] and right$(f$[i], 1) <> "/" then
			if ap then
				f$ = trg$ + f$[i]
			else
				f$ = trg$
			endif
			if tagged > 0 then 
				print 
				gosub copyProgress
				print f$" ";
			endif
			accMode = accRead + (accDelete * mv)
			gosub testAccess
			AccFile$ = f$
			accMode = accWrite + (accDelete * not ap)
			gosub testAccess2
			& copy(dir$ + f$[i] to f$)
			if mv then fDelete dir$ f$[i]
		endif
	next 
	print 
	if not tagged then f%[p] = FALSE
	if mv or nu then
		print
		goto reloadDir
	endif
return 


' ===== move =====

doMove:
	m$ = "move"
	mv = TRUE
goto doCpMv


' ===== view =====

doView:
	print a$
	accMode = accRead
	gosub testAccess
	if not tagged then
		i = p
		gosub showFile
	else
		for i = 1 to f
			if f%[i] then gosub showFile
		next 
	endif
	print 
return 

showFile:
	print 
	print "["f$(i)"]"
	& list dir$ + f$[i]
return


' ===== location =====

doLocation:
	& read (64),"location: ",f$
	if f$ = "" then 
		f$ = f$[p]
		& / dir$ + f$,i$
		if asc(mid$(i$,5)) < > 15 then return 
	endif

changeDir:
	fPrefix f$
	print
goto reloadDir


getYN:
	& rept
		get a$
		& lcase(a$)
	& until(a$ = "y" or a$ = "n")
	y = a$ = "y"
	print a$
return 


copyProgress:
	print spc(3 - len(str$(i))) i ": " f$[i] spc(17 - len(f$[i]))"-> ";
	& page clear 
return 


sweepError:
	& onerr e,l
showError:
	if e < 21 then
		i$ = er$[e]
	else
		i$ = str$(e) + "@" + str$(l)
	endif
	print "Error: " i$
	if e and e < 22 then goto cleanList
goto ExitError


' ===== quit =====

doQuit:
	print a$
goto Exit


' ===== edit =====

doEdit:
	print a$
	if not tagged then f%[p] = TRUE
	ed% = 0

	returnFromLaunch:
	while ed% < f then
		ed% = ed% + 1
		if f%[ed%] then 
			print "[editing " f$[ed%] "]"
			fStore var$
			System(ID$[uEditor] + " " + f$[ed%])
		endif
	wend
	if not tagged then f%[p] = FALSE
goto sweep_interrupt


#include <proline/proline.lib>
#include <proline/access.lib>
#include <proline/launch.lib>
