' **********************************************************************
' ***
' ***	stty.b		Set TTY options
' ***			(C)opyright 1994 Morgan Davis Group
' ***

#define IDENT_PROG "stty"
#define IDENT_VERS "1.3"
#define IDENT_DATE "28feb92"
#define	IDENT_NAME "Morgan_Davis"

#include <proline/proline.h>


	gosub AppInit

	cmd$ = "A:intr;B:nulls;C:lines;D:tabs;E:-tabs;F:0;"

	if argc > 1 then
		for arg = 1 to argc - 1
			a$ = argv$[arg]
			& pos (cmd$,":" + a$ + ";"),q
			if q then
				i = asc (mid$ (cmd$,q - 1)) - 64
				if i < 4 then
					if arg = argc - 1 then
						print argv$[0]": missing value for " a$
						goto Exit
					endif
					arg = arg + 1
					a$ = argv$[arg]
				endif
			endif
			on i gosub doIntr, doNulls, doLines, \
				doTabs, doTabs, Logout
		next
		goto Exit
	endif

	
	print "Usage: "argv$[0]" [options...]"
	print  "Options:"
	print  "	intr ^~C		cancel key is ^~C"
	print  "	nulls n		set n nulls after CR"
	print  "	lines n		set n lines per screen"
	print  "	tabs		preserve tabs"
	print  "	-tabs		expand tabs"
	print 
	print "Current settings:"

	& fn fnSpeed, connectSpeed
	& fn fnMode, connectMode

	cancelKey	= peek(sttyCancel)
	tabSupport	= peek(sttyTabs)
	nullCount	= peek(sttyNulls)

	s[bps300] = 300
	s[bps1200] = 1200
	s[bps2400] = 2400
	s[bps9600] = 9600
	s[bps19200] = 19200
	s[bps38400] = 38400

	n$[FALSE] = "-"
	m$[modeAns] = "answer"
	m$[modeOrig] = "originate"
	m$[modeQuiet] = "quiet (offhook)"
	print "^Iintr ^~" chr$ (cancelKey + 64)"; nulls " nullCount "; " \
		n$[not tabSupport]"tabs; " \
		s[connectSpeed]" bps; "m$[connectMode] " mode"
goto Exit
	
doIntr:
	i = asc(a$)
	if (i = 127 or (i > 0 and i < 32)) and i <> 8 and i <> 13 then
		poke sttyCancel, i
		& int = i
		& int on
	else
		print argv$[0]": bad intr choice"
		goto Exit
	endif
return 

doTabs:
	i = asc (a$) = 45
	& tab(i)
	poke sttyTabs,i
return 

doNulls:
	i = abs (val (a$))
	i = i * (i < 255)
	poke sttyNulls,i
	& nulls(i)
return 


doLines:
	i = abs (val (a$))
	if i and (i < 4) then 
		print argv$[0]": too few lines"
		goto Exit
	endif
	& page len i
	if i then 
		& page on 
	else
		& page stop
	endif
return 


#include <proline/proline.lib>
