' **********************************************************************
' ***
' ***	sendmail.b - Distributes mail to local and remote mailboxes
' ***	ProLine System Software Copyright (C) 1990 Morgan Davis Group
' ***
' **********************************************************************
'
' When    Ver	What
' ======= =====	========================================================
' 19apr90 1.1	Conversion to MD-BASIC
' 24apr90 1.2	Changed field parser to use a To: field if a Ppath: is
'		missing from a header.  A hack for a P-Net pmail bug.
' 21oct90 1.3	Complete redesign.  Handles domains correctly now.
'		No longer requires mail.o.  Optimized file management.
' 07nov90 1.4	Improved copy performance by creating 4K file i/o buffer.
' 18nov90 1.5	Created sendmail.rsrc handling (smart-host logic),
'		local site aliasing works, fixed domain parsing error for
'		bogus addresses that start with a period.
' 27nov90 1.6	Fixed bug in local domain vs. smart host handling.
' 21jan91 1.7	Added "~" (forced mailbox) feature
' 12feb91 1.8	Parses a%b@c to c!b!a	
' 11mar91 1.9	Correctly handles oddly mixed-formatted addresses
' 30apr91 2.0b1	Includes rmail logic to handle multiple From and >From
'		lines.  Does "From " protection in body of message when
'		mail is received for local delivery instead of doing it
'		when sending mail out.
' 30jul91 2.0	Fixed bug in trying to grab addresses from empty fields.
'		Non-OS fatal errors now bounce message to root.
'		Added a simple last-path-found address cache.
' 07aug91	Fixed bug in appending host name to From: address when
'		the address contained only bang-formatted paths
' 22aug91	Stamps local messages with Received: and Message-Id: fields.
' 26aug91	Reworked UnpackAddress to just alias % with @ (hmmm...)
' 12sep91 2.1	Removed UNIXNAMES support.  Fixed bug in saving original
'		file info when doing a BinaryPost.
' 25nov91 2.2	Added same-second sequencer to UniqueName.
'		Added progress reporting.  Added busyFlag% feature.
' 21feb92 2.3	Uses &PICKUP to make busy
' 24mar92	Searches $/adm directories for matching local deliveries
' 07jun93 2.3.1 Searches paths for site.domain entries
' 14sep93 2.3.2 Special cases rnews mailbox copies (&add), added
'		favorSmartHost% option to speed things up, max letter size
' 07dec93 2.4	Fixed bug in recognizing domain with period at end of address.
' 22jan94 3.0	IDENT update
' ______________________________________________________________________

#define	IDENT_PROG "sendmail"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "4mar94"
#define	IDENT_NAME "Morgan_Davis"

#define	SENDMAIL_VER	IDENT_PROG " " IDENT_VERS " " IDENT_DATE

#include <basic.h>
#include <prodos.h>
#include <proline/proline.h>

#define	RCP_STOP	"/rcpstop"
#define	LETTER_Q_SIZE	32
#define	TO_Q_SIZE	256
#define	TXT		4
#define	BIN		6
#define	IOBUF_SIZE	$1000
#define	IOBUFL		$00
#define	IOBUFH		$10


	' Volatile variables

#declare a$, argc, current, site$, user$, i, i$, p, q, info$, j, j$, k, k$
#declare domain$, errMsg$, fileType, find$, found, src, trg, letter$, siteDir$
#declare localUser, msgID$, msgFile$, numFiles, t$, recipient$, origCount
#declare remoteOrigin, returnAddress$, sf$, newPpath$, pathsExists, dirtest
#declare fromTime$, errCode, errLine, a1, a2, path$, mr$, skiplines, rcpinfo$
#declare fatalErrorFlag%, lastFind$, lastPath$, localID$, debugLevel%
#declare lastMsgID$, seq$, fnSeq, time$, index, entry$, busyFlag%, gotRsrc%
#declare actualFiles, favorSmartHost%, largestLetter, inForward%, ltrIndex%

	' Constant variables

#declare SysInfo$, From$, Host$, HostDomain$, FromArrow$, LetterQueue$
#declare PathsFile$, Ppath$, Quote$, SpoolMail$, SysMail$, MyDomain$
#declare ToQueue$, UseBangs, Root$, AliasFile$, argv$, SMVer$
#declare IOBuf%, ResourceFile$, SmartHost$

	gosub AppInit
	& chk stop
	& int stop
	
	Quote$		= chr$(34)
	Ppath$		= "Ppath: "
	From$		= "From "
	SpoolMail$	= SPOOL_MAIL_PATH
	SysMail$	= MAIL_PATH
	AliasFile$	= ETC_PATH + "aliases"
	PathsFile$	= ETC_PATH + "paths"
	Host$		= SysInfo$[plNode]
	MyDomain$	= SysInfo$[plDomain]
	HostDomain$	= Host$ + MyDomain$
	Root$		= SysInfo$[plAdmin]
	UseBangs	= MyDomain$ = ""
	FromArrow$[TRUE]= ">"
	SMVer$		= "(" + SENDMAIL_VER + ")"
	ResourceFile$	= RSRC_PATH + "sendmail.rsrc"
	
	dim LetterQueue$[LETTER_Q_SIZE], ToQueue$[TO_Q_SIZE], \
		IOBuf%[IOBUF_SIZE / 2]


' ====================
  main:
' ====================
	& files (SpoolMail$, LetterQueue$), numFiles, actualFiles
	if numFiles then
		gosub GetResources
		gosub SendLetters
		goto main
	endif
	& int on
	& chk on
	if busyFlag% then
		&hangup
		entry$ = "^I~ (modem ready)"
		gosub ShowEntry
	endif
	if not debugLevel% then & print
goto Exit

' ====================
  GetResources:
' ====================
	if not gotRsrc% then
		gotRsrc% = TRUE
		fOpen ResourceFile$
		fRead ResourceFile$
		onerr goto rsrcEOF
			& get SmartHost$
			input busyFlag%
			input debugLevel%
			& get a$
			& getinfo a$, i$
			if i$ > "" then AliasFile$ = a$
			& get a$
			& getinfo a$, i$
			if i$ > "" then PathsFile$ = a$
			input favorSmartHost%, largestLetter
			error(5)
		rsrcEOF:
		& onerr
		onerr goto HandleError
		fClose

		if debugLevel% then
			entry$ = "SENDMAIL ~ (" + str$(actualFiles) +  " letter"
			if actualFiles <> 1 then entry$ = entry$ + "s"
			entry$ = entry$ + ")"
			gosub ShowEntry
		else
			& print "sendmail (" actualFiles ") ";
		endif
	
		if busyFlag% then
			& fn fnCarrier, i
			if not i then
				&pickup (modeQuiet)
				entry$ = "^I~ (modem busy)"
				gosub ShowEntry
			else
				busyFlag% = FALSE
			endif
		endif
	endif
return


' ====================
  SendLetters:
' ====================

	current = 0
	repeat
		current = current + 1
		localID$ = LetterQueue$[current]
		& lcase(localID$)
		letter$ = SpoolMail$ + localID$
		inForward% = FALSE
		gosub SendCurrent
		fDelete letter$
	until current = numFiles
return


' ====================
  SendCurrent:
' ====================

	gosub GetHeaderInfo
	ltrIndex% = 1
	while ltrIndex% <= argc
		recipient$ = ToQueue$[ltrIndex%]
		user$ = recipient$
		gosub UnpackAddress
		if localUser then
			gosub LocalDelivery
		else
			dirTest = 0
			errMsg$ = "Site " + Quote$ + site$ + Quote$ + \
				" unknown at " + Host$
			gosub RemoteDelivery
		endif
		if a$ > "" then gosub ShowProgress
		ltrIndex% = ltrIndex% + 1
		fFre
	wend
return

	
' ====================
  GetHeaderInfo:
' ====================

	returnAddress$ = Root$
	& GETINFO letter$, info$
	fileType = asc (mid$(info$,5))
	argc = 0
	fOpen letter$ ",T" fileType
	fRead letter$
	onerr goto ghiError

	returnAddress$ = ""
	mr$ = ""
	skiplines = 0
	repeat
		& get a$
		k = TRUE
		& pos (a$, From$), i
		if i and (i < 3) then
			skiplines = skiplines + 1
			i = i + 5
			& pos (i, a$, " "), j
			mr$ = mid$ (a$, i, j - i)
		endif
		& pos (a$," remote from "),i
		if i then
			& spc (mid$(a$,i + 13)), i$
			returnAddress$ = returnAddress$ + i$ + "!"
			k = FALSE
		endif
	until k

	returnAddress$ = returnAddress$ + mr$
	& pos (returnAddress$, "!"), remoteOrigin

	while a$ > ""
		& pos (a$, ":"), p
		& pos ("To:Cc:Bcc:Ppath:", mid$(a$, 1, p)), p

		if p > 6 then			' Bcc or Ppath
			argc = 0
			gosub GetAddresses
			error(5)
		endif
		if p then
			if remoteOrigin and p = 1 then
				' Fix P-Net's pmail bug
				& pos right$ (a$, Host$ + "!"), q
				if q then
					a$ = "To: " + mid$(a$,q + len(Host$) + 1)
				endif
			endif
			gosub GetAddresses
		endif
		& get a$
	wend
	error(5)

	ghiError:
	& onerr errCode, errLine
	onerr goto FatalError
	fClose
	fFre

	if not argc then goto BounceToRoot
return


' ====================
  LocalDelivery:
' ====================

	if mid$(user$, 1, 1) = ">" then
		user$ = mid$(user$, 2)
		if mid$(user$, 1, 1) = ">" then
			user$ = mid$(user$, 2)
			a$ = "+"
			if user$ > "" then & add (letter$ to user$)
		else
			a$ = "="
			if user$ > "" then & copy (letter$ to user$)
		endif
		return
	endif

	if asc(user$) = 126 then
		user$ = mid$(user$, 2)
		a$ = "~"
		if user$ = "" then return
		i$ = a$
	else
		& getinfo ADM_PATH + user$ + "/", i$
		if i$ > "" then
			msgFile$ = USR_PATH + user$ + "/forward"
			& getinfo msgFile$, a$
			if a$ > "" and not inForward% then
				gosub AddForwardUsers
				inForward% = TRUE
				a$ = "F"
				return
			endif
		endif
	endif
	if i$ > "" then
		if fileType = BIN then goto BinaryPost
		msgFile$ = SysMail$ + user$
		if user$ = "rnews" then
			& add (letter$ to msgFile$)
			a$ = "N"
			return
		endif
		gosub MakeFromTime
		fOpen letter$
		fRead letter$ ",F" skiplines	' Discard old From lines
		fAppend msgFile$
		print From$ returnAddress$ " " fromTime$
		msgID$ = localID$
		gosub InsertReceivedBy
		gosub LineCopy
		a$ = "."
		return
	endif

	origCount = argc

	fOpen AliasFile$
	fRead AliasFile$
	onerr goto aliasEOF
	& lcase(user$)
	do
		repeat
			& get a$
			gosub fixAliasLine
		until p
		& lcase(a$)
		if user$ = mid$(a$, 1, p - 1) then
			repeat
				gosub GetAddresses
				& get a$
				gosub fixAliasLine
			until p
			error(5)
		endif
	loop
	aliasEOF:
	& onerr
	onerr goto FatalError
	fClose

	if argc > origCount then
		a$ = ""
		return
	endif

	errMsg$ = "User " + Quote$ + user$ + Quote$ + " not found on " + Host$
goto BounceIt

fixAliasLine:
	& pos (a$, "#"), p
	if p then & spc (mid$(a$, 1, p - 1)), a$
	& pos (a$, ":"), p
return


' ====================
  ReDoRemote:
' ====================		

	& pos (a$, "!"), p
	if p then
		site$ = left$(a$, p - 1)
		user$ = mid$(a$, p + 1) + "!" + user$
	else
		site$ = a$
		if site$ = "" then goto LocalDelivery
	endif
	domain$ = ""

' ====================
  RemoteDelivery:
' ====================

	if domain$ = "" then
		siteDir$ = MDSS_PATH + site$ + "/"
		repeat
			& pos (siteDir$, "-"), p
			if p then & mid$ (siteDir$, p) = "."
		until not p
		& GETINFO siteDir$, i$
		if i$ > "" then goto MDSSCopy

		dirTest = dirTest + 1
		if dirTest > 2 then
			returnAddress$ = ""
			errMsg$ = Quote$ + site$ + Quote$ + " not in paths database"
			goto BounceIt
		endif

		find$ = site$
		gosub PathsLookup
		if found then goto ReDoRemote
	endif

	if domain$ > "" and not favorSmartHost% then
		find$ = site$ + domain$
		gosub PathsLookup
		if found then goto ReDoRemote

		sf$ = domain$
		gosub FindDomain
	else
		found = FALSE
	endif

	if not found and not UseBangs and SmartHost$ = "" then
		sf$ = MyDomain$
		gosub FindDomain
	endif

	if found or SmartHost$ > "" then
		if not found then a$ = SmartHost$
		user$ = site$ + domain$ + "!" + user$
		goto ReDoRemote
	endif
goto BounceIt
	
FindDomain:
	& lcase (sf$)
	q = 0
	repeat
		& pos (q + 1, sf$, "."), q
		if q then
			find$ = mid$(sf$, q)
			gosub PathsLookup
		endif
	until not q or found
return	

' ====================
  PathsLookup:
' ====================

	if find$ = lastFind$ then
		found = TRUE
		a$ = lastPath$
		return
	endif

	found = FALSE
	
	if not pathsExists then
		& GETINFO PathsFile$, i$
		if i$ > "" then
			pathsExists = TRUE
		else
			pathsExists = -1
		endif
	endif
	if pathsExists = -1 then return

	fOpen PathsFile$
	fRead PathsFile$
	onerr goto pathsEOF
	do
		& get a$
		gosub fixAliasLine
		if a$ > "" then
			if not p then p = 1
			if find$ = mid$(a$, 1, p - 1) then
				found = TRUE
				& spc (mid$(a$, p + 1)), a$
				& pos (a$,"*"),p
				& spc(mid$(a$, 1, p - 1), 33), a$
				lastFind$ = find$
				lastPath$ = a$
				error(5)
			else
				if asc(find$) = 46 and asc(a$) <> 46 then
					error(5)
				endif
			endif
		endif
	loop
	pathsEOF:
	& onerr
	onerr goto FatalError
	fClose
return


' ====================
  MDSSCopy:
' ====================

	gosub UniqueName
	msgFile$ = siteDir$ + msgID$
	newPpath$ = Ppath$ + site$ + "!" + user$

	gosub MakeFromTime
	fOpen letter$ ",T" fileType
	src = peek(_OREFNUM)
	onerr goto letterEOF
	fRead letter$ ",F" skiplines
	fAppend msgFile$
	trg = peek(_OREFNUM)
	print From$ Host$ "!" returnAddress$ " "fromTime$
	gosub InsertReceivedBy

	repeat
		fRead letter$
		& get a$
		if a$ > "" then
			gosub FixPaths
			if left$ (a$,6) = "Date: " then
				i$ = a$
				& get a$
				gosub FixPaths
				j$ = a$
				a$ = i$ + "^M" + a$
				if left$ (j$,7) < > Ppath$ then
					a$ = i$ +"^M"+ newPpath$ +"^M"+ j$
				endif
			endif
		endif
		fWrite msgFile$
		print a$
	until a$ = ""
	fFlush msgFile$
	gosub FileCopy
	goto noEOFerr

	letterEOF:
	& onerr
	noEOFerr:
	onerr goto FatalError
	fClose
	& SETINFO msgFile$,info$
	a$ = "!"
return

' =================
  InsertReceivedBy:
' =================
	print "Received: by " HostDomain$ " " SMVer$ \
		"^M^Iid <" msgID$ "@" HostDomain$">; " \
		left$(t$,20) " " Sysinfo$[plZone]
	if not remoteOrigin then
		print "Message-Id: <" msgID$ "@" HostDomain$ ">"
	endif
return


LineCopy:
	onerr goto lcEOF
	do
		fRead letter$
		& get a$
		fWrite msgFile$
		print FromArrow$[ mid$(a$, 1, 5) = From$ ] a$
	loop
	lcEOF:
	& onerr
	onerr goto FatalError
	fClose
return


' ====================
  AddForwardUsers:
' ====================
	fOpen msgFile$ ",T" asc(mid$(a$, 5))
	fRead msgFile$
	onerr goto fwdEOF
	do
		& get a$
		gosub GetAddresses
	loop
	fwdEOF:
	&onerr
	fClose msgFile$
return


' ====================
  GetAddresses:
' ====================
	& pos (a$,":"),p
	if p then a$ = mid$ (a$,p + 1)
	gosub StripSpaces
	if a$ > "" then
		p = 0
		repeat
			q = p + 1
			& pos (p + 1,a$ + " "," "),p
			if p then
				argc = argc + 1
				& spc (mid$(a$,q,p - q),44), ToQueue$[argc]
			endif
		until not p
	endif
return


' ====================
  StripSpaces:
' ====================
	& spc (a$), a$
	& pos (a$,"  "),p
	if p then
		a$ = mid$ (a$,1,p) + mid$ (a$,p + 2)
		goto StripSpaces
	endif
return


' ====================
  FixPaths:
' ====================
	if left$ (a$,7) = Ppath$ then
		a$ = newPpath$
		return
	endif
	if left$ (a$,6) < > "From: " then return
	& pos right$ (a$,"@"),p
	if p then return

	& pos (a$,"!"),p
	if not UseBangs and not p then
		& pos (7,a$ + " "," "),p
		a$ = left$ (a$,p - 1) + "@" + HostDomain$ + mid$ (a$,p)
	else
		a$ = "From: " + Host$ + "!" + mid$ (a$,7)
	endif
return


' ====================
  MakeFromTime:
' ====================
	& time(t$)
	fromTime$ = left$ (t$,3) + mid$ (t$,8,5) + mid$ (t$,6,3) + \
		right$ (t$,8) + " 19" + mid$ (t$,13,2)
return


' ====================
  BounceToRoot:
' ====================
	errMsg$ = "Trouble parsing header (" + str$(errCode) + "@" + str$(errLine) + ")"
	returnAddress$ = ""
	
' ====================
  BounceIt:
' ====================
	if returnAddress$ = "" or returnAddress$ = "mdss" then returnAddress$ = Root$
	gosub UniqueName
	fClose
	fAppend SpoolMail$ msgID$
	gosub MakeFromTime
	print From$ "mdss " fromTime$
	print "Date: " t$ " " Sysinfo$[plZone]
	print "From: mdss (Mail Delivery SubSystem)"
	print "To: " returnAddress$
	print "Subject: Returned Mail"
	print "^MUnable to send your mail.  " errMsg$ "."
	print "^M^ISincerely,"
	print "^M^Imdss@"HostDomain$
	if fileType = TXT then
		print
		print "----- Returned Message Follows -----"
		fClose
		& add (letter$ to SpoolMail$ + msgID$)
		fAppend SpoolMail$ msgID$
		print "----- End of Returned Message -----"
	endif
	fClose
	&ucase (errMsg$)
	a$ = "X"
return


' ====================
  UnpackAddress:
' ====================
	domain$ = ""		' Init domain$ and	
	site$ = ""		'    site$ assuming a local user

	' Replace all %'s with @'s

	repeat
		& pos (user$, "%"), p
		if p then & mid$(user$,p) = "@"
	until not p


	' Check for an @ address format.  If found, convert to bang.
	' Reverse build the path if there are multiple @'s.

	path$ = ""
	repeat
		& pos right$ (user$,"@"), p
		if p then
			path$ = path$ + mid$ (user$, p + 1) + "!"
			user$ = left$(user$, p - 1)
		endif
	until not p
	user$ = path$ + user$
	
	' Now determine if path contains any addresses at all!
	
	& pos (user$, "!"), p
	localUser = not p		' If no bangs...
	if localUser then return	' return with localUser flag set

	' Break path down to user, site and domain components

	site$ = mid$ (user$, 1, p - 1)
	user$ = mid$ (user$, p + 1)
	
	& pos (2, site$, "."), p
	if p then
		& spc(mid$(site$, p + 1), 46), i$
		i$ = "." + i$
		domain$ = i$
		& lcase(i$)
		if i$ = MyDomain$ then domain$ = ""
		site$ = left$(site$, p - 1)
	endif
	i$ = site$
	& lcase (i$)
	if i$ = Host$ and domain$ = "" then goto UnpackAddress
return


' ====================
  FatalError:
' ====================
	& onerr errCode, errLine
	errMsg$ = "code #" + str$(errCode) + "@" + str$(errLine) +\
		" on " + letter$
	a$ = "X"
	if not debugLevel% then & print
	debugLevel% = 9
	gosub ShowProgress
	if errCode > 21 and not fatalErrorFlag% then
		fatalErrorFlag% = TRUE
		gosub BounceToRoot
		fDelete letter$
		run
	endif
	fClose
	& clear
	& trace tUnprotected
	& in ioConsole
	& hangup
	poke 216,0
	for k = 1 to 60
		for j = 10 to 1 step - 1
			for i = 1 to j * 4
				& beep (i,j) : & beep
			next
		next
	next
end


' ====================
  UniqueName:
' ====================
	& time(t$)
	& pos ("?anebarprayunulugepctovec", mid$ (t$,10,2)),i
	j = val (mid$ (t$,6))
	& right$ (str$ (val (mid$ (t$,16)) * 3600 + \
		val (mid$ (t$,19)) * 60 + val (right$ (t$,2))),5,48),a$
	msgID$ = chr$ (64 + i / 2) + chr$ (48 + j + 7 * (j > 9)) + a$
	& lcase (msgID$)
	if msgID$ = lastMsgID$ then
		seq$ = "." + str$(fnSeq)
		fnSeq = fnSeq + 1
	else
		fnSeq = 0
		seq$ = ""
	endif
	lastMsgID$ = msgID$
	msgID$ = msgID$ + seq$
return


' ====================
  BinaryPost:
' ====================
	msgFile$ = USR_PATH + user$
	gosub UniqueName
	fOpen letter$ ",T" fileType
	src = peek (_OREFNUM)
	fAppend SpoolMail$ msgID$
	repeat
		fRead letter$
		& get a$
		fWrite SpoolMail$ msgID$
		print a$
	until a$ = "^J---- Remote CoPy ----"

	errCode = TRUE
	fRead letter$
	& get sf$
	& get a$
	& GETINFO msgFile$,i$

	if i$ = "" then
		errMsg$ = "Directory " + msgFile$ + " not found"
	else
		rcpinfo$ = ""
		for i = 1 to 54 step 3
			rcpinfo$ = rcpinfo$ + chr$ (val(mid$(a$,i,3)))
		next

		& < sf$,j$
		k$ = mid$ (sf$, len (j$) + 2)
		j$ = msgFile$ + "/" + k$
		& GETINFO j$,i$
		if i$ > "" then j$ = msgFile$ + "/" + left$(k$, 7) + "." + msgID$
		& GETINFO ADM_PATH + user$ + RCP_STOP, i$
		if i$ > "" then
			errMsg$ = user$ + " can't receive remote files"
		else
			fOpen j$
			trg = peek(_OREFNUM)
			gosub FileCopy
			fClose j$
			& SETINFO j$, rcpinfo$
			errCode = FALSE
		endif
	endif

	fClose letter$
	if not errCode then
		errMsg$ = j$ + " successfully copied."
	else
		errMsg$ = errMsg$ + "^MThe sender (" + returnAddress$ + ") has been notified"
	endif
	fWrite SpoolMail$ msgID$
	print "Status: " errMsg$
	fClose

	if not errCode then
		& add (SpoolMail$ + msgID$ to SysMail$ + user$)
		fDelete SpoolMail$ msgID$
		a$ = ">"
		return
	endif

	errMsg$ = "Remote copy of " + sf$ + "^Mto " + user$ + \
		"@" + Host$ + " failed: " + errMsg$ + "."
goto BounceIt


' ====================
  FileCopy:
' ====================
	& poke _NEWLREF, src, 0
	& MLI (_NEWLINE, _SNEWLIN), errCode

	' Find address of IOBuf%[0] for file I/O buffer space
		
	a1 = 0
	a2 = 0
	IOBuf%[0] = 0
	& poke 0, peek(131), peek(132)
	a1 = peek(0)
	a2 = peek(1)

	repeat
		& poke _RWREFNUM, src, a1, a2, IOBUFL, IOBUFH
		& MLI (_READ, _SREAD), errCode
		if not errCode then
			& poke _RWREFNUM, trg, a1, a2, \
				peek(_RWTRANS), peek(_RWTRANS+1)
			& MLI (_WRITE, _SWRITE), errCode
		endif
	until errCode

	poke _CFREFNUM, trg
	& MLI (_FLUSH, _SFLUSH), errCode
return			

small_time:
	&time (time$)
	& pos ("?anebarprayunulugepctovec", mid$ (time$, 10, 2)),index
	index = index / 2
	time$ = str$ (index) + "/" + str$ (val(mid$(time$,6))) + \
		"-" + mid$ (time$,16,8)
return

ShowProgress:
	&spc(recipient$,$7E),i$
	if left$(i$, len(Host$) + 1) = Host$ + "!" then
		i$ = mid$(i$, len(Host$) + 2)
	endif
	j$ = returnAddress$
	if debugLevel% < 5 then
		k$ = i$ : gosub miniPath : i$ = k$
		k$ = j$ : gosub miniPath : j$ = k$
	endif
	entry$ = "^I~ " + j$  + " (" + a$ + ") " + i$
	if a$ = "X" then
		if debugLevel% then gosub ShowEntry
		entry$ = "^I~ <ERROR: " + errMsg$ + ">"
	endif

	if not debugLevel% then
		print a$;
		return
	endif

ShowEntry:
	if debugLevel% then
		&pos (entry$, "~"),p
		if p then
			gosub small_time
			entry$ = mid$(entry$, 1, p - 1) + time$ + \
				mid$(entry$, p + 1)
		endif
		& print entry$
	endif
return

miniPath:
	& pos right$ (k$, "!"), p
	if p then
		& pos right$ (p - 1, k$, "!"), p
		if p then k$ = mid$(k$, p + 1)
	endif
return

#include <proline/proline.lib>
