' **********************************************************************
' ***
' ***	rx.b	Receive XMODEM / YMODEM
' ***		(C)opyright 1994 Morgan Davis Group
' ***

#ifndef ZMODEM

#define	IDENT_PROG "rx"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "14apr94"
#define	IDENT_NAME "Morgan_Davis"

#define	MODULE	"RX"

#include <omm.h>
#include <basic.h>
#include <prodos.h>
#include <proline/proline.h>

	gosub AppInit

	q$ = chr$(34)
	stdflag$ = "X"

	options$ = "pydftbcklvr?"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "?" then
			showUsage = TRUE
		else
			if optchar$ = "r" then
				overwrite = TRUE
			else
				if optchar$ = "p" then
					stdflag$ = ""
				else
					flags$ = flags$ + optchar$
				endif
			endif
		endif
	until optchar$ = ""

	flags$ = stdflag$ + flags$
	& pos (flags$, "y"), i
	batchFlag = i > 0
	
	if showUsage then
		print "Usage: " argv$[0] " [ options ] [file...]"
		print "	-b	Binary II mode (Apple II)"
		print "	-c	128/CRC"
		print "	-d	Double delay tolerance"
		print "	-f	Accept full pathnames"
		print "	-k	1K/CRC"
		print "	-l	4K/CRC"
		print "	-p	ProDOS mode (Apple II)"
		print "	-r	Replace existing files"
		print "	-t	Text filter"
		print "	-v	Verbose 1K and 4K modes"
		print "	-y	YMODEM batch, 1K/CRC"
		goto Exit
	endif
#endif ZMODEM

	Result$[xferOK]		= "good"
	Result$[xferFail]	= "failed"
	Result$[xferCancel]	= "cancelled"

	& load get SysInfo$[plModulesDir] + MODULE

	xferType$ = mid$("XYZ", batchFlag + 1, 1)

	tmpname$ = xferType$ + "modem.recv.tmp"
	accFile$ = tmpname$
	& getinfo accFile$, i$
	accMode = accWrite + (accDelete * (i$ > ""))
	gosub CheckAccess
	if not accOK then
		& print argv$[0]": can't write in this directory"
		goto Exit
	endif
	if accMode > accWrite then fDelete accFile$
	
	& ucase(flags$)
	fileIndex = 1
	receiving = TRUE
	while receiving
		if fileIndex <= (nargc - 1) then
			argName$ = nargv$[fileIndex]
		else
			argName$ = ""
		endif
		gosub ReceiveFile
		fileIndex = fileIndex + 1
		if batchFlag then
			receiving = newName$ > ""
		else
			receiving = fileIndex < nargc
		endif
		if r then receiving = FALSE
	wend
goto Exit


ReceiveFile:
	AccFile$ = tmpname$
	AccMode = accWrite
	gosub CheckAccess
	if not AccOK then
		print argv$[0] ": can't create " AccFile$
		return
	endif

	& getinfo tmpname$, i$
	if i$ > "" then fDelete tmpname$

	if batchFlag then
		if fileIndex > 1 then goto RecvNow
		print IDENT_PROG " " IDENT_VERS " ready to receive " xferType$ "MODEM batch"
	else	
		print IDENT_PROG " " IDENT_VERS " ready to receive file."
	endif
	print "Start sending now, or type several Control-X keys to cancel"

RecvNow:
	& fn fnOutputMode, curOutMode
	& pr ioConsole
	print "### Receive (" xferType$ ") ";
	& pr curOutMode
	& rcv(tmpname$, flags$), r, newName$
	& pr ioConsole
	print ", " Result$[r]
	& pr curOutMode
	if not r then
		if batchFlag then
			if newName$ > "" then
				if argName$ > "" then newName$ = argName$
				gosub _FixName
				gosub renameFile
			else
				& pr ioConsole
				& ioctl(ioUp)
				& ioctl(ioEraseLine)
				& pr curOutMode
			endif
		else
			if argName$ = "" then
				& read "Name received file: ", newName$
			else
				newName$ = argName$
			endif
			gosub renameFile
		endif
	endif
return


renameFile:
	& getinfo newName$, i$
	AccFile$ = newName$
	accMode = accWrite + (accDestroy * (i$ > ""))
	gosub CheckAccess
	if not accOK then
		& print argv$[0]": can't write to " newName$
		fDelete tmpname$
	else
		if accMode = accWrite + accDestroy then
			if overwrite then
				fDelete newName$
			else
				if not batchFlag then \
					& print argv$[0]": " newName$ " exists!"
				i = val(right$(newName$, 1))
				if i then
					i = i + 1
					newName$ = left$(newName$, len(newName$) - 1) + str$(i)
				else
					newName$ = left$(newName$, 14) + "2"
				endif
				if not batchflag then
					i$ = newName$
					& read (-64, i$), "Name received file: ", newName$
					goto renameFile
				endif
			endif
		endif
		& pr ioConsole
		print argv$[0] ": " tmpname$ " -> " newName$
		& pr curOutMode
		fRename tmpname$ "," newName$
	endif
return

#define APP_AT_EXIT DumpTools
DumpTools:
	fClose
	& load fre ReceiveTool_ID
return
	
#include <proline/proline.lib>
#include <proline/access.lib>
#include <proline/getopt.lib>
#include <proline/fixname.lib>
