' ************************************************************************
' **									**
' **  plush.b		ProLine User's Shell				**
' **			(C)opyright 1994 Morgan Davis Group		**
' **									**
' ** When    Who Ver	What						**
' ** ======= === ======	==============================================  **
' ** 23sep90 mwd 1.3	Converted to MD-BASIC.
' ** 11feb91 mwd 1.4	Added restrictions to CD to remain in $/
' ** 21aug91 mwd 1.5	Added +/- to toggle --More--
' ** 01mar92 mwd 1.6	Added DO path list
' ** 10jun92 mwd 1.7	Reads in only titles of menus and file offsets
' **			when starting up.  Menus are then read in only
' **			when opened, and only one is read in at a time.
' ** 04sep93 mwd 2.1	Fixed bug in reverse >> searches, added games path
' **			Added &pop at intr entry to avoid stack overflow
' ** 24feb93 mwd 3.0	Added Parse module support
' **

#define IDENT_PROG "plush"
#define IDENT_VERS "3.0"
#define IDENT_DATE "24feb94"
#define	IDENT_NAME "Morgan_Davis"

#define	DEBUG		TRUE

#include <basic.h>
#include <prodos.h>
#include <proline/proline.h>
#include <proline/parse.h>

#define	VERSTR	"ProLine Users Shell " IDENT_VERS

#define	MAX_MENUS	100
#define	MAX_ITEMS	30

#define	PLUSH_COMMANDS	".DOEDVU>>EXBYPRCDRMINQYQNCL<<TFTB"
#define PLUSH_PROCS     doDO, doED, doVU, OpenMenu, doEX, doBY, doPR,\
			doCD, doRM, doIN, doQY, doQN, doCL, CloseMenu, \
			doTF, doTB

' ====================
' Main
' ====================

	gosub AppInit
	& on int goto EntryInt
	onerr goto PlushError

	GID = val(ID$[uGID])
	SuperUser = not GID		' reset this based on real GID

	plushEnv$ = TEMP_PATH + "plush.env"

	if ReturnFlag% then
		& getinfo plushEnv$, i$
		if i$ > "" then
			fRestore plushEnv$
			fDelete plushEnv$
			gosub LoadParser
			print
			goto Reentry
		endif
	endif

	& int stop 
	print "Welcome to the " VERSTR ", one moment...";
	gosub InitPLUSH
	print
	& ioctl(ioNormal)
	& ioctl(ioClearScreen)
	& int on 

' ====================
' Entry
' ====================

EntryInt:
	& pop
	& print
Entry:
	& pop
	if displayMenu% then
		gosub DisplayMenu
	else
		goto EntryPrompt
	endif

EntryPrompt:
	& pop
	print prompt$ " ";
	if not hotKeys% then
		& read (1),a$
	else
		get a$
	endif

	if a$ <= " " or a$ = chr$(127) then
		& clear 
		if currentMenu% > 1 then 
			print backup$[hotKeys%]
			goto CloseMenu
		endif
		print "(You're at the top menu)"
		goto EntryPrompt
	endif

	& pos (keysThisMenu$, a$), p
	if not p then 
		& pos ("?/", a$), p
		if not p then
			& pos ("-_=+", a$), p
			if not p then
				print "(Type ? for menu)"
				& clear
			else
				if p < 3 then
					print "- More off"
					& page stop
				else
					print "+ More on"
					& page on
				endif
			endif
		else
			if hotKeys% then & print "?"
			& print
			gosub DisplayMenu
		endif
		goto EntryPrompt
	endif

	currentItem% = int((p + 1) / 2)
	userInput$ = ""
	if hotKeys% then print echo$[currentItem%]
	print 
	cmdEntered% = cmdEntered% + 1
	CommandLine$ = cmd$[currentItem%]

NextCommand:
	gosub FullParse
	& pos (cmd$, left$(theCommand$, 2)),j
	if not j then
		a$ = theCommand$
		goto doDO
	endif

	& spc(mid$(theCommand$, 3)), a$
	on j / 2 gosub PLUSH_PROCS

Reentry:
	if CommandLine$ > "" then goto NextCommand
	if not extension% or not cmdEntered% then goto Entry

CloseMenu:
	on not stackPtr% goto EntryPrompt
	stackPtr% = stackPtr% - 1
	currentMenu% = menuStack%[stackPtr%]
	gosub ReadMenu
goto Entry


ClosePlushFile:
	fClose PlushMenuFile$
	PlushOpen% = FALSE
return


' ====================
' CL
' ====================

doCL:
	& ioctl(ioClearScreen)
return 


' ====================
' ED
' ====================

doED:
	a$ = ID$[uEditor] + " " + a$

' ====================
' DO
' ====================

doDO:
	gosub ClosePlushFile
	fStore plushEnv$
	i = SuperUser or root%[currentItem%]
	Launch(a$, ShellXPath$, i)
	print "plush: can't exec: " CommandLine$
return


' ====================
' >>
' ====================

OpenMenu:
	j = currentMenu%
	menuStack%[stackPtr%] = j
	stackPtr% = stackPtr% + 1
	for i = j + 1 to menuCount%
		if a$ = menuTitle$[i] then 
			j = i
			i = menuCount%
		endif
	next
	if j = currentMenu% and j > 1 then
		for i = j - 1 to 1 step -1
			if a$ = menuTitle$[i] then 
				j = i
				i = 1
			endif
		next
	endif
		
	if j <> currentMenu% then
		currentMenu% = j
		cmdEntered% = 0
		gosub ReadMenu
	endif
return 


' ====================
' VU
' ====================

doVU:
	accFile$ = a$
	gosub fileExists
	if accOK then
		accMode = accRead
		gosub testAccess
		if accOK then
			gosub ClosePlushFile
			& list accFile$
			print
		endif
	endif
return

fileExists:
	accOK = accFile$ > ""
	if accOK then
		& getinfo accFile$,i$
		accOK = i$ > ""
		if not accOK then print accFile$ ": not found^M"
	endif
return 

testAccess:
	AccOK = SuperUser or root%[currentItem%]
	if not AccOK then
		if accMode = -1 then	' doing a CD
			if asc(accFile$) <> 47 then
				fPrefix
				& get i$
				accFile$ = i$ + accFile$
			endif
			& lcase(accFile$)
			accOK = left$(accFile$, len(SysInfo$[plDir])) = SysInfo$[plDir]
		else
			gosub CheckAccess2
		endif
	endif
	if not AccOK then print accFile$ ": access denied"
return


' ====================
' IN
' ====================

doIN:
	print a$;
	& read (99),": ",userInput$
	& spc(userInput$), userInput$
	print 
return 

' ====================
' QY
' ====================

doQY:
	i$ = "Y"
goto _98_

' ====================
' QN
' ====================

doQN:
	i$ = "N"

_98_:
	print a$"? (y/n) "i$ "^H";
	get a$
	& ucase(a$)
	& pos ("NY",a$),p
	if not p then 
		a$ = i$
	endif
	print a$
	print
	if a$ <> "Y" then CommandLine$ = ""
return 


' ====================
' PR
' ====================

doPR:
	print a$
return 


' ====================
' CD
' ====================

doCD:
	accFile$ = a$
	if accFile$ = "" then accFile$ = ID$[uHome]
	gosub fileExists
	if accOK then
		if asc(mid$(i$,5)) <> 15 then
			print accFile$": not a directory"
			return
		endif
		accMode = -1
		gosub testAccess
		if accOK then
			fPrefix accFile$
			print "Current directory is: " accFile$
			print
		endif
	endif
return


' ====================
' RM
' ====================

doRM:
	accFile$ = a$
	gosub fileExists
	if accOK then
		accMode = accDelete
		gosub testAccess
		if accOK then
			fDelete accFile$
			print accFile$": deleted^M"
		endif
	endif
return 


' ====================
'  BY
' ====================

doBY:
	gosub ClosePlushFile
	& time(a$)
	print "Your session on " SysInfo$[plNode] " ends " \
		a$ " " SysInfo$[plZone] "..."
goto Logout


' ====================
' ?
' ====================

DisplayMenu:
	print spc(3)
	if extension% then
		print menuTitle$[currentMenu%] ":";
	else
		& ioctl(ioInverse)
		print " " menuTitle$[currentMenu%] " ";
		& ioctl(ioNormal)
		if stackPtr% then
			print " (RETURN: " menuTitle$[menuStack%[stackPtr% - 1]] ")";
		endif
	endif
	print 
	print 
	for i = 1 to itemCount%
		if help$[i] > "" then
			print spc(3) help$[i]
		else
			if echo$[i] = "" then print
		endif
	next 
	& print
return 


' ====================
' EX
' ====================

doEX:
	& restore ProgStack_Cell to a$
	& pos (a$,":"),p
	if not p then 
		print "Can't exit from PLUSH.^M"
		return 
	endif

PlushExit:
	gosub ClosePlushFile
goto Exit


' ====================
' TF
' ====================

doTF:
	gosub doTB
	& getinfo a$, i$
	if i$ = "" then
		print "The file '" a$ "' was not found."	
		goto PlushInterrupt
	endif
return

' ====================
' TB
' ====================

doTB:
	if a$ = "" then goto PlushInterrupt
return


' ====================
' Error
' ====================

StdErrMsg:
	print "plush: " i$
	goto PlushInterrupt

PlushError:
	& onerr e,l
	fClose
	print "plush: error "e" @ "l
	gosub LoadParser
	
PlushInterrupt:
	if not currentMenu% then goto PlushExit
goto EntryInt


' ====================
' Read environs
' ====================

GoGetEnv:
	gosub ClosePlushFile
	fOpen env$
	fRead env$ ",F10"
	input displayMenu%, hotKeys%
	fClose
return 



' ====================
  InitPLUSH:
' ====================
	& pos right$(AppPath$, "/"), p
	a$ = mid$(AppPath$, p + 1)

	' See if we can relaunch from a RAM disk

	ShellXPath$ = TEMP_PATH + a$
	& getinfo ShellXPath$, i$
	if i$ = "" then ShellXPath$ = AppPath$

	' Find parse module

	a$ = PARSER_NAME
	ParserPath$ = TEMP_PATH + a$
	& getinfo ParserPath$, i$
	if i$ = "" then ParserPath$ = SysInfo$[plModulesDir] + a$
	gosub LoadParser
	
	' Find the plush.m file, searching as follows:
	'
	' ADM_PATH/user/plush.m
	' TEMP_PATH/plush.m.{GID}
	' TEMP_PATH/plush.m
	' ETC_PATH/plush.m.{GID}
	' ETC_PATH/plush.m

	a$ = "plush.m"
	plushMenuFile$ = ADM_PATH + ID$[uName] + "/" + a$
	& getinfo plushMenuFile$, i$
	if i$ = "" then
		j$ = TEMP_PATH
		for i = 1 to 2
			plushMenuFile$ = j$ + a$ + "." + str$(GID)
			& getinfo plushMenuFile$, i$
			if i$ = "" then
				plushMenuFile$ = j$ + a$
				& getinfo plushMenuFile$, i$
			endif
			j$ = ETC_PATH
			if i$ > "" then i = 2
		next
	endif

	& fn fnCarrier, DCD
	backup$[TRUE]	= "<<^M"
	cmd$		= PLUSH_COMMANDS
	hotKeys%	= TRUE
	displayMenu%	= TRUE
	env$		= ADM_PATH + ID$[uName] + "/environs"
	q$		= "'"

	& GETINFO env$,i$
	if i$ > "" then gosub GoGetEnv

	dim menuTitle$[MAX_MENUS], menuOffset[MAX_MENUS], \
		menuStack%[MAX_MENUS], \
		root%[MAX_ITEMS], echo$[MAX_ITEMS], help$[MAX_ITEMS], \
		cmd$[MAX_ITEMS]

	fOpen plushMenuFile$
	poke _SREFNUM, peek(_OREFNUM)
	plushOpen% = TRUE
	fRead plushMenuFile$
	menuCount% = 0
	repeat
		repeat
			& get a$
		until a$ > ""
		if a$ <> "END" then
			menuCount% = menuCount% + 1
			menuTitle$[menuCount%] = a$
			& MLI (_GET_MARK, _SGETMRK), i
			menuOffset[menuCount%] = peek24(_SMARK)	' Get next line offset
			repeat
				& get a$
			until val(a$) = 9
		endif
	until a$ = "END"
	fFre

	currentMenu% = 1
	
ReadMenu:
	if not plushOpen% then
		fOpen plushMenuFile$
		poke _SREFNUM, peek(_OREFNUM)
		plushOpen% = TRUE
	endif
	
	fRead plushMenuFile$
	i = menuOffset[currentMenu%]
	poke24(_SMARK, i)
	& MLI (_SET_MARK, _SSETMRK), i

	& get prompt$
	extension% = asc(prompt$) = 60
	if extension% then prompt$ = mid$(prompt$, 2)
	i = 1
	keysThisMenu$ = ""
	repeat
		input j, k, root%[i], a$, echo$[i], help$[i], cmd$[i]
		if j <> 9 and GID <= j and (k = 2 or k = DCD) then
			if a$ = "" then a$ = "  "
			keysThisMenu$ = keysThisMenu$ + a$
			i = i + 1
		endif
	until j = 9
	itemCount% = i - 1
	fFre
return


plushVar:
	if i$ = "/" then
		i$ = SysInfo$[plDir]
	else
		if i$ = "spool" then
			i$ = SysInfo$[plSpoolDir]
			i$ = left$(i$, len(i$)-1)
		else
			if i$ = "tmpdir" then
				i$ = SysInfo$[plTempDir]
				i$ = left$(i$, len(i$)-1)
			else
				if i$ = "IN" then
					i$ = userInput$
				endif
			endif
		endif
	endif
	theCommand$ = mid$(theCommand$, 1, p - 1) + i$ + mid$(theCommand$, p + k + 1)
return


#define	APP_AT_EXIT ShellCleanUp
ShellCleanUp:
	& load fre PARSER_ID
return

#define	SHPARSE_QUOTE	39
#include "shparse.b"

#include <proline/proline.lib>
#include <proline/access.lib>

#define LAUNCH_PARSE
#include <proline/launch.lib>
