' **********************************************************************
' ***
' ***	par.b		ProLine Archive utility
' ***			ProLine System Software (C) 1990 Morgan Davis Group
' ***

#define IDENT_PROG "par"
#define IDENT_VERS "1.3"
#define IDENT_DATE "1jun92"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <proline/proline.h>

	gosub AppInit

	cd = 8192
	ec = cd + 21
	pn = cd + 22
	dt = 10752
	f% = 0
	if argv > 4 then 
		print "Usage: par [startdir listfile parfile]"
		goto Exit
	endif
	if argc = 1 then 
		& read "Start dir: ",StartDir$
	endif

	dim f$(255)

	if argc > 1 then 
		StartDir$ = argv$[1]
	endif
	if argc > 2 then 
		ListFile$ = argv$[2]
	endif
	if argc = 4 then 
		ParFile$ = argv$[3]
	endif

	& lcase(StartDir$)
	if right$ (StartDir$,1) <> "/" then 
		StartDir$ = StartDir$ + "/"
	endif
	
	& GETINFO StartDir$,i$
	if i$ = "" then 
		print "par: "StartDir$" not found"
		goto Exit
	endif

	fPrefix
	& get OldPrefix$
	
	if ListFile$ = "" then 
		print "Enter list of files, C/R alone to stop:"
	else
		AccMode = accRead
		AccFile$ = ListFile$
		gosub CheckAccess
		if AccOK then
			& GETINFO ListFile$,i$
			if i$ = "" then
				print argv$[0]": can't find " ListFile$
				goto Exit
			endif
			if asc(mid$(i$,5)) = 15 then 
				& files(ListFile$,f$, - 15),f%
				goto GetOutFile
			endif
			fOpen ListFile$
			fRead ListFile$
		endif
	endif

	onerr goto parEOF

	repeat
		if ListFile$ = "" then 
			print f% + 1;
			& read (64),": ",i$
		else
			& get i$
		endif

		& lcase(i$)
		& spc(i$),i$
		fin = i$ = ""
		
		if not fin then
			if asc (i$) = 47 then 
				if left$ (i$, len (StartDir$)) = StartDir$ then 
					i$ = mid$ (i$, len (StartDir$) + 1)
				else
					print "par: file outside of " StartDir$
					i$ = ""
				endif
			endif
			l = len (i$)
			if l > 64 then 
				print "par: path too long"
				i$ = ""
			endif
			if i$ > "" then
				AccFile$ = StartDir$ + i$
				AccMode = accRead
				gosub CheckAccess
				if not AccOK then 
					print "par: can't read " AccFile$
				else
					f% = f% + 1
					i$ = right$ (i$,l)
					f$(f%) = i$
				endif
			endif
		endif
	until fin
	error (5)

parEOF:
	&onerr
	fClose
	onerr goto HandleError

GetOutFile:
	if not f% then goto Exit
	if ParFile$ = "" then 
		& read "Output file: ",ParFile$
	endif
	if asc (ParFile$) <> 47 then 
		ParFile$ = OldPrefix$ + ParFile$
	endif
	l = len (ParFile$)
	if not l then goto Exit

	restore 
	for i = cd to cd + 360
		read x
		poke i,x
	next 
	AccMode = accWrite + accDestroy
	AccFile$ = ParFile$
	gosub CheckAccess
	if AccOK then 
		& GETINFO ParFile$,i$
		if i$ > "" then fDelete ParFile$
		fCreate ParFile$ ",TBIN"
	else
		print "par: can't make "ParFile$
		goto Exit
	endif

	poke pn,l
	for i = 1 to l
		poke pn + i, asc (mid$(ParFile$,i))
	next 
	call cd
	gosub ParError

	fPrefix StartDir$
	for j = 1 to f%
		i$ = f$(j)
		print j": Storing... "i$
		l = len (i$)
		poke pn,l
		for i = 1 to l
			poke pn + i, asc ( mid$ (i$,i))
		next 
		call cd + 18
		gosub ParError

		' GET_EOF

		call cd + 3
		gosub ParError
		poke dt + 127,f% - j
		call cd + 9
		gosub ParError
		ef = peek (dt + 20) + 256 * peek (dt + 21) + 65536 * \
			peek (dt + 22)
		if ef then
			& rept
				call cd + 6
				if not peek (ec) then 
					call cd + 9
				endif
			& until( peek (ec))
			if peek (ec) < > 76 then 
				gosub ParError
			endif
		endif
		call cd + 15	' Close entry file
		gosub ParError
	next 
	call cd + 12		' Close ParFile$
	print 
	print "Done."
pExit:
	fPrefix OldPrefix$
goto Exit


ParError:
	e% = peek (ec)
	if e% then
		print 
		if e% = 70 or e% = 64 then 
			print "par: no such file"
		else
			print "par: MLI err #"e%
		endif
		goto pExit
	endif
return
	
	data 76,116,32,76,132,32,76,247,32,76,11,33,76,21,33,76,27,33,76,87,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	data 0,0,0,0,0,0,0,32,0,191,196,85,33,32,39,33,24,173,103,33,109,93,33,141,103,33,173,104,33,109,94,33,141,104,33,96,32,0,191,200,57,33,32,39,33,173,62,33,141,78,33,96,32,236,32,169,10,141,0,42,169,2,141,18
	data 42,173,103,33,141,122,42,173,104,33,141,123,42,169,23,141,1,42,169,42,141,2,42,174,22,32,189,22,32,157,23,42,202,16,247,32,0,191,196,0,42,32,39,33,169,71,141,1,42,169,76,141,2,42,32,0,191,200,63,33,32,39,33,173
	data 68,33,141,70,33,141,56,33,141,19,42,173,4,42,201,15,240,9,32,0,191,209,18,42,32,39,33,96,162,127,169,0,157,0,42,202,16,250,96,32,236,32,32,0,191,202,69,33,144,5,201,76,208,1,24,32,39,33,96,32,0,191,203,77
	data 33,32,39,33,96,169,0,56,32,39,33,169,0,141,21,32,32,0,191,204,55,33,96,141,21,32,144,8,104,104,32,0,191,204,53,33,96,1,0,1,0,3,22,32,0,34,0,3,22,32,0,38,0,4,0,0,42,128,0,0,0,4,0,0,42,128,0,0,0,10,22,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

#include <proline/proline.lib>
#include <proline/access.lib>
