' ************************************************************
' ***
' ***	ls.b		Lists files
' ***			(C)opyright 1994 Morgan Davis Group
' ***
' ***	16feb93	1.4.1	Increased long entry allocation from 60 to 80 chars
' ***	17may94 3.0	Added > and >> support

#define IDENT_PROG "ls"
#define IDENT_VERS "3.0"
#define IDENT_DATE "17may94"
#define IDENT_NAME "Morgan_Davis"

#define	LONG_DIR	1
#define SIZE_IN_BLOCKS	2
#define	TAG_CHAR	3
#define ALL_FILES	4
#define NUM_FILES	5
#define PRODOS_DIR	6
#define	INVIS_FILES	7

#include <basic.h>
#include <proline/proline.h>

	gosub AppInit

	gosub testOutput
	if accFile$ > "" then
		on not AccOK goto Exit
		if k = 1 and accMode > accWrite then fDelete accFile$
		outputFile$ = accFile$
	endif

	s$ = " directory "

	options$ = "lsFanpi?"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "?" then
			print "Usage: " argv$[0] " [ -aFilnps ] [" s$ "...]"
			goto Exit
		endif
		& pos (options$, optchar$), p
		use%[p] = TRUE
	until optchar$ = ""

	if nargc < 2 then
		& erase (nargv$)
		dim nargv$[1]
		fPrefix
		& get nargv$[1]
		nargc = 2
	endif

	if use%[LONG_DIR] then
		i = 80
	else
		i = 18
	endif

	maxFiles% = (fre(0) - 2048) / i

	dim f$[maxFiles%]

	onerr goto MyErrorRtn

	for ii = 1 to nargc - 1
		f$ = nargv$[ii]
		& lcase(f$)
		& getinfo f$, i$
		if i$ = "" then
			& print f$ ":" s$ "not found"
		else
			if asc(mid$(i$, 5)) <> 15 then
				& print f$": not a" s$
			else
				if nargc > 2 then
					if outputFile$ > "" then fAppend outputFile$
					if ii > 1 then print
					print f$":"
					fClose
				endif
				gosub doDir
			endif
		endif
	next
goto Exit


doDir:
	if use%[PRODOS_DIR] then 
		fOpen f$ ",T15"
		fRead f$
		& get
		& get
		& get
		& print " Filename" spc(7) "Type  Blocks  Modified" spc(9) "Created" spc(12) "Bytes Subtype^M ";
		& hlin 78, 45
		& print
		catloop:
			& get a$
			if a$ > "" then
				& lcase(a$)
				& print mid$(a$,2)
				goto catloop
			endif
		fClose
	else
		if use%[LONG_DIR] then 
			gosub ShowLong
		else
			if use%[ALL_FILES] then
				visFlag = VIS_AND_INVIS
			else
				if use%[INVIS_FILES] then
					visFlag = INVISIBLE_ONLY
				else
					visFlag = VISIBLE_ONLY
				endif
			endif
			if use%[TAG_CHAR] then 
				& tfiles(f$,f$,,visFlag),nf,rf
			else
				& files(f$,f$,,visFlag),nf,rf
			endif
			if not nf and (visFlag = VIS_AND_INVIS) then
				print f$ ":" s$ "empty"
			else
				if nf then
					gosub DisplayFiles
					if nf <> rf then
						print "(more files exist than shown)"
					endif
				endif
			endif
		endif
	endif

	if use%[NUM_FILES] and not use%[PRODOS_DIR] then
		print f$": "rf" files"
	endif
return


ShowLong:
	fOpen f$",T15"
	fRead f$
	& get 
	& get 
	& get 
	nf = 0
	rf = 0
	sp = 0
	onerr goto dirEOF
	j = 23
	if not use%[SIZE_IN_BLOCKS] then j = 65
	do
		& get i$
		if mid$ (i$,2,1) = "B" or i$ = "" then
			error(5)
		endif
		rf = rf + 1
		if nf < maxFiles% then
			nf = nf + 1
			& lcase(i$)
			f$[nf] = mid$(i$,2) + mid$ (i$,2,1)
			sp = sp + val (mid$ (i$,j,8))
		endif
	loop

dirEOF:
	& onerr errCode, errLine
	onerr goto MyErrorRtn
	fClose
	if outputFile$ > "" then fAppend outputFile$
	print "total "nf" for "sp" ";
	if not use%[SIZE_IN_BLOCKS] then 
		print "byte";
	else
		print "block";
	endif
	if sp <> 1 then print "s";
	print 
	if nf then
		& sort(f$,nf)
		r = 1
		if r <= nf then
			for x = r to nf
				i$ = mid$ (f$[x],18,3)
				t$ = "-"
				if i$ = "dir" then t$ = "d"
				t$ = t$ + "r" + chr$ (119 - 74 * \
					(right$ (f$[x],1) = "*"))
				& pos ("bincmdbasys",i$),p
				t$ = t$ + chr$ (45 + 75 * (p > 0))
				& pos (mid$(f$[x],2)," "),p
				print t$ " " i$ \
				  mid$(f$[x],64-(use%[SIZE_IN_BLOCKS] * 43),8) \
				  " " mid$(f$[x],31,15) "  " mid$(f$[x],2,p-1)
			next
		endif
	endif
	fClose outputFile$
return


MyErrorRtn:
	& onerr e,l
	fClose
	normal
	if e = 6 or e = 7 then 
		print f$":" s$ "not found"
	else
		if e = 13 then 
			print f$": not a" s$
		else
			if e = 10 then
				print f$" unreadable"
			else
				print argv$[0]": error "e" at "l
			endif
		endif
	endif
goto Exit


DisplayFiles:
	if outputFile$ > "" then fAppend outputFile$
	k = nf
	& sort(f$,k)
	r = 0
	if k then
		w = 5
		os = int (k / w + .9)
		j = 1
		for i = 1 to k
			& lcase(f$[j + r])
			print f$[j + r];
			n = len (f$[j + r])
			m = i - int (i / w) * w
			if not m then 
				j = i / w + 1
				if n < 16 then print
			else
				if outputFile$ > "" then
					print spc(16 - n)
				else
					& hlin (n < 8) + (n < 16), 9
				endif
				j = j + os - ((os - 1) * w + m > k)
			endif
		next 
		if m then print
	endif
	fClose outputFile$
return


testOutput:
	accFile$ = ""
	if asc(argv$[argc-1]) = 62 then
		argc = argc - 1
		accFile$ = argv$[argc]
		k = len(accFile$)
		& spc (accFile$, 62), accFile$
		k = k - len(accFile$)
		gosub testAccFile
	endif
return

testAccFile:
	& getinfo accFile$,i$
	accMode = accWrite + accWrite * (i$ > "")
	gosub CheckAccess
	if not accOK then
		print argv$[0] ": can't open " accFile$
		status% = -1
	endif
return



#include <proline/proline.lib>
#include <proline/getopt.lib>
#include <proline/access.lib>
