' ************************************************************
' *
' *  login.b	Login
' *		(C)opyright 1994 Morgan Davis Group
' *
' * When    Who Ver	What
' * ======= === ======= =====================================
' * 17feb90 mwd	1.0	Creation
' * 02apr90 mwd 1.1	Added &ioctl(ioMTextOff) to kill mousetext
' * 18sep90 mwd 2.0	Added resources, tweaked macros and screen saver
' * 23sep90 mwd	2.1	Added support for new user environs
' * 16oct90 mwd		Added lowest speed logic (changed resources)
' * 18oct90 mwd		Fixed bug in 00 second logic to execute cron
' * 25oct90 mwd	2.2	Redesigned screen saver (safer and better)
' * 11feb91 mwd		Added console_abort and no_answer resources
' * 18feb91 mwd 2.3	Added local_time_out resource
' * 18feb92 mwd 2.4	Updated for MW3
' * 20oct93 mwd 2.5	Added selective user login alert
' *			Changed prompt to "pro-site login:"
' * 16jan94 mwd 3.0	IDENT/Launch update 
' * 17may94 mwd		Recycle now fully resets modem
' *
' * To Do:
' *		Clean up accounting stuff (logfile updating)	
' *
' ************************************************************

#define	IDENT_PROG "login"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "16may94"
#define	IDENT_NAME "Morgan_Davis"

#include <appleio.h>
#include <basic.h>
#include <proline/proline.h>
#include <proline/parse.h>
#include <romcall.h>

#define	MAX_CRON_TASKS	48

#define	DO_INTRO	1
#define	DO_NEWS		0
#define	DO_MAIL		0

#if DO_NEWS
#define	MAX_NEWS_FILES	32
#endif

#define SS_SAVE		0	' Screen saver control codes
#define	SS_RESTORE	1
#define	SCRNBUF_SIZE	479	' 24 * 40 / 2 - 1 (2 bytes per integer)

#define	pwPassword	2	' Password file entry fields
#define	pwUID		3
#define	pwGID		4
#define	pwName		5
#define	pwHome		6
#define	pwInterp	7

#define	ShowFile(file)	CurFile$ = file : GOSUB _ShowFile


' ==============================
' Main Entry Point
' ==============================

Main:
	onerr goto Handle_Error
	& pop
	speed 255
	normal
	clear

	& trace tUnprotected
	& page stop
	& page len 22
	& scrn (PrinterOff)
	& ioctl (ioMTextOff)

	& restore SysInfo_Cell to A$
	P = 0
	for I = 1 to plItemCount
		Q = P + 1
		& pos (Q, A$ + ":", ":"), P
		SysInfo$[I] = mid$(A$, Q, P - Q)
	next

	& restore ProgStack_Cell to A$
	ImmedLogin = A$ > ""
	if not ImmedLogin then
		& fn fnOnline, DCD
		if DCD then & hangup
	endif

	& pr ioConsole
	& in ioConsole

' ====================
' Pathnames
' ====================

	EtcDir$		= ETC_PATH
#if DO_NEWS
	NewsDir$	= NEWS_PATH
#endif
	UserTempFile$	= TEMP_PATH + "utmp"
	ResourceFile$	= RSRC_PATH + "login.rsrc"
	PasswdFile$	= EtcDir$ + "passwd"
	SysLogFile$	= SPOOL_LOGS_PATH + "syslog"
	CrontabFile$	= EtcDir$ + "crontab"
	ADMFile$	= EtcDir$ + "adm"
	NoLoginFile$	= EtcDir$ + "nologin"
	LowSpeedFile$	= EtcDir$ + "lowbps"

' ====================
' Resource Data Structure
' ====================
'
' 30		: seconds before screen saver kicks in (0 = disabled)
' 		: command to invoke on user logout (def = bin/sendmail)
' 0		: Jeff's speaker hack (0 = disabled)
' 300		: lowest connect speed allowed
' 30		: IIGS console request "holding time" (in seconds, 0 = off)
' !cmpqs	: macro command keys (no comments for macros following)
'
' csh -c
' mail 
' poll
' boot -q
' scan -l 
' 3		: local console cancel key
' 0		: no answer flag
' 30		: local command line timeout (seconds)
' 		: comma delimited list of names that emit an alert beep

'
' ====================
' Get Resources
' ====================

	& getinfo resourceFile$, i$
	if i$ = "" then
		BlankSecs	= 30		' Load up defaults
		' Macro$[0]	= "sendmail"
		jjSpkrHack	= FALSE
		lowestSpeed	= 300
		holdTime	= 30
		macroCommands$	= "!cmpqs"
		' Macro$[1]	= ""
		  Macro$[2]	= "csh -c "
		  Macro$[3] 	= "mail "
		  Macro$[4]	= "poll "
		  Macro$[5]	= "boot -q"
		  Macro$[6]	= "scan -l "
		console_abort	= 3
		no_answer	= FALSE
		local_time_out	= 30
		' alertList$	= ""
	else	
		CurFile$ = ResourceFile$
		onerr goto rsrcEOF
		fOpen CurFile$
		fRead CurFile$
			input BlankSecs
			& get logoutCommand$
			input jjSpkrHack, lowestSpeed, holdTime
			& get MacroCommands$
			j = len(MacroCommands$)
			dim Macro$[j]
			for i = 1 to j
				& get Macro$[i]
			next
			input console_abort, no_answer, local_time_out
			& get alertList$
			error(5)
		rsrcEOF:
		& onerr
		onerr goto Handle_Error
		fClose
	endif

	gosub TTY_Termcap
	poke sttyCancel, console_abort
	poke sttyNulls, 0
	poke sttyShell, 0

	& int = 4
	& tab (TRUE)
	& nulls (0)

	if not ImmedLogin and peek(sttyTabs) <> 255 then
		A$ = LogoutCommand$
		if A$ = "" then
			dim F$[1]
			& files(SPOOL_MAIL_PATH, F$), i
			if i then A$ = "sendmail"
		endif
		if A$ > "" then
			poke sttyTabs, 255
			CurFile$ = A$
			& print
			Launch(A$, LOGIN_PATH, TRUE)
		endif
	endif

	poke sttyTabs, TRUE
	& on int goto Main
	if jjSpkrHack then & usr uSpkrOff + (PDL(1) > 127)

	
' ==============================
' Install Screen Saver
' ==============================

	ScreenSaver = $300
	& poke ScreenSaver, \
		$20,$4C,$E7,$86,$00,$20,$BE,$DE,$20,$D9,$F7,$18,\
		$A5,$9B,$69,$07,$85,$9B,$A9,$00,$65,$9C,$85,$9C,\
		$38,$20,$1F,$FE,$A5,$00,$B0,$24,$D0,$18,$AD,$22,\
		$C0,$8D,$3B,$03,$29,$F0,$8D,$22,$C0,$AD,$34,$C0,\
		$8D,$40,$03,$29,$F0,$8D,$34,$C0,$80,$0A,$A9,$00
	& poke ScreenSaver + 60, \
		$8D,$22,$C0,$A9,$00,$8D,$34,$C0,$A2,$17,$8A,$20,\
		$C1,$FB,$A0,$27,$A5,$00,$D0,$0A,$B1,$28,$91,$9B,\
		$A9,$A0,$91,$28,$D0,$04,$B1,$9B,$91,$28,$88,$10,\
		$EB,$18,$A5,$9B,$69,$28,$85,$9B,$A9,$00,$65,$9C,\
		$85,$9C,$CA,$10,$D5,$A4,$00,$99,$0C,$C0,$4C,$22,$FC

	ScreenIsBlank = FALSE
	BlankX = 16
	BlankY = 12

	def fn ADD(X) = X + 44 * (X < 53) + 70 * (X > 52 AND X < 59)
	def fn LOW(X) = X - 32 * (X > 95)

	dim CronEntry$[MAX_CRON_TASKS]
#if DO_NEWS
	dim NewsFiles$[MAX_NEWS_FILES]
#endif
	
' ==============================
' Update System Log File & ADM
' ==============================

	& restore UserID_Cell to A$
	on A$ = "" goto NoLogUpdate

	& getinfo UserTempFile$,I$
	on I$ = "" goto NoLogUpdate

	CurFile$ = UserTempFile$
	fOpen UserTempFile$
	fRead UserTempFile$
	& get
	& get T$
	& get N$
	& get LoginWhere$
	gosub GetAcctNums1
	gosub GetAcctNums2
	input UID
	fClose
	CurFile$ = ""

	gosub GetAcctDateInfo
	LastLogin$ = T$
	J = DAY
	I = T
	& time(T$)
	gosub GetAcctDateInfo
	TI = T - I
	IF J <> DAY THEN TI = 1440 - I + T

	CurFile$ = ADMFile$
	fOpen ADMFile$ ",L256"
	OldUID = UID

UpdateADMRec:
	IF MOY < > CMN THEN
		CMN = MOY
		PMN = MCR
		MCR = 0
	ENDIF

	LGN = (LGN < 99999) * LGN + (OldUID > 0)
	MNT = MNT + TI
	MCR = MCR + TI
	BAL = BAL + RPM * TI

	fWrite ADMFile$ ",R" UID ",B" admAcctInfo
	& left$ (str$ (RPM) + "," + str$(BAL) + "," + str$(OWE),12), A$
	print A$
	print LastLogin$
	gosub WriteAcctNums2
	if UID then
		UID = 0
		fRead ADMFile$ ",R0,B" admAcctInfo
		gosub GetAcctNums1
		& GET
		gosub GetAcctNums2
		goto UpdateADMRec
	endif
	fClose
	CurFile$ = ""

	H = int (TI / 60)
	M = int (TI - H * 60)
	& right$ (str$ (H),2,48),H$
	& right$ (str$ (M),2,48),I$
	H$ = H$ + I$
	A$ = "-----"
	if OldUID then & right$ (str$ (LGN),5,48),A$

	& lcase(LastLogin$)
	& right$(LoginWhere$,5),J$

	CurFile$ = SysLogFile$
	fAppend SysLogFile$
	print mid$ (LastLogin$,6,2) + mid$ (LastLogin$,9,3) + \
		mid$ (LastLogin$,13,3) + A$ + " " + J$ + " " + \
		mid$ (T$,16,2) + MID$ (T$,19,2) + "-" + \
		mid$ (LastLogin$,16,2) + MID$ (LastLogin$,19,2) + \
		"=" + H$ + " " + N$
	fClose

	CurFile$ = UserTempFile$
	fDelete UserTempFile$
	CurFile$ = ""

	gosub EventStatus

NoLogUpdate:
	gosub InitCells
	LoginWhere$ = "local"
	& chk on
	& int stop
	& on hangup goto Main
	& fn fnOnline, DCD
	ImmedLogin = ImmedLogin OR DCD
	IF ImmedLogin THEN GOTO DoLogin

' ==============================
' Hangup, Reset to Idle Prompt
' ==============================

Recycle:
	& hangup
	& usr uResetModem
	normal
	& pop
	& pr ioConsole
	& in ioConsole
	& timer stop
	fClose

	if holdTime then
		if peek($C025) = 36 then
			print "^MHolding system for local use...";
			while peek($C025) = 36 and peek(_KBD) < 128 and holdTime
				& beep (17,70) : & beep
				& beep (20,90) : & beep
				& time(a$)
				repeat
					& time(i$)
				until a$ <> i$
				holdTime = holdTime - 1
			wend
			& beep (stdBeepDur, stdBeepPitch)
			& ioctl(ioEraseLine)
		endif
		holdTime = 0
	endif

Recycle2:
	BlankOutCount = 0
	poke 34,0
	print

' ==============================
' Idle Prompt (Time Checker)
' ==============================

IdlePrompt:
	gosub ShowTime
	if right$(T$,2) = "00" then gosub Cron

	repeat
		& time(A$)
		& fn fnRing, Ringing
		KeyPress = PEEK (_KBD)
	until A$ <> T$ or Ringing or (KeyPress > 127)

	if Ringing and not no_answer then
		gosub AwakenScreen
		goto AnswerRing
	endif

	if KeyPress < 128 then
		if not ScreenIsBlank and BlankSecs then
			BlankOutCount = BlankOutCount + 1
			if BlankOutCount = BlankSecs then gosub BlankScreen
		endif
		goto IdlePrompt
	endif

	& clear
	I = KeyPress - 128
	if I = 32 then
		on ScreenIsBlank + 1 gosub BlankScreen, AwakenScreen
		goto IdlePrompt
	endif

	gosub AwakenScreen
	if I = 27 then
		&read (1),"Exit? (y/n) ",a$
		if a$ = "y" or a$ = "Y" then
			print
			& trace tUnprotected 
			end
		endif
		goto IdlePrompt
	endif

	if I < 32 then goto DoLogin

	I$ = chr$ (I)
	& lcase(I$)
	& pos (MacroCommands$, I$) ,I
	if I then I$ = Macro$[I]

	if local_time_out then
		& timer (local_time_out)
		& timer on
	endif
	& read (-127, I$),"!", A$
	& timer stop
	& spc (A$), A$
	if A$ > "" then goto ExecTask
goto IdlePrompt


' ==============================
' Answering Ringing Line
' ==============================

AnswerRing:
	print "-ring ";
	& pickup
	& wait for carrier, I
	if I > 0 then goto Recycle2

DoLogin:
	& fn fnOnline, DCD
	if DCD then
		gosub GetConnectSpeed
		LoginWhere$ = str$(connectSpeed)
		if not ImmedLogin then
			& hlin 5, 8
			print "connect " LoginWhere$;
			& wait 2
			if connectSpeed < lowestSpeed then
				print ", too slow!^M"
				& pr ioBoth
				ShowFile (LowSpeedFile$)
				if not Shown then
					print str$(lowestSpeed) \
						" bps or higher required."
				endif
				goto Recycle
			endif
		endif
	else
		if not ImmedLogin then print "-" LoginWhere$
	endif

	& in ioConsole - DCD
	& pr ioConsole - DCD
	& timer (30)
	& timer on
	print
	& int on
	Attempts = 0

ShowHerald:
	print
	ShowFile (EtcDir$ + "herald")

GetCodes:
	print SysInfo$[plNode] " login: ";
	& read A$
	& clear
	& spc(A$), A$
	on A$ = "" goto ShowHerald

	Login$ = A$
	& lcase (Login$)
	I$ = Login$ + ":"
	P = LEN (I$)

	CurFile$ = PasswdFile$
	fOpen PasswdFile$
	fRead PasswdFile$
	onerr goto pfEOF

	repeat
		& GET A$
	until I$ = LEFT$ (A$, P)

	LogEnt$ = LEFT$ (A$, P - 1)
	fClose
	CurFile$ = ""
	
	for I = pwPassword TO pwInterp
		& pos (P + 1, A$ + ":", ":"), P%
		PWInfo$[I] = mid$ (A$,P + 1, P% - P - 1)
		P = P%
	next

	UID = val (PWInfo$[pwUID])
	GID = val (PWInfo$[pwGID])

	' ------------------------------
	' Display quoted string if interpreter
	' ------------------------------

	if asc (PWInfo$[pwInterp]) = 34 then
		& spc (PWInfo$[pwInterp], 34), A$
		print A$
		goto GetCodes
	endif
	
	A$ = PWInfo$[pwPassword]
	gosub Decrypt

 pfEOF:	fClose
	CurFile$ = ""
	onerr goto Handle_Error
	
	if GID = Staff_ID or GID = Guest_ID then
		ShowFile (NoLoginFile$)
		on Shown goto Recycle
	endif

	if Decoding$ <> "NONE" then
		print "Password: ";
		& pr ioNone
		& read A$
		& pr ioConsole - DCD
		print
		gosub PWFixEntry
		if A$ <> Decoding$ or LogEnt$ <> Login$ then
			& wait 5
			print "Login incorrect"
			Attempts = Attempts + 1
			on Attempts < 3 goto GetCodes
			print
			ShowFile (EtcDir$ + "badlogin")
			run
		endif
	endif

	if GID = Guest_ID AND PWInfo$[pwName] = "" then
		& rept
			& read (30),"Your full name: ", II$
			& pos (II$, " "), P
			& pos (II$, ":"), Q
			I = P and not Q and len (II$) > 5
		& until(I)
		& rept
			& READ "City and state: ", A$
		& until(LEN (A$) > 5)
		PWInfo$[pwName] = II$
		LogEnt$ = Login$ + ": " + II$ + ", " + A$
	endif

	& pos("," + alertList$ + ",", "," + Login$ + ","), p
	if p then
		for p = 1 to 2
			& wait 1
			& beep (10, 200) : & beep
			& beep (20, 100) : & beep
			& wait 1
			for i = 1 to len(Login$)
				& beep (asc(mid$(Login$, i))-90, 200) : & beep
			next
		next
		& beep (stdBeepDur, stdBeepPitch)
	endif

TaskExecEntry:
	& pop
	a$ = PWInfo$[pwHome]
	if a$ > "" then
		if asc (a$) <> 47 then
			PWInfo$[pwHome] = SysInfo$[plDir] + a$
		endif
	endif

	CurFile$ = ADMFile$
	& getinfo ADMFile$, II$
	if II$ > "" then
		fOpen ADMFile$ ",L256"
		fRead ADMFile$ ",R0,B" admAcctInfo
		& get AcctNums1$
		& get LastLogin$
		gosub GetAcctNums2
		CallerID = LGN + 1
		fFre
	endif

	gosub InitCells
	& timer (300 + 3300 * (not GID))
	& time (T$)
	Status$ = mid$ (T$,6,7) + MID$ (T$,16,5) + " <" + LoginWhere$ + "> " \
		+ LogEnt$ + " (" + PWInfo$[pwName] + ")"
	gosub DrawStatusBar

	if II$ > "" then
		fRead ADMFile$ ",R" UID ",B" admAcctInfo
		& get AcctNums1$
		& get LastLogin$
		gosub GetAcctNums2
		fClose
		CurFile$ = ""

		if GID and (GID <> Mail_ID) then
			gosub GetAcctDateInfo
			if MPM and (CMN = MOY) and (MCR > MPM) then
				print Login$ ": account overdrawn for this month. (" \
					MCR "/" MPM " minutes used)"
				goto UnableToLogin
			endif
		endif

		& time (T$)
		CurFile$ = UserTempFile$
		fOpen UserTempFile$
		fWrite UserTempFile$
		  print LastLogin$
		  print T$
		  print LogEnt$
		  print LoginWhere$
		  print AcctNums1$
		  gosub WriteAcctNums2
		  print UID
		  print Status$
		fClose
		CurFile$ = ""
	endif
	fClose
	CurFile$ = ""

	ED$ = "edit"
	if (GID <> Mail_ID) and (LoginWhere$ <> "cron") then
		gosub SetEnvironment
	endif

	& store Login$ + ":" + PWInfo$[pwUID] + ":" + PWInfo$[pwGID] + \
			 ":" + PWInfo$[pwName] + ":" + PWInfo$[pwHome] + \
			 ":" + str$(CallerID) + ":" + ED$ to UserID_Cell

	if ExecFlag or (GID = Mail_ID) then
		print
	else
		& page on
		if mid$(LastLogin$, 13, 2) <> "69" then
			print "Last successful login for " Login$ ": " LastLogin$
		endif
		print "^MProLine " SysInfo$[plVersion] " (C) 1984-1994 Morgan Davis^M"

#if DO_INTRO
		ShowFile (EtcDir$ + "motd")
		if GID = Guest_ID then ShowFile (EtcDir$ + "welcome")
#endif
#if DO_NEWS
		& files (NewsDir$, NewsFiles$), N
		if N then
			& sort(NewsFiles$, N)
			T$ = LastLogin$
			gosub GetAcctDateInfo
			NewsFile$ = "N" + str$ (Y * 1000 + DAY) + "." + \
				mid$(LastLogin$,16,2) + mid$(LastLogin$,19,2)
			for I = 1 TO N
				if NewsFiles$[I] > NewsFile$ then
					ShowFile (NewsDir$ + NewsFiles$[I])
				endif
			next
		ENDIF
#endif
#if DO_MAIL
		& getinfo MAIL_PATH + Login$, I$
		if I$ > "" then print "You have mail.^M"
#endif
		if not PG then & page stop
	endif

	CurFile$	= PWInfo$[pwHome]
	fPrefix		CurFile$
	CurFile$	= CommandLine$
Launch(PWInfo$[pwInterp], LOGIN_PATH, GID = Root_ID)


' ==============================
' Show A Text File (if it exists)
' ==============================

_ShowFile:
	onerr goto sfErr
	Shown = FALSE
	& list CurFile$
	CurFile$ = ""
	print
	Shown = TRUE
goto sfExit

sfErr:	& ONERR
sfExit:	onerr goto Handle_Error
return


' ==============================
' Standard Error Handler
' ==============================

Handle_Error:
	& onerr ErrCode,ErrLine
	fClose
	if ErrCode = 255 then run
	if CommandLine$ > "" then
		print "Unable to login " Login$
		CommandLine$ = ""
	endif
	if ErrCode = 6 or ErrCode = 7 then
		print CurFile$": not found"
	else
		print "Login error #" ErrCode " @ " ErrLine ": " CurFile$
	endif

UnableToLogin:
	fClose
	gosub InitCells
run


' ==============================
' Screen Saver Routines
' ==============================

BlankScreen:
	if not ScreenIsBlank then
		dim ScreenBuf%[SCRNBUF_SIZE]
		call ScreenSaver, SS_SAVE, ScreenBuf%
		ScreenIsBlank = TRUE
	endif
	BlankOutCount = 0
return

AwakenScreen:
	if ScreenIsBlank then
		call ScreenSaver, SS_RESTORE, ScreenBuf%
		ScreenIsBlank = FALSE
		& erase (ScreenBuf%)
		gosub ShowTime
	endif
	BlankOutCount = 0
goto ShowTime


' ==============================
' Storage Cell Routines
' ==============================

InitCells:
	for I = UserID_Cell to ShellArgs_Cell
		& store "" to I
	next
return


' ==============================
' Exec Keyboard or Cron Task
' ==============================

ExecTask:
	Login$ = SysInfo$[plAdmin]
	if LoginWhere$ = "cron" then print "-" LoginWhere$
	LogEnt$	= "!" + A$
	PWInfo$[pwInterp] = A$
	PWInfo$[pwGID] = "0"
	GID = Root_ID
	PWInfo$[pwUID] = "0"
	UID = 0
	PWInfo$[pwName] = SysInfo$[plAdminFull]
	PWInfo$[pwHome] = "usr/" + Login$
	& getinfo SysInfo$[plDir] + PWInfo$[pwHome], J$
	if J$ = "" then PWInfo$[pwHome] = ""
	& int = console_abort
	& int on
	ExecFlag = TRUE
goto TaskExecEntry


' ==============================
' Password Decryption Routine
' ==============================

PWFixEntry:
	& left$ (A$,8), A$
	for I = 1 TO 8
		J = asc (mid$ (A$,I))
		& mid$ (A$,I) = chr$ (fn LOW(J) + 32 * (J < 64))
	next
	& spc (A$,64),A$
RETURN

Decrypt:
	K$ = mid$ (A$,12,1) + mid$ (A$,6,1) + left$ (A$,1) + \
		mid$ (A$,8,1) + mid$ (A$,4,1)
	CO$ = mid$ (A$,3,1) + mid$ (A$,2,1) + mid$ (A$,7,1) + \
		mid$ (A$,5,1) + mid$ (A$,9,1) + right$ (A$,1) + \
		mid$ (A$,11,1) + mid$ (A$,10,1)
	J = 0
	Decoding$ = ""
	for I = 1 to 8
		J = J + 1
		if J > 5 then J = 1
		Decoding$ = Decoding$ + chr$ \
		    ( \
			fn ADD (asc (mid$ (CO$, I))) - \
			fn LOW (fn ADD (asc (mid$ (K$, J)))) + 64 \
		    )
	next
	& spc (Decoding$, 64), Decoding$
return


' ==============================
' ADM Record Misc Routines
' ==============================

' @@@@@  The anemic Julian date routine here is leap-year-dumb, plus
'	should use the full year

GetAcctDateInfo:
	& pos ("?anebarprayunulugepctovec", mid$ (T$,10,2)), MOY
	MOY = MOY / 2
	Y = val (mid$ (T$,13,2))
	DAY = val(mid$("??000031059090120151181212243273304334",MOY * 3,3)) \
		+ val (mid$(T$,6)) + (MOY > 2 and Y / 4 = INT (Y / 4))
	T = val (mid$(T$,16)) * 60 + val (mid$(T$,19))
return

GetAcctNums1:
	input RPM,BAL,OWE
return

GetAcctNums2:
	input LGN, MNT, CMN, MCR, PMN, MPM, TMO
return

WriteAcctNums2:
	& left$ (str$ (LGN) + "," + str$ (MNT) + "," + str$ (CMN) + "," + \
		str$ (MCR) + "," + str$ (PMN) + "," + str$ (MPM) + "," + \
		str$ (TMO), 36), I$
	print I$
return


' ==============================
' Cron Task Checker
' ==============================

Cron:
	if not CronRead then
		CronRead = TRUE
		P[1] = 19 : L[1] = 2		' Lookup pointers and lengths
		P[2] = 16 : L[2] = 2
		P[3] = 1  : L[3] = 3
		P[4] = 6  : L[4] = 2
		P[5] = 9  : L[5] = 3
		NumCronEntries = 0
		CurFile$ = CrontabFile$
		fOpen CrontabFile$
		fRead CrontabFile$

		onerr goto cronErr
		& get				' Skip header
		repeat
			& get I$
			NumCronEntries = NumCronEntries + 1
			CronEntry$[NumCronEntries] = I$
		until NumCronEntries = MAX_CRON_TASKS
		error (5)

	    cronErr:
		& onerr
		onerr goto Handle_Error
		fClose
		CurFile$ = ""
	endif

	fFre
	if NumCronEntries then
	  for K = 1 to NumCronEntries
		if CronEntry$[K] > "" then
			for J = 1 to 5
				if mid$ (CronEntry$[K],P[J],L[J]) <> \
					mid$ (T$,P[J],L[J]) and \
					asc (mid$ (CronEntry$[K],P[J])) <> \
					42 then J = 7
			next
			if J = 6 then
				A$ = mid$(CronEntry$[K], 22)
				LoginWhere$ = "cron"
				gosub AwakenScreen
				goto ExecTask
			endif
		endif
	  next
	endif
return


' ==============================
' Draw Status Bar Information
' ==============================

DrawStatusBar:
	& pr ioConsole
	Y = peek (_CV)
	& goto 0, 0
	inverse
	call _CLREOL
	print left$ (Status$, peek (_WNDWID));
	normal
	& goto 0,Y
	& fn fnOnline, DCD
	& pr ioConsole - DCD
	poke _WNDTOP, 1
return


' ==============================
' Set TTY Terminal Emulation
' ==============================

TTY_Termcap:
	for I = $00 to $7E
		poke $200 + I, $80 * (I < 32)
	next
	& poke $207,$0A,$13,$15,$11,$80,$02,$0B
	& poke $27F,$80,$80,$00,$80
	& tset($200)
RETURN


' ==============================
' Set Up User's Environment
' ==============================

SetEnvironment:
	EM$ = "tty"
	if LoginWhere$ = "local" then
		Ecancel = console_abort
	else
		Ecancel = 3
	endif
	Enulls = 0
	Etabs = 0
	Edummy1 = 0
	Edummy2 = 0
	PG = 1
	SL = 24
	CurFile$ = ADM_PATH + Login$ + "/environs"
	I = FALSE
	onerr goto envErr
	& getinfo CurFile$, I$
	on I$ = "" goto noEnvErr

	fOpen CurFile$
	fRead CurFile$
	  input ENV, Ecancel, Enulls, Etabs, Edummy1, Edummy2, \
		SL, SW, PG, EM$, MM, HK, ED$
	fClose
	CurFile$ = SYS_PATH + "termcaps/" + EM$
	fBload CurFile$ ",T0,A540"
	& tset(540)
	I = TRUE
	goto noEnvErr

envErr:
	& onerr
	fClose

noEnvErr:
	onerr goto Handle_Error
	CurFile$ = ""
	poke sttyCancel, Ecancel
	poke sttyNulls, Enulls
	poke sttyTabs, Etabs
	poke sttyShell, 0

	& nulls (Enulls)
	& int = Ecancel
	& tab (Etabs)

	& page len SL - 1
	if PG then
		& page on
	else
		& page stop
	endif

	& ioctl(ioNormal)
	& ioctl(ioInsertOff)
	& ioctl(ioULOff)

	if LoginWhere$ <> "local" then & int stop
return


' ==============================
' Display Idle Prompt & TIME
' ==============================

ShowTime:
	& time(T$)
	I$ = right$(T$, 8)
	if ScreenIsBlank then
		i = peek(_CH)
		j = peek(_CV)
		k = peek(_CH80)
		htab BlankX + 1
		vtab BlankY + 1
		i% = val(right$(I$,2))
		if i% / 5 = int(i% / 5) then
			print spc(8)
			BlankX = rnd(1) * 31
			BlankY = rnd(1) * 24
			htab BlankX + 1
			vtab BlankY + 1
		endif
		print I$;
		& poke _CH,i,j
		poke _CH80,k
	else
		& ioctl(ioCR)
		print "Waiting < " I$ " > ";
	endif
	fFre
return

' ==============================
  GetConnectSpeed:
' ==============================
	& fn fnModemType, connectSpeed
	if connectSpeed then
		& fn fnConnectSpeed, i$
	else
		& fn fnPortSpeed, connectSpeed
		connectSpeed = connectSpeed - ((connectSpeed > 5) * 6)
		i$ = mid$("  3  6 12 18 24 36 48 72 96192384576", \
			connectSpeed * 3 + 1, 3) + "00"
	endif
	connectSpeed = val(i$)
return

'012345678901234567890123456789012345678901234567890123456789
'________________________________________________________________________________
'
'     Event #: ......   Time In: ..:..   Time Out: ..:..   Elapsed: ..:..
'
'    Event ID: .....................................    Type/Speed: .....
'________________________________________________________________________________


' ====================
  EventStatus:
' ====================
	& scrn (stdAppleIO)
	poke _WNDTOP, 0
	if peek(_CH80) then print
	i$ = "": for i = 1 to 8 : i$ = i$ + "VWVWVWVWVW" : next
	& mid$(i$,1) = "Z"
	& mid$(i$,80) = "_"
	& hlin 7, 13
	& goto 1, peek(37) - 7
	& hlin 78, 95
	& ioctl (ioMTextOn)
	print "^\" i$ i$ i$ i$ i$ "^\";
	& hlin 78, 76
	& ioctl (ioMTextOff)
	& left$(N$, 37), N$
	& goto 7, peek(37) - 4 : print "^OCaller:^N " A$ " ";
	& goto 24, peek(37)    : print "^OTime In:^N " mid$(LastLogin$,16,5) " ";
	& goto 41, peek(37)    : print "^OTime Out:^N " mid$(T$,16,5) " ";
	& goto 59, peek(37)    : print "^OElapsed:^N " left$(H$,2)":"right$(h$,2) " ";
	& goto 4, peek(37) + 2 : print "^OTask/Name:^N " N$ " ";
	& goto 56, peek(37)    : print "^OPort/Speed:^N " J$ " "
	print
	& scrn (stdMWIO)	
return

#define APP_AT_EXIT cleanup
cleanup:
	& load fre PARSER_ID
return

#define LAUNCH_PARSE
#define LAUNCH_NO_EXEC_PERM
#include <proline/launch.lib>
