' **********************************************************************
' ***
' ***	itc.b	InteleTerm Script Compiler
' ***		(C)opyright 1994 Morgan Davis Group
' ***
' ***	23dec93 2.0	Conversion to MD-BASIC
' ***

#define	IDENT_PROG "itc"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "29jan94"
#define	IDENT_NAME "Morgan_Davis"

#define	COPR	"(C)opyright 1994 Morgan Davis Group^MAll Rights Reserved"

#include <appleio.h>
#include <basic.h>
#include <prodos.h>
#include <proline/proline.h>

#define	END_TOKEN	19
#define	MAX_LABELS	30
#define	MAX_LITS	100
#define	MAX_TOKENS	300
#define	MAX_REFS	128

	gosub AppInit
	
	errmsg$ = "*** ^G"
	srcDir$ = ID$[uHome] + "/src/"

	dim	label$[MAX_LABELS], label%[MAX_LABELS], lit$[MAX_LITS], \
		token%[MAX_TOKENS], labref%[MAX_REFS], labref$[MAX_REFS]

	c$ =	"1A;DO 0B;TERM 1C;GOTO 0D;CLEAR 2E;PRINT 4F;SPEED 4G;ECHO "\
		"2H;DIAL 0I;CONNECT 0J;RETURN 2K;WAIT 3L;IF 2M;SEND "\
		"0N;HANGUP 5O;SENDFILE 0P;EXIT 4Q;BREAK 4R;SLEEP "\
		"0S;END 2T;EXEC 2U;RUN 4V;PRINTER 2W;EMULATE 0X;FLUSH "

	c1$ =	"1;OK 1;GOOD 1;SUCCESS 1;ONLINE 1;YES 1;TRUE "\
		"1;FOUND 0;FAILED 0;BAD 0;NOT 0;NO 0;FALSE "

	spd$ =	"0;300 1;1200 2;2400 3;9600 4;19200 5;38400 6;57600 "

	& page def pg
	& page stop 
	print "InteleTerm Pro Script Compiler " IDENT_VERS
	print COPR
	
	if argc > 1 then 
		n$ = srcDir$ + argv$[1]
	else
		print 
		print "(Source files end in .src, but don't enter the extension)"
		print 
		i$ = srcDir$
		& read (-64, i$), "Compile which script? ",n$
		if n$ = "" then goto Exit
	endif

	f$ = n$ + ".src"
	& getinfo f$,i$
	if i$ = "" then 
		print f$": not found"
		goto ExitError
	endif

	AccMode = accRead
	AccFile$ = f$
	gosub CheckAccess
	if not AccOK then 
		print f$": cannot read"
		goto ExitError
	endif

	print "^MCompiling "f$
	& hlin 10 + len(f$), 45
	print 
	pc = 1
	lineCount = 0
	errCount = 0

	fOpen f$
	fRead f$
	onerr goto srcEOF

	do
		& get a$
		lineCount = lineCount + 1
		& right$ (str$(lineCount),3),i$
		print i$"  "a$
		& spc(a$),a$
		if a$ > "" then
			& pos ("#;*'", mid$(a$, 1, 1)), i
			if not i then gosub parseLine
		endif
	loop


srcEOF:
	& onerr e,l
	onerr goto HandleError
	fClose
	if e < > 5 then
		error(e)
	endif
	token%[pc] = END_TOKEN	' flag End

	print 
	if labref then
		print "Linking";
		for i = 1 to labref
			print ".";
			j = labCount + 1
			& rept
			j = j - 1
			& until(not j or labref$[i] = label$[j])
			if not j then 
				print 
				print errmsg$"Undefined label ``"labref$[i]"''";
				gosub waitKey
			endif
			if j then token%[labref%[i]] = label%[j]
		next 
		print 
		print 
	endif

	print lineCount" lines, "labCount" labels, "litCount \
		" strings, "errCount" errors^M"
	if errCount then 
		& get (0),"Press RETURN "
		print 
		goto ExitError
	endif

	f$ = n$
	print "Saving output to "f$"...";
	AccMode = accWrite + accDelete
	AccFile$ = f$
	gosub CheckAccess
	if not AccOK then 
		print "can't write!"
		goto ExitError
	endif

	& getinfo f$,i$
	if i$ > "" then fDelete f$
	fAppend f$
	print litCount","labCount","pc
	for i = 1 to litCount
		print lit$[i]
	next 
	for i = 1 to labCount
		print label$[i] "," label%[i]
	next 
	for i = 1 to pc
		print token%[i]
	next
	fClose
	print "done."
goto Exit

#define	APP_AT_EXIT	cleanup
cleanup:
	if pg then & page on
return

	
parseLine:
	p% = 0
parseNext:
	gosub nextWord
	& ucase(word$)
	if right$ (word$,1) = ":" then 
		labCount = labCount + 1
		label$[labCount] = left$(word$, len (word$) - 1)
		label%[labCount] = pc
		if not p% then return
		goto parseNext
	endif
	& pos (c$, ";" + word$ + " "),q%
	if not q% then 
		print errmsg$"Unknown Command ``"word$"''";
		gosub waitKey
	else
		op = asc(mid$(c$,q% - 1)) - 64
		token%[pc] = op
		pc = pc + 1
		opcode$ = word$
		on val(mid$(c$,q% - 2,1)) gosub \
			getLabel, \
			getLiteral, \
			getCondition, \
			getNumber, \
			getSendfile
	endif
return


' ===== Misc Routines =====

nextWord:
	e% = p% + 1
	if asc(mid$(a$,e%)) = 32 then 
		p% = p% + 1
		goto nextWord
	endif
	if asc(mid$(a$, e%)) = 34 then
'		& pos (e% + 1, a$, chr$(34)),q%
		& pos right$ (a$, chr$(34)),q%
		if not q% then q% = len(a$) + 1
		word$ = mid$(a$,e%,q% - e% + 1)
		p% = q% + 1
	else
		& pos (e%,a$," "),p%
		q% = p%
		if not q% then q% = len (a$) + 1
		word$ = mid$ (a$, e%, q% - e%)
	endif
return 


' ===== Label =====

getLabel:
	gosub nextWord

defineLabel:
	& ucase(word$)
	labref = labref + 1
	labref$[labref] = word$
	labref%[labref] = pc
	pc = pc + 1
return 


' ===== String Literal =====

getLiteral:
	word$ = "^~M"
	if p% then gosub nextWord
	i = litCount + 1
	& rept
		i = i - 1
	& until(not i or word$ = lit$[i])
	if not i then 
		litCount = litCount + 1
		i = litCount
		lit$[i] = word$
	endif
	token%[pc] = i
	pc = pc + 1
return 


' ===== Condition =====

getCondition:
	gosub nextWord
	& ucase(word$)
	& pos (c1$,";" + word$ + " "),z%
	if not z% then 
		print errmsg$"Unknown condition ``"word$"''";
		goto waitKey
	endif
	token%[pc] = val(mid$(c1$,z% - 1,1))
	pc = pc + 1
	if p% then 
		& rept
			gosub nextWord
		& until(not p%)
	endif
goto defineLabel


' ===== Numeric Value =====

getNumber:
	gosub nextWord
	if opcode$ = "SPEED" then
		& pos (spd$,";" + word$ + " "),q%
		if not q% then 
			print errmsg$"Invalid Modem Speed";
			goto waitKey
		endif
		q% = val(mid$(spd$,q% - 1,1))
	else
		if opcode$ = "ECHO" or opcode$ = "PRINTER" then
			& ucase(word$)
			q% = -1 + (word$ = "ON" or word$ = "OFF") + (word$ = "ON")
			if q% < 0 then 
				print errmsg$"Invalid Setting ``"word$"''";
				goto waitKey
			endif
		else
			q% = val(word$)
		endif
	endif		

addNumber:
	token%[pc] = q%
	pc = pc + 1
return 


' ===== filesend =====

getSendfile:
	gosub getLiteral
	if p% then
		gosub getNumber
	else
		q% = 0
		gosub addNumber
	endif
	if p% then
		gosub nextWord
		q% = asc(word$)
	else
		q% = 0
	endif
goto addNumber



waitKey:
	errCount = errCount + 1
	fFre
	get k$
	print 
	fRead f$
return 


#include <proline/proline.lib>
#include <proline/access.lib>
